(function( $ ) {

	function grve_wpb_css_editor_update( $container ) {
		var value = {};

		$container.find('.grve-wpb-css-editor-tab').each(function() {
			var screen = $(this).data('screen');
			$(this).find('.grve-wpb-css-editor-input').each(function() {
				var param	= $(this).attr('name'),
					val		= $(this).val();

				if ( val !== '' ) {

					if ( !$(this).hasClass('grve-wpb-css-editor-no-validation') ) {
						if ( $(this).attr('name').indexOf('padding') !== -1 || $(this).attr('name').indexOf('margin') !== -1 || $(this).attr('name').indexOf('radius') !== -1 ) {
							if ( val.indexOf('%') !== -1 ) {
								val	= parseInt(val, 10);

								if ( isNaN(val) ) {
									return true;
								} else {
									val += '%';
								}
							}
						} else {
							val	= parseInt(val, 10);

							if ( isNaN(val) ) {
								return true;
							}
						}
					}

					if ( $.isEmptyObject(value[screen]) ) {
						value[screen] = {};
					}
					value[screen][param] = val;

				}
			});

		});

		if ( !$.isEmptyObject(value) ) {
			value['desktop']['class'] = 'grve-wpb-' + Date.now();

			value.property = $container.data('prop');
			value = JSON.stringify(value);
		} else {
			value = '';
		}
		$container.find('.grve-wpb-css-editor-value').val(value);
	}

	$(document).ready(function() {
		$('.grve-wpb-css-editor-wrapper').each(function() {
			var $this = $(this);

			$this.find('.grve-wpb-css-editor-input').change();

			var params = {
				change: function(e, ui) {
				  $( e.target ).val( ui.color.toString() );
				  $( e.target ).trigger('change');
				},
			}
			$this.find('.grve-wpb-color-picker').wpColorPicker( params );

			grve_wpb_css_editor_update($this);

			$this.find('.grve-wpb-css-editor-input').on('change', function() {
				grve_wpb_css_editor_update($this);
			});
			$this.find('.grve-wpb-css-editor-input').on('input', function() {
				grve_wpb_css_editor_update($this);
			});

			$this.find('.grve-wpb-css-editor-tabs-label').on('click', function() {
				if ( !$(this).hasClass('active') ) {
					var screen = $(this).data('screen');
					$this.find('.grve-wpb-css-editor-tab').removeClass('active');
					$this.find('.grve-wpb-css-editor-tab[data-screen="'+screen+'"]').addClass('active');
					$this.find('.grve-wpb-css-editor-tabs-label').removeClass('active');
					$(this).addClass('active');
				}
			});

		});


	});

})( jQuery );