

var GRVE_EXT = GRVE_EXT || {};

(function($){

	"use strict";


	// # Document on Ready
	// ============================================================================= //
	GRVE_EXT.documentReady = {
		init: function(){
			GRVE_EXT.sectionSettings.init();
			GRVE_EXT.basicElements.init();
		}
	};
	// # Document on Ready
	// ============================================================================= //
	GRVE_EXT.documentResize = {
		init: function(){
			GRVE_EXT.basicElements.iconBox.resize();
			GRVE_EXT.sectionSettings.expandColumnBg();
		}
	};

	GRVE_EXT.afterPageTransition = {
		init: function(){
			GRVE_EXT.basicElements.counter();
			GRVE_EXT.basicElements.pieChartInit();
		}
	};

	// # Document on Load
	// ============================================================================= //
	GRVE_EXT.documentLoad = {
		init: function(){
			GRVE_EXT.basicElements.iconBox.init();
		}
	};



	// # Section Settings
	// ============================================================================= //
	GRVE_EXT.sectionSettings = {
		init: function(){
			this.expandColumnBg();
			this.changeBgColorOnScroll();
			this.opacityScroll();
			this.columnHover();
		},
		expandColumnBg: function(){
			var $column = $('.grve-expand-bg');
			$column.each(function(){
				var $that = $(this),
					$inner = $that.children(),
					direction = 'left';
				if( $that.hasClass('grve-expand-bg-right') ) {
					direction = 'right';
				}

				GRVE_EXT.sectionSettings.expandSettings( $that, $inner, direction );
				if( $that.hasClass('grve-clipping-animation') ) {
					var $innerWrapper = $that.find('.grve-clipping-content').children();
					GRVE_EXT.sectionSettings.expandSettings( $that, $innerWrapper, direction );
				}

			});
		},
		expandSettings: function( $that, $element, direction ){
			resetExpandBg();

			var positionL = $element.offset().left,
				positionR = $(window).width() - (positionL + $element.width()),
				elementSizeL = $element.outerWidth() + positionL,
				elementSizeR = $element.outerWidth() + positionR,
				windowWidth = $(window).width();

			if ( windowWidth > tabletPortrait && windowWidth < tabletLandscape ) {
				if( $that.hasClass('grve-tablet-landscape-expand-bg-reset') ) {
					resetExpandBg();
				} else if( $that.hasClass('grve-tablet-landscape-expand-bg-both-sides') ) {
					expandBgBoth();
				} else {
					expandBg();
				}
			} else if ( windowWidth > mobileScreen && windowWidth < tabletPortrait ) {
				if( $that.hasClass('grve-tablet-portrait-expand-bg-reset') ) {
					resetExpandBg();
				} else if( $that.hasClass('grve-tablet-portrait-expand-bg-both-sides') ) {
					expandBgBoth();
				} else {
					expandBg();
				}
			} else if( windowWidth < mobileScreen ) {
				if( $that.hasClass('grve-mobile-expand-bg-reset') ) {
					resetExpandBg();
				} else if( $that.hasClass('grve-mobile-expand-bg-both-sides') ) {
					expandBgBoth();
				} else {
					expandBg();
				}
			} else {
				expandBg();
			}

			function expandBg() {
				if( 'left' == direction ) {
					$element[0].style.cssText += 'padding-left: ' + positionL + 'px !important';
					$element[0].style.cssText += 'margin-left: -' + positionL + 'px !important';
					$element[0].style.cssText += 'width:' + elementSizeL + 'px !important';
				} else {
					$element[0].style.cssText += 'padding-right: ' + positionR + 'px !important';
					$element[0].style.cssText += 'margin-right: -' + positionR + 'px !important';
					$element[0].style.cssText += 'width:' + elementSizeR + 'px !important';
				}
			}

			function expandBgBoth() {
				$element[0].style.cssText += 'padding-left: ' + positionL + 'px !important';
				$element[0].style.cssText += 'margin-left: -' + positionL + 'px !important';
				$element[0].style.cssText += 'padding-right: ' + positionR + 'px !important';
				$element[0].style.cssText += 'margin-right: -' + positionR + 'px !important';
				$element[0].style.cssText += 'width:' + windowWidth + 'px !important';
			}

			function resetExpandBg() {
				$element.css({
					'margin-left' : '',
					'margin-right' : '',
					'padding-left' : '',
					'padding-right' : '',
					'width': ''
				});
			}

			$that.css('visibility','visible');
		},
		changeBgColorOnScroll: function(){
			if ( typeof bgScrollex == 'undefined' && !$().bgScrollex ) {
				console.log('bgScrollex not Defined.');
				return true;
			}
			var $section = $('.grve-section.grve-with-bg-animated-color, .grve-inner-section.grve-with-bg-animated-color, .grve-column.grve-with-bg-animated-color .grve-column-wrapper, .grve-column-inner.grve-with-bg-animated-color .grve-column-wrapper-inner');
			$section.bgScrollex();
		},
		opacityScroll: function(){
			if ( typeof bgOpacity == 'undefined' && !$().bgOpacity ) {
				console.log('bgOpacity not Defined.');
				return true;
			}
			$bgImageScrollEffect.bgOpacity();
		},
		columnHover: function(){
			$document.on('touchstart mouseenter', '.grve-hover-animation-wrapper', function (e) {
				var $column = $(this).parents('.grve-hover-animation');
				$column.addClass('grve-hover-effect');
				var zIndex = getZindex( $column );
				$column.css( 'z-index', zIndex );
				if( $column.hasClass('grve-emphasized') ) {
					$column.siblings().addClass('grve-understate');
				}
			});

			$document.on('mouseleave touchmove click', '.grve-hover-animation-wrapper', function (e) {
				var $column = $(this).parents('.grve-hover-animation');
				$column.removeClass('grve-hover-effect');
				$column.css( 'z-index', '' );
				if( $column.hasClass('grve-emphasized') ) {
					$column.siblings().removeClass('grve-understate');
				}
			});

			function getZindex( $element ){
				var zIndex = 3,
					zIndexs = [];
				$element.siblings().each(function(){
					zIndexs.push( $(this).css('z-index') );
				});
				zIndexs.push( $element.css('z-index') );
				zIndex = Math.max.apply( Math, zIndexs );
				return zIndex + 1;
			}
		}
	};

	// # Basic Elements
	// ============================================================================= //
	GRVE_EXT.basicElements = {
		init: function(){
			this.autoHeadings();
			this.setPieChart();
			this.progressBars();
			this.advancedPromo();
			this.messageBox();
			this.htmlVideoPlayWhenAppear();
			this.accordionToggle();
			this.tabs();
			this.productSocials();
			this.countdown();
		},
		autoHeadings: function(){
			var $portfolio = $('.grve-portfolio.grve-auto-headings .grve-isotope-item-inner');
			$portfolio.autoHeading({
				compressor : 20,
				items : [
					{ 'item' : '.grve-title', 'min' : 18, 'max' : 50 }
				]
			});
		},
		setPieChart: function(){
			$pieChartNumber.each(function() {
				var $element  = $(this),
					size      = $element.data('pie-size'),
					chartSize = '130px';
				if( size == 'small' ){
					chartSize = '100px';
				}
				if( size == 'large' ){
					chartSize = '160px';
				}
				$element.css({ 'width' : chartSize, 'height' : chartSize, 'line-height' : chartSize });
			});
		},
		pieChartInit: function(){
			if ( typeof easyPieChart == 'undefined' && !$().easyPieChart ) {
				console.log('Easy Pie Chart not Defined.');
				return true;
			}
			$pieChartNumber.each(function() {
				var $element    = $(this),
					delay       = $element.parent().data('delay') !== '' ? parseInt( $element.parent().data('delay') ) : 0,
					activeColor = $element.data('pie-active-color') !== '' ? $element.data('pie-active-color') : 'rgba(0,0,0,1)',
					pieColor    = $element.data('pie-color') !== '' ? $element.data('pie-color') : 'rgba(0,0,0,0.1)',
					pieLineCap  = $element.data('pie-line-cap') !== '' ? $element.data('pie-line-cap') : 'round',
					lineSize    = $element.data('pie-line-size') !== '' ? $element.data('pie-line-size') : '6',
					size        = $element.data('pie-size'),
					chartSize   = '130';
				if( size == 'small' ){
					chartSize = '100';
				}
				if( size == 'large' ){
					chartSize = '160';
				}

				$element.appear(function() {
					setTimeout(function () {
						$element.easyPieChart({
							barColor: activeColor,
							trackColor: pieColor,
							scaleColor: false,
							lineCap: pieLineCap,
							lineWidth: lineSize,
							animate: 1500,
							size: chartSize
						});
					}, delay);
				});
			});
		},
		progressBars: function(){
			$progressBars.each(function() {
				$(this).appear(function() {
					var val = $(this).attr('data-value');
					$(this).find('.grve-bar-line').animate({ width: val + '%' }, 1600);

				});
			});
		},
		counter: function(){
			if ( typeof CountUp == 'undefined' && !$().CountUp ) {
				console.log('CountUp not Defined.');
				return true;
			}
			$counter.each(function(i){
				var $that = $(this),
					$element = $that.find('span'),
					thousandsSeparator = $element.attr('data-thousands-separator') !== '' ? $element.attr('data-thousands-separator') : ',',
					delay = $that.attr('data-delay') !== '' ? parseInt( $that.attr('data-delay') ) : 200,
					options = {
						useEasing    : true,
						useGrouping  : true,
						separator    : $element.attr('data-thousands-separator-vis') !== 'yes' ? thousandsSeparator : '',
						decimal      : $element.attr('data-decimal-separator') !== '' ? $element.attr('data-decimal-separator') : '.',
						prefix       : $element.attr('data-prefix') !== '' ? $element.attr('data-prefix') : '',
						suffix       : $element.attr('data-suffix') !== '' ? $element.attr('data-suffix') : ''
					};
					$element.attr('id','grve-counter-' + i );
					var counter = new CountUp( $element.attr('id') , $element.attr('data-start-val'), $element.attr('data-end-val'), $element.attr('data-decimal-points'), 2.5, options);
					$that.appear(function() {
						setTimeout(function () {
							counter.start();
						}, delay);
					});
			});
		},
		advancedPromo: function(){
			var $item = $('.grve-expandable-info');
			$item.each(function(){
				var $that         = $(this),
					$wrapper      = $that.parents('.grve-section'),
					$content      = $that.find('.grve-expandable-info-content'),
					paddingTop    = parseInt( $wrapper.css('padding-top') ),
					paddingBottom = parseInt( $wrapper.css('padding-bottom') );

				$wrapper.addClass('grve-pointer-cursor');
				$wrapper.on('click',function(){

					var headerHeight   = $header.data('sticky') != 'none' ? $mainHeader.outerHeight() : 0,
						fieldBarHeight = $('.grve-fields-bar').length ? $('.grve-fields-bar').outerHeight() : 0,
						offset         = $(this).offset().top,
						distance       = offset - ( headerHeight + fieldBarHeight );

					if( $content.is(":visible") ){
						$content.slideUp( 600, function(){
							$content.removeClass('show');
						});
					} else {

						$('html,body').animate({
							scrollTop: distance
						}, 600,function(){
							$content.slideDown( function(){
								$content.addClass('show');
								return;
							});
						});
					}
				});
				$wrapper.on('mouseenter', function () {
					$(this).css({ 'padding-top' : paddingTop + 40, 'padding-bottom' : paddingBottom + 40 });
				});
				$wrapper.on('mouseleave', function () {
					$(this).css({ 'padding-top' : paddingTop, 'padding-bottom' : paddingBottom });
				});
			});
		},
		iconBox: {
			boxArr: [],
			sizeArr: [],
			init: function(){

				var base = this;
				base.boxArr = $.makeArray( $('.grve-box-icon.grve-advanced-hover') );
				base.resize();

				$.each(base.boxArr, function(i,item){
					var $that = $(item),
						$text = $that.find('p'),
						$column = $that.parent();
					$column.on('mouseenter.grve_icon_box', function(){
						if( $text.length ) {
							base.toggle( true, $that, $text, 0 );
						}
					});
					$column.on('mouseleave.grve_icon_box', function(){
						if( $text.length ) {
							base.toggle( false, $that, $text, base.sizeArr[i] );
						}
					});
				});
			},
			resize: function(){
				var base = this;
				base.sizeArr = [];
				$.each(base.boxArr, function(i,item){
					var $text = $(item).find('p'),
						textH = $text.length ? $text.outerHeight() : 0;
					$(item).css({
						'transform': 'translate(0px, ' + textH + 'px)',
						'visibility' : 'visible'
					});
					$text.css({
						'transform': 'translate(0px, 100%)'
					});
					base.sizeArr.push( textH );
				});
			},
			toggle: function( show, item, text, space ){
				var timeline = gsap.timeline(),
					opacity = show ? 1 : 0;
				timeline.to(item, {duration:.3, y: space, ease:'power1.out' });
				timeline.to(text, {duration:.5, y: space, opacity: opacity, ease:'power1.out' }, '-=0.2');
			}
		},
		messageBox: function(){
			var $infoMessage = $('.grve-message'),
				$closeBtn = $infoMessage.find('.grve-close-btn');
			$closeBtn.on('click', function() {
				$(this).parent().slideUp(250);
			});
		},
		htmlVideoPlayWhenAppear: function(){
			var $video = $('.grve-embed-video');
			$video.each(function(){
				var $that = $(this);
				$that[0].pause();
				$that.appear(function(){
					if( $that[0].autoplay ){
						$that[0].play();
					}
				},{accX: 0, accY: -150});
			});
		},
		accordionToggle: function(){
			$('.grve-accordion-wrapper.grve-action-toggle').on('click', '.grve-title-wrapper', function() {
				var $that = $(this);
				$that
					.toggleClass('active')
					.next().slideToggle(350);
				setTimeout(function(){
					$window.trigger('resize');
				},350);
			});
			$('.grve-accordion-wrapper.grve-action-accordion').on('click', '.grve-title-wrapper', function() {
				var $that = $(this);
				$that
					.toggleClass('active').next().slideToggle(350)
					.parent().siblings().find('.grve-title-wrapper').removeClass('active')
					.next().slideUp(350);
				setTimeout(function(){
					$window.trigger('resize');
					// Go tot top
					if( $that.parents().hasClass('grve-accordion-go-top') ) {
						GRVE.helpers.linkGoToTop( $that.parent() );
					}
				},350);

			});
		},
		tabs: function(){
			$('.grve-tab-title').on('click',function() {
				var $that = $(this),
					contentId = $that.data('rel');

				$that.parents('.grve-tab').find('.grve-tab-title').removeClass('active');
				$that.addClass('active');
				if( $that.hasClass('grve-responsive-tab-link') && $that.parents('.grve-tab').find('.grve-tabs-title').hasClass('grve-tabs-collapse') ) {
					$that.parents('.grve-tab').find(contentId).toggleClass('active');
				} else {
					$that.parents('.grve-tab').find('.grve-tab-content').removeClass('active');
					$that.parents('.grve-tab').find(contentId).addClass('active');
				}
				setTimeout(function(){
					$window.trigger('resize');
				},350);
				if( $that.parents('.grve-tab').find(contentId).find('.flickity').length ) {
					$('.flickity').flickity('resize');
				}
				// Go tot top
				if( $that.parents().hasClass('grve-tabs-go-top') ) {
					GRVE.helpers.linkGoToTop( $that.parent() );
				}
			});
		},
		productSocials: function(){
			var $socials = $('.grve-product-social'),
				$item    = $socials.find('li');
			if( !$socials.length ) return;

			$socials.appear(function() {
				$item.each(function(i,n){
					var $this = $(this);
					setTimeout(function(){
						$this.addClass('grve-animated');
					},150 * i);
				});
			},{accX: 0, accY: -50});
		},
		countdown: function(){
			if ( typeof countdown == 'undefined' && !$().countdown ) {
				console.log('Countdown not Defined.');
				return true;
			}
			$('.grve-countdown').each(function() {
				var $this           = $(this),
					finalDate       = $this.data('countdown'),
					numbersSize     = $this.data('numbers-size'),
					textSize        = $this.data('text-size'),
					bgColor         = $this.data('bg-color'),
					numbersColor    = $this.data('numbers-color'),
					textColor       = $this.data('text-color'),
					increaseHeading = $this.data('increase-heading'),
					numberClass     = 'grve-number grve-' + numbersSize + ' grve-text-' + numbersColor,
					countdownItems  = '',
					text = '',
					countdownFormat = $this.data('countdown-format').split('|');

					if( increaseHeading !== undefined ) {
						numberClass += ' grve-increase-heading grve-heading-' + increaseHeading;
					}

				$.each( countdownFormat, function( index, value ) {
					switch (value) {
						case 'w':
							text = impeka_grve_main_data.string_weeks;
							break;
						case 'D':
						case 'd':
						case 'n':
							text = impeka_grve_main_data.string_days;
							break;
						case 'H':
							text = impeka_grve_main_data.string_hours;
							break;
						case 'M':
							text = impeka_grve_main_data.string_minutes;
							break;
						case 'S':
							text = impeka_grve_main_data.string_seconds;
							break;
						default:
							text = '';
					}

					if( bgColor !== undefined ) {
						countdownItems += '<div class="grve-countdown-item grve-bg-' + bgColor + '">';
					} else {
						countdownItems += '<div class="grve-countdown-item">';
					}
					countdownItems += '<div class="' + numberClass + '"><span>%' + value + '</span></div>';
					countdownItems += '<span class="grve-' + textSize + ' grve-text-' + textColor + '">' + text + '</span>';
					countdownItems += '</div>';

				});

				$this.countdown(finalDate, function(event) {
					$this = $(this).html(event.strftime( countdownItems ));
				});
			});
		}
	};

	// # Global Variables
	// ============================================================================= //
	var largeScreen = 2048;
	var tabletLandscape = 1200;
	var tabletPortrait = 1023;
	var mobileScreen = 767;
	var lastScrollTop = 0;
	var wpBarHeight = $('.grve-body').hasClass('admin-bar') ? 32 : 0;


	var $document = $(document),
		$window = $(window),
		$body = $('body'),
		$themeWrapper = $('#grve-theme-content'),
		$header = $('#grve-header'),
		$mainHeader = $('#grve-main-header'),
		headerSkin = $mainHeader.data('header-skin'),
		$verticalMenu = $('.grve-vertical-menu'),
		$responsiveHeader = $('#grve-main-responsive-header'),
		$topBar = $('#grve-top-bar'),
		$featureSection = $('#grve-feature-section'),
		$featureSlider = $('#grve-feature-slider'),
		$pageTitle = $('.grve-page-title'),
		$videoBg = $('.grve-bg-video'),
		$stickyEl = $('.grve-sticky-element'),
		$parallaxColumn = $('.grve-parallax-effect'),
		$floatingNav = $('.grve-navigation-bar.grve-layout-2'),
		$animationItem = $('.grve-animated-item'),
		$bgImageScrollEffect = $('.grve-bg-scroll-effect'),
		scrollBarWidth = GRVE.helpers.getScrollBarWidth(),
		scrolPosition = 0,
		$stickyHeader = $mainHeader.hasClass('grve-layout-top-bottom') ? $('.grve-bottom-header-area') : $mainHeader,
		headerSticky = $mainHeader.data('sticky'),
		headerIsSticky = false,
		featureParallax = false,
		frameSize = $('#grve-frames').data('frame-size') !== undefined ? $('#grve-frames').data('frame-size') : 0,
		offcanvasIsOpen = false,
		$progressBars = $('.grve-progress-bar'),
		$backToTop = $('.grve-back-top'),
		$counter = $('.grve-counter'),
		$pieChartNumber = $('.grve-chart-number'),
		resizeTimeout;


	$(function() {
		GRVE_EXT.documentReady.init();
	});

	$window.on('load', function() {
		GRVE_EXT.documentLoad.init();
	});

	// On Window Resize
	$window.on('resize', function(){
		window.clearTimeout( resizeTimeout );
		resizeTimeout = window.setTimeout(function () {
			GRVE_EXT.documentResize.init();
		}, 300);
	});

	$window.on('grve_after_page_transition', function(){ GRVE_EXT.afterPageTransition.init(); });

})(jQuery);