<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Class Impeka_Vc_Templates
 */
class Impeka_Vc_Templates {
	/**
	 * @var bool
	 */
	protected $initialized = false;

	/**
	 *
	 */
	public function init() {
		if ( $this->initialized ) {
			return;
		}
		$this->initialized = true;

		add_filter( 'vc_templates_render_category', array(
			$this,
			'renderTemplateBlock',
		), 10 );

		add_filter( 'vc_get_all_templates', array(
			$this,
			'addTemplatesTab',
		) );
		add_filter( 'vc_templates_render_frontend_template', array(
			$this,
			'renderFrontendTemplate',
		), 10, 2 );
		add_filter( 'vc_templates_render_backend_template', array(
			$this,
			'renderBackendTemplate',
		), 10, 2 );
		add_filter( 'vc_templates_render_backend_template_preview', array(
			$this,
			'renderBackendTemplate',
		), 10, 2 );

	}

	/**
	 * @param $data
	 *
	 * @return array
	 */
	public function addTemplatesTab( $data ) {
		$newCategory = array(
			'category' => 'impeka_templates',
			'category_name' => esc_html__( 'Content Manager', 'impeka-wpb-extension' ),
			'category_weight' => 9,
			'templates' => $this->getTemplates(),
		);
		$data[] = $newCategory;

		return $data;
	}

	/**
	 * @param $category
	 *
	 * @return mixed
	 */
	public function renderTemplateBlock( $category ) {
		if ( 'impeka_templates' === $category['category'] ) {
			$category['output'] = $this->getTemplateBlockTemplate();
		}
		return $category;
	}

	/**
	 * @return string
	 */
	private function getTemplateBlockTemplate() {
		ob_start();
		$this->impeka_vc_include_template( 'impeka-templates/category.tpl.php', array(
			'controller' => $this,
			'templates' => $this->getTemplates(),
			'filters' => $this->getFilters(),
		) );

		return ob_get_clean();
	}

	public function impeka_vc_include_template( $template, $variables = array(), $once = false ) {
		is_array( $variables ) && extract( $variables );
		if ( $once ) {
			return require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . $template;
		} else {
			return require IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . $template;
		}
	}

	public function renderBackendTemplate( $templateId, $templateType ) {
		if ( 'impeka_templates' === $templateType ) {
			$templates = $this->getTemplates();
			if ( ! is_numeric( $templateId ) || ! is_array( $templates ) || ! isset( $templates[ $templateId ] ) ) {
				wp_send_json_error( array(
					'code' => 'Wrong ID or no Template found',
				) );
			} else {
				$data =  $templates[ $templateId ];
				return trim( $data['content'] );
			}
		}
		return $templateId;
	}

	public function renderFrontendTemplate( $templateId, $templateType ) {
		if ( 'impeka_templates' === $templateType ) {
			$templates = $this->getTemplates();
			if ( ! is_numeric( $templateId ) || ! is_array( $templates ) || ! isset( $templates[ $templateId ] ) ) {
				wp_send_json_error( array(
					'code' => 'Wrong ID or no Template found',
				) );
			} else {
				$data = $templates[ $templateId ];
				vc_frontend_editor()->setTemplateContent( trim( $data['content'] ) );
				vc_frontend_editor()->enqueueRequired();
				vc_include_template( 'editors/frontend_template.tpl.php', array(
					'editor' => vc_frontend_editor(),
				) );
				die();
			}
		}

		return $templateId;
	}

	public function getFilters() {
		return array(
			'*' => esc_html__( 'All', 'impeka-wpb-extension' ),
			'hero' => esc_html__( 'Hero', 'impeka-wpb-extension' ),
			'portfolio' => esc_html__( 'Portfolio', 'impeka-wpb-extension' ),
			'shop' => esc_html__( 'Shop', 'impeka-wpb-extension' ),
			'content' => esc_html__( 'Content', 'impeka-wpb-extension' ),
			'contact' => esc_html__( 'Contact', 'impeka-wpb-extension' ),
			'image-text' => esc_html__( 'Image Text', 'impeka-wpb-extension' ),
			'fancy-boxes' => esc_html__( 'Fancy Boxes', 'impeka-wpb-extension' ),
			'steps' => esc_html__( 'Steps', 'impeka-wpb-extension' ),
			'team' => esc_html__( 'Team', 'impeka-wpb-extension' ),
			'progress' => esc_html__( 'Progress', 'impeka-wpb-extension' ),
			'media-box' => esc_html__( 'Media Box', 'impeka-wpb-extension' ),
			'pricing-tables' => esc_html__( 'Pricing Tables', 'impeka-wpb-extension' ),
			'icon-box' => esc_html__( 'Icon Box', 'impeka-wpb-extension' ),
			'tabs-accordions' => esc_html__( 'Tabs & Accordions', 'impeka-wpb-extension' ),
			'testimonials' => esc_html__( 'Testimonials', 'impeka-wpb-extension' ),
			'clients' => esc_html__( 'Clients', 'impeka-wpb-extension' ),
			'safebuttons' => esc_html__( 'Safebuttons', 'impeka-wpb-extension' ),
			'menus' => esc_html__( 'Area Items Menus', 'impeka-wpb-extension' ),
			'footers' => esc_html__( 'Footers', 'impeka-wpb-extension' ),
		);
	}

	public function getTemplates() {

		$templates = array();


$data = array();
$data['unique_id'] = $data['id'] = 'hero-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-1.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" columns_gap="none" mobile_columns_vertical_gap="none" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#131729"][vc_column width="1/2" vertical_content_position="bottom" grve_css="{``desktop``:{``padding-right``:``40%``,``class``:``grve-wpb-1598937952406``},``mobile_landscape``:{``padding-right``:``0``}}"][impeka_empty_space height_multiplier="4x"][impeka_divider line_type="vertical-line" line_width="1" vertical_line_height="4x" line_color="primary-2" line_loop_animation="top-bottom" padding_bottom="30"][impeka_title heading_tag="h1" heading="h2"]Let’s work<br />
and <span style="color: #6c84ff;">create</span> together.[/impeka_title][vc_column_text]If you want quality and top of the line support you’ve found it here. Impeka theme that will make the design life of your site a wonderful serenity.[/vc_column_text][impeka_empty_space height_multiplier="4x"][/vc_column][vc_column width="1/2" vertical_content_position="bottom" full_height="yes" rc_bg_type="gradient" rc_bg_gradient_color_1="#4064eb" rc_bg_gradient_color_2="#30368e" rc_bg_gradient_direction="135" expand_column_bg="expand-bg-right"][impeka_empty_space height_multiplier="4x"][impeka_single_image image_mode="medium_large" image="https://source.unsplash.com/1465x955" image_column_space="125" inherit_align="right"][impeka_empty_space height_multiplier="4x"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-2.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="custom" padding_bottom_multiplier="custom" padding_top="13%" padding_bottom="13%"][vc_column width="1/2" content_width="custom" horizontal_content_position="center" custom_content_width="370"][impeka_single_image image_mode="medium_large" image="https://images.unsplash.com/photo-1517281749396-564b95a206c3?fit=crop&amp;w=740&amp;h=1100&amp;q=80" radius="3" shadow="medium" animation="clipping-animation" clipping_animation="colored-clipping-up" animation_delay="300"][vc_row_inner][vc_column_inner grve_css="{``desktop``:{``margin-top``:``-12%``,``margin-left``:``-12%``,``class``:``grve-wpb-1598351068805``},``tablet_portrait``:{``margin-left``:``-2%``}}"][impeka_divider line_type="custom-line" line_width="100" line_height="10" line_color="black" animation="fade-in-left" animation_delay="600"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" vertical_content_position="middle" column_effect="mouse-move-x-y"][impeka_title heading_tag="h1" heading="page-title" animation="fade-in-up" animation_delay="400" margin_bottom="30"]Design<span style="color: #fec700;">+</span> Strategy.[/impeka_title][vc_row_inner columns_gap="60" tablet_sm_columns_vertical_gap="30"][vc_column_inner width="1/2" animation="fade-in-left" animation_delay="500" tablet_sm_width="1"][vc_column_text]We love to work with clients all over the world to design and develop unique and modern websites.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" tablet_sm_width="1"][vc_column_text animation="fade-in-left" animation_delay="600"]As an innovative digital and web design agency, we believe in sharing our design wisdom.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-3.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row height_ratio="100" padding_top_multiplier="" padding_bottom_multiplier="2x" rc_heading_color="white" rc_bg_type="image" rc_bg_image="https://images.unsplash.com/photo-1506574723610-7fe0f0c7f9ea?fit=crop&amp;w=2560&amp;h=1440" rc_bg_color_overlay="black" rc_bg_opacity_overlay="60" tablet_sm_height_ratio="0" mobile_height_ratio="0" scroll_header_skin="light" rc_bg_color="#000000" rc_font_color="#ffffff"][vc_column width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][vc_column width="5/6" vertical_content_position="middle" tablet_sm_width="1" grve_css="{``desktop``:{``padding-top``:``20%``,``class``:``grve-wpb-1598419827134``},``tablet_portrait``:{``padding-top``:``90``}}"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier=""][vc_column_inner][impeka_title heading_tag="h1" heading="page-title" title_color="primary-1"]Sharing<br />our expertise.[/impeka_title][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space][/vc_column_inner][vc_column_inner width="2/3"][vc_column_text text_style="leader-text"]Our dedicated team of creatives is bursting with talent, experience, and passion for what we do.[/vc_column_text][impeka_empty_space height_multiplier="2x"][impeka_button btn_text="Get in touch" btn_type="line" btn_line_position="right" btn_color="white" btn_link="url:%23"][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="rgba(255,255,255,0.15)" padding_top="8%" padding_bottom="4%"][/vc_column_inner][vc_column_inner width="1/3"][vc_column_text text_style="small-text"]<strong>Address 1:</strong> 709 Honey Creek Dr.<br />New York, NY 10028[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][vc_column_text text_style="small-text"]<strong>Address 2:</strong> 4851 Willow Greene<br />Drive Montgomery, AL 36109[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" vertical_content_position="middle" text_align="right" mobile_text_align="left"][impeka_social_links icon_size="small" icon_color="white" icon_shape="circle" shape_color="dark-grey" twitter_url="#" facebook_url="#" instagram_url="#" el_id="1598418944557-f691d944-78a3"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 4', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-4.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="3x" rc_bg_type="color" rc_bg_color="#f0e9e1"][vc_column width="1/6"][/vc_column][vc_column width="5/6" grve_css="{``desktop``:{``padding-top``:``18%``,``padding-bottom``:``14%``,``class``:``grve-wpb-1599199982409``}}"][impeka_title heading_tag="h1" heading="feature-title" title_color="custom" title_color_custom="#543a34" animation_delay="200" margin_bottom="30"]A full experience<br />
design agency.[/impeka_title][vc_row_inner][vc_column_inner width="1/2" tablet_sm_width="2-3"][vc_column_text animation_delay="300"]Our dedicated team of creatives is bursting with talent, experience, and passion for what we do, and we’re committed to delivering the very best for your brand.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" tablet_sm_width="1-3"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier=""][vc_column grve_css="{``desktop``:{``margin-top``:``-14%``,``class``:``grve-wpb-1599199444770``}}"][vc_row_inner][vc_column_inner width="1/3"][impeka_single_image image_mode="medium" image="https://source.unsplash.com/random/740x860" image_column_space="100" animation="clipping-animation" clipping_animation="colored-clipping-up" animation_delay="200"][/vc_column_inner][vc_column_inner width="2/3"][impeka_single_image image_mode="medium_large" image="https://source.unsplash.com/random/1540x860" image_column_space="100" animation="clipping-animation" clipping_animation="colored-clipping-up" animation_delay="400"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-5';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 5', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-5.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row height_ratio="100" padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_heading_color="white" rc_bg_type="image" rc_bg_color_overlay="gradient" rc_bg_gradient_overlay_custom_1="rgba(255,68,51,0.8)" rc_bg_gradient_overlay_custom_2="#6040FF" rc_bg_gradient_overlay_direction="180" tablet_sm_height_ratio="70" mobile_height_ratio="50" separator_bottom="wave-right-separator" separator_bottom_size="30%" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#6040FF"][vc_column width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][vc_column width="7/12" vertical_content_position="middle" tablet_width="2-3" tablet_sm_width="1"][impeka_title heading_tag="h1" heading="page-title"]Design with<br />
the user in mind.[/impeka_title][vc_column_text text_style="leader-text"]A perfect blend of energy, creativity and clarity.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Watch the trailer" btn_type="video" btn_color="white" btn_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D0s4_7BuszuQ" btn_video_icon_shape_type="outline" btn_video_icon_shape_color="white" btn_class="grve-video-popup"][/vc_column][vc_column width="1/4" tablet_width="1-6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-6';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 6', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-6.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="4x"][vc_column grve_css="{``desktop``:{``padding-top``:``22%``,``class``:``grve-wpb-1598612082824``}}"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier=""][vc_column_inner width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column_inner][vc_column_inner width="2/3" tablet_sm_width="1"][impeka_title heading_tag="h1" heading="page-title"]We are based<br />
in <span class="grve-underline grve-line-primary-1">New York</span> City.[/impeka_title][vc_column_text text_style="leader-text"]We offer you a panoply of cutting-edge options.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier="" mobile_columns_vertical_gap="none"][vc_column width="1/2" mobile_width="1-2"][/vc_column][vc_column width="1/2" mobile_width="1-3" grve_css="{``desktop``:{``margin-top``:``-70``,``margin-bottom``:``-70``,``z-index``:3,``class``:``grve-wpb-1598613285731``},``mobile_landscape``:{``margin-top``:``-40``,``margin-bottom``:``-40``}}"][impeka_single_image image="https://placehold.co/140x140/6040FF/FFF?text=image icon" inherit_align="right"][/vc_column][/vc_row][vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="4x"][vc_column content_width="custom" horizontal_content_position="center" custom_content_width="1290"][impeka_single_image image_mode="extra-extra-large" image="https://images.unsplash.com/photo-1581209440177-72e2d68c07df?fit=crop&w=2580&h=1300"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-7';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 7', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-7.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="custom" padding_bottom_multiplier="custom" rc_bg_type="gradient" rc_bg_gradient_color_1="#ffffff" rc_bg_gradient_color_2="#fafafa" rc_bg_gradient_direction="180" padding_top="13%" padding_bottom="13%"][vc_column width="1/6" tablet_sm_width="hide"][/vc_column][vc_column width="2/3" tablet_sm_width="1"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier=""][vc_column_inner width="2/3" vertical_content_position="bottom" grve_css="{``desktop``:{``z-index``:3,``class``:``grve-wpb-1599025660334``}}"][impeka_title heading_tag="h1" heading="page-title" animation="fade-in-up" animation_delay="200"]Stay Connected[/impeka_title][vc_column_text text_style="leader-text" animation="fade-in-up" animation_delay="300"]We are a passionate team of professional web designers and developers.[/vc_column_text][impeka_empty_space height_multiplier="3x"][vc_column_text animation="fade-in" animation_delay="600"]Phone: 543 222 123
E-mail: info@impeka.eu
Address: 709 Honey Creek, New York[/vc_column_text][impeka_empty_space][impeka_social_links icon_size="small" social_space="12" icon_color="white" icon_shape="circle" shape_color="orange" twitter_url="#" facebook_url="#" instagram_url="#" animation="fade-in" animation_delay="700" el_id="1599025764647-4a026591-a322"][/vc_column_inner][vc_column_inner width="1/3"][impeka_single_image image_mode="medium_large" image="https://images.unsplash.com/photo-1517281749396-564b95a206c3?fit=crop&amp;w=925&amp;h=1300&amp;q=80" image_column_space="200" image_column_space_reset="mobile" inherit_align="right" radius="3" shadow="medium" animation="clipping-animation" clipping_animation="colored-clipping-up" animation_delay="300"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-8';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 8', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-8.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" columns_gap="none" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000" scroll_section_title="Intro"][vc_column width="1/2" content_width="custom" vertical_content_position="middle" full_height="yes" custom_content_width="470"][impeka_empty_space height_multiplier="4x"][impeka_title heading_tag="h1" heading="page-title"]Design<br />
Agency.[/impeka_title][vc_column_text text_style="leader-text"]We will do our best to assist you with any issues related to the use of our themes as soon as possible.[/vc_column_text][impeka_empty_space height_multiplier="4x"][/vc_column][vc_column width="1/2" rc_bg_type="color" expand_column_bg="expand-bg-right" rc_bg_color="#ed74a4"][impeka_empty_space height_multiplier="4x"][impeka_single_image image_mode="medium_large" image="https://source.unsplash.com/random/1424x1134" image_load_mode="off" image_column_space="125" image_column_space_reset="tablet-sm"][impeka_empty_space height_multiplier="4x"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-9';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 9', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-9.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="gradient" rc_bg_gradient_color_1="#4064eb" rc_bg_gradient_color_2="#30368e" rc_bg_gradient_direction="135" scroll_header_skin="light" rc_font_color="#ffffff"][vc_column grve_css="{``desktop``:{``padding-top``:``17%``,``padding-bottom``:``22%``,``class``:``grve-wpb-1598957068817``},``mobile_landscape``:{``padding-top``:``24%``,``padding-bottom``:``45%``}}"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier=""][vc_column_inner width="1/6" tablet_width="1-12" tablet_sm_width="hide" mobile_width="hide"][/vc_column_inner][vc_column_inner width="2/3" text_align="center" tablet_width="5-6" tablet_sm_width="1"][impeka_icon icon_type="theme-icon-svg" icon_size="large" theme_icon="video-1" icon_color="primary-2" icon_shape="circle" icon_shape_color="white" loop_animation="animation-1" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D0s4_7BuszuQ" link_class="grve-video-popup" margin_bottom="30"][impeka_title heading="h6" margin_bottom="18"]We are here for you.[/impeka_title][impeka_title heading_tag="h1"]We are a team which strives to create products that respect your time.[/impeka_title][/vc_column_inner][vc_column_inner width="1/6" tablet_width="1-12" tablet_sm_width="hide" mobile_width="hide"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier="4x"][vc_column rc_bg_type="color" rc_bg_color="#131729" grve_css="{``desktop``:{``margin-top``:``-12%``,``class``:``grve-wpb-1598956289795``}}"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" columns_gap="none" mobile_columns_vertical_gap="none" rc_font_color="#ffffff"][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-up" clipping_animation_colors="white" animation_delay="200" grve_css="{``desktop``:{``padding-top``:``15%``,``padding-right``:``15%``,``padding-bottom``:``15%``,``padding-left``:``15%``,``class``:``grve-wpb-1598956985642``},``tablet_landscape``:{``padding-right``:``13%``,``padding-left``:``13%``},``mobile_landscape``:{``padding-right``:``10%``,``padding-left``:``10%``}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-laptop" icon_color="primary-2" title="Build your shop" heading="h6"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-up" clipping_animation_colors="white" animation_delay="400" grve_css="{``desktop``:{``border-right``:1,``border-left``:1,``padding-top``:``15%``,``padding-right``:``15%``,``padding-bottom``:``15%``,``padding-left``:``15%``,``border-color``:``#262e52``,``border-style``:``solid``,``class``:``grve-wpb-1598957012555``},``tablet_landscape``:{``padding-right``:``12%``,``padding-left``:``12%``},``mobile_landscape``:{``border-top``:1,``border-right``:0,``border-bottom``:1,``border-left``:0,``padding-right``:``10%``,``padding-left``:``10%``}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-linegraph" icon_color="primary-2" title="Speed Optimized" heading="h6"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-up" clipping_animation_colors="white" animation_delay="600" grve_css="{``desktop``:{``padding-top``:``15%``,``padding-right``:``15%``,``padding-bottom``:``15%``,``padding-left``:``15%``,``class``:``grve-wpb-1598957020486``},``tablet_landscape``:{``padding-right``:``13%``,``padding-left``:``13%``},``mobile_landscape``:{``padding-right``:``10%``,``padding-left``:``10%``}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-genius" icon_color="primary-2" title="Video Tutorials" heading="h6"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-10';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 10', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-10.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="4x" rc_heading_color="white" rc_bg_type="color" mobile_columns_vertical_gap="60" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#6040FF"][vc_column grve_css="{``desktop``:{``padding-top``:``14%``,``class``:``grve-wpb-1599111002653``},``mobile_landscape``:{``padding-top``:``24%``}}"][vc_row_inner mobile_columns_vertical_gap="60"][vc_column_inner width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column_inner][vc_column_inner width="1/2" vertical_content_position="middle" tablet_sm_width="7-12" grve_css="{``desktop``:{``z-index``:3,``class``:``grve-wpb-1599110916895``}}"][impeka_title heading_tag="h1" heading="feature-title"]Human<br />
Resources[/impeka_title][vc_column_text text_style="leader-text"]We don’t believe in compromise. You, your brand and your users deserve the very best, and that’s why we pour our love, dedication and expertise into every one of our prized WordPress themes.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Discover More" btn_type="outline" btn_color="white" btn_hover_color_gradient="white" btn_shape="round" btn_link="url:%23"][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="5-12"][impeka_single_image image_mode="medium_large" image="https://images.unsplash.com/photo-1516575334481-f85287c2c82d?fit=crop&w=1115&h=1130" image_column_space="150" image_column_space_reset="mobile" inherit_align="right"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-11';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 11', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-11.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row][vc_column grve_css="{``desktop``:{``padding-top``:``20%``,``padding-bottom``:``10%``,``class``:``grve-wpb-1599463416711``}}"][vc_row_inner][vc_column_inner width="1/6" tablet_sm_width="1-12"][/vc_column_inner][vc_column_inner width="3/4" tablet_width="5-6" tablet_sm_width="11-12"][impeka_animated_text animated_text="|Our dedicated team of creatives is bursting with talent, experience and passion for what we do.|" heading_tag="h1" heading="h1" style="style-2" animation_delay="300"][/vc_column_inner][vc_column_inner width="1/12" tablet_width="hide" tablet_sm_width="hide"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier=""][vc_column content_width="custom" horizontal_content_position="center" custom_content_width="1920" grve_css="{``desktop``:{``margin-bottom``:``-20%``,``class``:``grve-wpb-1599469882641``}}"][vc_row_inner][vc_column_inner width="1/6" tablet_sm_width="1-12"][/vc_column_inner][vc_column_inner width="5/6" tablet_sm_width="11-12"][impeka_single_image image_mode="extra-extra-large" image="https://source.unsplash.com/2400x1200" image_load_mode="off" image_column_space="100" inherit_align="left" animation="clipping-animation" clipping_animation="colored-clipping-left" animation_delay="300" animation_duration="slow"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="custom" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000" padding_top="20%"][vc_column tablet_width="5-6" tablet_sm_width="11-12"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-12';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 12', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-12.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row][vc_column grve_css="{``desktop``:{``padding-top``:``20%``,``padding-bottom``:``10%``,``class``:``grve-wpb-1599463416711``}}"][vc_row_inner][vc_column_inner width="1/6" tablet_sm_width="1-12"][/vc_column_inner][vc_column_inner width="3/4" tablet_width="5-6" tablet_sm_width="11-12"][impeka_animated_text animated_text="|We believe in sharing our design wisdom and technical expertise.|" heading_tag="h1" heading="h1" style="style-2" animation_delay="300"][/vc_column_inner][vc_column_inner width="1/12" tablet_width="hide" tablet_sm_width="hide"][/vc_column_inner][vc_column_inner][impeka_empty_space][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="5/12" tablet_sm_width="7-12"][vc_column_text animation="fade-in-up" animation_delay="500"]Through our in-house freelancing services, including expert graphic design and web development, elegant copywriting and ingenious content strategy, we’ve become renowned for quality and reliability – and we earn that reputation for greatness every day![/vc_column_text][/vc_column_inner][vc_column_inner width="5/12" tablet_sm_width="1-4"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier=""][vc_column width="1/6"][/vc_column][vc_column width="5/6" content_width="custom" horizontal_content_position="center" custom_content_width="1920" grve_css="{``desktop``:{``margin-bottom``:``-20%``,``class``:``grve-wpb-1599469732724``}}"][vc_row_inner columns_gap="none"][vc_column_inner width="1/3"][impeka_team team_layout="layout-2" image_size="medium" image="https://images.unsplash.com/photo-1517941823-815bea90d291?fit=crop&amp;w=700&amp;h=930" name="Adam Denisov" identity="Creative Director" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][vc_column_inner width="1/3"][impeka_team team_layout="layout-2" image_size="medium" image="https://images.unsplash.com/photo-1550063037-be7db23ff0a3?fit=crop&amp;w=700&amp;h=930" name="Harinder Bharwal" identity="Designer" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][vc_column_inner width="1/3"][impeka_team team_layout="layout-2" image_size="medium" image="https://images.unsplash.com/photo-1517841905240-472988babdf9?fit=crop&amp;w=700&amp;h=930" name="Alma Malmberg" identity="Developer" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="custom" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000" padding_top="20%"][vc_column tablet_width="5-6" tablet_sm_width="11-12"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-13';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 13', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-13.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="3x" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" rc_bg_color="#3d342f" rc_font_color="#ffffff"][vc_column width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][vc_column width="5/6" tablet_sm_width="1" grve_css="{``desktop``:{``padding-top``:``22%``,``padding-bottom``:``14%``,``class``:``grve-wpb-1599212377624``},``mobile_landscape``:{``padding-bottom``:``0``}}"][impeka_title heading_tag="h1" heading="feature-title" margin_bottom="30"]Contact our<br />
Support team.[/impeka_title][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier="3x"][vc_column width="1/6" grve_css="{``desktop``:{``margin-top``:``-36``,``class``:``grve-wpb-1599212367329``},``mobile_landscape``:{``margin-top``:``-10``}}"][impeka_icon icon_type="theme-icon-svg" theme_icon="plus" icon_color="white" icon_shape="circle" icon_shape_color="black" loop_animation="animation-1" link="url:%23"][/vc_column][vc_column width="5/12" grve_css="{``desktop``:{``margin-top``:``-13%``,``class``:``grve-wpb-1599212403036``},``mobile_landscape``:{``margin-top``:``30``}}"][impeka_media_box media_style="style-2" bg_image_size="medium_large" image="https://source.unsplash.com/1140x800" image_load_mode="off" overlay_opacity="30" title="49 Geraldin Lane" heading="h5" title_link="url:%23" read_more_title="Read More" min_height="320" animation="fade-in-up" animation_delay="200"]You’ll have everything you’ll need<br />
inside a powerful back-end.[/impeka_media_box][/vc_column][vc_column width="5/12" grve_css="{``desktop``:{``margin-top``:``-13%``,``class``:``grve-wpb-1599212326874``},``mobile_landscape``:{``margin-top``:``30``}}"][impeka_media_box media_style="style-2" bg_image_size="medium_large" image="https://source.unsplash.com/1140x800" image_load_mode="off" overlay_opacity="40" title="22 Oxford Street" heading="h5" title_link="url:%23" read_more_title="Read More" min_height="320" animation="fade-in-up" animation_delay="400"]Create your shop in a few minutes<br />
and customize everything as you wish.[/impeka_media_box][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-14';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 14', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-14.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="3x" rc_bg_type="color" rc_bg_color="#e3e2e2"][vc_column width="5/6" tablet_sm_width="1" grve_css="{``desktop``:{``padding-top``:``22%``,``padding-bottom``:``14%``,``class``:``grve-wpb-1599207607268``}}"][impeka_title heading_tag="h1" heading="feature-title" title_color="custom" title_color_custom="#645953" margin_bottom="30"]Always happy<br />
to hear your feedback.[/impeka_title][/vc_column][vc_column width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier=""][vc_column grve_css="{``desktop``:{``margin-top``:``-14%``,``class``:``grve-wpb-1599199444770``}}"][vc_row_inner][vc_column_inner][impeka_single_image image_mode="extra-extra-large" image="https://source.unsplash.com/2340x1300" image_load_mode="off" image_column_space="100" animation="clipping-animation" clipping_animation="colored-clipping-up" animation_delay="200"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-15';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 15', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-15.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="custom" padding_bottom_multiplier="4x" padding_top="13%"][vc_column width="1/2"][impeka_single_image image_mode="medium" image="https://source.unsplash.com/570x445" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="white"][/vc_column][vc_column width="1/2" content_width="custom" horizontal_content_position="center" vertical_content_position="middle" custom_content_width="470"][impeka_animated_text animated_text="|Top rated;Elite Author Team.|" heading_tag="h1" heading="leader-text" increase_heading="250" animation_delay="200"][vc_column_text text_style="leader-text" animation="fade-in-up" animation_delay="600"]User experience is our highest priorities, and contemporary interface of Impeka is the icing on the premium cake.[/vc_column_text][/vc_column][vc_column mobile_width="hide"][impeka_empty_space][/vc_column][vc_column width="1/4"][/vc_column][vc_column width="1/3"][impeka_single_image image_mode="medium" image="https://source.unsplash.com/370x470" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="white"][/vc_column][vc_column width="1/4"][impeka_single_image image_mode="medium" image="https://source.unsplash.com/270x270" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="white"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-16';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 16', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-16.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="3x" rc_bg_type="color" rc_bg_color="#fff6e1"][vc_column tablet_sm_width="1" grve_css="{``desktop``:{``padding-top``:``20%``,``padding-bottom``:``25%``,``class``:``grve-wpb-1608283180990``}}"][vc_row_inner][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="2/3" text_align="center"][impeka_icon icon_type="theme-icon-svg" icon_size="large" theme_icon="video-1" icon_shape="circle" shape_type="outline" icon_shape_color="primary-1" loop_animation="animation-1" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D0s4_7BuszuQ" link_class="grve-video-popup" animation="fade-in-up" margin_bottom="30"][impeka_title heading_tag="div" heading="subtitle-text" title_color="primary-1" animation="fade-in-up" animation_delay="100" margin_bottom="18"]We are here for you.[/impeka_title][impeka_animated_text animated_text="|We are a team which strives to create products that respect your time.|" heading_tag="h1" style="style-2" animation_delay="200"][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier="3x"][vc_column grve_css="{``desktop``:{``margin-top``:``-25%``,``class``:``grve-wpb-1608283165908``}}"][vc_row_inner][vc_column_inner][impeka_single_image image_mode="extra-extra-large" image="https://source.unsplash.com/1170x550" image_load_mode="off" image_column_space="100" animation="clipping-animation" clipping_animation="colored-clipping-up" animation_delay="200"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="3/4" grve_css="{``desktop``:{``margin-left``:``30``,``class``:``grve-wpb-1608283565995``}}"][/vc_column][vc_column width="1/4" text_align="right" grve_css="{``desktop``:{``margin-top``:``-90``,``margin-right``:``-30``,``class``:``grve-wpb-1608283626839``}}"][impeka_button btn_text="Get in touch" btn_shadow="medium" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon="arrow-2"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-17';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 17', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-17.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row height_ratio="100" padding_top_multiplier="3x" padding_bottom_multiplier="3x" rc_heading_color="white" rc_bg_type="image" rc_bg_image="https://images.unsplash.com/photo-1517941823-815bea90d291?fit=crop&amp;w=1920&amp;h=1080" separator_bottom="tilt-left-separator" separator_bottom_color="#b7f300" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column vertical_content_position="middle" text_align="right"][impeka_animated_text animated_text="|Will be near you|" heading_tag="h1" heading="page-title" increase_heading="120" style="style-2"][vc_row_inner][vc_column_inner text_align="right" rc_heading_color="primary-1"][impeka_animated_text animated_text="|on every step|" heading_tag="h1" heading="page-title" increase_heading="120" style="style-2"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner content_width="custom" horizontal_content_position="right" text_align="right" custom_content_width="510"][vc_column_text text_style="leader-text" animation="fade-in-up" animation_delay="600"]All our trainers are award winning experts that will be near you on every step of your transformation[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'hero-18';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Hero 18', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/heroes/hero-18.jpg');
$data['custom_class'] = 'hero';
$data['content'] = <<<CONTENT
[vc_row height_ratio="100" padding_top_multiplier="2x" padding_bottom_multiplier="2x" tablet_sm_height_ratio="70"][vc_column width="2/3" vertical_content_position="middle" tablet_sm_width="7-12" mobile_column_order="2" grve_css="{``desktop``:{``margin-bottom``:``-180``,``z-index``:3,``class``:``grve-wpb-1633811267230``},``mobile_landscape``:{``margin-bottom``:``0``}}"][impeka_empty_space height_multiplier="2x"][impeka_animated_text animated_text="|An experience;design agency.|" heading_tag="h1" heading="page-title" increase_heading="120" increase_heading_reset="tablet-sm" style="style-2"][vc_row_inner][vc_column_inner content_width="custom" custom_content_width="400"][vc_column_text text_style="leader-text"]Located in London, but due to the internet we have no boundaries![/vc_column_text][/vc_column_inner][vc_column_inner grve_css="{``desktop``:{``margin-top``:``90``,``class``:``grve-wpb-1633673471187``}}"][impeka_divider line_type="vertical-line" line_width="2" line_loop_animation="top-bottom"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/3" vertical_content_position="middle" column_effect="mouse-move-x-y" column_effect_sensitive="1" tablet_sm_width="5-12" mobile_column_order="1" grve_css="{``desktop``:{``margin-left``:``-10%``,``z-index``:1,``class``:``grve-wpb-1633811302183``},``mobile_landscape``:{``margin-left``:``0``}}"][impeka_single_image image="https://images.unsplash.com/photo-1517941823-815bea90d291?fit=crop&amp;w=940&amp;h=1180" image_column_space="125" image_column_space_reset="tablet-sm" inherit_align="right"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'steps-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Steps 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/steps/steps-1.jpg');
$data['custom_class'] = 'steps portfolio';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_heading_color="white" rc_bg_type="color" columns_gap="60" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="5/12" content_width="custom" tablet_width="1-3" custom_content_width="370"][impeka_title heading="h4"]You don’t need any <span style="color: #fab901;">coding skills</span> to get professional results.[/impeka_title][/vc_column][vc_column width="7/12" tablet_width="2-3"][impeka_animated_text animated_text="|We are a passionate team of professional web designers and developers, and WordPress virtuosos, who specialize in creating premium WordPress themes.|" heading="leader-text" style="style-2"][/vc_column][vc_column][impeka_empty_space height_multiplier="3x"][/vc_column][vc_column width="5/12" content_width="custom" vertical_content_position="bottom" tablet_width="1-3" tablet_sm_column_order="5" custom_content_width="370"][impeka_empty_space height_multiplier="2x"][vc_column_text]You, your brand deserve the very best, and that’s why we pour our love and expertise into Impeka theme.[/vc_column_text][/vc_column][vc_column width="7/12" tablet_width="2-3" tablet_sm_width="1" tablet_sm_column_order="4"][vc_row_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-left" clipping_animation_colors="dark-grey" animation_delay="500"][impeka_title heading="h1" margin_bottom="8"]01[/impeka_title][impeka_title heading="h5"]Support[/impeka_title][vc_column_text]Build a fast website for the highest user experience.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-left" clipping_animation_colors="dark-grey" animation_delay="600"][impeka_title heading="h1" margin_bottom="8"]02[/impeka_title][impeka_title heading="h5"]Development[/impeka_title][vc_column_text]Everything you’ll need inside a powerful back-end.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-left" clipping_animation_colors="dark-grey" animation_delay="700"][impeka_title heading="h1" margin_bottom="8"]03[/impeka_title][impeka_title heading="h5"]JQuery Power[/impeka_title][vc_column_text]More than 50 elements will make your life much easier.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'steps-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Steps 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/steps/steps-3.jpg');
$data['custom_class'] = 'steps portfolio';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" columns_gap="60" mobile_columns_vertical_gap="60"][vc_column content_width="custom" custom_content_width="670"][impeka_animated_text animated_text="|Out of love for stylish and functional WP themes and for taking pride to support you.|" style="style-2" animation_delay="200"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column width="1/3" animation="fade-in-up" animation_delay="600"][impeka_title heading="h6" margin_bottom="18"]01. Development[/impeka_title][vc_column_text]A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.[/vc_column_text][/vc_column][vc_column width="1/3" animation="fade-in-up" animation_delay="800"][impeka_title heading="h6" margin_bottom="18"]02. CSS Capabilities[/impeka_title][vc_column_text]A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.[/vc_column_text][/vc_column][vc_column width="1/3" animation="fade-in-up" animation_delay="1000"][impeka_title heading="h6" margin_bottom="18"]03. JQuery Power[/impeka_title][vc_column_text]A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.[/vc_column_text][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'steps-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Steps 4', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/steps/steps-4.jpg');
$data['custom_class'] = 'steps';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" mobile_columns_vertical_gap="60"][vc_column width="1/2" tablet_sm_width="2-3"][impeka_title heading="subtitle-text" margin_bottom="30"]brand messaging[/impeka_title][impeka_title heading="h4"]A stunning website, compelling brand messaging to give you that elusive competitive edge.[/impeka_title][/vc_column][vc_column width="1/2" tablet_sm_width="1-3" mobile_width="hide"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="60" tablet_sm_columns_vertical_gap="60"][vc_column_inner width="1/4" animation="clipping" clipping_animation="colored-clipping-down" clipping_animation_colors="grey" animation_delay="200" tablet_sm_width="1-2"][impeka_title heading_tag="h4" heading="h6"]01 Speed Optimized[/impeka_title][vc_column_text]Build a website that loads fast for the highest user experience.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/4" animation="clipping" clipping_animation="colored-clipping-down" clipping_animation_colors="grey" animation_delay="300" tablet_sm_width="1-2"][impeka_title heading_tag="h4" heading="h6"]02 Powerful Backend[/impeka_title][vc_column_text]You’ll have everything you’ll need inside a powerful back-end.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/4" animation="clipping" clipping_animation="colored-clipping-down" clipping_animation_colors="grey" animation_delay="400" tablet_sm_width="1-2"][impeka_title heading_tag="h4" heading="h6"]03 Knowledge Base[/impeka_title][vc_column_text]A knowledgebase to provide instructions on how to use Impeka.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/4" animation="clipping" clipping_animation="colored-clipping-down" clipping_animation_colors="grey" animation_delay="500" tablet_sm_width="1-2"][impeka_title heading_tag="h4" heading="h6"]04 Development[/impeka_title][vc_column_text]More than 50 elements will make your life much easier.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'steps-5';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Steps 5', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/steps/steps-5.jpg');
$data['custom_class'] = 'steps';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" columns_gap="60"][vc_column width="1/3"][impeka_media_box media_style="style-2" bg_image_size="large" overlay_opacity="30" title="01" heading="page-title" text_style="subtitle" title_link="url:%23" read_more_title="Read More About" min_height="440" align="center" animation="fade-in-up" animation_delay="200"]Behind the word mountains, far from the countries.[/impeka_media_box][/vc_column][vc_column width="1/3"][impeka_media_box media_style="style-2" bg_image_size="large" overlay_opacity="30" title="02" heading="page-title" text_style="subtitle" title_link="url:%23" read_more_title="Read More About" min_height="440" align="center" animation="fade-in-up" animation_delay="200"]Behind the word mountains, far from the countries.[/impeka_media_box][/vc_column][vc_column width="1/3"][impeka_media_box media_style="style-2" bg_image_size="large" overlay_opacity="30" title="03" heading="page-title" text_style="subtitle" title_link="url:%23" read_more_title="Read More About" min_height="440" align="center" animation="fade-in-up" animation_delay="200"]Behind the word mountains, far from the countries.[/impeka_media_box][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'steps-7';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Steps 7', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/steps/steps-7.jpg');
$data['custom_class'] = 'steps';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="6x" padding_bottom_multiplier="4x" rc_heading_color="white" rc_bg_type="image" rc_bg_image="https://images.unsplash.com/photo-1522202176988-66273c2fd55f?fit=crop&w=2560" rc_bg_color_overlay="black" rc_bg_opacity_overlay="80" mobile_columns_vertical_gap="60" separator_top="wave-left-separator" separator_top_size="30%" separator_top_hide="mobile" separator_top_z_index="3" separator_bottom_size="150px" separator_bottom_hide="mobile" separator_bottom_z_index="7" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/2" tablet_sm_width="2-3"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="orange" margin_bottom="30"]brand messaging[/impeka_title][impeka_title heading="h4"]A stunning website, compelling brand messaging to give you that elusive competitive edge.[/impeka_title][/vc_column][vc_column width="1/2" tablet_sm_width="1-3" mobile_width="hide"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column grve_css="{``desktop``:{``padding-bottom``:``50``,``class``:``grve-wpb-1599018486542``}}"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="60" tablet_sm_columns_vertical_gap="60"][vc_column_inner width="1/4" animation="fade-in-up" animation_delay="200" tablet_sm_width="1-2"][impeka_title heading_tag="h4" heading="h6"]01 Speed Optimized[/impeka_title][vc_column_text]Build a website that loads fast for the highest user experience.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/4" animation="fade-in-up" animation_delay="300" tablet_sm_width="1-2"][impeka_title heading_tag="h4" heading="h6"]02 Powerful Backend[/impeka_title][vc_column_text]You’ll have everything you’ll need inside a powerful back-end.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/4" animation="fade-in-up" animation_delay="400" tablet_sm_width="1-2"][impeka_title heading_tag="h4" heading="h6"]03 Knowledge Base[/impeka_title][vc_column_text]A knowledgebase to provide instructions on how to use Impeka.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/4" animation="fade-in-up" animation_delay="500" tablet_sm_width="1-2"][impeka_title heading_tag="h4" heading="h6"]04 Development[/impeka_title][vc_column_text]More than 50 elements will make your life much easier.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier=""][vc_column width="3/4" rc_heading_color="white" rc_bg_type="color" expand_column_bg="expand-bg-left" tablet_sm_width="11-12" rc_font_color="#ffffff" rc_bg_color="#fab901" grve_css="{``desktop``:{``margin-top``:``-50``,``padding-top``:``24``,``padding-right``:``30``,``padding-bottom``:``24``,``class``:``grve-wpb-1599018392739``}}"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier=""][vc_column_inner width="1/4" vertical_content_position="middle" tablet_width="1-3"][impeka_title heading="h6"]Join our newsletter[/impeka_title][/vc_column_inner][vc_column_inner width="3/4" vertical_content_position="middle" tablet_width="2-3"][impeka_contact_form id="" inputs_shape="round" inputs_bg_color="custom" inputs_bg_color_custom="#ffffff" inputs_placeholder_color="#727272" inputs_borders="" button_color="black" button_hover_color="white" button_shape="round"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/4" tablet_sm_width="1-12"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'team-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Team 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/team/team-2.jpg');
$data['custom_class'] = 'team';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/2" tablet_width="7-12" tablet_sm_width="2-3"][impeka_title heading="h4"]We love to work with clients all over the world to <span style="color: #6a80ff;">develop unique,</span> innovative and modern websites.[/impeka_title][/vc_column][vc_column width="1/2" vertical_content_position="bottom" text_align="right" tablet_width="5-12" tablet_sm_width="1-3" mobile_text_align="left"][impeka_button btn_text="Become a member" btn_type="only-text" btn_color="black" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon="arrow-2"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="60"][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="200"][impeka_team team_layout="layout-2" image_size="medium" image="https://images.unsplash.com/photo-1517941823-815bea90d291?fit=crop&amp;w=700&amp;h=930" name="Alexander Ljung" identity="Designer" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="400"][impeka_team team_layout="layout-2" image_size="medium" image="https://images.unsplash.com/photo-1550063037-be7db23ff0a3?fit=crop&amp;w=700&amp;h=930" name="Chigusa Kisa" identity="Manager" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="600"][impeka_team team_layout="layout-2" image_size="medium" image="https://images.unsplash.com/photo-1517841905240-472988babdf9?fit=crop&amp;w=700&amp;h=930" name="Helena Brauer" identity="Developer" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'team-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Team 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/team/team-3.jpg');
$data['custom_class'] = 'team';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/2" tablet_width="7-12" tablet_sm_width="2-3"][impeka_title heading="h4"]We test the limits of creativity every single day to meet demanding minds.[/impeka_title][/vc_column][vc_column width="1/2" vertical_content_position="bottom" text_align="right" tablet_width="5-12" tablet_sm_width="1-3" mobile_text_align="left"][impeka_button btn_text="Become a member" btn_type="only-text" btn_color="black" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon_shape="circle"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner columns_gap="60"][vc_column_inner width="1/3" animation="clipping" clipping_animation="clipping-down" animation_delay="200"][impeka_team image_size="medium" image="https://images.unsplash.com/photo-1517941823-815bea90d291?fit=crop&w=700&h=720" image_effect="grayscale-image-hover" name="Leonetta Lloyd" heading="h6" identity="Designer" shadow="medium-shadow" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="clipping-down" animation_delay="400"][impeka_team image_size="medium" image="https://images.unsplash.com/photo-1550063037-be7db23ff0a3?fit=crop&w=700&h=720" image_effect="grayscale-image-hover" name="Alfie Wood" heading="h6" identity="Manager" shadow="medium-shadow" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="clipping-down" animation_delay="600"][impeka_team image_size="medium" image="https://images.unsplash.com/photo-1517841905240-472988babdf9?fit=crop&w=700&h=720" image_effect="grayscale-image-hover" name="Bairam Frootan" heading="h6" identity="Developer" shadow="medium-shadow" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'team-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Team 4', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/team/team-4.jpg');
$data['custom_class'] = 'team';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/2" tablet_width="7-12" tablet_sm_width="2-3"][impeka_title]We strive for excellence and share our knowledge so that users become creative.[/impeka_title][impeka_empty_space][impeka_button btn_text="Read more about" btn_color_gradient="black" btn_hover_action="pulse" btn_link="url:%23"][/vc_column][vc_column width="1/2" tablet_width="5-12" tablet_sm_width="1-3"][/vc_column][vc_column][vc_row_inner][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner width="1/3"][impeka_team team_layout="layout-2" image_size="medium" image="https://images.unsplash.com/photo-1517941823-815bea90d291?fit=crop&amp;w=700&amp;h=930" name="Alexander Ljung" identity="Designer" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][vc_column_inner width="1/3" grve_css="{``desktop``:{``margin-top``:``-90``,``class``:``grve-wpb-1608309567492``},``mobile_landscape``:{``margin-top``:``30``}}"][impeka_team team_layout="layout-2" image_size="medium" image="https://images.unsplash.com/photo-1550063037-be7db23ff0a3?fit=crop&amp;w=700&amp;h=930" name="Chigusa Kisa" identity="Manager" social_facebook="#" social_twitter="#" social_linkedin="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-1.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" rc_bg_color="#ffffff"][vc_column width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][vc_column width="2/3" tablet_sm_width="1"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="60"][vc_column_inner width="1/2"][impeka_counter counter_end_val="400" counter_prefix="+" counter_heading="h1" title="Satisfied Customers" heading="leader-text" animation="fade-in-up" animation_delay="200" margin_bottom="18"][vc_column_text animation="fade-in-up" animation_delay="300"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][impeka_counter counter_end_val="2500" counter_thousands_separator="." counter_heading="h1" title="Working Hours" heading="leader-text" animation="fade-in-up" animation_delay="400" margin_bottom="18"][vc_column_text animation="fade-in-up" animation_delay="500"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column_inner][vc_column_inner width="1/2"][impeka_counter counter_end_val="6700" counter_thousands_separator="." counter_heading="h1" title="Lines of code" heading="leader-text" animation="fade-in-up" animation_delay="400" margin_bottom="18"][vc_column_text animation="fade-in-up" animation_delay="500"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][impeka_counter counter_heading="h1" title="Finished Projects" heading="leader-text" animation="fade-in-up" animation_delay="600" margin_bottom="18"][vc_column_text animation="fade-in-up" animation_delay="700"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column_inner][vc_column_inner][impeka_progress_bar values="90|Development,80|Design,70|Marketing" base_color="" heading="link-text"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-2.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="" rc_bg_type="color" columns_gap="60" mobile_columns_vertical_gap="none" rc_bg_color="#ffffff"][vc_column width="1/2" full_height="yes" rc_bg_type="image" rc_bg_position="center-top" expand_column_bg="expand-bg-left" grve_css="{``desktop``:{``padding-top``:``85%``,``class``:``grve-wpb-1599108129840``}}"][/vc_column][vc_column width="1/2" content_width="custom" horizontal_content_position="right" custom_content_width="420"][impeka_empty_space height_multiplier="3x"][impeka_title heading="h4" margin_bottom="30"]We believe in<br />
sharing our expertise.[/impeka_title][vc_column_text]Our dedicated team of creatives is bursting with talent, experience, and passion for what we do, and we’re committed to delivering the very best for your brand. A stunning website, compelling brand messaging, or innovative business development to give you that elusive competitive edge.[/vc_column_text][impeka_empty_space][impeka_progress_bar bar_style="style-2" values="90|Development,80|Web And Domain" color="blue" base_color="" bar_line_style="extra-round" heading="h6"][impeka_empty_space height_multiplier="3x"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-3.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="2x" padding_bottom_multiplier="2x" rc_heading_color="white" rc_bg_type="color" columns_gap="none" mobile_columns_vertical_gap="none" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/3" grve_css="{``desktop``:{``border-right``:1,``border-color``:``#3e3e3e``,``border-style``:``solid``,``class``:``grve-wpb-1599109712975``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_empty_space][impeka_counter counter_end_val="40" counter_suffix="k" counter_color="white" counter_heading="h1" increase_counter_heading="140" title="Instagram Followers" heading="leader-text" align="center" animation="fade-in-up" animation_delay="200"][impeka_empty_space][/vc_column][vc_column width="1/3" grve_css="{``desktop``:{``border-right``:1,``border-color``:``#3e3e3e``,``border-style``:``solid``,``class``:``grve-wpb-1599109720042``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_empty_space][impeka_counter counter_end_val="150" counter_suffix="m" counter_color="white" counter_heading="h1" increase_counter_heading="140" title="Company Turnover" heading="leader-text" align="center" animation="fade-in-up" animation_delay="300"][impeka_empty_space][/vc_column][vc_column width="1/3"][impeka_empty_space][impeka_counter counter_end_val="23" counter_color="white" counter_heading="h1" increase_counter_heading="140" title="Years of Experience" heading="leader-text" align="center" animation="fade-in-up" animation_delay="400"][impeka_empty_space][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 4', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-4.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" mobile_columns_vertical_gap="50"][vc_column width="1/6" tablet_width="hide" tablet_sm_width="hide" mobile_width="hide"][/vc_column][vc_column width="2/3" text_align="center" tablet_width="1"][impeka_title heading="h1" animation="fade-in-up"]Manage your Project
smart and easy[/impeka_title][vc_column_text text_style="leader-text" animation="fade-in-up" animation_delay="100"]Perfectly designed elements and endless customization options.[/vc_column_text][/vc_column][vc_column width="1/6" tablet_width="hide" tablet_sm_width="hide" mobile_width="hide"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column width="1/3"][impeka_counter counter_end_val="90" counter_suffix="%" counter_color="black" counter_heading="h1" increase_counter_heading="140" title="Arabica Coffee" heading="leader-text" align="center" animation="fade-in-up" animation_delay="200"][/vc_column][vc_column width="1/3"][impeka_counter counter_suffix="%" counter_color="black" counter_heading="h1" increase_counter_heading="140" title="Original Coffee" heading="leader-text" align="center" animation="fade-in-up" animation_delay="300"][/vc_column][vc_column width="1/3"][impeka_counter counter_end_val="15" counter_suffix="*" counter_color="black" counter_heading="h1" increase_counter_heading="140" title="Cups of Coffee" heading="leader-text" align="center" animation="fade-in-up" animation_delay="400"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-5';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 5', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-5.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" mobile_columns_vertical_gap="60"][vc_column width="1/3" content_width="custom" horizontal_content_position="center" grve_css="{``desktop``:{``border-right``:1,``padding-right``:``30``,``padding-left``:``30``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599113497918``},``tablet_portrait``:{``border-right``:0},``mobile_landscape``:{``border-right``:0,``padding-right``:``0``,``padding-left``:``0``}}" custom_content_width="270"][impeka_counter counter_end_val="96" counter_suffix="%" title="CSS Capabilities" heading="h5" margin_bottom="18"][vc_column_text]Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read More" btn_type="line" btn_line_position="right" btn_color="black" btn_link="url:%23"][/vc_column][vc_column width="1/3" content_width="custom" horizontal_content_position="center" grve_css="{``desktop``:{``border-right``:1,``padding-right``:``30``,``padding-left``:``30``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599113491325``},``tablet_portrait``:{``border-right``:0},``mobile_landscape``:{``border-right``:0,``padding-right``:``0``,``padding-left``:``0``}}" custom_content_width="270"][impeka_counter counter_end_val="87" counter_suffix="%" title="Development" heading="h5" margin_bottom="18"][vc_column_text]Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read More" btn_type="line" btn_line_position="right" btn_color="black" btn_link="url:%23"][/vc_column][vc_column width="1/3" content_width="custom" horizontal_content_position="center" custom_content_width="270" grve_css="{``desktop``:{``padding-right``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1599113484197``},``mobile_landscape``:{``padding-right``:``0``,``padding-left``:``0``}}"][impeka_counter counter_end_val="34" counter_suffix="%" title="Web And Domain" heading="h5" margin_bottom="18"][vc_column_text]Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read More" btn_type="line" btn_line_position="right" btn_color="black" btn_link="url:%23"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-6';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 6', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-6.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" mobile_columns_vertical_gap="none"][vc_column width="1/4" tablet_sm_width="1-6" mobile_width="hide"][/vc_column][vc_column width="1/2" text_align="center" tablet_sm_width="2-3"][impeka_title heading="subtitle-text" margin_bottom="30"]Amazing simplicity[/impeka_title][impeka_title heading="h4"]You’ll have everything you’ll need inside a powerful back-end[/impeka_title][/vc_column][vc_column width="1/4" tablet_sm_width="1-6" mobile_width="hide"][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="none" equal_column_height="equal" mobile_columns_vertical_gap="none"][vc_column_inner width="1/4" grve_css="{``desktop``:{``border-right``:1,``border-bottom``:1,``padding-top``:``17%``,``padding-right``:``17%``,``padding-bottom``:``17%``,``padding-left``:``17%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599016856363``},``mobile_landscape``:{``border-right``:0}}"][impeka_counter counter_end_val="32" counter_color="black" counter_heading="h3" title="Video Tutorials" heading="link-text" align="center" animation="zoom-in" animation_delay="200"][/vc_column_inner][vc_column_inner width="1/4" grve_css="{``desktop``:{``border-right``:1,``border-bottom``:1,``padding-top``:``17%``,``padding-right``:``17%``,``padding-bottom``:``17%``,``padding-left``:``17%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599016863368``},``mobile_landscape``:{``border-right``:0}}"][impeka_counter counter_end_val="24" counter_prefix="+" counter_color="black" counter_heading="h3" title="Years of Experience" heading="link-text" align="center" animation="zoom-in" animation_delay="300"][/vc_column_inner][vc_column_inner width="1/4" grve_css="{``desktop``:{``border-right``:1,``border-bottom``:1,``padding-top``:``17%``,``padding-right``:``17%``,``padding-bottom``:``17%``,``padding-left``:``17%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599016868668``},``mobile_landscape``:{``border-right``:0}}"][impeka_counter counter_end_val="60" counter_color="black" counter_heading="h3" title="Happy Clients" heading="link-text" align="center" animation="zoom-in" animation_delay="400"][/vc_column_inner][vc_column_inner width="1/4" grve_css="{``desktop``:{``border-bottom``:1,``padding-top``:``17%``,``padding-right``:``17%``,``padding-bottom``:``17%``,``padding-left``:``17%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599016536382``}}"][impeka_counter counter_end_val="32" counter_color="black" counter_heading="h3" title="Video Tutorials" heading="link-text" align="center" animation="zoom-in" animation_delay="500"][/vc_column_inner][vc_column_inner width="1/4" grve_css="{``desktop``:{``border-right``:1,``padding-top``:``17%``,``padding-right``:``17%``,``padding-bottom``:``17%``,``padding-left``:``17%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599016899000``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_counter counter_end_val="268" counter_color="black" counter_heading="h3" title="Cups of Coffee" heading="link-text" align="center" animation="zoom-in" animation_delay="300"][/vc_column_inner][vc_column_inner width="1/4" grve_css="{``desktop``:{``border-right``:1,``padding-top``:``17%``,``padding-right``:``17%``,``padding-bottom``:``17%``,``padding-left``:``17%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599016906142``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_counter counter_end_val="53" counter_suffix="k" counter_color="black" counter_heading="h3" title="Instagram Followers" heading="link-text" align="center" animation="zoom-in" animation_delay="400"][/vc_column_inner][vc_column_inner width="1/4" grve_css="{``desktop``:{``border-right``:1,``padding-top``:``17%``,``padding-right``:``17%``,``padding-bottom``:``17%``,``padding-left``:``17%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599016914040``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_counter counter_end_val="12" counter_suffix="k" counter_color="black" counter_heading="h3" title="Closed Tickets" heading="link-text" align="center" animation="zoom-in" animation_delay="500"][/vc_column_inner][vc_column_inner width="1/4" grve_css="{``desktop``:{``padding-top``:``17%``,``padding-right``:``17%``,``padding-bottom``:``17%``,``padding-left``:``17%``,``class``:``grve-wpb-1599016563066``}}"][impeka_counter counter_end_val="356" counter_color="black" counter_heading="h3" title="Cups of Coffee" heading="link-text" align="center" animation="zoom-in" animation_delay="600"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-7';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 7', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-7.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" mobile_columns_vertical_gap="none"][vc_column width="1/2"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" animation_delay="200" margin_bottom="30"]Simply Impeccable[/impeka_title][impeka_title heading="h4"]We love to work with clients all over the world to develop unique, innovative and modern websites.[/impeka_title][/vc_column][vc_column width="1/2"][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][impeka_divider][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner][vc_column_inner width="1/4" mobile_width="1-2"][impeka_counter counter_end_val="83" counter_suffix="%" counter_color="black" counter_heading="h3" title="WP Framework" heading="h6" animation="fade-in-up" animation_delay="200"][/vc_column_inner][vc_column_inner width="1/4" mobile_width="1-2"][impeka_counter counter_end_val="56" counter_suffix="%" counter_color="black" counter_heading="h3" title="CSS Capabilities" heading="h6" animation="fade-in-up" animation_delay="300"][/vc_column_inner][vc_column_inner width="1/4" mobile_width="1-2"][impeka_counter counter_end_val="72" counter_suffix="%" counter_color="black" counter_heading="h3" title="Web And Domain" heading="h6" animation="fade-in-up" animation_delay="400"][/vc_column_inner][vc_column_inner width="1/4" mobile_width="1-2"][impeka_counter counter_end_val="94" counter_suffix="%" counter_color="black" counter_heading="h3" title="JQuery Power" heading="h6" animation="fade-in-up" animation_delay="500"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-8';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 8', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-8.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_heading_color="white" rc_bg_type="color" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][impeka_title heading="subtitle-text" margin_bottom="30"]Out of love for WP themes [/impeka_title][impeka_title title_color="custom" title_color_custom="#e3cc9d"]A full branding &amp; experience design agency in Barcelona.[/impeka_title][vc_column_text text_style="leader-text"]User experience is one of our highest priorities, and the clean and contemporary interface of Impeka is the icing on the premium cake.[/vc_column_text][impeka_empty_space height_multiplier="2x"][impeka_progress_bar bar_style="style-2" values="60|CSS Capabilities,90| Support,70| Development,50|CSS Design" color="grey" base_color="" bar_height="3" bar_line_style="round"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-9';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 9', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-9.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="" rc_bg_type="color" columns_gap="none" mobile_columns_vertical_gap="none" rc_bg_color="#ffffff"][vc_column width="5/12" vertical_content_position="middle" mobile_column_order="1" grve_css="{``desktop``:{``z-index``:3,``class``:``grve-wpb-1599107368823``}}"][impeka_single_image image_mode="medium_large" image_load_mode="off" image_column_space="125" inherit_align="left" animation="clipping-animation" clipping_animation="colored-clipping-left" animation_delay="400"][/vc_column][vc_column width="7/12" rc_bg_type="color" expand_column_bg="expand-bg-right" mobile_column_order="2" rc_bg_color="#f9f9f9" grve_css="{``desktop``:{``padding-left``:``30%``,``class``:``grve-wpb-1599107266917``},``mobile_landscape``:{``padding-left``:``30``}}"][impeka_empty_space height_multiplier="4x"][impeka_title heading="h4"]We believe in<br />
sharing our expertise.[/impeka_title][vc_column_text]Our dedicated team of creatives is bursting with talent, experience, and passion for what we do, and we’re committed to delivering the very best for your brand.[/vc_column_text][impeka_empty_space][impeka_progress_bar bar_style="style-2" values="90|Development,80|Design,70|Marketing" heading="link-text"][impeka_empty_space height_multiplier="4x"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-10';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 10', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-10.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" rc_bg_color="#ffffff"][vc_column width="1/6" tablet_sm_width="1-12" mobile_width="hide"][/vc_column][vc_column width="2/3" tablet_width="5-6" tablet_sm_width="11-12"][vc_row_inner columns_gap="60"][vc_column_inner][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" margin_bottom="30"]Our Services[/impeka_title][vc_column_text text_style="leader-text"]Through our in-house freelancing services, including expert graphic design and web development, elegant copywriting and ingenious content strategy, we’ve <u>become renowned</u> for quality and reliability – and we earn that reputation for greatness every day![/vc_column_text][/vc_column_inner][vc_column_inner][impeka_empty_space height_multiplier="3x"][/vc_column_inner][vc_column_inner width="1/2"][impeka_counter counter_end_val="400" counter_prefix="+" counter_color="black" counter_heading="h1" title="Satisfied Customers" heading="leader-text" animation="fade-in-up" animation_delay="200" margin_bottom="18"][vc_column_text animation="fade-in-up" animation_delay="300"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][impeka_counter counter_end_val="2500" counter_thousands_separator="." counter_color="black" counter_heading="h1" title="Working Hours" heading="leader-text" animation="fade-in-up" animation_delay="400" margin_bottom="18"][vc_column_text animation="fade-in-up" animation_delay="500"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column_inner][vc_column_inner width="1/2"][impeka_counter counter_end_val="6700" counter_thousands_separator="." counter_color="black" counter_heading="h1" title="Lines of code" heading="leader-text" animation="fade-in-up" animation_delay="400" margin_bottom="18"][vc_column_text animation="fade-in-up" animation_delay="500"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][impeka_counter counter_color="black" counter_heading="h1" title="Finished Projects" heading="leader-text" animation="fade-in-up" animation_delay="600" margin_bottom="18"][vc_column_text animation="fade-in-up" animation_delay="700"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/6" tablet_width="hide" tablet_sm_width="hide" mobile_width="hide"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-11';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 11', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-11.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/6" tablet_sm_width="1-12"][/vc_column][vc_column width="3/4" tablet_width="5-6" tablet_sm_width="11-12"][vc_row_inner][vc_column_inner width="1/3"][impeka_counter counter_end_val="96" counter_suffix="%" counter_color="white" counter_heading="leader-text" increase_counter_heading="250" title="CSS Capabilities" heading="h6" margin_bottom="24"][vc_column_text]Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][impeka_counter counter_end_val="85" counter_suffix="%" counter_color="white" counter_heading="leader-text" increase_counter_heading="250" title="Development" heading="h6" margin_bottom="24"][vc_column_text]Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][impeka_counter counter_end_val="34" counter_suffix="%" counter_color="white" counter_heading="leader-text" increase_counter_heading="250" title="Web And Domain" heading="h6" margin_bottom="24"][vc_column_text]Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner][impeka_empty_space height_multiplier="3x"][/vc_column_inner][vc_column_inner width="1/3"][impeka_counter counter_end_val="79" counter_suffix="%" counter_color="white" counter_heading="leader-text" increase_counter_heading="250" title="JQuery Power" heading="h6" margin_bottom="24"][vc_column_text]Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][impeka_counter counter_end_val="93" counter_suffix="%" counter_color="white" counter_heading="leader-text" increase_counter_heading="250" title="Web Design" heading="h6" margin_bottom="24"][vc_column_text]Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][impeka_counter counter_end_val="58" counter_suffix="%" counter_color="white" counter_heading="leader-text" increase_counter_heading="250" title="WP Framework" heading="h6" margin_bottom="24"][vc_column_text]Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/12" tablet_width="hide" tablet_sm_width="hide"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-12';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 12', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-12.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" mobile_columns_vertical_gap="none"][vc_column width="1/2" content_width="custom" horizontal_content_position="center" rc_bg_type="color" animation="clipping" clipping_animation="colored-clipping-left" tablet_sm_width="1" rc_bg_color="#ffe7e5" grve_css="{``desktop``:{``padding-top``:``25%``,``padding-right``:``30``,``padding-bottom``:``25%``,``padding-left``:``30``,``class``:``grve-wpb-1608311507910``},``tablet_portrait``:{``padding-top``:``12%``,``padding-bottom``:``12%``},``mobile_landscape``:{``padding-top``:``25%``,``padding-right``:``30``,``padding-bottom``:``25%``,``padding-left``:``30``}}" custom_content_width="370" rc_font_color="#ff695c"][impeka_title heading="h2" title_color="custom" title_color_custom="#ff695c"]Build a website which loads fast.[/impeka_title][vc_column_text text_style="leader-text"]Lorem ipsum dolor sit adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus.[/vc_column_text][/vc_column][vc_column width="1/2" content_width="custom" horizontal_content_position="center" rc_bg_type="color" animation="clipping" clipping_animation="colored-clipping-left" tablet_sm_width="1" rc_bg_color="#ff695c" custom_content_width="370" grve_css="{``desktop``:{``padding-top``:``25%``,``padding-right``:``30``,``padding-bottom``:``25%``,``padding-left``:``30``,``class``:``grve-wpb-1608311536249``},``tablet_portrait``:{``padding-top``:``12%``,``padding-bottom``:``12%``},``mobile_landscape``:{``padding-top``:``25%``,``padding-right``:``30``,``padding-bottom``:``25%``,``padding-left``:``30``}}" rc_font_color="#b62519"][impeka_title heading="h2" title_color="custom" title_color_custom="#b62519"]Build a website which loads fast.[/impeka_title][vc_column_text text_style="leader-text"]Lorem ipsum dolor sit adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus.[/vc_column_text][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier=""][vc_column grve_css="{``desktop``:{``margin-top``:``-9%``,``class``:``grve-wpb-1608311145078``}}"][vc_row_inner padding_top_multiplier="2x" padding_bottom_multiplier="2x" rc_heading_color="white" rc_bg_type="color" rc_font_color="#ffffff" rc_bg_color="#0a0a0a"][vc_column_inner width="1/4" mobile_width="1-2"][impeka_counter counter_end_val="80" counter_suffix="%" counter_color="white" counter_heading="h4" title="Marketing" heading="h6" align="center"][/vc_column_inner][vc_column_inner width="1/4" mobile_width="1-2"][impeka_counter counter_end_val="95" counter_suffix="%" counter_color="white" counter_heading="h4" title="CSS Capabilities" heading="h6" align="center"][/vc_column_inner][vc_column_inner width="1/4" mobile_width="1-2"][impeka_counter counter_end_val="78" counter_suffix="%" counter_color="white" counter_heading="h4" title="CSS Design" heading="h6" align="center"][/vc_column_inner][vc_column_inner width="1/4" mobile_width="1-2"][impeka_counter counter_end_val="86" counter_suffix="%" counter_color="white" counter_heading="h4" title="SEO Optimized" heading="h6" align="center"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'progress-13';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Progress 13', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/progress/progress-13.jpg');
$data['custom_class'] = 'progress';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="6x" padding_bottom_multiplier="4x" rc_bg_type="color" separator_top="tilt-right-separator" rc_bg_color="#ffffff"][vc_column][vc_row_inner][vc_column_inner width="1/2"][impeka_title]From just <span class="grve-underline grve-line-primary-1">25$/month</span> you get full package and personal trainer.[/impeka_title][/vc_column_inner][vc_column_inner width="1/2" vertical_content_position="middle" text_align="right" mobile_text_align="left"][impeka_button btn_text="Request Private Session" btn_type="only-text" btn_color="black" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_svg_icon_color="black"][/vc_column_inner][vc_column_inner][impeka_empty_space height_multiplier="2x"][/vc_column_inner][/vc_row_inner][vc_row_inner columns_gap="50"][vc_column_inner width="1/3"][impeka_counter counter_end_val="87" counter_suffix="%" counter_color="black" counter_heading="h1" title="GROUP EXERCISE" heading="h6" align="left"][impeka_empty_space][vc_column_text]A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.[/vc_column_text][impeka_divider line_type="custom-line" line_width="50%" line_height="4" padding_top="40" padding_bottom="40"][impeka_button btn_text="More" btn_type="only-text" btn_color="black" btn_hover_color="primary-1" btn_size="large" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Ftrainers%2F"][/vc_column_inner][vc_column_inner width="1/3"][impeka_counter counter_end_val="96" counter_suffix="%" counter_color="black" counter_heading="h1" title="PERSONALIZED DIET PLAN" heading="h6" align="left"][impeka_empty_space][vc_column_text]A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.[/vc_column_text][impeka_divider line_type="custom-line" line_width="50%" line_height="4" padding_top="40" padding_bottom="40"][impeka_button btn_text="More" btn_type="only-text" btn_color="black" btn_hover_color="primary-1" btn_size="large" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Ftrainers%2F"][/vc_column_inner][vc_column_inner width="1/3"][impeka_counter counter_end_val="93" counter_suffix="%" counter_color="black" counter_heading="h1" title="SWIMMING POOL" heading="h6" align="left"][impeka_empty_space][vc_column_text]A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.[/vc_column_text][impeka_divider line_type="custom-line" line_width="50%" line_height="4" padding_top="40" padding_bottom="40"][impeka_button btn_text="More" btn_type="only-text" btn_color="black" btn_hover_color="primary-1" btn_size="large" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Ftrainers%2F"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'media-box-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Media Box 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/media-box/media-box-1.jpg');
$data['custom_class'] = 'media-box';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/2"][impeka_media_box media_style="style-2" bg_image_size="medium_large" image="https://source.unsplash.com/1140x800" overlay_opacity="45" title="Online Support" heading="h5" title_link="url:%23" read_more_title="Read More" animation="fade-in-up" animation_delay="200"]You’ll have everything you’ll need<br />
inside a powerful back-end.[/impeka_media_box][/vc_column][vc_column width="1/2"][impeka_media_box media_style="style-2" bg_image_size="medium_large" image="https://source.unsplash.com/1140x800" overlay_opacity="45" title="Build your shop" heading="h5" title_link="url:%23" read_more_title="Read More" animation="fade-in-up" animation_delay="400"]Create your shop in a few minutes<br />
and customize everything as you wish.[/impeka_media_box][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'portfolio-section-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Section 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/portfolio-section-3.jpg');
$data['custom_class'] = 'portfolio';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" mobile_columns_vertical_gap="none" rc_font_color="#ffffff" rc_bg_color="#f1c1c6"][vc_column width="1/3" vertical_content_position="bottom" mobile_column_order="2" grve_css="{``desktop``:{``padding-top``:``80%``,``padding-right``:``12%``,``padding-bottom``:``12%``,``padding-left``:``12%``,``class``:``grve-wpb-1593508932124``},``mobile_landscape``:{``padding-top``:``12%``,``padding-right``:``12%``,``padding-bottom``:``12%``,``padding-left``:``12%``}}"][impeka_title heading="h5" margin_bottom="18"]Logo Design[/impeka_title][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo. [/vc_column_text][/vc_column][vc_column width="2/3" full_height="yes" rc_bg_type="image" rc_bg_image="" mobile_column_order="1" grve_css="{``desktop``:{``padding-bottom``:``20%``,``class``:``grve-wpb-1593508920825``},``mobile_landscape``:{``padding-bottom``:``60%``}}"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'portfolio-section-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Section 4', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/portfolio-section-4.jpg');
$data['custom_class'] = 'portfolio';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" mobile_columns_vertical_gap="none" min_height="370"][vc_column width="1/6" full_height="yes" rc_bg_type="color" animation="clipping" mobile_width="1-4" rc_bg_color="#f1c1c6" grve_css="{``desktop``:{``padding-top``:``80%``,``class``:``grve-wpb-1593608750003``}}"][/vc_column][vc_column width="1/6" full_height="yes" rc_bg_type="color" animation="clipping" animation_delay="200" mobile_width="1-4" rc_bg_color="#e2afb4" grve_css="{``desktop``:{``padding-top``:``80%``,``class``:``grve-wpb-1593608755301``}}"][/vc_column][vc_column width="1/6" full_height="yes" rc_bg_type="color" animation="clipping" animation_delay="400" mobile_width="1-4" rc_bg_color="#fdefee" grve_css="{``desktop``:{``padding-top``:``80%``,``class``:``grve-wpb-1593608775721``}}"][/vc_column][vc_column width="1/6" full_height="yes" rc_bg_type="color" animation="clipping" animation_delay="600" mobile_width="1-4" rc_bg_color="#fef4f3" grve_css="{``desktop``:{``padding-top``:``80%``,``class``:``grve-wpb-1593608784906``}}"][/vc_column][vc_column width="1/3" vertical_content_position="bottom" grve_css="{``desktop``:{``padding-top``:``12%``,``padding-right``:``12%``,``padding-bottom``:``12%``,``padding-left``:``12%``,``class``:``grve-wpb-1593511492201``}}"][impeka_title heading="h5" animation="appear-animation" appear_animation="appear-down" animation_delay="800" margin_bottom="18"]Color Palete[/impeka_title][vc_column_text animation="fade-in" animation_delay="1000" animation_duration="slow"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'portfolio-section-5';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Section 5', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/portfolio-section-5.jpg');
$data['custom_class'] = 'portfolio image-text';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" scroll_header_skin="light"][vc_column width="1/3" full_height="yes" tablet_sm_width="1-2"][vc_row_inner height_ratio="100" padding_top_multiplier="" padding_bottom_multiplier=""][vc_column_inner rc_bg_type="image" grve_css="{``desktop``:{``padding-top``:``75%``,``class``:``grve-wpb-1593517598348``}}"][/vc_column_inner][vc_column_inner vertical_content_position="bottom" grve_css="{``desktop``:{``padding-top``:``12%``,``padding-right``:``12%``,``padding-bottom``:``12%``,``padding-left``:``12%``,``class``:``grve-wpb-1593517697740``}}"][impeka_title heading="h5" margin_bottom="18"]Card Mockup[/impeka_title][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="2/3" full_height="yes" rc_bg_type="image" tablet_sm_width="1-2" grve_css="{``desktop``:{``padding-top``:``75%``,``class``:``grve-wpb-1593517382432``}}"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-1.jpg');
$data['custom_class'] = 'image-text portfolio';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" rc_bg_type="color" rc_bg_color="#dccfbd"][vc_column width="1/2" content_width="custom" horizontal_content_position="center" vertical_content_position="middle" text_align="center" grve_css="{``desktop``:{``padding-top``:``8%``,``padding-right``:``8%``,``padding-bottom``:``8%``,``padding-left``:``8%``,``class``:``grve-wpb-1593518673643``}}" custom_content_width="600"][impeka_title heading="subtitle-text" margin_bottom="30"]The New Theme On The Block[/impeka_title][impeka_title]Impeka is a creative and multipurpose WP theme that gives you unparalleled versatility.[/impeka_title][/vc_column][vc_column width="1/2"][impeka_single_image image_mode="square" image="" image_column_space="100"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-2.jpg');
$data['custom_class'] = 'image-text portfolio';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" rc_bg_type="color" separator_top="line-separator" separator_top_size="50%" separator_bottom_size="50%" separator_bottom_color="" rc_bg_color="#f3e800"][vc_column width="1/4" tablet_sm_width="1-6" mobile_width="hide"][/vc_column][vc_column width="3/4" tablet_sm_width="5-6"][impeka_single_image image_mode="full" image_column_space="100" animation="clipping-animation" clipping_animation="clipping-left" animation_delay="100"][/vc_column][/vc_row][vc_row section_type="fullwidth" padding_top_multiplier="3x" padding_bottom_multiplier="4x" rc_bg_type="color" mobile_columns_vertical_gap="none" rc_bg_color="#f3e800"][vc_column width="1/4" tablet_sm_width="1-6" mobile_width="hide"][/vc_column][vc_column width="3/4" content_width="custom" tablet_sm_width="5-6" tablet_content_width="80" tablet_sm_content_width="85" mobile_content_width="80" tablet_sm_horizontal_content_position="left" mobile_horizontal_content_position="center" custom_content_width="970"][impeka_title heading="h2" animation="fade-in-up"]Simply choose from our pre-made designs, get inspired, and mould them to your needs with more than 50 handcrafted elements at your fingertips.[/impeka_title][impeka_empty_space height_multiplier="2x"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" tablet_sm_columns_vertical_gap="60"][vc_column_inner width="1/2" tablet_sm_width="1"][vc_column_text animation="fade-in-up" animation_delay="200"]When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, and but a few stray gleams steal into the inner sanctuary, I throw myself down among the tall grass by the trickling stream[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" tablet_sm_width="1"][vc_column_text animation="fade-in-up" animation_delay="300"]A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.[/vc_column_text][/vc_column_inner][/vc_row_inner][impeka_empty_space height_multiplier="2x"][impeka_button btn_fluid="yes" btn_fluid_height="short" btn_text="Read more about" btn_color_gradient="black" btn_hover_color_gradient="white" animation="fade-in-up" animation_delay="400"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-7';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 7', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-7.jpg');
$data['custom_class'] = 'image-text';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/2"][impeka_single_image image_mode="large" image="https://source.unsplash.com/1440x1380"][/vc_column][vc_column width="1/2" content_width="custom" horizontal_content_position="center" vertical_content_position="middle" custom_content_width="360" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1598856907387``}}"][impeka_title heading="subtitle-text" margin_bottom="18"]Impeka Theme[/impeka_title][impeka_title]User experience is one of our highest priorities.[/impeka_title][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo. Vestibulum aliquam hendrerit molestie.[/vc_column_text][impeka_empty_space height_multiplier="2x"][impeka_button btn_text="Read More About" btn_type="only-text" btn_color="white" btn_hover_color="white" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon_shape="circle"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-8';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 8', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-8.jpg');
$data['custom_class'] = 'image-text';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/2" content_width="custom" horizontal_content_position="center" vertical_content_position="middle" mobile_column_order="2" custom_content_width="360" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1598857299242``}}"][impeka_title heading="subtitle-text" margin_bottom="18"]Greatives Team[/impeka_title][impeka_title]Our dedicated team of creatives is bursting with talent.[/impeka_title][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo. Vestibulum aliquam hendrerit molestie.[/vc_column_text][impeka_empty_space height_multiplier="2x"][impeka_button btn_text="Read More About" btn_type="only-text" btn_color="white" btn_hover_color="white" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon_shape="circle"][/vc_column][vc_column width="1/2" mobile_column_order="1"][impeka_single_image image_mode="large" image="https://source.unsplash.com/1440x1380"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-9';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 9', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-9.jpg');
$data['custom_class'] = 'image-text';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="2x" padding_bottom_multiplier="2x" rc_bg_type="gradient" rc_bg_gradient_color_1="#ffffff" rc_bg_gradient_color_2="#fafafa" rc_bg_gradient_direction="180"][vc_column width="5/12" content_width="custom" vertical_content_position="middle" mobile_column_order="2" custom_content_width="370"][impeka_title heading_tag="h2" animation="clipping-animation"]You don’t need<br />
any coding skills[/impeka_title][vc_column_text animation="fade-in" animation_delay="200"]Our goal has always been to motivate, encourage and release our fellow creatives to do their thing, so we’ve lovingly crafted a theme that is both super easy to use and packed full of endless possibilities.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read More" btn_type="only-text" btn_color="black" btn_link="url:%23|||" btn_icon_type="icon-svg" btn_svg_icon="arrow-2" animation_delay="400"][/vc_column][vc_column width="7/12" vertical_content_position="middle" mobile_column_order="1" grve_css="{``desktop``:{``padding-top``:``18%``,``padding-bottom``:``18%``,``padding-left``:``30%``,``class``:``grve-wpb-1598977695960``},``tablet_portrait``:{``padding-left``:``25%``},``mobile_landscape``:{``padding-left``:``0``}}"][impeka_cascading_image image_item="%5B%7B%22label%22%3A%22Image%201%22%2C%22image_mode%22%3A%22medium_large%22%2C%22image%22%3A%22https%3A%2F%2Fsource.unsplash.com%2F940x600%22%2C%22offset_x%22%3A%22-10%25%22%2C%22offset_y%22%3A%2210%25%22%2C%22radius%22%3A%22none%22%2C%22shadow%22%3A%22none%22%2C%22animation_delay%22%3A%22100%22%2C%22animation_duration%22%3A%22normal%22%7D%2C%7B%22label%22%3A%22Image%202%22%2C%22image_mode%22%3A%22medium_large%22%2C%22image%22%3A%22https%3A%2F%2Fimages.unsplash.com%2Fphoto-1517281749396-564b95a206c3%3Ffit%3Dcrop%26amp%3Bw%3D940%26amp%3Bh%3D600%26amp%3Bq%3D80%22%2C%22offset_x%22%3A%2210%25%22%2C%22offset_y%22%3A%22-10%25%22%2C%22radius%22%3A%22none%22%2C%22shadow%22%3A%22medium%22%2C%22animation_delay%22%3A%22400%22%2C%22animation_duration%22%3A%22normal%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-10';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 10', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-10.jpg');
$data['custom_class'] = 'image-text';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier=""][vc_column][impeka_empty_space height_multiplier="custom" height="12vw"][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#9b958f"][vc_column width="5/12" vertical_content_position="bottom" grve_css="{``desktop``:{``margin-top``:``-16%``,``class``:``grve-wpb-1599200970539``}}"][impeka_single_image image_mode="medium" image="https://source.unsplash.com/698x900" image_load_mode="off" image_column_space="100" animation="fade-in-left" animation_duration="slow"][/vc_column][vc_column width="7/12" vertical_content_position="middle" mobile_text_align="center"][impeka_empty_space][impeka_animated_text animated_text="|Out of love for stylish and functional WP themes with many configuration options in a user-friendly environment.|" heading="h4" style="style-2" animation_delay="600" animation_duration="very-fast"][impeka_empty_space][impeka_title heading="link-text" animation="fade-in" animation_delay="1300"]Gabriel Moreira[/impeka_title][impeka_empty_space][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-11';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 11', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-11.jpg');
$data['custom_class'] = 'image-text';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="" rc_bg_type="color" rc_bg_color="#ffffff"][vc_column width="1/3" content_width="custom" horizontal_content_position="center" vertical_content_position="bottom" tablet_sm_width="5-12" custom_content_width="370"][impeka_single_image image_mode="medium_large" image="https://source.unsplash.com/740x1180" animation="fade-in-left" animation_delay="400"][/vc_column][vc_column width="2/3" vertical_content_position="bottom" tablet_sm_width="7-12"][vc_row_inner columns_gap="60" tablet_sm_columns_vertical_gap="30" mobile_columns_vertical_gap="45"][vc_column_inner width="7/12" vertical_content_position="middle" tablet_width="2-3" tablet_sm_width="1" mobile_text_align="center"][impeka_title]We guarantee you support for everyone. [/impeka_title][/vc_column_inner][vc_column_inner width="5/12" vertical_content_position="middle" text_align="right" tablet_width="1-3" tablet_sm_width="1" tablet_sm_text_align="left" mobile_text_align="center"][impeka_button btn_text="Purchase Impeka" btn_color_gradient="primary-2" btn_size="small" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon="arrow-2"][/vc_column_inner][vc_column_inner tablet_sm_width="hide" mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column_inner][vc_column_inner width="1/3" content_width="custom" horizontal_content_position="center" tablet_sm_width="1-2" mobile_width="1" mobile_text_align="center" custom_content_width="300"][impeka_title heading="h6"]<span style="color: #687cff;">01.</span> People[/impeka_title][vc_column_text]Interdum et malesuada fames ac ante ipsum primis in id nisi nec nulla luctus lacinia.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" content_width="custom" horizontal_content_position="center" tablet_sm_width="1-2" mobile_width="1" mobile_text_align="center" custom_content_width="300"][impeka_title heading="h6"]<span style="color: #687cff;">02.</span> Design[/impeka_title][vc_column_text]Interdum et malesuada fames ac ante ipsum primis in id nisi nec nulla luctus lacinia.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" content_width="custom" horizontal_content_position="center" tablet_sm_width="1-2" mobile_text_align="center" custom_content_width="300"][impeka_title heading="h6"]<span style="color: #687cff;">03.</span> Philosophy[/impeka_title][vc_column_text]Interdum et malesuada fames ac ante ipsum primis in id nisi nec nulla luctus lacinia.[/vc_column_text][/vc_column_inner][vc_column_inner tablet_sm_width="hide" mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column_inner][vc_column_inner width="1/3" content_width="custom" horizontal_content_position="center" tablet_sm_width="1-2" mobile_text_align="center" custom_content_width="300"][impeka_title heading="h6"]<span style="color: #687cff;">04.</span> Scope[/impeka_title][vc_column_text]Interdum et malesuada fames ac ante ipsum primis in id nisi nec nulla luctus lacinia.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" content_width="custom" horizontal_content_position="center" tablet_sm_width="1-2" mobile_text_align="center" custom_content_width="300"][impeka_title heading="h6"]<span style="color: #687cff;">05.</span> Passion[/impeka_title][vc_column_text]Interdum et malesuada fames ac ante ipsum primis in id nisi nec nulla luctus lacinia.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" content_width="custom" horizontal_content_position="center" tablet_sm_width="1-2" mobile_text_align="center" custom_content_width="300"][impeka_title heading="h6"]<span style="color: #687cff;">06.</span> Ideas[/impeka_title][vc_column_text]Interdum et malesuada fames ac ante ipsum primis in id nisi nec nulla luctus lacinia.[/vc_column_text][/vc_column_inner][vc_column_inner][impeka_empty_space height_multiplier="2x"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-17';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 17', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-17.jpg');
$data['custom_class'] = 'image-text shop';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" columns_gap="none" mobile_columns_vertical_gap="none"][vc_column width="5/12" content_width="custom" horizontal_content_position="center" vertical_content_position="middle" full_height="yes" rc_bg_type="color" mobile_column_order="2" rc_bg_color="#f7f7f7" custom_content_width="270" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1608537451688``},``mobile_landscape``:{``padding-top``:``60``,``padding-bottom``:``60``}}"][impeka_title heading="h4"]Visit Our Store[/impeka_title][vc_column_text]A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my heart.[/vc_column_text][impeka_divider padding_top="30" padding_bottom="30"][vc_column_text]19 Maypole Crescent, London,<br />
UK | 0 (354) 123 4567[/vc_column_text][/vc_column][vc_column width="7/12" vertical_content_position="middle" mobile_column_order="1"][impeka_single_image image_mode="medium_large" image="https://source.unsplash.com/740x495" image_column_space="100"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-18';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 18', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-18.jpg');
$data['custom_class'] = 'image-text shop';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/2" content_width="custom" mobile_content_width="100" custom_content_width="470"][impeka_single_image image_mode="medium_large" image="https://source.unsplash.com/470x500"][/vc_column][vc_column width="1/2" vertical_content_position="middle" animation="fade-in" animation_delay="100"][impeka_title heading="h6"]<span style="color: #b7f300;">Power</span> Training[/impeka_title][impeka_empty_space][impeka_title]Expect a slimmer waist, a lifted booty and a sexy back.[/impeka_title][vc_column_text text_style="leader-text"]A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. [/vc_column_text][impeka_empty_space][impeka_button btn_text="Book this class" btn_type="only-text" btn_color="black" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_svg_icon_color="black"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-19';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 19', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-19.jpg');
$data['custom_class'] = 'image-text shop';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" columns_gap="60" separator_top="line-separator" separator_top_size="50%" separator_top_color="#b7f300"][vc_column width="1/2" grve_css="{``desktop``:{``margin-bottom``:``-20%``,``class``:``grve-wpb-1631960737446``},``mobile_landscape``:{``margin-bottom``:``0``}}"][impeka_single_image image_mode="medium_large" image="https://source.unsplash.com/470x500" animation_delay="100"][/vc_column][vc_column width="1/2" animation="fade-in" animation_delay="100"][vc_column_text text_style="link-text"]All our trainers are award[/vc_column_text][impeka_empty_space][impeka_title heading_tag="h2" heading="h4"]Come discover a diverse selection of classes, led by top quality trainers[/impeka_title][impeka_empty_space height_multiplier="3x"][impeka_single_image image_mode="medium_large" image="https://source.unsplash.com/570x570" animation_delay="300"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'shop-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Shop 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/shop/shop-1.jpg');
$data['custom_class'] = 'shop';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="2x" padding_bottom_multiplier="2x" tablet_sm_columns_vertical_gap="30"][vc_column width="1/2" full_height="yes" text_align="center" add_column_link="yes" column_link="url:%23" rc_bg_type="color" tablet_sm_width="1" rc_bg_color="#f7f7f7" grve_css="{``desktop``:{``padding-top``:``60``,``padding-right``:``70``,``padding-bottom``:``70``,``padding-left``:``70``,``class``:``grve-wpb-1608554078196``}}"][impeka_single_image image="https://placehold.co/400x405/EFEFEF/E7E7E7?text=Product Image" retina_image="https://placehold.co/800x810/EFEFEF/E7E7E7?text=Product Image" margin_bottom="20"][impeka_title heading="h4"]Accesories[/impeka_title][/vc_column][vc_column width="1/2" tablet_sm_width="1"][vc_row_inner rc_bg_type="color" columns_gap="none" rc_bg_color="#fafafa"][vc_column_inner width="1/2" vertical_content_position="middle" mobile_column_order="2" grve_css="{``desktop``:{``padding-left``:``30``,``class``:``grve-wpb-1608554413625``},``mobile_landscape``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``}}"][impeka_title heading="h4"]Get 20% off<br />
to any items[/impeka_title][vc_column_text]All you need to do is share this page.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Start your journey" btn_color_gradient="black" btn_hover_action="pulse" btn_size="small" btn_link="url:%23"][/vc_column_inner][vc_column_inner width="1/2" mobile_column_order="1"][impeka_single_image image_mode="medium" image="https://placehold.co/300x300/f5f5f5/F0EFEF?text=Product Image"][/vc_column_inner][/vc_row_inner][impeka_empty_space][vc_row_inner rc_bg_type="color" columns_gap="none" rc_bg_color="#f0ede8"][vc_column_inner width="1/2" vertical_content_position="middle" mobile_column_order="2" grve_css="{``desktop``:{``padding-left``:``30``,``class``:``grve-wpb-1608554396539``},``mobile_landscape``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``}}"][impeka_title heading="h4"]Get 20% off<br />
to any items[/impeka_title][vc_column_text]All you need to do is share this page.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Start your journey" btn_color_gradient="black" btn_hover_action="pulse" btn_size="small" btn_link="url:%23"][/vc_column_inner][vc_column_inner width="1/2" mobile_column_order="1"][impeka_single_image image_mode="medium" image="https://placehold.co/300x300/E1DCD3/D3CCBF?text=Product Image"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-1.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="2x"][vc_column width="1/4"][/vc_column][vc_column width="1/2" text_align="center"][impeka_title heading="subtitle-text" margin_bottom="30"]The New Theme On The Block[/impeka_title][impeka_title]Impeka is a creative and multipurpose WP theme that gives you unparalleled versatility.[/impeka_title][impeka_divider line_type="vertical-line" line_width="1" line_color="black" padding_top="30"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-2.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="gradient" rc_bg_gradient_color_1="#f6f6f6" rc_bg_gradient_color_2="#e4e1df" rc_bg_gradient_direction="135"][vc_column width="1/4" tablet_sm_width="1-6"][/vc_column][vc_column width="3/4" tablet_sm_width="11-12"][impeka_animated_text animated_text="|Our Themes simply provide the quality of being clear.|" heading_tag="h2" heading="page-title" style="style-2" animation_delay="200" margin_bottom="40"][vc_row_inner][vc_column_inner width="7/12"][vc_column_text animation="fade-in-right" animation_delay="700"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet augue accumsan tincidunt. Maecenas tincidunt, velit ac porttitor pulvinar, tortor eros facilisis libero, vitae commodo nunc quam et ligula. Ut nec ipsum sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Integer id nisi nec nulla luctus lacinia non eu turpis. Etiam in ex imperdiet justo tincidunt egestas.[/vc_column_text][/vc_column_inner][vc_column_inner width="5/12"][vc_column_text animation="fade-in-right" animation_delay="900"]Mauris malesuada nisi sit amet augue accumsan tincidunt. Maecenas tincidunt, velit ac porttitor pulvinar, tortor eros facilisis libero, vitae commodo nunc quam et ligula. Ut nec ipsum sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Integer id nisi nec nulla luctus lacinia non eu turpis.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier=""][vc_column width="2/3" text_align="center" rc_heading_color="white" rc_bg_type="color" expand_column_bg="expand-bg-left" mobile_text_align="left" rc_font_color="#ffffff" rc_bg_color="#30221e" grve_css="{``desktop``:{``margin-top``:``-44``,``padding-top``:``32``,``padding-right``:``32``,``padding-bottom``:``32``,``padding-left``:``32``,``class``:``grve-wpb-1599205858579``},``mobile_landscape``:{``margin-top``:``-15``}}"][impeka_button btn_text="Let’s build the next big thing together" btn_type="only-text" btn_color="white" btn_hover_color="white" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon="arrow-2"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-3.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" mobile_columns_vertical_gap="60"][vc_column width="1/6" mobile_width="hide"][/vc_column][vc_column width="5/6"][impeka_title heading="h2" animation="fade-in-up"]Simply choose from our pre-made designs, get inspired, and mould them to your needs with more than 50 handcrafted elements.[/impeka_title][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column width="1/3" tablet_width="1-6" mobile_width="hide"][/vc_column][vc_column width="1/3" tablet_width="5-12"][vc_column_text animation="fade-in-up" animation_delay="100"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.

<strong>Vestibulum aliquam.</strong>[/vc_column_text][/vc_column][vc_column width="1/3" tablet_width="5-12"][vc_column_text animation="fade-in-up" animation_delay="200"]Ut nec ipsum sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Integer id nisi nec nulla luctus lacinia non.

<strong>Dolor sit amet</strong>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 4', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-4.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" mobile_columns_vertical_gap="none"][vc_column content_width="custom" horizontal_content_position="center" custom_content_width="770"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" mobile_columns_vertical_gap="15"][vc_column_inner width="1/4"][impeka_title heading="h6"]Details[/impeka_title][/vc_column_inner][vc_column_inner width="3/4"][impeka_title heading="h5"]Impeka is a creative and multipurpose WordPress theme that gives you unparalleled versatility.[/impeka_title][vc_column_text]A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.[/vc_column_text][/vc_column_inner][/vc_row_inner][impeka_empty_space height_multiplier="2x"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" mobile_columns_vertical_gap="15"][vc_column_inner width="1/4"][impeka_title heading="h6"]Services[/impeka_title][/vc_column_inner][vc_column_inner width="3/4"][vc_column_text]Content Strategy, Design, Development, Video Production.[/vc_column_text][/vc_column_inner][/vc_row_inner][impeka_empty_space height_multiplier="2x"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" mobile_columns_vertical_gap="15"][vc_column_inner width="1/4"][impeka_title heading="h6"]Clients[/impeka_title][/vc_column_inner][vc_column_inner width="3/4"][vc_column_text]Hector Mariano - Arend Pellewever[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-5';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 5', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-5.jpg');
$data['custom_class'] = 'content portfolio';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" tablet_sm_columns_vertical_gap="60"][vc_column width="1/2" tablet_sm_width="1"][impeka_title heading_tag="h2"]Impeka is a creative and multipurpose WP theme that gives you unparalleled versatility.[/impeka_title][/vc_column][vc_column width="1/2" content_width="custom" horizontal_content_position="right" tablet_sm_width="1" tablet_sm_content_width="100" mobile_content_width="100" tablet_sm_horizontal_content_position="left" mobile_horizontal_content_position="left" custom_content_width="370"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="30"][vc_column_inner width="1/2" tablet_sm_width="1-4" mobile_width="1-2"][impeka_title heading="h5"]Client[/impeka_title][vc_column_text]Nature Planner[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" tablet_sm_width="1-4" mobile_width="1-2"][impeka_title heading="h5"]Year[/impeka_title][vc_column_text]2020[/vc_column_text][/vc_column_inner][vc_column_inner tablet_sm_width="hide" mobile_width="hide"][impeka_empty_space][/vc_column_inner][vc_column_inner width="1/2" tablet_sm_width="1-4" mobile_width="1-2"][impeka_title heading="h5"]Services[/impeka_title][vc_column_text]Content Strategy<br />
Design<br />
Development<br />
Video Production[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" tablet_sm_width="1-4" mobile_width="1-2"][impeka_title heading="h5"]Awards[/impeka_title][vc_column_text]Site Of The Day<br />
Honorable Mention[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-6';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 6', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-6.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="6x" padding_bottom_multiplier="6x" rc_heading_color="white" rc_bg_type="color" tablet_sm_columns_vertical_gap="60" mobile_columns_vertical_gap="60" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/2" tablet_sm_width="1"][impeka_title]Impeka is a <span class="grve-underline grve-line-blue">creative</span> and <span class="grve-underline grve-line-primary-1">multipurpose</span> theme that gives you unparalleled versatility.[/impeka_title][/vc_column][vc_column width="1/2" tablet_sm_width="1"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" mobile_columns_vertical_gap="60"][vc_column_inner width="1/2"][impeka_title heading="h6" animation="fade-in-up" animation_delay="200"]SEO Optimized[/impeka_title][vc_column_text animation="fade-in-up" animation_delay="300"]Impeka uses valid and clean code so that you make sure that Gooogle and other search engines will love it.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read More" btn_type="line" btn_color="white" btn_line_color="orange" btn_link="url:%23" animation="fade-in-up" animation_delay="400"][/vc_column_inner][vc_column_inner width="1/2"][impeka_title heading="h6" animation="fade-in-up" animation_delay="300"]Online Support[/impeka_title][vc_column_text animation="fade-in-up" animation_delay="400"]We will do our best to assist you with any issues related to the use of our themes as soon as possible.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read More" btn_type="line" btn_color="white" btn_line_color="orange" btn_link="url:%23" animation="fade-in-up" animation_delay="500"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-7';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 7', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-7.jpg');
$data['custom_class'] = 'content portfolio';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/2" tablet_width="7-12" tablet_sm_width="2-3"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" margin_bottom="30"]Who we are[/impeka_title][impeka_title heading="h4"]We guarantee you premium support for every buyer of Impeka. [/impeka_title][/vc_column][vc_column width="1/2" tablet_width="5-12" tablet_sm_width="1-3"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="60" tablet_sm_columns_vertical_gap="60" rc_font_color="#847d75"][vc_column_inner width="1/3" tablet_sm_width="1-2"][impeka_title heading="h6" line_type="left-line" line_width="30" line_color="black" align="left" animation="appear-animation" appear_animation="appear-down"]Powerful Backend[/impeka_title][vc_column_text animation="fade-in"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-2"][impeka_title heading="h6" line_type="left-line" line_width="30" line_color="black" align="left" animation="appear-animation" appear_animation="appear-down" animation_delay="100"]Build your shop[/impeka_title][vc_column_text animation="fade-in" animation_delay="100"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-2"][impeka_title heading="h6" line_type="left-line" line_width="30" line_color="black" align="left" animation="appear-animation" appear_animation="appear-down" animation_delay="200"]Video Tutorials[/impeka_title][vc_column_text animation="fade-in" animation_delay="200"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner tablet_sm_width="hide" mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-2"][impeka_title heading="h6" line_type="left-line" line_width="30" line_color="black" align="left" animation="appear-animation" appear_animation="appear-down" animation_delay="200"]Lifetime Updates[/impeka_title][vc_column_text animation="fade-in" animation_delay="200"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-2"][impeka_title heading="h6" line_type="left-line" line_width="30" line_color="black" align="left" animation="appear-animation" appear_animation="appear-down" animation_delay="300"]Pixel Perfect[/impeka_title][vc_column_text animation="fade-in" animation_delay="300"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-2"][impeka_title heading="h6" line_type="left-line" line_width="30" line_color="black" align="left" animation="appear-animation" appear_animation="appear-down" animation_delay="400"]Innovative Framework[/impeka_title][vc_column_text animation="fade-in" animation_delay="400"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-8';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 8', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-8.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row height_ratio="80" padding_top_multiplier="2x" padding_bottom_multiplier="2x" rc_heading_color="white" rc_bg_type="image" rc_bg_color_overlay="black" rc_bg_opacity_overlay="40" tablet_sm_height_ratio="50" separator_top="wave-right-separator" separator_top_size="50%" separator_top_color="#000000" separator_top_z_index="2" scroll_header_skin="light" rc_bg_color="#000000" rc_font_color="#ffffff"][vc_column vertical_content_position="bottom"][vc_row_inner][vc_column_inner width="1/2" content_width="custom" custom_content_width="360"][vc_column_text]Exceptional design quality and superior performance for your website. We can make it happen.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" vertical_content_position="bottom" text_align="right" mobile_text_align="left"][impeka_button btn_text="Watch the video trailer" btn_type="video" btn_color="white" btn_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D0s4_7BuszuQ" btn_video_icon_shape_hover_color="white" btn_class="grve-video-popup"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-9';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 9', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-9.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/6" tablet_sm_width="1-12"][/vc_column][vc_column width="7/12" tablet_width="2-3" tablet_sm_width="3-4"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" animation_delay="200" margin_bottom="30"]Multi-purpose and beyond[/impeka_title][impeka_title heading="h4"]Premium WordPress themes, top freelancing services, <u>uncompromising reliability</u> &amp; outstanding support.[/impeka_title][impeka_empty_space height_multiplier="2x"][vc_row_inner columns_gap="60"][vc_column_inner width="1/2"][vc_column_text animation="fade-in-up" animation_delay="200"]Never rest, always in a creative flux. We test the limits of creativity every single day to meet the most demanding minds out there.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text animation="fade-in-up" animation_delay="300"]We strive for excellence and share our knowledge so that users and developers become creative and great.[/vc_column_text][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text animation="fade-in-up" animation_delay="300"]We share our web design wisdom and excellence for you to evolve and stand out from the competition.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text animation="fade-in-up" animation_delay="400"]We strive for excellence and share our knowledge so that users and developers become creative and great.[/vc_column_text][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text animation="fade-in-up" animation_delay="400"]Never rest, always in a creative flux. We test the limits of creativity every single day to meet the most demanding minds out there.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text animation="fade-in-up" animation_delay="500"]We share our web design wisdom and excellence for you to evolve and stand out from the competition.[/vc_column_text][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column_inner][vc_column_inner animation="clipping" clipping_animation="clipping-left" animation_delay="200" animation_duration="slow"][impeka_button btn_fluid="yes" btn_fluid_height="short" btn_text="Read more about" btn_color_gradient="black" btn_hover_action="pulse" btn_link="url:%23"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/4" tablet_width="1-6" tablet_sm_width="1-12"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-10';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 10', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-10.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/2" tablet_sm_width="2-3"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" animation_delay="100" margin_bottom="30"]Who we are[/impeka_title][impeka_animated_text animated_text="|We love to work with clients all over the world to develop unique, innovative and modern websites.|" heading="h4" style="style-2"][vc_column_text animation="fade-in-up" animation_delay="300"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo. Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet augue accumsan tincidunt. Maecenas tincidunt, velit ac porttitor pulvinar, tortor eros facilisis libero, vitae commodo nunc quam et ligula. Ut nec ipsum sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Integer id nisi nec nulla luctus.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read More About" btn_type="only-text" btn_color="black" btn_hover_color="primary-1" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" animation="fade-in-up" animation_delay="400"][/vc_column][vc_column width="1/2" tablet_sm_width="1-3"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-11';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 11', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-11.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" rc_bg_color="#ffffff"][vc_column width="1/6" tablet_sm_width="1-12" mobile_width="hide"][/vc_column][vc_column width="5/6" tablet_width="5-6" tablet_sm_width="11-12"][vc_row_inner columns_gap="60"][vc_column_inner content_width="custom" custom_content_width="670"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" margin_bottom="30"]Support Center[/impeka_title][vc_column_text text_style="leader-text"]Whether it’s through our <u>carefully crafted themes</u> or our custom design and development services, we deliver inspiring results that speak for themselves and stand the test of time.[/vc_column_text][/vc_column_inner][vc_column_inner][impeka_empty_space height_multiplier="3x"][/vc_column_inner][vc_column_inner width="5/12" vertical_content_position="middle"][impeka_title heading="h5"]You’re looking for answers, would like to solve a problem[/impeka_title][/vc_column_inner][vc_column_inner width="1/3" vertical_content_position="middle"][vc_column_text]Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/4" vertical_content_position="middle" text_align="right"][impeka_button btn_text="Read More About" btn_color_gradient="black" btn_hover_action="pulse" btn_size="small" btn_link="url:%23"][/vc_column_inner][vc_column_inner][impeka_divider padding_top="36" padding_bottom="36"][/vc_column_inner][vc_column_inner width="5/12" vertical_content_position="middle"][impeka_title heading="h5"]We strive for excellence and share our knowledge[/impeka_title][/vc_column_inner][vc_column_inner width="1/3" vertical_content_position="middle"][vc_column_text]Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/4" vertical_content_position="middle" text_align="right"][impeka_button btn_text="Read More About" btn_color_gradient="black" btn_hover_action="pulse" btn_size="small" btn_link="url:%23"][/vc_column_inner][vc_column_inner][impeka_divider padding_top="36" padding_bottom="36"][/vc_column_inner][vc_column_inner width="5/12" vertical_content_position="middle"][impeka_title heading="h5"]All potential customers feel confident about our products.[/impeka_title][/vc_column_inner][vc_column_inner width="1/3" vertical_content_position="middle"][vc_column_text]Vestibulum aliquam hendrerit molestie. Mauris malesuada nisi sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/4" text_align="right"][impeka_button btn_text="Read More About" btn_color_gradient="black" btn_hover_action="pulse" btn_size="small" btn_link="url:%23"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-12';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 12', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-12.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="6x" padding_bottom_multiplier="6x"][vc_column width="1/3" content_width="custom" horizontal_content_position="center" custom_content_width="300"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="clipping-left" margin_bottom="18"]Developer[/impeka_title][impeka_title heading="h5"]Responsive Design[/impeka_title][vc_column_text]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.[/vc_column_text][/vc_column][vc_column width="1/3" content_width="custom" horizontal_content_position="center" custom_content_width="300"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="clipping-left" animation_delay="200" margin_bottom="18"]Head of Finance[/impeka_title][impeka_title heading="h5"]Powerful Backend[/impeka_title][vc_column_text]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.[/vc_column_text][/vc_column][vc_column width="1/3" content_width="custom" custom_content_width="300"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="clipping-left" animation_delay="400" margin_bottom="18"]Creative Director[/impeka_title][impeka_title heading="h5"]Google Analytics[/impeka_title][vc_column_text]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.[/vc_column_text][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-13';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 13', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-13.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="custom" padding_bottom_multiplier="3x" rc_heading_color="white" rc_bg_type="image" rc_bg_image="https://images.unsplash.com/photo-1497250681960-ef046c08a56e?w=1440&q=80" rc_bg_color_overlay="black" rc_bg_opacity_overlay="60" padding_top="18%" rc_bg_color="#000000" rc_font_color="#ffffff"][vc_column width="1/2" tablet_width="2-3"][impeka_icon icon_type="theme-icon-svg" theme_icon="video-1" icon_color="dark-grey" icon_shape="circle" icon_shape_color="white" loop_animation="animation-1" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D0s4_7BuszuQ" link_class="grve-video-popup"][impeka_empty_space][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="white" animation_delay="200" margin_bottom="30"]Effortless and intuitive[/impeka_title][impeka_animated_text animated_text="|Trust us, we know from first hand the true meaning of the word “Support”.|" style="style-2" animation_delay="400"][/vc_column][vc_column width="1/2" tablet_width="1-3"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-14';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 14', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-14.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="6x" padding_bottom_multiplier="6x"][vc_column width="1/4"][/vc_column][vc_column width="1/2" text_align="center"][impeka_single_image image="https://placehold.co/165x90/FFE7E5/63BBC1?text=Icon" retina_image="https://placehold.co/330x180/FFE7E5/63BBC1?text=Icon" animation="fade-in-up" animation_delay="200"][impeka_empty_space][impeka_title heading="subtitle-text" animation="fade-in-up" animation_delay="600" margin_bottom="18"]Welcome to our office[/impeka_title][impeka_animated_text animated_text="|YOU DESERVE; THE BEST RESULT|" heading="h1" style="style-2" animation_delay="600"][impeka_empty_space][impeka_button btn_text="Get free consultation" btn_color_gradient="dark-grey" btn_hover_action="pulse" btn_link="url:%23" animation="fade-in-up" animation_delay="800"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-15';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 15', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-15.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="6x" padding_bottom_multiplier="6x" rc_link_color="primary-1"][vc_column text_align="center"][impeka_title heading="leader-text" increase_heading="250" increase_heading_reset="mobile"]Impeka WordPress theme masterfully handcrafted for awesomeness.[/impeka_title][impeka_empty_space height_multiplier="2x"][impeka_menu nav_menu="" heading="h6" item_space="35"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-16';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 16', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-16.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/3"][/vc_column][vc_column width="2/3" rc_bg_type="color" rc_bg_color="#f0f0f0"][vc_row_inner padding_top_multiplier="3x" padding_bottom_multiplier="2x"][vc_column_inner grve_css="{``desktop``:{``margin-left``:``-20%``,``padding-left``:``0``,``class``:``grve-wpb-1612860368069``},``mobile_landscape``:{``margin-left``:``0``,``padding-left``:``40``}}"][impeka_title heading="h1"]Get in touch today and receive a free quote[/impeka_title][impeka_empty_space][impeka_button btn_text="Get in touch" btn_type="only-text" btn_color="black" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-architecture%2Fcontact%2F|title:Contact" btn_icon_type="icon-svg" btn_svg_icon="arrow-2"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-17';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 17', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-17.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="" separator_top_size="50%" separator_top_color="#f7f7fb"][vc_column rc_heading_color="white" rc_bg_type="image" rc_bg_image="https://images.unsplash.com/photo-1497250681960-ef046c08a56e?w=1440&q=80" rc_bg_color_overlay="gradient" rc_bg_gradient_overlay_custom_1="rgba(0,0,0,0.82)" rc_bg_gradient_overlay_custom_2="rgba(0,0,0,0.01)" rc_bg_gradient_overlay_direction="45" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``30%``,``padding-right``:``60``,``padding-bottom``:``60``,``padding-left``:``60``,``class``:``grve-wpb-1631964591128``}}"][impeka_icon icon_type="theme-icon-svg" theme_icon="video-1" icon_color="white" icon_shape="circle" icon_shape_color="primary-1" loop_animation="animation-1" margin_bottom="30"][impeka_title heading="h4"]WANT A PERSONAL TRAINER?[/impeka_title][vc_column_text]All our trainers are award winning experts[/vc_column_text][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'content-18';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Content 18', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/content/content-18.jpg');
$data['custom_class'] = 'content';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" separator_bottom_size="50%" rc_bg_color="#f7f7fb"][vc_column][vc_row_inner rc_bg_type="image" rc_bg_image="https://images.unsplash.com/photo-1497250681960-ef046c08a56e?w=1440&q=80" rc_bg_color_overlay="gradient" rc_bg_gradient_overlay_custom_1="rgba(0,0,0,0.8)" rc_bg_gradient_overlay_custom_2="rgba(0,0,0,0.01)" rc_bg_gradient_overlay_direction="45"][vc_column_inner width="1/2" rc_heading_color="white" rc_font_color="#b7f300" grve_css="{``desktop``:{``padding-top``:``15%``,``padding-bottom``:``15%``,``padding-left``:``5%``,``class``:``grve-wpb-1631820440082``}}"][impeka_title heading="h4"]Never say never because limits, like fears, are often just an illusion.[/impeka_title][impeka_empty_space height_multiplier="2x"][vc_column_text text_style="small-text"]Michael Jordan[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'contact-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Contact 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/contact/contact-1.jpg');
$data['custom_class'] = 'contact';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" mobile_columns_vertical_gap="none"][vc_column width="1/4" tablet_sm_width="1-6"][/vc_column][vc_column width="1/2" content_width="custom" horizontal_content_position="center" text_align="center" tablet_sm_width="2-3" custom_content_width="470"][impeka_title heading="subtitle-text" margin_bottom="30"]Visit our office[/impeka_title][impeka_title heading="h4"]We are a team of professional web <span class="grve-underline grve-line-orange">designers and developers.</span>[/impeka_title][vc_column_text]The most important is that behind every single project we work on, there is a talented group of human beings. Each part and member strive to provide a revolutionary and certainly, profitable result.[/vc_column_text][/vc_column][vc_column width="1/4" tablet_sm_width="1-6"][/vc_column][vc_column][impeka_empty_space height_multiplier="3x"][/vc_column][vc_column][vc_row_inner columns_gap="none" mobile_columns_vertical_gap="none"][vc_column_inner width="1/3" text_align="center" animation="clipping" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="200" grve_css="{``desktop``:{``border-right``:1,``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599023656346``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_title heading="h6" margin_bottom="18"]London[/impeka_title][vc_column_text]19 Maypole Crescent
Ilford, L6 2UJ[/vc_column_text][impeka_empty_space][impeka_title heading="h6"]800 283 8292[/impeka_title][/vc_column_inner][vc_column_inner width="1/3" text_align="center" animation="clipping" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="300" grve_css="{``desktop``:{``border-right``:1,``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599023682409``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_title heading="h6" margin_bottom="18"]New York[/impeka_title][vc_column_text]1077 Layman Court,
10001, New York[/vc_column_text][impeka_empty_space][impeka_title heading="h6"]646 312 6838[/impeka_title][/vc_column_inner][vc_column_inner width="1/3" text_align="center" animation="clipping" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="400" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1599023697248``}}"][impeka_title heading="h6" margin_bottom="18"]Moscow[/impeka_title][vc_column_text]Lenina Ul, bld. 168,
Lipetsk, Lipetskaya[/vc_column_text][impeka_empty_space][impeka_title heading="h6"](4742)814 915 704[/impeka_title][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][impeka_button btn_fluid="yes" btn_fluid_height="short" btn_text="Open Google Map" btn_color_gradient="black" btn_hover_action="pulse" btn_link="url:%23" animation="fade-in-up"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'contact-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Contact 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/contact/contact-3.jpg');
$data['custom_class'] = 'contact';
$data['content'] = <<<CONTENT
[vc_row height_ratio="100" padding_top_multiplier="6x" padding_bottom_multiplier="6x" mobile_columns_vertical_gap="none" tablet_sm_height_ratio="60" mobile_height_ratio="0"][vc_column vertical_content_position="middle" full_height="yes" text_align="center" add_column_link="yes" column_link="url:mailto%3Ainfo%40impekatheme.eu" hover_animation="magnetism"][impeka_title heading="subtitle-text" margin_bottom="18"]Have a new project in mind?[/impeka_title][impeka_title heading="page-title" increase_heading="140"]Say Hallo[/impeka_title][impeka_empty_space][impeka_title heading="small-text"]<u>info@impekatheme.eu</u>[/impeka_title][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'contact-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Contact 4', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/contact/contact-4.jpg');
$data['custom_class'] = 'contact';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" rc_bg_color="#b7f300"][vc_column width="1/3" tablet_sm_width="1-2"][vc_column_text text_style="small-text"]Call Us[/vc_column_text][impeka_empty_space][impeka_title heading_tag="h2" heading="h4"]888-299-2000[/impeka_title][impeka_empty_space][vc_column_text]<strong>Address 1</strong>: 709 Honey Creek Dr.,<br />
New York, NY 10028[/vc_column_text][impeka_empty_space][vc_column_text]<strong>Address 2</strong>: 4851 Willow Greene Drive<br />
Montgomery, AL 36109[/vc_column_text][impeka_empty_space][vc_column_text]<strong>Address 3</strong>: 709 Honey Creek Dr.,<br />
New York, NY 10028[/vc_column_text][vc_row_inner][vc_column_inner vertical_content_position="bottom" grve_css="{``desktop``:{``padding-top``:``45``,``class``:``grve-wpb-1631860942592``}}"][vc_column_text]Email: info@impekaoffice.com[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="2/3" tablet_sm_width="1-2"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-3.jpg');
$data['custom_class'] = 'image-text portfolio';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/2" content_width="custom" horizontal_content_position="center" mobile_column_order="1" custom_content_width="370"][impeka_single_image image_mode="portrait" image_column_space="100" animation="fade-in-up"][/vc_column][vc_column width="1/2" content_width="custom" vertical_content_position="middle" mobile_column_order="2" custom_content_width="370"][impeka_title heading="h5" animation="fade-in-up" animation_delay="300" margin_bottom="18"]Prestige Rose[/impeka_title][vc_column_text animation="fade-in-up" animation_delay="400"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][impeka_empty_space][vc_column_text animation="fade-in-up" animation_delay="500"]Ut nec ipsum sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Integer id nisi nec nulla luctus lacinia non.[/vc_column_text][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'portfolio-section-6';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Section 6', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/portfolio-section-6.jpg');
$data['custom_class'] = 'portfolio';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" mobile_columns_vertical_gap="none"][vc_column width="1/6" tablet_sm_width="1-12"][/vc_column][vc_column width="2/3" text_align="center" tablet_sm_width="5-6"][impeka_title heading="h1" animation="fade-in-up"]Color Palete[/impeka_title][vc_column_text text_style="leader-text" animation="fade-in-up" animation_delay="200"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et.[/vc_column_text][impeka_empty_space height_multiplier="2x"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" columns_gap="5" mobile_columns_vertical_gap="5" rc_font_color="#ffffff"][vc_column_inner width="1/4" text_align="center" rc_bg_type="color" animation="clipping" clipping_animation="clipping-left" animation_delay="300" mobile_width="1-2" rc_bg_color="#475778" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1593534462785``}}"][impeka_title heading="link-text"]#475778[/impeka_title][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_bg_type="color" animation="clipping" clipping_animation="clipping-left" animation_delay="450" mobile_width="1-2" rc_bg_color="#c1ddea" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1593534470763``}}"][impeka_title heading="link-text"]#C1DDEA[/impeka_title][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_bg_type="color" animation="clipping" clipping_animation="clipping-left" animation_delay="550" mobile_width="1-2" rc_bg_color="#b9a890" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1593534475939``}}"][impeka_title heading="link-text"]#B9A890[/impeka_title][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_bg_type="color" animation="clipping" clipping_animation="clipping-left" animation_delay="650" mobile_width="1-2" rc_bg_color="#dccfbd" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1593534480687``}}"][impeka_title heading="link-text"]#DCCFBD[/impeka_title][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/6" tablet_sm_width="1-12"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-4.jpg');
$data['custom_class'] = 'image-text portfolio';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" mobile_columns_vertical_gap="none" rc_font_color="#ffffff" rc_bg_color="#6b6e93"][vc_column width="1/2" vertical_content_position="bottom" full_height="yes" mobile_column_order="2" grve_css="{``desktop``:{``padding-top``:``12%``,``padding-right``:``12%``,``padding-bottom``:``12%``,``padding-left``:``12%``,``class``:``grve-wpb-1593534872176``}}"][impeka_title heading="h5"]Client[/impeka_title][vc_column_text]Arend Pellewever[/vc_column_text][impeka_empty_space][impeka_title heading="h5"]Services[/impeka_title][vc_column_text]Content Strategy<br />
Design<br />
Development<br />
Video Production[/vc_column_text][/vc_column][vc_column width="1/2" rc_bg_type="image" animation="clipping" clipping_animation="colored-clipping-left" mobile_column_order="1" grve_css="{``desktop``:{``padding-top``:``100%``,``class``:``grve-wpb-1593535017184``}}"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-5';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 5', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-5.jpg');
$data['custom_class'] = 'image-text';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_heading_color="white" rc_bg_type="color" tablet_sm_columns_vertical_gap="60" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#1d2024"][vc_column width="5/12" tablet_sm_width="1"][impeka_single_image image_mode="medium_large" image="https://unsplash.it/940/700/" image_column_space="150" image_column_space_reset="tablet-sm" inherit_align="left" radius="5" shadow="medium"][/vc_column][vc_column width="7/12" content_width="custom" vertical_content_position="middle" tablet_sm_width="1" custom_content_width="570"][impeka_title heading_tag="h1" heading="page-title"]Expand
Image Width[/impeka_title][vc_column_text text_style="page-description"]Setting a percentage larger than 100% the image overflows out of the column. The default is the initial image resolution.[/vc_column_text][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-12';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 12', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-12.jpg');
$data['custom_class'] = 'image-text';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/12"][/vc_column][vc_column width="11/12"][vc_row_inner columns_gap="60"][vc_column_inner width="1/2" rc_bg_type="image" rc_bg_image="https://images.unsplash.com/photo-1552154357-aaba12e68e64?w=650&q=80" grve_css="{``desktop``:{``padding-top``:``30%``,``padding-right``:``40``,``padding-bottom``:``40``,``padding-left``:``40``,``class``:``grve-wpb-1608321514791``}}"][impeka_slogan title="Powerful Backend" heading_tag="h3" heading="h5" btn_text="Read more about" btn_color_gradient="black" btn_hover_color_gradient="white" btn_shape="round" btn_link="url:%23" btn2_text=""]You’ll have everything you’ll need<br />
inside a powerful back-end.[/impeka_slogan][/vc_column_inner][vc_column_inner width="1/2" rc_bg_type="image" rc_bg_image="https://images.unsplash.com/photo-1581328210890-badc6eed1efd?w=668&q=80" grve_css="{``desktop``:{``padding-top``:``30%``,``padding-right``:``40``,``padding-bottom``:``40``,``padding-left``:``40``,``class``:``grve-wpb-1608321047783``}}"][impeka_slogan title="Build your shop" heading_tag="h3" heading="h5" btn_text="Read more about" btn_color_gradient="black" btn_hover_color_gradient="white" btn_shape="round" btn_link="url:%23" btn2_text=""]Create your shop in a few minutes<br />
and customize everything as you wish.[/impeka_slogan][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'image-text-16';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Image text 16', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/image-text/image-text-16.jpg');
$data['custom_class'] = 'image-text';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="3x" padding_bottom_multiplier="" rc_bg_type="color" separator_bottom="line-separator" rc_bg_color="#d9e8ea"][vc_column][vc_row_inner rc_heading_color="white" rc_bg_type="image" rc_bg_color_overlay="primary-1" rc_bg_opacity_overlay="70" rc_font_color="#ffffff"][vc_column_inner text_align="center"][impeka_empty_space height_multiplier="custom" height="15vw"][impeka_title heading="leader-text" increase_heading="250"]Need Support?[/impeka_title][vc_column_text text_style="leader-text"]Get in touch with our Team![/vc_column_text][impeka_empty_space][impeka_icon icon_type="theme-icon-svg" theme_icon="plus" icon_color="black" icon_shape="circle" icon_shape_color="white" loop_animation="animation-1" link="url:%23"][impeka_empty_space height_multiplier="custom" height="7vw"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'fancy-boxes-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Fancy Boxes 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/fancy-boxes/fancy-boxes-1.jpg');
$data['custom_class'] = 'fancy-boxes';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="4x" padding_bottom_multiplier="4x" columns_gap="30"][vc_column width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][vc_column width="2/3" content_width="custom" horizontal_content_position="center" text_align="center" tablet_sm_width="1" custom_content_width="770" grve_css="{``desktop``:{``padding-right``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1598980073603``}}"][impeka_title heading="subtitle-text" margin_bottom="30"]Effortless and intuitive[/impeka_title][impeka_title heading="h4"]User experience is one of our highest priorities, and the clean and <span class="grve-underline grve-line-orange">contemporary interface</span> of Impeka is the icing on the premium cake.[/impeka_title][/vc_column][vc_column width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" tablet_columns_vertical_gap="30" tablet_sm_columns_vertical_gap="30"][vc_column_inner width="1/4" tablet_width="1-3" tablet_sm_width="1-2"][impeka_fancy_box title="Build your shop" heading="h6" align="center" content_bg_hover="grey" radius="3" read_more_link="url:%23" icon_type="icon" icon_library="etlineicons" icon_etlineicons="et-icon-gift" icon_color="black"]We love to work with clients all over the world to develop unique and modern websites.[/impeka_fancy_box][/vc_column_inner][vc_column_inner width="1/4" tablet_width="1-3" tablet_sm_width="1-2"][impeka_fancy_box title="Handcrafted Elements" heading="h6" align="center" content_bg_hover="grey" radius="3" read_more_link="url:%23" icon_type="icon" icon_library="etlineicons" icon_etlineicons="et-icon-lightbulb" icon_color="black"]We love to work with clients all over the world to develop unique and modern websites.[/impeka_fancy_box][/vc_column_inner][vc_column_inner width="1/4" tablet_width="1-3" tablet_sm_width="1-2"][impeka_fancy_box title="Pixel Perfect" heading="h6" align="center" content_bg_hover="grey" radius="3" read_more_link="url:%23" icon_type="icon" icon_library="etlineicons" icon_etlineicons="et-icon-happy" icon_color="black"]We love to work with clients all over the world to develop unique and modern websites.[/impeka_fancy_box][/vc_column_inner][vc_column_inner width="1/4" tablet_width="1-3" tablet_sm_width="1-2"][impeka_fancy_box title="Video Tutorials" heading="h6" align="center" content_bg_hover="grey" radius="3" read_more_link="url:%23" icon_type="icon" icon_library="etlineicons" icon_etlineicons="et-icon-download" icon_color="black"]We love to work with clients all over the world to develop unique and modern websites.[/impeka_fancy_box][/vc_column_inner][vc_column_inner tablet_width="hide" tablet_sm_width="hide" mobile_width="hide"][impeka_empty_space][/vc_column_inner][vc_column_inner width="1/4" tablet_width="1-3" tablet_sm_width="1-2"][impeka_fancy_box title="Lifetime Updates" heading="h6" align="center" content_bg_hover="grey" radius="3" read_more_link="url:%23" icon_type="icon" icon_library="etlineicons" icon_etlineicons="et-icon-refresh" icon_color="black"]We love to work with clients all over the world to develop unique and modern websites.[/impeka_fancy_box][/vc_column_inner][vc_column_inner width="1/4" tablet_width="1-3" tablet_sm_width="1-2"][impeka_fancy_box title="Google Analytics" heading="h6" align="center" content_bg_hover="grey" radius="3" read_more_link="url:%23" icon_type="icon" icon_library="etlineicons" icon_etlineicons="et-icon-bargraph" icon_color="black"]We love to work with clients all over the world to develop unique and modern websites.[/impeka_fancy_box][/vc_column_inner][vc_column_inner width="1/4" tablet_width="1-3" tablet_sm_width="1-2"][impeka_fancy_box title="Speed Optimized" heading="h6" align="center" content_bg_hover="grey" radius="3" read_more_link="url:%23" icon_type="icon" icon_library="etlineicons" icon_etlineicons="et-icon-hourglass" icon_color="black"]We love to work with clients all over the world to develop unique and modern websites.[/impeka_fancy_box][/vc_column_inner][vc_column_inner width="1/4" tablet_width="1-3" tablet_sm_width="1-2"][impeka_fancy_box title="Purchase Impeka" heading="h6" align="center" content_bg_hover="grey" radius="3" read_more_link="url:%23" icon_type="icon" icon_library="etlineicons" icon_etlineicons="et-icon-basket" icon_color="black"]We love to work with clients all over the world to develop unique and modern websites.[/impeka_fancy_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'fancy-boxes-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Fancy Boxes 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/fancy-boxes/fancy-boxes-2.jpg');
$data['custom_class'] = 'fancy-boxes';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" rc_bg_color="#f7f7fb"][vc_column width="2/3"][impeka_title heading="subtitle-text" margin_bottom="36"]Effortless and intuitive[/impeka_title][impeka_title heading="h4"]User experience is one of our highest priorities, and the clean and <span style="color: #4a6fff;">contemporary interface</span> of Impeka is the icing on the premium cake.[/impeka_title][/vc_column][vc_column width="1/3"][/vc_column][vc_column][impeka_empty_space height_multiplier="3x"][/vc_column][vc_column][impeka_flexible_carousel type="advanced" items_per_page="3" items_tablet_portrait="2" loop="no" auto_play="no" nav_visibility="" pagination="yes"][impeka_fancy_box title="Powerful Backend" heading="h5" align="center" content_bg="white" content_bg_hover="primary-2" radius="5" shadow="medium-shadow" read_more_title="Read More" read_more_link="url:%23|||" icon_type="icon" icon_size="large" icon_library="etlineicons" icon_etlineicons="et-icon-strategy" icon_color="primary-2"]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/impeka_fancy_box][impeka_fancy_box title="Innovative Framework" heading="h5" align="center" content_bg="white" content_bg_hover="primary-2" radius="5" shadow="medium-shadow" read_more_title="Read More" read_more_link="url:%23|||" icon_type="icon" icon_size="large" icon_library="etlineicons" icon_etlineicons="et-icon-puzzle" icon_color="primary-2"]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/impeka_fancy_box][impeka_fancy_box title="Responsive Design" heading="h5" align="center" content_bg="white" content_bg_hover="primary-2" radius="5" shadow="medium-shadow" read_more_title="Read More" read_more_link="url:%23|||" icon_type="icon" icon_size="large" icon_library="etlineicons" icon_color="primary-2"]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/impeka_fancy_box][impeka_fancy_box title="Retina Ready" heading="h5" align="center" content_bg="white" content_bg_hover="primary-2" radius="5" shadow="medium-shadow" read_more_title="Read More" read_more_link="url:%23|||" icon_type="icon" icon_size="large" icon_library="etlineicons" icon_etlineicons="et-icon-heart" icon_color="primary-2"]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/impeka_fancy_box][impeka_fancy_box title="Knowledge Base" heading="h5" align="center" content_bg="white" content_bg_hover="primary-2" radius="5" shadow="medium-shadow" read_more_title="Read More" read_more_link="url:%23|||" icon_type="icon" icon_size="large" icon_library="etlineicons" icon_etlineicons="et-icon-happy" icon_color="primary-2"]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/impeka_fancy_box][impeka_fancy_box title="Online Support" heading="h5" align="center" content_bg="white" content_bg_hover="primary-2" radius="5" shadow="medium-shadow" read_more_title="Read More" read_more_link="url:%23|||" icon_type="icon" icon_size="large" icon_library="etlineicons" icon_etlineicons="et-icon-circle-compass" icon_color="primary-2"]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/impeka_fancy_box][impeka_fancy_box title="Responsive Design" heading="h5" align="center" content_bg="white" content_bg_hover="primary-2" radius="5" shadow="medium-shadow" read_more_title="Read More" read_more_link="url:%23|||" icon_type="icon" icon_size="large" icon_library="etlineicons" icon_etlineicons="et-icon-circle-compass" icon_color="primary-2"]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/impeka_fancy_box][impeka_fancy_box title="Innovative Framework" heading="h5" align="center" content_bg="white" content_bg_hover="primary-2" radius="5" shadow="medium-shadow" read_more_title="Read More" read_more_link="url:%23|||" icon_type="icon" icon_size="large" icon_library="etlineicons" icon_etlineicons="et-icon-gears" icon_color="primary-2"]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/impeka_fancy_box][impeka_fancy_box title="Powerful Backend" heading="h5" align="center" content_bg="white" content_bg_hover="primary-2" radius="5" shadow="medium-shadow" read_more_title="Read More" read_more_link="url:%23|||" icon_type="icon" icon_size="large" icon_library="etlineicons" icon_etlineicons="et-icon-adjustments" icon_color="primary-2"]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/impeka_fancy_box][/impeka_flexible_carousel][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'pricing-table-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Pricing Table 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/pricing/pricing-1.jpg');
$data['custom_class'] = 'pricing-tables';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" rc_bg_color="#f7f7f7"][vc_column][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="none"][vc_column_inner width="1/3" vertical_content_position="middle"][impeka_pricing_table price="$29" heading_tag="h2" heading="h1" interval="" title="Freelancer" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,40 MB | Storage Space" shadow="medium-shadow" align="center" btn_text="Read more about" btn_type="outline" btn_color="grey" btn_hover_action="pulse" btn_shape="round" btn_link="url:%23|||" animation="fade-in-up" animation_delay="100" button_text="Purchase Now" button_color="grey" button_shape="round" button_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3"][impeka_pricing_table price="$59" heading_tag="h2" heading="h1" increase_heading="140" interval="" title="Small Business" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,40 MB | Storage Space,100GB | Bandwidth" color="white" price_color="white" content_bg="gradient-2" shadow="medium-shadow" align="center" btn_text="Read more about" btn_color_gradient="white" btn_hover_action="pulse" btn_shape="round" btn_shadow="medium" btn_link="url:%23|||" animation="fade-in-up" animation_delay="200" button_text="Purchase Now" button_shape="round" button_shadow="medium" button_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" vertical_content_position="middle"][impeka_pricing_table price="$79" heading_tag="h2" heading="h1" interval="" title="Basic" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,Unlimited | Bandwidth" shadow="medium-shadow" align="center" btn_text="Read more about" btn_type="outline" btn_color="grey" btn_hover_action="pulse" btn_shape="round" btn_link="url:%23|||" animation="fade-in-up" animation_delay="300" button_text="Purchase Now" button_color="grey" button_shape="round" button_link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'pricing-table-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Pricing Table 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/pricing/pricing-2.jpg');
$data['custom_class'] = 'pricing-tables';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_heading_color="white" rc_bg_type="color" columns_gap="15" equal_column_height="equal" separator_bottom_size="40%" separator_bottom_color="#000000" scroll_header_skin="light" rc_bg_color="#131729" rc_font_color="#ffffff"][vc_column][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="10"][vc_column_inner width="1/2" tablet_width="2-3"][impeka_title heading="subtitle-text" margin_bottom="30"]Effortless and intuitive[/impeka_title][impeka_title heading="h4"]Type A highly resourceful, innovative, and competent PHP developer with extensive experience.[/impeka_title][/vc_column_inner][vc_column_inner width="1/2" tablet_width="1-3"][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column_inner][vc_column_inner width="1/3"][impeka_pricing_table layout="layout-2" price="19<sup>€</sup>" heading="h1" increase_heading="120" interval="/ Month" title="Freelancer" description="Mauris malesuada nisi sit amet augue accumsan tincidunt tincidunt, velit ac porttitor pulvinar." border="top-border" border_color="blue" shadow="medium-shadow" btn_text="Purchase Now" btn_type="outline" btn_color="grey" btn_hover_color_gradient="blue" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3"][impeka_pricing_table layout="layout-2" price="69<sup>€</sup>" heading="h1" increase_heading="120" interval="/ Month" title="Small Bussiness" description="Mauris malesuada nisi sit amet augue accumsan tincidunt tincidunt, velit ac porttitor pulvinar." border="top-border" shadow="medium-shadow" btn_text="Purchase Now" btn_type="outline" btn_color="grey" btn_hover_color_gradient="primary-1" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3"][impeka_pricing_table layout="layout-2" price="89<sup>€</sup>" heading="h1" increase_heading="120" interval="/ Month" title="Large Business" description="Mauris malesuada nisi sit amet augue accumsan tincidunt tincidunt, velit ac porttitor pulvinar." border="top-border" border_color="green" shadow="medium-shadow" btn_text="Purchase Now" btn_type="outline" btn_color="grey" btn_hover_color_gradient="green" btn_link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'pricing-table-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Pricing Table 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/pricing/pricing-3.jpg');
$data['custom_class'] = 'pricing-tables';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" separator_top_size="30px" separator_top_color="#131729" rc_bg_color="#ffffff"][vc_column width="1/4" tablet_width="1-6"][/vc_column][vc_column width="1/2" text_align="center" tablet_width="2-3"][impeka_title heading="h4"]Choose your Plan[/impeka_title][vc_column_text text_style="leader-text"]Type A highly resourceful, innovative, and competent PHP developer with extensive experience.[/vc_column_text][impeka_empty_space height_multiplier="custom" height="36px"][impeka_single_image image="https://placehold.co/120x35?text=image"][/vc_column][vc_column width="1/4" tablet_width="1-6"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="none" mobile_columns_vertical_gap="none"][vc_column_inner width="1/4" grve_css="{``desktop``:{``border-right``:1,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1597995867098``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_pricing_table price="$29" heading="h1" interval="" title="" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,40MB|Storage Space" align="center" btn_text="Purchase Now" btn_type="outline" btn_color="grey" btn_hover_color_gradient="primary-1" btn_hover_action="pulse" btn_size="small" btn_shape="round" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" grve_css="{``desktop``:{``border-right``:1,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1597995890083``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_pricing_table price="$59" heading="h1" interval="" title="" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,100MB|Storage Space" align="center" btn_text="Purchase Now" btn_type="outline" btn_color="grey" btn_hover_color_gradient="primary-1" btn_hover_action="pulse" btn_size="small" btn_shape="round" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" grve_css="{``desktop``:{``border-right``:1,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1597995897620``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_pricing_table price="$79" heading="h1" interval="" title="" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,2GB|Storage Space" align="center" btn_text="Purchase Now" btn_type="outline" btn_color="grey" btn_hover_color_gradient="primary-1" btn_hover_action="pulse" btn_size="small" btn_shape="round" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4"][impeka_pricing_table price="$99" heading="h1" interval="" title="" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,5GB|Storage Space" align="center" btn_text="Purchase Now" btn_type="outline" btn_color="grey" btn_hover_color_gradient="primary-1" btn_hover_action="pulse" btn_size="small" btn_shape="round" btn_link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'pricing-table-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Pricing Table 4', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/pricing/pricing-4.jpg');
$data['custom_class'] = 'pricing-tables';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="" rc_bg_type="color" columns_gap="15" equal_column_height="equal" separator_bottom_size="40%" separator_bottom_color="#000000" scroll_header_skin="dark" rc_bg_color="#fafafa"][vc_column grve_css="{``desktop``:{``margin-bottom``:``-17%``,``z-index``:3,``class``:``grve-wpb-1598941959827``}}"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="10"][vc_column_inner width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column_inner][vc_column_inner width="2/3" text_align="center" tablet_sm_width="1"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="primary-2" margin_bottom="30"]Affordable Prices[/impeka_title][vc_column_text text_style="leader-text" animation="fade-in" animation_delay="400"]Choose your package fast hosting plans dedicated for the WordPress websites. Affordable prices and premium support.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column_inner][vc_column_inner width="1/3" animation_delay="300"][impeka_pricing_table layout="layout-2" price="19<sup>€</sup>" heading="h1" increase_heading="120" interval="" title="Freelancer" description="Mauris malesuada nisi sit amet augue accumsan tincidunt tincidunt, velit ac porttitor pulvinar." border="top-border" border_color="primary-2" shadow="medium-shadow" btn_text="Purchase Now" btn_color_gradient="primary-2" btn_size="small" btn_shape="round" btn_link="url:%23|||" animation="zoom-in"][/vc_column_inner][vc_column_inner width="1/3"][impeka_pricing_table layout="layout-2" price="69<sup>€</sup>" heading="h1" increase_heading="120" interval="" title="Small Bussiness" description="Mauris malesuada nisi sit amet augue accumsan tincidunt tincidunt, velit ac porttitor pulvinar." border="top-border" border_color="primary-2" shadow="medium-shadow" btn_text="Purchase Now" btn_color_gradient="primary-2" btn_size="small" btn_shape="round" btn_link="url:%23|||" animation="zoom-in" animation_delay="200"][/vc_column_inner][vc_column_inner width="1/3"][impeka_pricing_table layout="layout-2" price="89<sup>€</sup>" heading="h1" increase_heading="120" interval="" title="Large Business" description="Mauris malesuada nisi sit amet augue accumsan tincidunt tincidunt, velit ac porttitor pulvinar." border="top-border" border_color="primary-2" shadow="medium-shadow" btn_text="Purchase Now" btn_color_gradient="primary-2" btn_size="small" btn_shape="round" btn_link="url:%23|||" animation="zoom-in" animation_delay="400"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="" rc_heading_color="white" rc_bg_type="image" rc_bg_color_overlay="gradient" rc_bg_gradient_overlay_custom_1="#131729" rc_bg_gradient_overlay_custom_2="rgba(19,23,41,0.75)" rc_bg_gradient_overlay_direction="180" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#131729"][vc_column grve_css="{``desktop``:{``padding-top``:``32%``,``class``:``grve-wpb-1598942278297``},``tablet_portrait``:{``padding-top``:``36%``}}"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier=""][vc_column_inner width="1/3" tablet_sm_width="1-6"][/vc_column_inner][vc_column_inner width="1/3" text_align="center" tablet_sm_width="2-3"][impeka_icon icon_type="theme-icon-svg" theme_icon="video-1" icon_color="primary-2" icon_shape="circle" icon_shape_color="white" loop_animation="animation-1" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D0s4_7BuszuQ" link_class="grve-video-popup"][impeka_empty_space][impeka_title heading="h4"]Access it from<br />
everywhere anytime[/impeka_title][impeka_divider line_type="custom-line" line_width="130" line_color="primary-2" animation="fade-in-up" padding_top="30"][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-6"][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space height_multiplier="5x"][/vc_column_inner][vc_column_inner width="1/5"][impeka_single_image image="https://placehold.co/250x100/ffffff/4D74FB?text=Partner Logo"][/vc_column_inner][vc_column_inner width="1/5"][impeka_single_image image="https://placehold.co/250x100/ffffff/4D74FB?text=Partner Logo"][/vc_column_inner][vc_column_inner width="1/5"][impeka_single_image image="https://placehold.co/250x100/ffffff/4D74FB?text=Partner Logo"][/vc_column_inner][vc_column_inner width="1/5"][impeka_single_image image="https://placehold.co/250x100/ffffff/4D74FB?text=Partner Logo"][/vc_column_inner][vc_column_inner width="1/5"][impeka_single_image image="https://placehold.co/250x100/ffffff/4D74FB?text=Partner Logo"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'pricing-table-5';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Pricing Table 5', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/pricing/pricing-5.jpg');
$data['custom_class'] = 'pricing-tables';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_heading_color="primary-1" columns_gap="none" mobile_columns_vertical_gap="none" rc_font_color="#6040FF"][vc_column width="1/2" text_align="center" grve_css="{``desktop``:{``border-right``:1,``padding-top``:``15%``,``padding-right``:``10%``,``padding-bottom``:``15%``,``padding-left``:``10%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599099177659``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_title heading="h1" increase_heading="200" animation="fade-in-up" animation_delay="200"]$39[/impeka_title][impeka_title heading="h4" animation="fade-in-up" animation_delay="300"]Download Mockups[/impeka_title][vc_column_text text_style="leader-text" animation="fade-in-up" animation_delay="400"]A full-size model of our design, used for demonstration and other purposes.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Download Now" btn_hover_color_gradient="primary-1" btn_hover_action="pulse" btn_link="url:%23" animation="fade-in-up" animation_delay="500"][/vc_column][vc_column width="1/2" text_align="center" grve_css="{``desktop``:{``padding-top``:``15%``,``padding-right``:``10%``,``padding-bottom``:``15%``,``padding-left``:``10%``,``class``:``grve-wpb-1599098837241``}}"][impeka_title heading="h1" increase_heading="200" animation="fade-in-up" animation_delay="300"]$59[/impeka_title][impeka_title heading="h4" animation="fade-in-up" animation_delay="400"]Purchase Impeka[/impeka_title][vc_column_text text_style="leader-text" animation="fade-in-up" animation_delay="500"]Complete freedom to dream up your ideal website and then make it happen, fast.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Purchase Now" btn_hover_color_gradient="primary-1" btn_hover_action="pulse" btn_link="url:%23" animation="fade-in-up" animation_delay="600"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'pricing-table-6';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Pricing Table 6', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/pricing/pricing-6.jpg');
$data['custom_class'] = 'pricing-tables';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/6" tablet_sm_width="1-12"][/vc_column][vc_column width="1/2" tablet_sm_width="7-12"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" margin_bottom="30"]Choose your Plan[/impeka_title][vc_column_text text_style="leader-text"]We love to work with clients all over the world to develop unique, innovative and modern websites.[/vc_column_text][/vc_column][vc_column width="1/3"][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column width="1/12" tablet_sm_width="hide"][/vc_column][vc_column width="11/12" tablet_sm_width="1"][vc_row_inner][vc_column_inner width="1/3" vertical_content_position="middle" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``border-left``:1,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599465169412``}}"][impeka_pricing_table price="$29" heading_tag="h2" heading="h1" interval="" title="Freelancer" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,40 MB | Space" content_bg="none" align="center" btn_text="Read more about" btn_type="outline" btn_color="grey" btn_hover_action="pulse" btn_shape="round" btn_link="url:%23|||" animation_delay="100" button_text="Purchase Now" button_color="grey" button_shape="round" button_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``border-left``:1,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599465179100``}}"][impeka_pricing_table price="$59" heading_tag="h2" heading="h1" interval="" title="Small Business" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,100GB | Space" content_bg="none" align="center" btn_text="Read more about" btn_type="outline" btn_color="grey" btn_hover_action="pulse" btn_shape="round" btn_link="url:%23|||" animation_delay="200" button_text="Purchase Now" button_shape="round" button_shadow="medium" button_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" vertical_content_position="middle" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``border-left``:1,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599465188796``}}"][impeka_pricing_table price="$79" heading_tag="h2" heading="h1" interval="" title="Basic" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,Unlimited | Bandwidth" content_bg="none" align="center" btn_text="Read more about" btn_type="outline" btn_color="grey" btn_hover_action="pulse" btn_shape="round" btn_link="url:%23|||" animation_delay="300" button_text="Purchase Now" button_color="grey" button_shape="round" button_link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'pricing-table-7';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Pricing Table 7', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/pricing/pricing-7.jpg');
$data['custom_class'] = 'pricing-tables';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" rc_bg_color="#fbfbfb"][vc_column width="1/3" mobile_width="hide"][/vc_column][vc_column width="1/3" text_align="center"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" margin_bottom="30"]Choose your Plan[/impeka_title][impeka_title heading="h4"]Affordable prices and premium support.[/impeka_title][/vc_column][vc_column width="1/3"][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column tablet_sm_width="1"][vc_row_inner columns_gap="60"][vc_column_inner width="1/3" vertical_content_position="middle" grve_css="{``desktop``:{``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1608314463971``}}"][impeka_pricing_table price="$29" heading_tag="h2" heading="leader-text" increase_heading="250" interval="" title="Freelancer" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,40 MB | Space" align="center" shadow="medium-shadow" btn_text="Read more about" btn_type="outline" btn_color="grey" btn_hover_action="pulse" btn_shape="round" btn_link="url:%23|||" animation_delay="100" button_text="Purchase Now" button_color="grey" button_shape="round" button_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" grve_css="{``desktop``:{``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1608314478601``}}"][impeka_pricing_table price="$59" heading_tag="h2" heading="leader-text" increase_heading="250" interval="" title="Small Business" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,100GB | Space" align="center" shadow="medium-shadow" btn_text="Read more about" btn_type="outline" btn_color="grey" btn_hover_action="pulse" btn_shape="round" btn_link="url:%23|||" animation_delay="200" button_text="Purchase Now" button_shape="round" button_shadow="medium" button_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" vertical_content_position="middle" grve_css="{``desktop``:{``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1608314489739``}}"][impeka_pricing_table price="$79" heading_tag="h2" heading="leader-text" increase_heading="250" interval="" title="Basic" title_heading="subtitle-text" description="" values="Support Forum,Free Hosting,Unlimited | Bandwidth" align="center" shadow="medium-shadow" btn_text="Read more about" btn_type="outline" btn_color="grey" btn_hover_action="pulse" btn_shape="round" btn_link="url:%23|||" animation_delay="300" button_text="Purchase Now" button_color="grey" button_shape="round" button_link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-1.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" mobile_columns_vertical_gap="none" rc_bg_color="#ffffff"][vc_column][impeka_typed_text typed_prefix="Animated" typed_values="SVG Icons" heading="h5" text_color="primary-1" align="center" textspeed="100" backspeed="80" startdelay="0" backdelay="500" loop="yes" show_cursor=""][impeka_empty_space height_multiplier="2x"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="none" equal_column_height="equal" mobile_columns_vertical_gap="none"][vc_column_inner width="1/3" tablet_sm_width="1-2" grve_css="{``desktop``:{``border-right``:1,``border-bottom``:1,``padding-top``:``16%``,``padding-right``:``16%``,``padding-bottom``:``16%``,``padding-left``:``16%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1598066358550``},``tablet_landscape``:{``padding-right``:``10%``,``padding-left``:``10%``},``mobile_landscape``:{``border-right``:0}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-basket" icon_color="blue" title="Build your shop" heading="h6"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-2" grve_css="{``desktop``:{``border-right``:1,``border-bottom``:1,``padding-top``:``16%``,``padding-right``:``16%``,``padding-bottom``:``16%``,``padding-left``:``16%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1598066360844``},``tablet_landscape``:{``padding-right``:``10%``,``padding-left``:``10%``},``tablet_portrait``:{``border-right``:0}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-hourglass" icon_color="blue" title="Speed Optimized" heading="h6"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-2" grve_css="{``desktop``:{``border-bottom``:1,``padding-top``:``16%``,``padding-right``:``16%``,``padding-bottom``:``16%``,``padding-left``:``16%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1598066449566``},``tablet_landscape``:{``padding-right``:``10%``,``padding-left``:``10%``},``tablet_portrait``:{``border-right``:1},``mobile_landscape``:{``border-right``:0}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-video" icon_color="blue" title="Video Tutorials" heading="h6"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-2" grve_css="{``desktop``:{``border-right``:1,``padding-top``:``16%``,``padding-right``:``16%``,``padding-bottom``:``16%``,``padding-left``:``16%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1598066295873``},``tablet_landscape``:{``padding-right``:``10%``,``padding-left``:``10%``},``tablet_portrait``:{``border-right``:0,``border-bottom``:1}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-magnifying-glass" icon_color="blue" title="Knowledge Base" heading="h6"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-2" grve_css="{``desktop``:{``border-right``:1,``padding-top``:``16%``,``padding-right``:``16%``,``padding-bottom``:``16%``,``padding-left``:``16%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1598066476226``},``tablet_landscape``:{``padding-right``:``10%``,``padding-left``:``10%``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-browser" icon_color="blue" title="Innovative Framework" heading="h6"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3" tablet_sm_width="1-2" grve_css="{``desktop``:{``padding-top``:``16%``,``padding-right``:``16%``,``padding-bottom``:``16%``,``padding-left``:``16%``,``class``:``grve-wpb-1598066218258``},``tablet_landscape``:{``padding-right``:``10%``,``padding-left``:``10%``}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-circle-compass" icon_color="blue" title="Handcrafted Elements" heading="h6"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-2.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="2x" padding_bottom_multiplier="3x" mobile_columns_vertical_gap="50"][vc_column width="1/3" content_width="custom" horizontal_content_position="right" vertical_content_position="middle" text_align="right" mobile_horizontal_content_position="left" mobile_text_align="left" mobile_column_order="2" custom_content_width="270"][impeka_icon_box icon_box_type="side-icon" icon_side_align="inherit" icon_size="small" icon_library="simplelineicons" icon_simplelineicons="smp-icon-fire" title="Pixel Perfect" heading="h6"]Integer id nisi nec nulla luctus lacinia non eu turpis imperdiet justo tincidunt.[/impeka_icon_box][impeka_empty_space height_multiplier="2x"][impeka_icon_box icon_box_type="side-icon" icon_side_align="inherit" icon_size="small" icon_library="simplelineicons" icon_simplelineicons="smp-icon-ghost" title="Powerful Backend" heading="h6"]Integer id nisi nec nulla luctus lacinia non eu turpis imperdiet justo tincidunt.[/impeka_icon_box][impeka_empty_space height_multiplier="2x"][impeka_icon_box icon_box_type="side-icon" icon_side_align="inherit" icon_size="small" icon_library="simplelineicons" icon_simplelineicons="smp-icon-puzzle" title="Handcrafted Elements" heading="h6"]Integer id nisi nec nulla luctus lacinia non eu turpis imperdiet justo tincidunt.[/impeka_icon_box][/vc_column][vc_column width="1/3" vertical_content_position="middle" mobile_column_order="1"][impeka_single_image image_mode="medium_large" image="https://source.unsplash.com/748x1300" image_column_space="100"][/vc_column][vc_column width="1/3" content_width="custom" vertical_content_position="middle" mobile_text_align="left" mobile_column_order="3" custom_content_width="270"][impeka_icon_box icon_box_type="side-icon" icon_side_align="inherit" icon_size="small" icon_library="simplelineicons" icon_simplelineicons="smp-icon-like" title="Speed Optimized" heading="h6"]Integer id nisi nec nulla luctus lacinia non eu turpis imperdiet justo tincidunt.[/impeka_icon_box][impeka_empty_space height_multiplier="2x"][impeka_icon_box icon_box_type="side-icon" icon_side_align="inherit" icon_size="small" icon_library="simplelineicons" icon_simplelineicons="smp-icon-rocket" title="Innovative Framework" heading="h6"]Integer id nisi nec nulla luctus lacinia non eu turpis imperdiet justo tincidunt.[/impeka_icon_box][impeka_empty_space height_multiplier="2x"][impeka_icon_box icon_box_type="side-icon" icon_side_align="inherit" icon_size="small" icon_library="simplelineicons" icon_simplelineicons="smp-icon-earphones-alt" title="Online Support" heading="h6"]Integer id nisi nec nulla luctus lacinia non eu turpis imperdiet justo tincidunt.[/impeka_icon_box][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-3.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" rc_bg_color="#fbfbfb"][vc_column][impeka_title heading="leader-text" increase_heading="250" increase_heading_reset="mobile" align="center"]User experience is one
of our highest priorities.[/impeka_title][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="3x"][/vc_column][vc_column][vc_row_inner columns_gap="none"][vc_column_inner width="1/2" grve_css="{``desktop``:{``border-right``:1,``border-bottom``:1,``padding-top``:``11%``,``padding-right``:``11%``,``padding-bottom``:``11%``,``padding-left``:``11%``,``border-color``:``#efefef``,``border-style``:``solid``,``class``:``grve-wpb-1608313816146``},``mobile_landscape``:{``border-right``:0,``padding-right``:``0``,``padding-left``:``0``}}"][impeka_icon_box icon_top_align="left" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-download" icon_color="black" title="Lifetime Updates" heading="h5"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo. Vestibulum aliquam hendrerit molestie.[/impeka_icon_box][impeka_empty_space][impeka_button btn_text="Discover More" btn_type="only-text" btn_color="black" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_svg_icon_color="black" btn_svg_icon_shape_color="white"][/vc_column_inner][vc_column_inner width="1/2" grve_css="{``desktop``:{``border-bottom``:1,``padding-top``:``11%``,``padding-right``:``11%``,``padding-bottom``:``11%``,``padding-left``:``11%``,``border-color``:``#efefef``,``border-style``:``solid``,``class``:``grve-wpb-1608313854523``},``mobile_landscape``:{``padding-right``:``0``,``padding-left``:``0``}}"][impeka_icon_box icon_top_align="left" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-laptop" icon_color="black" title="Responsive Design" heading="h5"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo. Vestibulum aliquam hendrerit molestie.[/impeka_icon_box][impeka_empty_space][impeka_button btn_text="Discover More" btn_type="only-text" btn_color="black" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_svg_icon_color="black" btn_svg_icon_shape_color="white"][/vc_column_inner][vc_column_inner width="1/2" grve_css="{``desktop``:{``border-right``:1,``padding-top``:``11%``,``padding-right``:``11%``,``padding-bottom``:``11%``,``padding-left``:``11%``,``border-color``:``#efefef``,``border-style``:``solid``,``class``:``grve-wpb-1608313867430``},``mobile_landscape``:{``border-right``:0,``border-bottom``:1,``padding-right``:``0``,``padding-left``:``0``}}"][impeka_icon_box icon_top_align="left" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-circle-compass" icon_color="black" title="Handcrafted Elements" heading="h5"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo. Vestibulum aliquam hendrerit molestie.[/impeka_icon_box][impeka_empty_space][impeka_button btn_text="Discover More" btn_type="only-text" btn_color="black" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_svg_icon_color="black" btn_svg_icon_shape_color="white"][/vc_column_inner][vc_column_inner width="1/2" grve_css="{``desktop``:{``padding-top``:``11%``,``padding-right``:``11%``,``padding-bottom``:``11%``,``padding-left``:``11%``,``class``:``grve-wpb-1608313876034``},``mobile_landscape``:{``padding-right``:``0``,``padding-left``:``0``}}"][impeka_icon_box icon_top_align="left" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-heart" icon_color="black" title="No Skills Needed" heading="h5"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo. Vestibulum aliquam hendrerit molestie.[/impeka_icon_box][impeka_empty_space][impeka_button btn_text="Discover More" btn_type="only-text" btn_color="black" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_svg_icon_color="black" btn_svg_icon_shape_color="white"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 4', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-4.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" mobile_columns_vertical_gap="none" rc_bg_color="#fafafa"][vc_column][impeka_title heading="h5" align="center"]Custom Image Icons[/impeka_title][impeka_empty_space height_multiplier="2x"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier=""][vc_column_inner width="1/3" rc_bg_type="color" rc_add_shadow="medium-shadow" rc_bg_color="#ffffff" grve_css="{``desktop``:{``border-top-left-radius``:``6``,``border-top-right-radius``:``6``,``border-bottom-right-radius``:``6``,``border-bottom-left-radius``:``6``,``padding-top``:``24%``,``padding-right``:``13%``,``padding-bottom``:``24%``,``padding-left``:``13%``,``class``:``grve-wpb-1598073767011``},``tablet_landscape``:{``padding-top``:``18%``,``padding-right``:``8%``,``padding-bottom``:``18%``,``padding-left``:``8%``}}"][impeka_icon_box icon_type="image" icon_animation="yes" icon_image="https://placehold.co/96x96/71CCF6/FFF?text=image icon" title="Design" margin_bottom="48"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][impeka_button align="center" btn_text="Handcrafted Elements" btn_type="line" btn_line_position="bottom" btn_color="black" btn_line_color="blue" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" rc_bg_type="color" rc_add_shadow="medium-shadow" rc_bg_color="#ffffff" grve_css="{``desktop``:{``border-top-left-radius``:``6``,``border-top-right-radius``:``6``,``border-bottom-right-radius``:``6``,``border-bottom-left-radius``:``6``,``padding-top``:``24%``,``padding-right``:``13%``,``padding-bottom``:``24%``,``padding-left``:``13%``,``class``:``grve-wpb-1598073615765``},``tablet_landscape``:{``padding-top``:``18%``,``padding-right``:``8%``,``padding-bottom``:``18%``,``padding-left``:``8%``}}"][impeka_icon_box icon_type="image" icon_animation="yes" icon_image="https://placehold.co/96x96/71CCF6/FFF?text=image icon" title="Create" margin_bottom="48"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][impeka_button align="center" btn_text="Pixel Perfect" btn_type="line" btn_line_position="bottom" btn_color="black" btn_line_color="blue" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" rc_bg_type="color" rc_add_shadow="medium-shadow" rc_bg_color="#ffffff" grve_css="{``desktop``:{``border-top-left-radius``:``6``,``border-top-right-radius``:``6``,``border-bottom-right-radius``:``6``,``border-bottom-left-radius``:``6``,``padding-top``:``24%``,``padding-right``:``13%``,``padding-bottom``:``24%``,``padding-left``:``13%``,``class``:``grve-wpb-1598073627287``},``tablet_landscape``:{``padding-top``:``18%``,``padding-right``:``8%``,``padding-bottom``:``18%``,``padding-left``:``8%``}}"][impeka_icon_box icon_type="image" icon_animation="yes" icon_image="https://placehold.co/96x96/71CCF6/FFF?text=image icon" title="Support" margin_bottom="48"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][impeka_button align="center" btn_text="Google Analytics" btn_type="line" btn_line_position="bottom" btn_color="black" btn_line_color="blue" btn_link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-5';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 5', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-5.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/2"][impeka_single_image image_mode="large" image="https://source.unsplash.com/1440x1380"][/vc_column][vc_column width="1/2" content_width="custom" horizontal_content_position="center" vertical_content_position="middle" full_height="yes" add_column_link="yes" column_link="url:%23" hover_animation="magnetism" custom_content_width="270" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1599020807894``}}"][impeka_icon_box icon_library="etlineicons" icon_etlineicons="et-icon-basket" icon_color="white" title="Build your Shop" heading="h6"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][impeka_empty_space height_multiplier="custom" height="36px"][impeka_button align="center" btn_text="Read More About" btn_type="only-text" btn_color="white" btn_hover_color="orange" btn_link="url:%23"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-6';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 6', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-6.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_link_color="white" rc_link_hover_color="primary-1" rc_bg_type="image" rc_bg_color_overlay="black" rc_bg_opacity_overlay="60" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#0a0a0a"][vc_column width="1/3" content_width="custom" horizontal_content_position="center" vertical_content_position="middle" text_align="center" hover_animation="emphasized" custom_content_width="250" grve_css="{``desktop``:{``padding-top``:``25%``,``padding-right``:``30``,``padding-bottom``:``25%``,``padding-left``:``30``,``class``:``grve-wpb-1613470724632``}}"][impeka_icon_box icon_library="etlineicons" icon_etlineicons="et-icon-circle-compass" icon_color="white" title="Knowledge Base" heading="h5"]We guarantee you premium support for every buyer of Impeka. Trust us, we know from first hand the true meaning of the word “Support”.[/impeka_icon_box][impeka_empty_space height_multiplier="2x"][impeka_button btn_text="Read More About" btn_type="line" btn_line_position="bottom" btn_color="white" btn_line_color="white" btn_link="url:%23"][/vc_column][vc_column width="1/3" content_width="custom" horizontal_content_position="center" vertical_content_position="middle" text_align="center" hover_animation="emphasized" grve_css="{``desktop``:{``border-top``:0,``border-left``:1,``padding-top``:``25%``,``padding-right``:``30``,``padding-bottom``:``25%``,``padding-left``:``30``,``border-color``:``#212121``,``border-style``:``solid``,``class``:``grve-wpb-1613470734512``},``mobile_landscape``:{``border-top``:1,``border-left``:0}}" custom_content_width="250"][impeka_icon_box icon_library="etlineicons" icon_etlineicons="et-icon-globe" icon_color="white" title="Translation Ready" heading="h5"]We guarantee you premium support for every buyer of Impeka. Trust us, we know from first hand the true meaning of the word “Support”.[/impeka_icon_box][impeka_empty_space height_multiplier="2x"][impeka_button btn_text="Read More About" btn_type="line" btn_line_position="bottom" btn_color="white" btn_line_color="white" btn_link="url:%23"][/vc_column][vc_column width="1/3" content_width="custom" horizontal_content_position="center" vertical_content_position="middle" text_align="center" hover_animation="emphasized" grve_css="{``desktop``:{``border-top``:0,``border-left``:1,``padding-top``:``25%``,``padding-right``:``30``,``padding-bottom``:``25%``,``padding-left``:``30``,``border-color``:``#212121``,``border-style``:``solid``,``class``:``grve-wpb-1613470740725``},``mobile_landscape``:{``border-top``:1,``border-left``:0}}" custom_content_width="250"][impeka_icon_box icon_library="etlineicons" icon_etlineicons="et-icon-anchor" icon_color="white" title="Video Tutorials" heading="h5"]We guarantee you premium support for every buyer of Impeka. Trust us, we know from first hand the true meaning of the word “Support”.[/impeka_icon_box][impeka_empty_space height_multiplier="2x"][impeka_button btn_text="Read More About" btn_type="line" btn_line_position="bottom" btn_color="white" btn_line_color="white" btn_link="url:%23"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-7';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 7', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-7.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="gradient" rc_bg_gradient_color_1="#ffffff" rc_bg_gradient_color_2="#fafafa" rc_bg_gradient_direction="180" mobile_columns_vertical_gap="none"][vc_column width="1/4" tablet_width="1-6"][/vc_column][vc_column width="1/2" text_align="center" tablet_width="2-3"][impeka_title heading="subtitle-text" animation="fade-in"]The New Theme On The Block[/impeka_title][impeka_animated_text animated_text="|Impeka is a creative WordPress theme that gives you unparalleled versatility.|" heading="h4" style="style-2" animation_duration="fast"][/vc_column][vc_column width="1/4" tablet_width="1-6"][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-up" clipping_animation_colors="light-grey" animation_delay="200" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``border-left``:1,``border-top-left-radius``:``2``,``border-top-right-radius``:``2``,``border-bottom-right-radius``:``2``,``border-bottom-left-radius``:``2``,``padding-top``:``24%``,``padding-right``:``13%``,``padding-bottom``:``24%``,``padding-left``:``13%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599197216269``},``tablet_landscape``:{``padding-top``:``18%``,``padding-right``:``8%``,``padding-bottom``:``18%``,``padding-left``:``8%``}}"][impeka_icon_box icon_type="image" icon_image="https://placehold.co/96x96/6040FF/FFF?text=image icon" title="Design" heading="h5" margin_bottom="48"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][impeka_button align="center" btn_text="Handcrafted Elements" btn_type="line" btn_line_position="bottom" btn_color="black" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-up" clipping_animation_colors="light-grey" animation_delay="400" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``border-left``:1,``border-top-left-radius``:``2``,``border-top-right-radius``:``2``,``border-bottom-right-radius``:``2``,``border-bottom-left-radius``:``2``,``padding-top``:``24%``,``padding-right``:``13%``,``padding-bottom``:``24%``,``padding-left``:``13%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599197241372``},``tablet_landscape``:{``padding-top``:``18%``,``padding-right``:``8%``,``padding-bottom``:``18%``,``padding-left``:``8%``}}"][impeka_icon_box icon_type="image" icon_image="https://placehold.co/96x96/6040FF/FFF?text=image icon" title="Create" heading="h5" margin_bottom="48"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][impeka_button align="center" btn_text="Pixel Perfect" btn_type="line" btn_line_position="bottom" btn_color="black" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" animation="clipping" clipping_animation="colored-clipping-up" clipping_animation_colors="light-grey" animation_delay="600" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``border-left``:1,``border-top-left-radius``:``2``,``border-top-right-radius``:``2``,``border-bottom-right-radius``:``2``,``border-bottom-left-radius``:``2``,``padding-top``:``24%``,``padding-right``:``13%``,``padding-bottom``:``24%``,``padding-left``:``13%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1599197253209``},``tablet_landscape``:{``padding-top``:``18%``,``padding-right``:``8%``,``padding-bottom``:``18%``,``padding-left``:``8%``}}"][impeka_icon_box icon_type="image" icon_image="https://placehold.co/96x96/6040FF/FFF?text=image icon" title="Support" heading="h5" margin_bottom="48"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][impeka_button align="center" btn_text="Google Analytics" btn_type="line" btn_line_position="bottom" btn_color="black" btn_link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-8';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 8', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-8.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier=""][vc_column content_width="custom" horizontal_content_position="center" custom_content_width="1920" grve_css="{``desktop``:{``margin-bottom``:``-20%``,``class``:``grve-wpb-1599469882641``}}"][vc_row_inner][vc_column_inner width="1/6" tablet_sm_width="1-12"][/vc_column_inner][vc_column_inner width="5/6" tablet_sm_width="11-12"][impeka_single_image image_mode="extra-extra-large" image="https://source.unsplash.com/2400x1200" image_load_mode="off" image_column_space="100" inherit_align="left" animation="clipping-animation" clipping_animation="colored-clipping-left" animation_delay="300" animation_duration="slow"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="custom" padding_bottom_multiplier="4x" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000" padding_top="20%"][vc_column width="1/6" tablet_sm_width="1-12"][/vc_column][vc_column width="3/4" tablet_width="5-6" tablet_sm_width="11-12"][vc_row_inner][vc_column_inner][impeka_empty_space height_multiplier="4x"][/vc_column_inner][vc_column_inner width="1/2" content_width="custom" custom_content_width="435"][impeka_title heading="h4"]We tick masterfully all the boxes of <span style="color: #fab901;">design solutions.</span>[/impeka_title][/vc_column_inner][vc_column_inner width="1/2"][/vc_column_inner][vc_column_inner][impeka_empty_space height_multiplier="3x"][/vc_column_inner][vc_column_inner width="1/3"][impeka_icon_box icon_top_align="left" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-genius" icon_color="white" title="Responsive Design" heading="h6" animation="fade-in-up" animation_delay="200"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3"][impeka_icon_box icon_top_align="left" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-speedometer" icon_color="white" title="Speed Optimized" heading="h6" animation="fade-in-up" animation_delay="300"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3"][impeka_icon_box icon_top_align="left" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-shield" icon_color="white" title="No Skills Needed" heading="h6" animation="fade-in-up" animation_delay="400"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner][impeka_empty_space height_multiplier="3x"][/vc_column_inner][vc_column_inner width="1/3"][impeka_icon_box icon_top_align="left" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-dial" icon_color="white" title="Innovative Framework" heading="h6" animation="fade-in-up" animation_delay="300"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3"][impeka_icon_box icon_top_align="left" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-search" icon_color="white" title="Google Analytics" heading="h6" animation="fade-in-up" animation_delay="400"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3"][impeka_icon_box icon_top_align="left" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-aperture" icon_color="white" title="Pixel Perfect" heading="h6" animation="fade-in-up" animation_delay="500"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/12" tablet_width="hide" tablet_sm_width="hide"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-9';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 9', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-9.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="gradient" rc_bg_gradient_color_1="#ffffff" rc_bg_gradient_color_2="#fafafa" rc_bg_gradient_direction="180" mobile_columns_vertical_gap="none"][vc_column width="1/4" tablet_width="1-6"][/vc_column][vc_column width="1/2" text_align="center" rc_heading_color="primary-1" tablet_width="2-3"][impeka_title heading="subtitle-text" title_color="black" animation="fade-in"]The New Theme On The Block[/impeka_title][impeka_animated_text animated_text="|Impeka is a creative WordPress theme that gives you unparalleled versatility.|" heading="h4" style="style-2" animation_duration="fast"][/vc_column][vc_column width="1/4" tablet_width="1-6"][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner][vc_column_inner width="1/3" rc_heading_color="white" rc_bg_type="image" rc_bg_color_overlay="custom" rc_bg_color_overlay_custom="rgba(26,27,29,0.8)" animation="clipping" clipping_animation="colored-clipping-up" clipping_animation_colors="light-grey" animation_delay="200" grve_css="{``desktop``:{``border-top-left-radius``:``2``,``border-top-right-radius``:``2``,``border-bottom-right-radius``:``2``,``border-bottom-left-radius``:``2``,``padding-top``:``24%``,``padding-right``:``13%``,``padding-bottom``:``24%``,``padding-left``:``13%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1608284582384``},``tablet_landscape``:{``padding-top``:``18%``,``padding-right``:``8%``,``padding-bottom``:``18%``,``padding-left``:``8%``}}" rc_font_color="#ffffff"][impeka_icon_box icon_library="etlineicons" icon_color="white" title="Pixel Perfect" heading="h5" margin_bottom="48"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][impeka_button align="center" btn_text="Discover More" btn_color_gradient="white" btn_hover_color_gradient="white" btn_hover_action="pulse" btn_size="small" btn_shape="round" btn_shadow="medium" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" rc_heading_color="white" rc_bg_type="image" rc_bg_color_overlay="custom" rc_bg_color_overlay_custom="rgba(26,27,29,0.8)" animation="clipping" clipping_animation="colored-clipping-up" clipping_animation_colors="light-grey" animation_delay="400" grve_css="{``desktop``:{``border-top-left-radius``:``2``,``border-top-right-radius``:``2``,``border-bottom-right-radius``:``2``,``border-bottom-left-radius``:``2``,``padding-top``:``24%``,``padding-right``:``13%``,``padding-bottom``:``24%``,``padding-left``:``13%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1608284586418``},``tablet_landscape``:{``padding-top``:``18%``,``padding-right``:``8%``,``padding-bottom``:``18%``,``padding-left``:``8%``}}" rc_font_color="#ffffff"][impeka_icon_box icon_library="etlineicons" icon_etlineicons="et-icon-trophy" icon_color="white" title="Responsive Design" heading="h5" margin_bottom="48"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][impeka_button align="center" btn_text="Discover More" btn_color_gradient="white" btn_hover_color_gradient="white" btn_hover_action="pulse" btn_size="small" btn_shape="round" btn_shadow="medium" btn_link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/3" rc_heading_color="white" rc_bg_type="image" rc_bg_color_overlay="custom" rc_bg_color_overlay_custom="rgba(26,27,29,0.8)" animation="clipping" clipping_animation="colored-clipping-up" clipping_animation_colors="light-grey" animation_delay="600" grve_css="{``desktop``:{``border-top-left-radius``:``2``,``border-top-right-radius``:``2``,``border-bottom-right-radius``:``2``,``border-bottom-left-radius``:``2``,``padding-top``:``24%``,``padding-right``:``13%``,``padding-bottom``:``24%``,``padding-left``:``13%``,``border-color``:``#e1e1e1``,``border-style``:``solid``,``class``:``grve-wpb-1608284593934``},``tablet_landscape``:{``padding-top``:``18%``,``padding-right``:``8%``,``padding-bottom``:``18%``,``padding-left``:``8%``}}" rc_font_color="#ffffff"][impeka_icon_box icon_library="etlineicons" icon_etlineicons="et-icon-anchor" icon_color="white" title="Innovative Framework" heading="h5" margin_bottom="48"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][impeka_button align="center" btn_text="Discover More" btn_color_gradient="white" btn_hover_color_gradient="white" btn_hover_action="pulse" btn_size="small" btn_shape="round" btn_shadow="medium" btn_link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-10';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 10', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-10.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="custom" padding_bottom_multiplier="custom" columns_gap="15" padding_top="15" padding_bottom="15"][vc_column width="1/3" rc_heading_color="primary-1" rc_bg_type="color" animation="clipping" clipping_animation="clipping-down" animation_delay="200" rc_font_color="#6040FF" rc_bg_color="#eaf5f7" grve_css="{``desktop``:{``padding-top``:``28%``,``padding-right``:``20%``,``padding-bottom``:``28%``,``padding-left``:``20%``,``class``:``grve-wpb-1608316158602``}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" title="Responsive Design" heading="h5"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column][vc_column width="1/3" rc_heading_color="primary-1" rc_bg_type="color" animation="clipping" clipping_animation="clipping-down" animation_delay="400" rc_font_color="#6040FF" rc_bg_color="#eaf5f7" grve_css="{``desktop``:{``padding-top``:``28%``,``padding-right``:``20%``,``padding-bottom``:``28%``,``padding-left``:``20%``,``class``:``grve-wpb-1608316164538``}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-linegraph" title="Google Analytics" heading="h5"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column][vc_column width="1/3" rc_heading_color="primary-1" rc_bg_type="color" animation="clipping" clipping_animation="clipping-down" animation_delay="600" rc_font_color="#6040FF" rc_bg_color="#eaf5f7" grve_css="{``desktop``:{``padding-top``:``28%``,``padding-right``:``20%``,``padding-bottom``:``28%``,``padding-left``:``20%``,``class``:``grve-wpb-1608316174350``}}"][impeka_icon_box icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-lightbulb" title="Video Tutorials" heading="h5"]You’ll have everything you’ll need inside a powerful back-end.[/impeka_icon_box][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'icon-boxes-11';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Icon Boxes 11', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/icon-boxes/icon-boxes-11.jpg');
$data['custom_class'] = 'icon-box';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_heading_color="white" rc_bg_type="color" columns_gap="none" rc_bg_color="#b7f300"][vc_column width="1/3" content_width="custom" horizontal_content_position="center" text_align="center" animation="fade-in" animation_delay="100" grve_css="{``desktop``:{``border-right``:2,``border-color``:``#ffffff``,``border-style``:``solid``,``class``:``grve-wpb-1631973932948``},``mobile_landscape``:{``border-right``:0}}" custom_content_width="270"][impeka_single_image image="https://placehold.co/96x96/000000/FFF?text=image icon" retina_image="https://placehold.co/192x192/000000/FFF?text=image icon" margin_bottom="30"][impeka_title heading_tag="h2" heading="h4"]Strength[/impeka_title][vc_column_text]You’ll have everything you’ll need inside a powerful back-end.[/vc_column_text][impeka_empty_space][impeka_icon icon_type="theme-icon-svg" icon_size="extra-small" theme_icon="plus" icon_color="black" icon_shape="circle" icon_shape_color="white" loop_animation="animation-1" link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fabout%2F"][/vc_column][vc_column width="1/3" content_width="custom" horizontal_content_position="center" text_align="center" animation="fade-in" animation_delay="300" custom_content_width="270" grve_css="{``desktop``:{``border-right``:2,``border-color``:``#ffffff``,``border-style``:``solid``,``class``:``grve-wpb-1631973940934``},``mobile_landscape``:{``border-right``:0}}"][impeka_single_image image="https://placehold.co/96x96/000000/FFF?text=image icon" retina_image="https://placehold.co/192x192/000000/FFF?text=image icon" margin_bottom="30"][impeka_title heading_tag="h2" heading="h4"]Cardio Class[/impeka_title][vc_column_text]From just 25$/month you get full package and personal trainer.[/vc_column_text][impeka_empty_space][impeka_icon icon_type="theme-icon-svg" icon_size="extra-small" theme_icon="plus" icon_color="black" icon_shape="circle" icon_shape_color="white" loop_animation="animation-1" link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fabout%2F"][/vc_column][vc_column width="1/3" content_width="custom" horizontal_content_position="center" text_align="center" animation="fade-in" animation_delay="500" custom_content_width="270"][impeka_single_image image="https://placehold.co/96x96/000000/FFF?text=image icon" retina_image="https://placehold.co/192x192/000000/FFF?text=image icon" margin_bottom="30"][impeka_title heading_tag="h2" heading="h4"]Fat Burn[/impeka_title][vc_column_text]It's an intense aerobic method that includes sprinting.[/vc_column_text][impeka_empty_space][impeka_icon icon_type="theme-icon-svg" icon_size="extra-small" theme_icon="plus" icon_color="black" icon_shape="circle" icon_shape_color="white" loop_animation="animation-1" link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fabout%2F"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'tabs-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Tab 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/tabs/tab-1.jpg');
$data['custom_class'] = 'tabs-accordions';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="gradient" rc_bg_gradient_color_1="#ffffff" rc_bg_gradient_color_2="#fafafa" rc_bg_gradient_direction="180"][vc_column animation_delay="200"][vc_tta_tabs alignment="center" active_section="1" heading_tag="h2" heading="leader-text"][vc_tta_section i_type="material" i_icon_material="vc-material vc-material-favorite_border" add_icon="true" title="Build your shop" tab_id="tab1-1"][vc_row_inner padding_bottom_multiplier=""][vc_column_inner width="1/3" vertical_content_position="middle" tablet_sm_width="1-2"][impeka_title heading="subtitle-text" margin_bottom="18"]Impeka Theme[/impeka_title][impeka_title heading="h4"]User experience is one of our highest priorities.[/impeka_title][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Maecenas tincidunt, velit ac porttitor pulvinar, tortor eros facilisis libero.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read more about" btn_type="only-text" btn_color="black" btn_link="url:%23|||" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_icon_shape="circle"][/vc_column_inner][vc_column_inner width="2/3" content_width="custom" horizontal_content_position="right" tablet_sm_width="1-2" custom_content_width="670"][impeka_single_image image_mode="large" image="https://source.unsplash.com/1340x860" image_column_space="100" inherit_align="right"][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section i_type="material" i_icon_material="vc-material vc-material-chat_bubble_outline" add_icon="true" title="Google Analytics" tab_id="1594657421171-70d5668c-2630"][vc_row_inner padding_bottom_multiplier=""][vc_column_inner width="1/3" vertical_content_position="middle" tablet_sm_width="1-2"][impeka_title heading="h4"]Google Analytics lets you measure your ROI.[/impeka_title][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Maecenas tincidunt, velit ac porttitor pulvinar, tortor eros facilisis libero.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read more about" btn_type="only-text" btn_color="black" btn_link="url:%23|||" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_icon_shape="circle"][/vc_column_inner][vc_column_inner width="2/3" content_width="custom" horizontal_content_position="right" tablet_sm_width="1-2" custom_content_width="670"][impeka_single_image image_mode="large" image="https://source.unsplash.com/1340x860" image_column_space="100" inherit_align="right"][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section i_type="material" i_icon_material="vc-material vc-material-personal_video" add_icon="true" title="Translation Ready" tab_id="1594657439942-babc1f9e-a267"][vc_row_inner padding_bottom_multiplier=""][vc_column_inner width="1/3" vertical_content_position="middle" tablet_sm_width="1-2"][impeka_title heading="h4"]It can easily be translated into multiple languages. [/impeka_title][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Maecenas tincidunt, velit ac porttitor pulvinar, tortor eros facilisis libero.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read more about" btn_type="only-text" btn_color="black" btn_link="url:%23|||" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_icon_shape="circle"][/vc_column_inner][vc_column_inner width="2/3" content_width="custom" horizontal_content_position="right" tablet_sm_width="1-2" custom_content_width="670"][impeka_single_image image_mode="large" image="https://source.unsplash.com/1340x860" image_column_space="100" inherit_align="right"][/vc_column_inner][/vc_row_inner][/vc_tta_section][/vc_tta_tabs][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'tabs-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Tab 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/tabs/tab-2.jpg');
$data['custom_class'] = 'tabs-accordions';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column][vc_row_inner][vc_column_inner width="1/4" tablet_width="1-6"][/vc_column_inner][vc_column_inner width="1/2" text_align="center" tablet_width="2-3"][impeka_title heading="subtitle-text" margin_bottom="30"]schedule[/impeka_title][impeka_title heading="h5"]From just 25$/month you get full package and personal trainer[/impeka_title][/vc_column_inner][vc_column_inner width="1/4" tablet_width="1-6"][/vc_column_inner][/vc_row_inner][impeka_empty_space height_multiplier="2x"][vc_tta_tabs alignment="center" active_section="1"][vc_tta_section title="Monday" tab_id="1631869756596-821573fa-52bc"][vc_row_inner padding_top_multiplier="1x" columns_gap="10" tablet_sm_columns_vertical_gap="10" mobile_columns_vertical_gap="10"][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870414267``}}"][impeka_title heading="h6" margin_bottom="10"]9:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]KICKBOXING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870423386``}}"][impeka_title heading="h6" margin_bottom="10"]11:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]YOGA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870428632``}}"][impeka_title heading="h6" margin_bottom="10"]12:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]SWIMMING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870433209``}}"][impeka_title heading="h6" margin_bottom="10"]14:00[/impeka_title][impeka_title heading="h5" title_color="primary-1"]ZUMBA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner tablet_sm_width="hide" mobile_width="hide"][impeka_empty_space height_multiplier="custom" height="10"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870439253``}}"][impeka_title heading="h6" margin_bottom="10"]10:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]ZUMBA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870444181``}}"][impeka_title heading="h6" margin_bottom="10"]12:00[/impeka_title][impeka_title heading="h5" title_color="primary-1"]KICKBOXING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870449165``}}"][impeka_title heading="h6" margin_bottom="10"]13:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]YOGA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870453915``}}"][impeka_title heading="h6" margin_bottom="10"]14:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]SWIMMING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section title="Tuesday" tab_id="1631869756611-18842a2c-06b3"][vc_row_inner padding_top_multiplier="1x" columns_gap="10" tablet_sm_columns_vertical_gap="10" mobile_columns_vertical_gap="10"][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870414267``}}"][impeka_title heading="h6" margin_bottom="10"]9:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]KICKBOXING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870423386``}}"][impeka_title heading="h6" margin_bottom="10"]11:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]YOGA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870428632``}}"][impeka_title heading="h6" margin_bottom="10"]12:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]SWIMMING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870433209``}}"][impeka_title heading="h6" margin_bottom="10"]14:00[/impeka_title][impeka_title heading="h5" title_color="primary-1"]ZUMBA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner tablet_sm_width="hide" mobile_width="hide"][impeka_empty_space height_multiplier="custom" height="10"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870439253``}}"][impeka_title heading="h6" margin_bottom="10"]10:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]ZUMBA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870444181``}}"][impeka_title heading="h6" margin_bottom="10"]12:00[/impeka_title][impeka_title heading="h5" title_color="primary-1"]KICKBOXING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870449165``}}"][impeka_title heading="h6" margin_bottom="10"]13:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]YOGA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870453915``}}"][impeka_title heading="h6" margin_bottom="10"]14:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]SWIMMING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section title="Wednesday" tab_id="1631870724365-5f22cba9-c1dd"][vc_row_inner padding_top_multiplier="1x" columns_gap="10" tablet_sm_columns_vertical_gap="10" mobile_columns_vertical_gap="10"][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870414267``}}"][impeka_title heading="h6" margin_bottom="10"]9:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]KICKBOXING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870423386``}}"][impeka_title heading="h6" margin_bottom="10"]11:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]YOGA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870428632``}}"][impeka_title heading="h6" margin_bottom="10"]12:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]SWIMMING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870433209``}}"][impeka_title heading="h6" margin_bottom="10"]14:00[/impeka_title][impeka_title heading="h5" title_color="primary-1"]ZUMBA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner tablet_sm_width="hide" mobile_width="hide"][impeka_empty_space height_multiplier="custom" height="10"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870439253``}}"][impeka_title heading="h6" margin_bottom="10"]10:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]ZUMBA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870444181``}}"][impeka_title heading="h6" margin_bottom="10"]12:00[/impeka_title][impeka_title heading="h5" title_color="primary-1"]KICKBOXING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870449165``}}"][impeka_title heading="h6" margin_bottom="10"]13:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]YOGA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870453915``}}"][impeka_title heading="h6" margin_bottom="10"]14:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]SWIMMING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section title="Thursday" tab_id="1631870745844-3b421261-53a9"][vc_row_inner padding_top_multiplier="1x" columns_gap="10" tablet_sm_columns_vertical_gap="10" mobile_columns_vertical_gap="10"][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870414267``}}"][impeka_title heading="h6" margin_bottom="10"]9:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]KICKBOXING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870423386``}}"][impeka_title heading="h6" margin_bottom="10"]11:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]YOGA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870428632``}}"][impeka_title heading="h6" margin_bottom="10"]12:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]SWIMMING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870433209``}}"][impeka_title heading="h6" margin_bottom="10"]14:00[/impeka_title][impeka_title heading="h5" title_color="primary-1"]ZUMBA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner tablet_sm_width="hide" mobile_width="hide"][impeka_empty_space height_multiplier="custom" height="10"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870439253``}}"][impeka_title heading="h6" margin_bottom="10"]10:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]ZUMBA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870444181``}}"][impeka_title heading="h6" margin_bottom="10"]12:00[/impeka_title][impeka_title heading="h5" title_color="primary-1"]KICKBOXING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870449165``}}"][impeka_title heading="h6" margin_bottom="10"]13:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]YOGA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870453915``}}"][impeka_title heading="h6" margin_bottom="10"]14:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]SWIMMING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section title="Friday" tab_id="1631870758778-9fb64f2b-9f89"][vc_row_inner padding_top_multiplier="1x" columns_gap="10" tablet_sm_columns_vertical_gap="10" mobile_columns_vertical_gap="10"][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870414267``}}"][impeka_title heading="h6" margin_bottom="10"]9:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]KICKBOXING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870423386``}}"][impeka_title heading="h6" margin_bottom="10"]11:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]YOGA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870428632``}}"][impeka_title heading="h6" margin_bottom="10"]12:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]SWIMMING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870433209``}}"][impeka_title heading="h6" margin_bottom="10"]14:00[/impeka_title][impeka_title heading="h5" title_color="primary-1"]ZUMBA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner tablet_sm_width="hide" mobile_width="hide"][impeka_empty_space height_multiplier="custom" height="10"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870439253``}}"][impeka_title heading="h6" margin_bottom="10"]10:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]ZUMBA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870444181``}}"][impeka_title heading="h6" margin_bottom="10"]12:00[/impeka_title][impeka_title heading="h5" title_color="primary-1"]KICKBOXING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870449165``}}"][impeka_title heading="h6" margin_bottom="10"]13:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]YOGA[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][vc_column_inner width="1/4" text_align="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1-3" rc_font_color="#ffffff" rc_bg_color="#000000" grve_css="{``desktop``:{``padding-top``:``40``,``padding-right``:``30``,``padding-bottom``:``40``,``padding-left``:``30``,``class``:``grve-wpb-1631870453915``}}"][impeka_title heading="h6" margin_bottom="10"]14:30[/impeka_title][impeka_title heading="h5" title_color="primary-1"]SWIMMING[/impeka_title][vc_column_text text_style="leader-text"]2h 15min[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3b3b3b" padding_top="15" padding_bottom="30"][impeka_button btn_text="Book Class" btn_type="line" btn_line_position="bottom" btn_color="white" btn_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fimpeka-fitness%2Fclasses%2F"][/vc_column_inner][/vc_row_inner][/vc_tta_section][/vc_tta_tabs][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'accordion-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Accordion 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/accordions/accordion-1.jpg');
$data['custom_class'] = 'tabs-accordions';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="" rc_heading_color="white" rc_bg_type="color" columns_gap="60" mobile_columns_vertical_gap="none" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#131729"][vc_column width="5/12" content_width="custom" vertical_content_position="middle" mobile_column_order="2" custom_content_width="455"][impeka_empty_space height_multiplier="3x"][impeka_title heading="h4" margin_bottom="30"]How to start with Impeka[/impeka_title][vc_tta_accordion c_position="right" active_section="1" heading="link-text"][vc_tta_section title="Can I use Revolution Slider as Feautered Section?" tab_id="1594660430213-c4485d8e-1f27de97-198d"][vc_column_text]Before all else you must setup a WordPress version on your server. After downloading the package, you will have “Impeka” folder and “impeka.zip” file inside the Theme package. [/vc_column_text][/vc_tta_section][vc_tta_section title="Support deals with more satisfied customers?" tab_id="1525082265500-00929566-4755de97-198d"][vc_column_text]Click the Impeka tab from the main WordPress navigation and then you will be able to access and enjoy many core features of Impeka.[/vc_column_text][/vc_tta_section][vc_tta_section title="You’ll have everything you’ll need?" tab_id="1525082265545-1faa0928-8b95de97-198d"][vc_column_text]Most of these elements can have their own align without one’s place affecting the other’s. This way, virtually dozens of combinations can turn out.[/vc_column_text][/vc_tta_section][vc_tta_section title="Pages, Posts, Portfolios, Products and Area Items" tab_id="1594663649290-d8a69ebc-98bede97-198d"][vc_column_text]Most of these elements can have their own align without one’s place affecting the other’s. This way, virtually dozens of combinations can turn out.[/vc_column_text][/vc_tta_section][/vc_tta_accordion][impeka_empty_space height_multiplier="3x"][/vc_column][vc_column width="7/12" full_height="yes" rc_bg_type="image" rc_bg_position="center-top" expand_column_bg="expand-bg-right" mobile_column_order="1" mobile_expand_column_bg="both-sides"][impeka_empty_space height_multiplier="custom" height="40vh"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'accordion-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Accordion 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/accordions/accordion-2.jpg');
$data['custom_class'] = 'tabs-accordions';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="" rc_bg_type="color" columns_gap="none" mobile_columns_vertical_gap="none" rc_bg_color="#ffffff"][vc_column width="7/12" rc_bg_type="color" expand_column_bg="expand-bg-left" mobile_column_order="2" rc_bg_color="#f9f9f9" grve_css="{``desktop``:{``padding-right``:``30%``,``class``:``grve-wpb-1598859012869``},``mobile_landscape``:{``padding-right``:``30``}}"][impeka_empty_space height_multiplier="4x"][impeka_title heading="h4"]Top rated
Elite Author Team.[/impeka_title][vc_tta_accordion c_position="right" active_section="1" heading="link-text"][vc_tta_section title="Can I use Revolution Slider as Featured Section?" tab_id="1594660430213-c4485d8e-1f27cda3-e6daaaef-86c1"][vc_column_text]Before all else you must setup a WordPress version on your server. After downloading the package, you will have “Impeka” folder and “impeka.zip” file inside the Theme package. [/vc_column_text][/vc_tta_section][vc_tta_section title="Support deals with more satisfied customers?" tab_id="1525082265500-00929566-4755cda3-e6daaaef-86c1"][vc_column_text]Click the Impeka tab from the main WordPress navigation and then you will be able to access and enjoy many core features of Impeka.[/vc_column_text][/vc_tta_section][vc_tta_section title="You’ll have everything you’ll need?" tab_id="1525082265545-1faa0928-8b95cda3-e6daaaef-86c1"][vc_column_text]Most of these elements can have their own align without one’s place affecting the other’s. This way, virtually dozens of combinations can turn out.[/vc_column_text][/vc_tta_section][/vc_tta_accordion][impeka_empty_space height_multiplier="4x"][/vc_column][vc_column width="5/12" vertical_content_position="middle" mobile_column_order="1"][impeka_single_image image_mode="medium_large" image_load_mode="off" image_column_space="125" inherit_align="right" animation="clipping-animation" clipping_animation="colored-clipping-left" animation_delay="400"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'accordion-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Accordion 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/accordions/accordion-3.jpg');
$data['custom_class'] = 'tabs-accordions';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/6" tablet_sm_width="hide"][/vc_column][vc_column width="2/3" tablet_sm_width="1"][impeka_title heading="h1" margin_bottom="0"]Frequently<br />
Asked Questions[/impeka_title][impeka_empty_space height_multiplier="2x"][vc_tta_accordion c_position="right" active_section="1"][vc_tta_section title="Set your Home and Blog page in Impeka" tab_id="1599538524117-e9ffb15a-b9b9"][vc_column_text]Create a new page from Pages &gt; Add New. Give a title, like ‘Home’, add the elements and settings you wish and then publish it. Next, create another page with the title you want for your blog. You do not need any content for your main blog page. The next thing is to tell WordPress to use your pages appropriately. Go to Settings &gt; Reading and set the ‘Front page displays’ to ‘A static page’. Set the home page you just created as the ‘Front page’, and the blog page you created as the ‘Posts page’ and save your changes.[/vc_column_text][/vc_tta_section][vc_tta_section title="Update Impeka and its required plugins" tab_id="1599538524134-414ca8f8-7bad"][vc_column_text]This is for sure the easiest and fastest way to update Impeka. The only thing you have to do is to activate the theme update and enter your Themeforest username and an API key (from Envato).[/vc_column_text][/vc_tta_section][vc_tta_section title="Import Full Demo Content in Impeka" tab_id="1599538553816-724ea419-a89b"][vc_column_text]With Impeka you have the possibility to import any of the demos with just ONE click.[/vc_column_text][/vc_tta_section][vc_tta_section title="Install Impeka and its required plugins" tab_id="1599538563628-a9eba140-7f07"][vc_column_text]Before all else, you must setup a WordPress version on your server. After downloading the package, you will have “Impeka” folder and “impeka.zip” file inside the Theme package. You can either choose to upload the Theme to your server via ftp (just upload the folder “Impeka” into the folder wp-content/themes) or via WordPress upload function (Appearance &gt; Themes &gt; Install Themes &gt; Upload) using the “impeka.zip” file.[/vc_column_text][/vc_tta_section][/vc_tta_accordion][impeka_empty_space height_multiplier="3x"][vc_row_inner][vc_column_inner width="1/2" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``border-left``:1,``padding-top``:``10%``,``padding-right``:``20%``,``padding-bottom``:``10%``,``padding-left``:``20%``,``border-color``:``#e5e5e5``,``border-style``:``solid``,``class``:``grve-wpb-1599538844860``}}"][impeka_icon_box icon_type="image" icon_image="https://placehold.co/100x100/848484/FFF?text=image icon" title="Knowledge Base" heading="h5"]A knowledgebase to provide detailed instructions on how to use Impeka Theme.[/impeka_icon_box][impeka_empty_space][impeka_button align="center" btn_text="Visit Documentation" btn_type="line" btn_line_position="bottom" btn_color="black" btn_link="url:%23"][/vc_column_inner][vc_column_inner width="1/2" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``border-left``:1,``padding-top``:``10%``,``padding-right``:``20%``,``padding-bottom``:``10%``,``padding-left``:``20%``,``border-color``:``#e5e5e5``,``border-style``:``solid``,``class``:``grve-wpb-1599538866921``}}"][impeka_icon_box icon_type="image" icon_image="https://placehold.co/100x100/848484/FFF?text=image icon" title="Online Support" heading="h5"]We will do our best to assist you with any issues related to the use of our theme.[/impeka_icon_box][impeka_empty_space][impeka_button align="center" btn_text="Send a ticket" btn_type="line" btn_line_position="bottom" btn_color="black" btn_link="url:%23"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/6" tablet_sm_width="hide"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'testimonials-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Testimonials 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/testimonials/testimonials-1.jpg');
$data['custom_class'] = 'testimonials';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x" rc_bg_type="color" rc_bg_color="#f7f7f7"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][impeka_title heading="subtitle-text" animation="clipping-animation" clipping_animation="colored-clipping-left" margin_bottom="30"]Effortless and intuitive[/impeka_title][vc_column_text text_style="leader-text"]User experience is one of our highest priorities, and the clean and contemporary interface of Impeka is the icing on the premium cake.[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column width="1/6"][/vc_column][vc_column width="5/6"][impeka_testimonial_carousel testimonial_style="style-4" type="advanced" items_per_page="2" items_tablet_landscape="2" items_tablet_portrait="2" items_to_show="10" loop="no" auto_play="no" heading="h5"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'clients-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Clients 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/clients/clients-1.jpg');
$data['custom_class'] = 'clients';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/2" tablet_sm_width="2-3"][impeka_title heading="h4"]Our Clients[/impeka_title][impeka_animated_text animated_text="|We love to work with clients all over the world to develop unique, innovative and modern websites.|" heading="leader-text" style="style-2"][/vc_column][vc_column width="1/2" tablet_sm_width="1-3"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][vc_row_inner columns_gap="none" mobile_columns_vertical_gap="none"][vc_column_inner width="1/3" mobile_width="1-2" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-left``:1,``padding-top``:``18%``,``padding-right``:``18%``,``padding-bottom``:``18%``,``padding-left``:``18%``,``border-color``:``#f2f2f2``,``border-style``:``solid``,``class``:``grve-wpb-1608369631133``}}"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="200"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``padding-top``:``18%``,``padding-right``:``18%``,``padding-bottom``:``18%``,``padding-left``:``18%``,``border-color``:``#f2f2f2``,``border-style``:``solid``,``class``:``grve-wpb-1608369636894``}}"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="400"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``padding-top``:``18%``,``padding-right``:``18%``,``padding-bottom``:``18%``,``padding-left``:``18%``,``border-color``:``#f2f2f2``,``border-style``:``solid``,``class``:``grve-wpb-1608369754972``},``mobile_landscape``:{``border-right``:0,``border-left``:1}}"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="600"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``border-left``:1,``padding-top``:``18%``,``padding-right``:``18%``,``padding-bottom``:``18%``,``padding-left``:``18%``,``border-color``:``#f2f2f2``,``border-style``:``solid``,``class``:``grve-wpb-1608369780511``},``mobile_landscape``:{``border-bottom``:0}}"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="400"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``padding-top``:``18%``,``padding-right``:``18%``,``padding-bottom``:``18%``,``padding-left``:``18%``,``border-color``:``#f2f2f2``,``border-style``:``solid``,``class``:``grve-wpb-1608369828325``},``mobile_landscape``:{``border-left``:1}}"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="600"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2" grve_css="{``desktop``:{``border-top``:1,``border-right``:1,``border-bottom``:1,``padding-top``:``18%``,``padding-right``:``18%``,``padding-bottom``:``18%``,``padding-left``:``18%``,``border-color``:``#f2f2f2``,``border-style``:``solid``,``class``:``grve-wpb-1608369659173``}}"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation="clipping-animation" clipping_animation="colored-clipping-left" clipping_animation_colors="grey" animation_delay="800"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'clients-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Clients 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/clients/clients-2.jpg');
$data['custom_class'] = 'clients';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="4x"][vc_column width="1/6" tablet_width="1-12" tablet_sm_width="hide"][/vc_column][vc_column width="2/3" text_align="center" tablet_width="5-6" tablet_sm_width="1"][impeka_title heading="subtitle-text"]Our Clients[/impeka_title][impeka_animated_text animated_text="|We love to work with clients to develop unique, innovative websites.|" style="style-2"][/vc_column][vc_column width="1/6" tablet_width="1-12" tablet_sm_width="hide"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column content_width="custom" horizontal_content_position="center" custom_content_width="970"][vc_row_inner][vc_column_inner width="1/3" mobile_width="1-2"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation_delay="400"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation_delay="400"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation_delay="400"][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation_delay="400"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation_delay="400"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2"][impeka_single_image image="https://placehold.co/250x100/fafafa/dfdfdf?text=Client Logo" retina_image="https://placehold.co/500x200/fafafa/dfdfdf?text=Client Logo" animation_delay="400"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'safebutton-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Safebutton 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/safebuttons/safebutton-1.jpg');
$data['custom_class'] = 'safebuttons';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" height_ratio="100" padding_top_multiplier="3x" padding_bottom_multiplier="3x" rc_heading_color="white" rc_link_color="white" rc_link_hover_color="primary-1" rc_bg_type="color" tablet_sm_columns_vertical_gap="50" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="2/3" vertical_content_position="middle" tablet_sm_width="1" grve_css="{``desktop``:{``padding-right``:``8%``,``padding-left``:``8%``,``class``:``grve-wpb-1611172797455``}}"][vc_row_inner][vc_column_inner width="1/2" add_column_link="yes" column_link="url:%23" rc_heading_color="white" rc_bg_type="image" rc_bg_image="" rc_bg_position="center-top" rc_bg_opacity_overlay="80" hover_animation="magnetism" rc_font_color="#ffffff" grve_css="{``desktop``:{``padding-top``:``55%``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1611310364772``}}"][impeka_title heading="h5"]100+<br />
Prebuilt Websites &amp; Blocks[/impeka_title][/vc_column_inner][vc_column_inner width="1/2" add_column_link="yes" column_link="url:%23|target:_blank" rc_heading_color="white" rc_bg_type="image" rc_bg_image="" rc_bg_opacity_overlay="70" hover_animation="magnetism" rc_font_color="#ffffff" grve_css="{``desktop``:{``padding-top``:``55%``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1611310351256``}}"][impeka_title heading="h5"]50+<br />
Handcrafted Elements[/impeka_title][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space][/vc_column_inner][vc_column_inner width="1/2" add_column_link="yes" column_link="url:%23" rc_heading_color="white" rc_bg_type="image" rc_bg_image="" rc_bg_opacity_overlay="50" hover_animation="magnetism" rc_font_color="#ffffff" grve_css="{``desktop``:{``padding-top``:``55%``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1611310375758``}}"][impeka_title heading="h5"]Start<br />
Selling Online[/impeka_title][/vc_column_inner][vc_column_inner width="1/2" add_column_link="yes" column_link="url:%23" rc_heading_color="white" rc_bg_type="image" rc_bg_image="" rc_bg_opacity_overlay="50" hover_animation="magnetism" rc_font_color="#ffffff" grve_css="{``desktop``:{``padding-top``:``55%``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1611310387079``}}"][impeka_title heading="h5"]Build &amp; Scale<br />
your Startup[/impeka_title][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/3" content_width="custom" horizontal_content_position="center" vertical_content_position="middle" tablet_sm_width="1" tablet_sm_content_width="100" tablet_sm_horizontal_content_position="left" custom_content_width="370" grve_css="{``desktop``:{``padding-right``:``12%``,``padding-left``:``12%``,``class``:``grve-wpb-1611172929373``}}"][impeka_menu nav_menu="" orientation="vertical" menu_type="slide" heading="h3" item_space="10"][impeka_empty_space height_multiplier="2x"][impeka_menu nav_menu="" orientation="vertical" menu_type="slide" item_space="10"][impeka_empty_space height_multiplier="2x"][impeka_button btn_text="Come on Board" btn_color_gradient="green" btn_hover_color_gradient="green" btn_hover_action="pulse" btn_shape="round" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_svg_icon_color="green" btn_svg_icon_shape_color="white"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'safebutton-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Safebutton 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/safebuttons/safebutton-2.jpg');
$data['custom_class'] = 'safebuttons';
$data['content'] = <<<CONTENT
[vc_row height_ratio="100" rc_heading_color="white" rc_font_color="#ffffff"][vc_column width="1/2" vertical_content_position="middle" text_align="center" rc_bg_type="color" rc_bg_color="#ff4433" grve_css="{``desktop``:{``padding-top``:``90``,``padding-bottom``:``40``,``class``:``grve-wpb-1633858152990``}}"][impeka_single_image image="https://placehold.co/538x386/ff4433/FFF"][impeka_title heading="h4" margin_bottom="12"]Our Latest Project[/impeka_title][impeka_button btn_text="Discover Impekka" btn_type="line" btn_line_position="bottom" btn_color="white" btn_line_color="white" btn_link="url:https%3A%2F%2F1.envato.market%2Fimpeka|title:Impekka|target:_blank"][/vc_column][vc_column width="1/2" vertical_content_position="middle"][vc_row_inner columns_gap="none"][vc_column_inner width="7/12" vertical_content_position="middle" full_height="yes" rc_bg_type="color" mobile_width="3-5" rc_bg_color="#2f17e1" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1633858205681``}}"][impeka_title heading="h4" margin_bottom="12"]Knowledge Base[/impeka_title][impeka_button btn_text="Discover More" btn_type="line" btn_line_position="bottom" btn_color="white" btn_line_color="white" btn_link="url:https%3A%2F%2Fdocs.greatives.eu%2Ftheme%2Fimpeka%2F|title:Tutorial|target:_blank"][/vc_column_inner][vc_column_inner width="5/12" vertical_content_position="middle" full_height="yes" rc_bg_type="color" mobile_width="2-5" rc_bg_color="#4128ff" grve_css="{``desktop``:{``padding-top``:``90``,``padding-bottom``:``90``,``class``:``grve-wpb-1633858211427``}}"][impeka_single_image image="https://placehold.co/104x90/2f17e1/FFF"][/vc_column_inner][/vc_row_inner][impeka_empty_space][vc_row_inner columns_gap="none"][vc_column_inner width="7/12" vertical_content_position="middle" full_height="yes" rc_bg_type="color" mobile_width="3-5" rc_bg_color="#1c427c" grve_css="{``desktop``:{``padding-top``:``30``,``padding-right``:``30``,``padding-bottom``:``30``,``padding-left``:``30``,``class``:``grve-wpb-1633858226023``}}"][impeka_title heading="h4" margin_bottom="12"]Narrated Videos[/impeka_title][impeka_button btn_text="Watch More" btn_type="line" btn_line_position="bottom" btn_color="white" btn_line_color="white" btn_link="url:https%3A%2F%2Fwww.youtube.com%2Fplaylist%3Flist%3DPLsRm8BqfgIKOhS-zJq990JmpZyupxs8m5|title:Contact|target:_blank"][/vc_column_inner][vc_column_inner width="5/12" vertical_content_position="middle" full_height="yes" rc_bg_type="color" mobile_width="2-5" rc_bg_color="#184b99" grve_css="{``desktop``:{``padding-top``:``90``,``padding-bottom``:``90``,``class``:``grve-wpb-1633858231028``}}"][impeka_single_image image="https://placehold.co/104x90/1c427c/FFF"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'menu-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Menu 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/menus/menu-1.jpg');
$data['custom_class'] = 'menus';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="custom" padding_bottom_multiplier="2x" rc_heading_color="white" rc_bg_type="color" tablet_sm_columns_vertical_gap="30" rc_font_color="#ffffff" rc_bg_color="#000000" padding_top="24"][vc_column width="2/3" vertical_content_position="middle"][vc_column_text]Custom mega menu, created with the theme's page builder.[/vc_column_text][/vc_column][vc_column width="1/3" vertical_content_position="middle" text_align="right" mobile_text_align="left"][impeka_button btn_text="Watch how easy it is" btn_type="video" btn_color="white" btn_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D0s4_7BuszuQ" btn_video_icon_shape_hover_color="primary-1" btn_class="grve-video-popup"][/vc_column][vc_column][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#3c3e46" padding_top="24" padding_bottom="24"][/vc_column][vc_column width="3/4" tablet_sm_width="1"][vc_row_inner][vc_column_inner width="1/3" add_column_link="yes" column_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Felements%2F|title:Elements" rc_bg_type="image" hover_animation="emphasized" grve_css="{``desktop``:{``padding-top``:``50%``,``padding-right``:``15``,``padding-bottom``:``15``,``padding-left``:``15``,``class``:``grve-wpb-1613124053258``}}"][impeka_title heading="link-text" increase_heading="120"]Page Builders[/impeka_title][/vc_column_inner][vc_column_inner width="1/3" add_column_link="yes" column_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fsafe-button%2F" rc_bg_type="image" hover_animation="emphasized" grve_css="{``desktop``:{``padding-top``:``50%``,``padding-right``:``15``,``padding-bottom``:``15``,``padding-left``:``15``,``class``:``grve-wpb-1613062149938``}}"][impeka_title heading="link-text" increase_heading="120"]Safe Button[/impeka_title][/vc_column_inner][vc_column_inner width="1/3" add_column_link="yes" column_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Ffont-manager%2F" rc_bg_type="image" hover_animation="emphasized" grve_css="{``desktop``:{``padding-top``:``50%``,``padding-right``:``15``,``padding-bottom``:``15``,``padding-left``:``15``,``class``:``grve-wpb-1613045953755``}}"][impeka_title heading="link-text" increase_heading="120"]Font Manager[/impeka_title][/vc_column_inner][vc_column_inner mobile_width="hide"][impeka_empty_space][/vc_column_inner][vc_column_inner width="1/3" add_column_link="yes" column_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fcustom-modals%2F" rc_bg_type="image" hover_animation="emphasized" grve_css="{``desktop``:{``padding-top``:``50%``,``padding-right``:``15``,``padding-bottom``:``15``,``padding-left``:``15``,``class``:``grve-wpb-1613048334827``}}"][impeka_title heading="link-text" increase_heading="120"]Global Modals[/impeka_title][/vc_column_inner][vc_column_inner width="1/3" add_column_link="yes" column_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fcontent-manager%2F" rc_bg_type="image" rc_bg_position="center-bottom" hover_animation="emphasized" grve_css="{``desktop``:{``padding-top``:``50%``,``padding-right``:``15``,``padding-bottom``:``15``,``padding-left``:``15``,``class``:``grve-wpb-1613128144376``}}"][impeka_title heading="link-text" increase_heading="120"]Content Manager[/impeka_title][/vc_column_inner][vc_column_inner width="1/3" add_column_link="yes" column_link="url:https%3A%2F%2Fgreatives.eu%2Fthemes%2Fimpeka%2Fdemo-importers%2F|title:Demo%20Importers" rc_bg_type="image" hover_animation="emphasized" grve_css="{``desktop``:{``padding-top``:``50%``,``padding-right``:``15``,``padding-bottom``:``15``,``padding-left``:``15``,``class``:``grve-wpb-1613060712741``}}"][impeka_title heading="link-text" increase_heading="120"]Demo Importers[/impeka_title][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/4" content_width="custom" horizontal_content_position="center" tablet_sm_width="1" mobile_content_width="100" tablet_sm_horizontal_content_position="left" tablet_sm_text_align="left" custom_content_width="200"][impeka_empty_space height_multiplier="custom" height="18"][vc_row_inner][vc_column_inner add_column_link="yes" column_link="url:%23" rc_bg_type="color" hover_animation="magnetism" rc_bg_color="#1a1a1a" grve_css="{``desktop``:{``border-top-left-radius``:``3``,``border-top-right-radius``:``3``,``border-bottom-right-radius``:``3``,``border-bottom-left-radius``:``3``,``padding-top``:``12``,``padding-right``:``12``,``padding-bottom``:``12``,``padding-left``:``12``,``class``:``grve-wpb-1613295863582``}}"][impeka_icon_box icon_box_type="side-icon" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-genius" icon_color="primary-2" title="Greatives Hub" heading="link-text"][/impeka_icon_box][/vc_column_inner][/vc_row_inner][impeka_empty_space height_multiplier="custom" height="18px"][vc_row_inner][vc_column_inner add_column_link="yes" column_link="url:%23" rc_bg_type="color" hover_animation="magnetism" rc_bg_color="#1a1a1a" grve_css="{``desktop``:{``border-top-left-radius``:``3``,``border-top-right-radius``:``3``,``border-bottom-right-radius``:``3``,``border-bottom-left-radius``:``3``,``padding-top``:``12``,``padding-right``:``12``,``padding-bottom``:``12``,``padding-left``:``12``,``class``:``grve-wpb-1613295863582``}}"][impeka_icon_box icon_box_type="side-icon" icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-basket" icon_color="green" title="Purchase Impeka" heading="link-text"][/impeka_icon_box][/vc_column_inner][/vc_row_inner][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="rgba(255,255,255,0.1)" padding_top="30" padding_bottom="30"][vc_row_inner rc_link_color="white" rc_link_hover_color="primary-1"][vc_column_inner][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" item_space="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'footer-1';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Footer 1', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/footers/footer-1.jpg');
$data['custom_class'] = 'footers';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="custom" rc_heading_color="white" rc_link_color="white" rc_link_hover_color="primary-1" rc_bg_type="color" mobile_columns_vertical_gap="50" scroll_header_skin="light" padding_bottom="36" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/2" mobile_text_align="center"][impeka_title heading="h1" increase_heading="160"]Let’s Talk[/impeka_title][vc_column_text text_style="leader-text"]We are a passionate team of professional web designers and developers, who specialize in creating premium WordPress themes.[/vc_column_text][impeka_empty_space height_multiplier="custom" height="36"][impeka_button btn_text="Get in touch" btn_hover_color_gradient="primary-1" btn_hover_action="pulse" btn_link="url:https%3A%2F%2Fthemeforest.net%2Fuser%2Fgreatives%23contact|target:_blank" btn_icon_type="icon-svg" btn_svg_icon_shape="circle" btn_svg_icon_color="primary-1" btn_svg_icon_shape_color="white"][/vc_column][vc_column width="1/2" text_align="right" mobile_text_align="center"][impeka_title heading="subtitle-text" margin_bottom="22"]Will be around[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="h3" item_space="25"][/vc_column][vc_column mobile_width="hide"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#404040" padding_bottom="36"][vc_row_inner mobile_columns_vertical_gap="15"][vc_column_inner width="1/2" mobile_text_align="center"][vc_column_text text_style="small-text"]©2021 Impeka WordPress Theme[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" text_align="right" mobile_text_align="center"][vc_column_text text_style="small-text"]Powered by <a href="https://greatives.eu/" target="_blank" rel="noopener">Greatives</a>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'footer-2';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Footer 2', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/footers/footer-2.jpg');
$data['custom_class'] = 'footers';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="2x" rc_heading_color="white" rc_link_color="white" rc_link_hover_color="black" rc_bg_type="gradient" rc_bg_gradient_color_1="#ff4433" rc_bg_gradient_color_2="#ff7962" rc_bg_gradient_direction="45" scroll_header_skin="light" rc_font_color="#ffffff"][vc_column text_align="center"][impeka_single_image image="https://placehold.co/120x35?text=logo" retina_image="" image_load_mode="native-lazyload" margin_bottom="8"][impeka_title heading="subtitle-text"]Effortless and intuitive[/impeka_title][impeka_empty_space height_multiplier="2x"][impeka_menu nav_menu="" responsive_orientation="vertical-mobile" align="center" heading="h5" item_space="35"][/vc_column][vc_column content_width="custom" horizontal_content_position="center" text_align="center" custom_content_width="370"][impeka_empty_space][vc_column_text]Impeka gives you complete freedom to dream up your ideal website and then make it happen, fast.[/vc_column_text][/vc_column][vc_column text_align="center"][impeka_empty_space height_multiplier="2x"][impeka_divider line_type="vertical-line" line_width="1" vertical_line_height="2x" line_color="white" line_loop_animation="top-bottom"][impeka_empty_space height_multiplier="2x"][impeka_menu nav_menu="" heading="link-text"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'footer-3';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Footer 3', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/footers/footer-3.jpg');
$data['custom_class'] = 'footers';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="2x" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/4"][/vc_column][vc_column width="1/2" text_align="center"][impeka_title heading="h4"]Join our Newsletter[/impeka_title][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas varius tortor nibh, sit amet tempor nibh finibus et. Aenean eu enim justo.[/vc_column_text][/vc_column][vc_column width="1/4"][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column width="1/6"][/vc_column][vc_column width="2/3" rc_bg_type="color" rc_bg_color="#ffffff" grve_css="{``desktop``:{``border-top-left-radius``:``3``,``border-top-right-radius``:``3``,``border-bottom-right-radius``:``3``,``border-bottom-left-radius``:``3``,``padding-top``:``18``,``padding-right``:``18``,``padding-bottom``:``18``,``padding-left``:``18``,``class``:``grve-wpb-1610997855482``}}"][impeka_contact_form id="" inputs_borders="" button_color="primary-3"][/vc_column][vc_column width="1/6"][/vc_column][vc_column][impeka_empty_space height_multiplier="3x"][/vc_column][vc_column text_align="center" rc_link_color="inherit" rc_link_hover_color="primary-3" rc_font_color="#5e5e5e"][impeka_social_links icon_size="small" icon_color="grey" align="center" twitter_url="#" facebook_url="#" instagram_url="#" linkedin_url="#" el_id="1610997643312-a0d54088-8be3" margin_bottom="24"][impeka_menu nav_menu="" responsive_orientation="vertical-mobile" align="center" item_space="25"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'footer-4';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Footer 4', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/footers/footer-4.jpg');
$data['custom_class'] = 'footers';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" padding_bottom_multiplier="3x" rc_bg_type="color" rc_bg_color="#f9f9f9"][vc_column width="1/4" tablet_width="1-6" tablet_sm_width="1-12"][/vc_column][vc_column width="1/2" tablet_width="2-3" tablet_sm_width="5-6"][impeka_title align="center"]Stay Connected
We appreciate your feedback.[/impeka_title][impeka_empty_space][vc_row_inner mobile_visibility="hide"][vc_column_inner width="1/3"][impeka_icon_box icon_box_type="side-icon" icon_library="etlineicons" icon_etlineicons="et-icon-lightbulb" icon_color="dark-grey" icon_shape="circle" icon_shape_color="white" title="Knowledge Base" heading="link-text"][/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3"][impeka_icon_box icon_box_type="side-icon" icon_library="etlineicons" icon_etlineicons="et-icon-chat" icon_color="dark-grey" icon_shape="circle" icon_shape_color="white" title="Support Forum" heading="link-text"][/impeka_icon_box][/vc_column_inner][vc_column_inner width="1/3"][impeka_icon_box icon_box_type="side-icon" icon_library="etlineicons" icon_etlineicons="et-icon-aperture" icon_color="dark-grey" icon_shape="circle" icon_shape_color="white" title="Video Tutorials" heading="link-text"][/impeka_icon_box][/vc_column_inner][/vc_row_inner][vc_row_inner desktop_visibility="hide" tablet_visibility="hide" tablet_sm_visibility="hide"][vc_column_inner width="1/3" text_align="right" mobile_width="1-3"][impeka_icon icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-lightbulb" icon_color="dark-grey" icon_shape="circle" icon_shape_color="white"][/vc_column_inner][vc_column_inner width="1/3" text_align="center" mobile_width="1-3"][impeka_icon icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-chat" icon_color="dark-grey" icon_shape="circle" icon_shape_color="white"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-3"][impeka_icon icon_size="small" icon_library="etlineicons" icon_etlineicons="et-icon-aperture" icon_color="dark-grey" icon_shape="circle" icon_shape_color="white"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/4" tablet_width="1-6" tablet_sm_width="1-12"][/vc_column][/vc_row][vc_row padding_top_multiplier="" padding_bottom_multiplier="" rc_link_color="inherit" rc_link_hover_color="primary-1" rc_bg_type="color" rc_bg_color="#ffffff"][vc_column rc_heading_color="white" rc_bg_type="color" rc_add_shadow="medium-shadow" rc_font_color="#ffffff" rc_bg_color="#ff4433" grve_css="{``desktop``:{``margin-top``:``-49``,``border-top-left-radius``:``3``,``border-top-right-radius``:``3``,``border-bottom-right-radius``:``3``,``border-bottom-left-radius``:``3``,``padding-top``:``24``,``padding-right``:``30``,``padding-bottom``:``24``,``padding-left``:``30``,``class``:``grve-wpb-1599631257706``},``mobile_landscape``:{``margin-top``:``-5``}}"][vc_row_inner][vc_column_inner width="5/12" content_width="custom" horizontal_content_position="right" vertical_content_position="middle" text_align="center" custom_content_width="340"][impeka_title heading="h6"]Join our newsletter[/impeka_title][/vc_column_inner][vc_column_inner width="7/12" content_width="custom" custom_content_width="540"][impeka_contact_form id="" inputs_shape="round" inputs_bg_color="custom" inputs_bg_color_custom="#f7f7f7" inputs_placeholder_color="#a8a8a8" inputs_borders="" inputs_focus_bg_color="custom" inputs_focus_bg_color_custom="#ffffff" button_color="white" button_shape="round"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row padding_top_multiplier="3x" rc_bg_type="color" rc_bg_color="#ffffff"][vc_column width="1/4" tablet_width="1-3"][impeka_title heading="h6" margin_bottom="18"]About Us[/impeka_title][vc_column_text]We guarantee you premium support for every buyer of Impeka. Trust us, we know from first hand the true meaning of the word “Support”.[/vc_column_text][impeka_empty_space][impeka_button btn_text="Read More" btn_type="only-text" btn_color="black" btn_hover_color="primary-1" btn_link="url:%23" btn_icon_type="icon-svg"][/vc_column][vc_column width="1/4" tablet_width="1-6" tablet_sm_width="1-12"][/vc_column][vc_column width="1/2" tablet_sm_width="7-12"][vc_row_inner][vc_column_inner width="1/3" mobile_width="1-2"][impeka_title heading="h6" margin_bottom="18"]Company[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="body-text" item_space="10" menu_space="12px" el_id="1599630697133-a8932e92-5fd1"][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2"][impeka_title heading="h6" margin_bottom="18"]Support[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="body-text" item_space="10" menu_space="12px" el_id="1599630703036-02882490-16f1"][/vc_column_inner][vc_column_inner width="1/3"][impeka_title heading="h6" margin_bottom="18"]Quick Links[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="body-text" item_space="10" menu_space="12px" el_id="1599630644126-d682dc8d-65a3"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][impeka_empty_space height_multiplier="2x"][impeka_divider][impeka_empty_space][/vc_column][vc_column][vc_row_inner mobile_columns_vertical_gap="10"][vc_column_inner width="1/2" mobile_text_align="center"][impeka_title heading="small-text"]©2021 Impeka WordPress Theme[/impeka_title][/vc_column_inner][vc_column_inner width="1/2" text_align="right" mobile_text_align="center"][impeka_menu nav_menu="" heading="small-text" el_id="1599630771448-846582c1-a178"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'footer-5';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Footer 5', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/footers/footer-5.jpg');
$data['custom_class'] = 'footers';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="4x" rc_heading_color="white" rc_link_color="inherit" rc_link_hover_color="orange" rc_bg_type="color" tablet_sm_columns_vertical_gap="60" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/3" tablet_sm_width="1-2" mobile_text_align="center"][vc_row_inner mobile_columns_vertical_gap="none"][vc_column_inner content_width="custom" mobile_content_width="100" custom_content_width="270"][impeka_single_image image="https://placehold.co/120x35?text=logo" retina_image="" image_load_mode="native-lazyload" inherit_align="inherit"][impeka_empty_space][vc_column_text]We guarantee you premium support for every buyer of Impeka. Trust us, we know from first hand the true meaning of the word “Support”.[/vc_column_text][/vc_column_inner][vc_column_inner][impeka_empty_space][/vc_column_inner][vc_column_inner][impeka_contact_form id="" inputs_shape="round" inputs_bg_color="custom" inputs_bg_color_custom="#121417" inputs_text_color="#ffffff" inputs_placeholder_color="#9e9e9e" inputs_borders="" inputs_focus_bg_color="custom" inputs_focus_bg_color_custom="#121417" inputs_focus_text_color="#ffffff" inputs_focus_placeholder_color="#ffffff" button_color="black" button_shape="round"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/6" tablet_sm_width="hide" mobile_width="hide"][/vc_column][vc_column width="1/2" tablet_sm_width="1" mobile_text_align="center"][vc_row_inner][vc_column_inner width="1/3"][impeka_title heading="subtitle-text" margin_bottom="30"]Company[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="body-text" item_space="15" menu_space="18px" el_id="1599628812655-b0a94d60-1dd9"][/vc_column_inner][vc_column_inner width="1/3"][impeka_title heading="subtitle-text" margin_bottom="30"]Support[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="body-text" item_space="15" menu_space="18px" el_id="1599628819874-0cf90db2-6fea"][/vc_column_inner][vc_column_inner width="1/3"][impeka_title heading="subtitle-text" margin_bottom="30"]Quick Links[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="body-text" item_space="15" menu_space="18px" el_id="1599628274056-8814f326-3335"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][impeka_empty_space height_multiplier="4x"][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="#313131"][impeka_empty_space][/vc_column][vc_column][vc_row_inner mobile_columns_vertical_gap="15"][vc_column_inner width="1/2" mobile_text_align="center"][vc_column_text text_style="small-text"]©2021 Impeka WordPress Theme[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" text_align="right" mobile_text_align="center"][impeka_menu nav_menu="" heading="small-text" el_id="1599628934928-ad802b19-396e"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'footer-6';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Footer 6', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/footers/footer-6.jpg');
$data['custom_class'] = 'footers';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="5x" padding_bottom_multiplier="3x" rc_heading_color="white" rc_link_color="inherit" rc_link_hover_color="primary-1" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#000000"][vc_column width="1/6" tablet_sm_width="hide"][/vc_column][vc_column width="2/3" vertical_content_position="middle" text_align="center" tablet_sm_width="1"][impeka_title heading="subtitle-text" margin_bottom="36"]Effortless and intuitive[/impeka_title][impeka_menu nav_menu="" heading="h4" menu_space="1.500em" el_id="1600255429615-c7575892-6acc"][vc_row_inner padding_top_multiplier="1x"][vc_column_inner grve_css="{``desktop``:{``padding-right``:``26%``,``padding-left``:``26%``,``class``:``grve-wpb-1596536212260``},``mobile_landscape``:{``padding-right``:``0``,``padding-left``:``0``}}"][vc_column_text]Impeka gives you complete freedom to dream up your ideal website and then make it happen, fast.[/vc_column_text][impeka_empty_space height_multiplier="2x"][impeka_divider line_type="custom-line" line_width="110" line_height="3" align="center"][impeka_empty_space height_multiplier="2x"][impeka_menu nav_menu="" heading="small-text" menu_space="1.500em" el_id="1596535440059-d52eaf00-925a"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/6" tablet_sm_width="hide"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'footer-7';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Footer 7', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/footers/footer-7.jpg');
$data['custom_class'] = 'footers';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="2x" padding_bottom_multiplier="2x" rc_heading_color="white" rc_link_color="inherit" rc_link_hover_color="primary-2" rc_bg_type="color" scroll_header_skin="light" rc_font_color="#ffffff" rc_bg_color="#131729"][vc_column][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier=""][vc_column_inner width="1/3"][impeka_title heading="subtitle-text" title_color="custom" title_color_custom="rgba(255,255,255,0.5)" margin_bottom="8"]Call us[/impeka_title][impeka_title title_color="primary-2"]93 987 6543[/impeka_title][/vc_column_inner][vc_column_inner width="1/3"][impeka_title heading="subtitle-text" title_color="custom" title_color_custom="rgba(255,255,255,0.5)" margin_bottom="8"]Visit Us[/impeka_title][vc_column_text]4851 Willow Greene Drive<br />
Montgomery[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" vertical_content_position="bottom" text_align="right" mobile_text_align="left"][impeka_social_links icon_size="small" social_space="12px" icon_color="white" icon_shape="circle" shape_color="primary-2" twitter_url="#" facebook_url="#" instagram_url="#" el_id="1598953639549-786597bc-7ff6"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][impeka_empty_space][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="rgba(225,225,225,0.2)"][impeka_empty_space height_multiplier="2x"][/vc_column][vc_column width="1/3" content_width="custom" custom_content_width="270"][impeka_title heading="h6" margin_bottom="18"]About Us[/impeka_title][vc_column_text]We guarantee you premium support for every buyer of Impeka. Trust us, we know from first hand the true meaning of the word “Support”.[/vc_column_text][impeka_empty_space height_multiplier="custom" height="24"][impeka_button btn_text="Get in touch" btn_type="only-text" btn_color="white" btn_hover_color="primary-2" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon="arrow-2"][impeka_empty_space][/vc_column][vc_column width="2/3"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier="" tablet_sm_columns_vertical_gap="45" mobile_columns_vertical_gap="60"][vc_column_inner width="1/4" tablet_sm_width="1-2" mobile_width="1-2"][impeka_title heading="h6" margin_bottom="18"]Company[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="body-text" menu_space="12px" el_id="1598954618899-cb38adfa-a3c6"][/vc_column_inner][vc_column_inner width="1/4" tablet_sm_width="1-2" mobile_width="1-2"][impeka_title heading="h6" margin_bottom="18"]Support[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="body-text" menu_space="12px" el_id="1598954449976-d900219a-9d23"][/vc_column_inner][vc_column_inner width="1/4" tablet_sm_width="1-2" mobile_width="1-2"][impeka_title heading="h6" margin_bottom="18"]Quick Links[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="body-text" menu_space="12px" el_id="1598954452343-45357ced-aa09"][/vc_column_inner][vc_column_inner width="1/4" tablet_sm_width="1-2" mobile_width="1-2"][impeka_title heading="h6" margin_bottom="18"]Terms[/impeka_title][impeka_menu nav_menu="" orientation="vertical" menu_type="toggle" heading="body-text" menu_space="12px" el_id="1598954081564-9f2bc6d1-39ea"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'footer-8';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Footer 8', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/footers/footer-8.jpg');
$data['custom_class'] = 'footers';
$data['content'] = <<<CONTENT
[vc_row section_type="fullwidth" padding_top_multiplier="" padding_bottom_multiplier="" columns_gap="none" mobile_columns_vertical_gap="none" scroll_header_skin="light"][vc_column width="1/2" content_width="custom" horizontal_content_position="center" rc_heading_color="white" rc_bg_type="color" tablet_sm_width="1" rc_font_color="#ffffff" rc_bg_color="#131729" custom_content_width="480" grve_css="{``desktop``:{``padding-right``:``12%``,``padding-left``:``12%``,``class``:``grve-wpb-1598981946549``}}"][impeka_empty_space height_multiplier="6x"][impeka_title heading="subtitle-text" margin_bottom="18"]Stay Connected[/impeka_title][impeka_title heading="h1" margin_bottom="36"]Let’s build the next big thing together[/impeka_title][impeka_button btn_fluid="custom" btn_custom_width="185" btn_text="Get in touch" btn_color_gradient="orange" btn_hover_color_gradient="orange" btn_link="url:%23" btn_icon_type="icon-svg" btn_svg_icon="arrow-2"][impeka_empty_space height_multiplier="6x"][/vc_column][vc_column width="1/2" content_width="custom" horizontal_content_position="center" vertical_content_position="bottom" rc_heading_color="white" rc_link_color="inherit" rc_link_hover_color="orange" rc_bg_type="color" tablet_sm_width="1" rc_font_color="#ffffff" rc_bg_color="#000000" custom_content_width="470" grve_css="{``desktop``:{``padding-right``:``12%``,``padding-left``:``12%``,``class``:``grve-wpb-1598981995908``}}"][impeka_empty_space height_multiplier="5x"][vc_column_text text_style="leader-text"]We are a passionate team of professional web designers and developers.[/vc_column_text][impeka_divider line_type="custom-line" line_width="100%" line_height="1" line_color="custom" line_color_custom="rgba(255,255,255,0.2)" padding_top="30" padding_bottom="30"][vc_row_inner padding_top_multiplier="" padding_bottom_multiplier=""][vc_column_inner width="1/3"][impeka_title heading="link-text" margin_bottom="18"]Address[/impeka_title][vc_column_text text_style="small-text"]4851 Willow Greene Drive Montgomery[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2"][impeka_title heading="link-text" margin_bottom="18"]Policies[/impeka_title][vc_column_text text_style="small-text"]<a href="#">Terms of Service</a>
<a href="#">Privacy Statement</a>[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" mobile_width="1-2"][impeka_title heading="link-text" margin_bottom="18"]Support[/impeka_title][vc_column_text text_style="small-text"]<a href="#">Contact Support</a>
<a href="#">Knowldge Base</a>[/vc_column_text][/vc_column_inner][/vc_row_inner][impeka_empty_space height_multiplier="5x"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'footer-9';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Footer 9', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/footers/footer-9.jpg');
$data['custom_class'] = 'footers';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="" padding_bottom_multiplier="custom" rc_heading_color="white" rc_bg_type="color" scroll_header_skin="light" padding_bottom="36" rc_font_color="#ffffff" rc_bg_color="#0a0a0a"][vc_column text_align="center"][impeka_divider line_type="vertical-line" line_width="1" line_color="white" line_loop_animation="top-bottom"][impeka_empty_space height_multiplier="3x"][impeka_single_image image="https://placehold.co/120x35?text=logo" retina_image="" margin_bottom="6"][impeka_title heading="subtitle-text"]Creative Agency[/impeka_title][/vc_column][vc_column text_align="center"][impeka_empty_space height_multiplier="2x"][impeka_title title_color="primary-3" margin_bottom="12"]93 987 6543[/impeka_title][vc_column_text]<span style="color: #f7978f;">4851 Willow Greene Drive Montgomery.</span>[/vc_column_text][impeka_empty_space height_multiplier="5x"][/vc_column][vc_column text_align="center"][vc_column_text text_style="small-text"]© 2021 All rights reserved Impeka theme. [/vc_column_text][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

$data = array();
$data['unique_id'] = $data['id'] = 'footer-10';
$data['type'] = 'impeka_templates';
$data['name'] = esc_html__( 'Footer 10', 'impeka-wpb-extension' );
$data['image_path'] = preg_replace( '/\s/', '%20', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'impeka-templates/images/footers/footer-10.jpg');
$data['custom_class'] = 'footers';
$data['content'] = <<<CONTENT
[vc_row padding_top_multiplier="5x" padding_bottom_multiplier="3x" rc_heading_color="white" rc_link_color="white" rc_link_hover_color="primary-1" rc_bg_type="color" separator_top="tilt-right-separator" scroll_header_skin="light" rc_font_color="#b7f300" rc_bg_color="#000000"][vc_column text_align="center"][impeka_single_image image="https://placehold.co/220x150/1D1D1D/FFF?text=image icon" retina_image="https://placehold.co/440x300/1D1D1D/FFF?text=image icon" margin_bottom="30"][impeka_menu nav_menu="" responsive_orientation="vertical-mobile"][impeka_empty_space height_multiplier="2x"][impeka_social_links icon_color="white" twitter_url="#" facebook_url="#" instagram_url="#" dribbble_url="#" el_id="1631708911317-efeb044e-cfc5"][impeka_empty_space height_multiplier="2x"][vc_column_text]38 FARLEA DRIVE<br />
MIAMI, FLORIDA 283020[/vc_column_text][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

		return $templates;
	}
}

$impeka_vc_templates = new Impeka_Vc_Templates();
$impeka_vc_templates->init();
