<?php
/*
 * Plugin Name: Impeka WPBakery Extension
 * Description: This plugin extends WPBakery Page Builder and adds custom elements.
 * Author: Greatives Team
 * Author URI: https://greatives.eu
 * Version: 1.3.6
 * Text Domain: impeka-wpb-extension
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! defined( 'IMPEKA_WPB_EXT_VERSION' ) ) {
	define( 'IMPEKA_WPB_EXT_VERSION', '1.3.6' );
}

if ( ! defined( 'IMPEKA_WPB_EXT_PLUGIN_DIR_PATH' ) ) {
	define( 'IMPEKA_WPB_EXT_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'IMPEKA_WPB_EXT_PLUGIN_DIR_URL' ) ) {
	define( 'IMPEKA_WPB_EXT_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! class_exists( 'Impeka_WPBakery_Extension_Plugin' ) ) {

	class Impeka_WPBakery_Extension_Plugin {

		/**
		 * @action plugins_loaded
		 * @return Impeka_WPBakery_Extension_Plugin
		 * @static
		 */
		public static function init()
		{

			static $instance = false;

			if ( ! $instance ) {
				load_plugin_textdomain( 'impeka-wpb-extension' , false , dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
				$instance = new Impeka_WPBakery_Extension_Plugin;
			}
			return $instance;

		}

		/* Add Page Builder Plugin*/
		private function __construct() {

			if ( is_user_logged_in() ) {
				add_action( 'admin_enqueue_scripts' , $this->marshal( 'impeka_wpb_ext_add_scripts' ) );
			}
			add_action( 'wp_enqueue_scripts' , $this->marshal( 'impeka_wpb_ext_add_front_end_scripts' ) );

			require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'includes/impeka-wpb-ext-add-param.php';
			require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'includes/impeka-wpb-ext-shortcode-param.php';


			//Shortcodes
			if( function_exists( 'vc_lean_map' ) || function_exists( 'vc_map' ) ) {
				if ( function_exists( 'impeka_grve_info') ) {
					vc_set_shortcodes_templates_dir( IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'wpb_templates' );
				}

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/title_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/empty_space_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/divider_params.php';


				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/button_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/button_group_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/quote_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/dropcap_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/slogan_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/callout_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/progress_bar_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/pricing_table_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/message_box_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/icon_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/icon_box_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/fancy_box_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/image_text_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/cascading_image_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/split_content_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/media_box_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/image_single_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/image_gallery_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/image_gallery_advanced_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/image_gallery_broken_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/image_carousel_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/image_carousel_advanced_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/image_slider_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/video_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/social_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/social_links_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/gmap_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/team_params.php';


				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/blog_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/blog_carousel_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/blog_leader_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/portfolio_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/portfolio_carousel_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/portfolio_broken_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/testimonial_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/testimonial_carousel_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/list_title_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/content_slider_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/flexible_carousel_params.php';

				if ( class_exists( 'woocommerce' ) ) {
					require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/products_params.php';
					require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/products_carousel_params.php';
				}
				if ( class_exists( 'Tribe__Events__Main' ) ) {
					require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/events_params.php';
				}
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/countdown_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/counter_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/pie_chart_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/typed_text_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/animated_text_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/promo_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/language_selector_params.php';
				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/menu_params.php';

				require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/area_item_params.php';

				if ( class_exists( 'WPCF7_ContactForm' ) ) {
					require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/custom_contact_form_params.php';
				}
				if ( function_exists( 'wpFluent' ) ) {
					require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'shortcodes/fluent_form_params.php';
				}
				if ( function_exists( 'impeka_grve_visibility' ) ) {
					$content_manager = impeka_grve_visibility( 'vc_content_manager_visibility' );
					if ( $content_manager ) {
						require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'impeka-templates/impeka-templates.php';
					}
				}

			}

		}

		public function impeka_wpbakery_extension_plugin() {
			$this->__construct();
		}

		public function impeka_wpb_ext_add_scripts( $hook ) {
			wp_enqueue_style('impeka-wpb-ext-elements', IMPEKA_WPB_EXT_PLUGIN_DIR_URL .'assets/css/admin/impeka-wpb-ext-elements.css', array(), time(), 'all');
			wp_enqueue_style('impeka-wpb-ext-custom-fields', IMPEKA_WPB_EXT_PLUGIN_DIR_URL .'assets/css/admin/impeka-wpb-ext-custom-fields.css', array(), time(), 'all');

			wp_enqueue_style('impeka-wpb-ext-simple-line-icons', IMPEKA_WPB_EXT_PLUGIN_DIR_URL .'assets/css/simple-line-icons.css', array(), '2.2.3', 'all');
			wp_enqueue_style('impeka-wpb-ext-elegant-line-icons', IMPEKA_WPB_EXT_PLUGIN_DIR_URL .'assets/css/et-line-icons.css', array(), '1.0.0', 'all');
			if ( isset( $_GET['page'] ) && ( 'impeka-wpb' == $_GET['page'] ) ) {
				wp_enqueue_style( 'impeka-grve-admin-panel' );
			}
		}

		public function impeka_wpb_ext_add_front_end_scripts() {

			$min = '';
			if ( function_exists( 'impeka_grve_visibility' ) && impeka_grve_visibility( 'minify_assets', '1' ) ) {
				$min = '.min';
			}

			wp_register_style( 'impeka-wpb-ext-simple-line-icons', IMPEKA_WPB_EXT_PLUGIN_DIR_URL .'assets/css/simple-line-icons' . $min . '.css', array(), '2.2.3', 'all' );
			wp_register_style( 'impeka-wpb-ext-elegant-line-icons', IMPEKA_WPB_EXT_PLUGIN_DIR_URL .'assets/css/et-line-icons' . $min . '.css', array(), '1.0.0', 'all' );

			wp_enqueue_style( 'impeka-wpb-grid',  IMPEKA_WPB_EXT_PLUGIN_DIR_URL .'assets/css/wpb-grid' . $min . '.css', array(), IMPEKA_WPB_EXT_VERSION, 'all');
			wp_enqueue_style( 'impeka-ext-style',  IMPEKA_WPB_EXT_PLUGIN_DIR_URL .'assets/css/ext-style' . $min . '.css', array(), IMPEKA_WPB_EXT_VERSION, 'all');

			if ( function_exists( 'impeka_grve_option' ) && '1' == impeka_grve_option( 'combine_js', '1' ) ) {
				wp_enqueue_script( 'impeka-ext-extras-script',  IMPEKA_WPB_EXT_PLUGIN_DIR_URL .'assets/js/ext-extras.min.js', array( 'jquery' ), IMPEKA_WPB_EXT_VERSION, true );
			} else {
				wp_enqueue_script( 'countup', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/countUp.min.js', array( 'jquery' ), '1.9.3', true );
				wp_enqueue_script( 'jquery-easypiechart', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/jquery.easypiechart.min.js', array( 'jquery' ), '2.1.6', true );
				wp_enqueue_script( 'typed', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/typed.min.js', array( 'jquery' ), '1.0', true );
				wp_enqueue_script( 'jquery-countdown', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/jquery.countdown.min.js', array( 'jquery' ), '2.2.0', true );
				wp_enqueue_script( 'bg-scroller', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/bg-scroller.min.js', array( 'jquery' ), '1.0.0', true );
				wp_enqueue_script( 'bg-opacity', IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/bg-opacity.min.js', array( 'jquery' ), '1.0.0', true );
			}
			wp_enqueue_script( 'impeka-ext-elements-script',  IMPEKA_WPB_EXT_PLUGIN_DIR_URL .'assets/js/ext-elements' . $min . '.js', array( 'jquery' ), IMPEKA_WPB_EXT_VERSION, true );
		}

		public function marshal( $method_name ) {
			return array( &$this , $method_name );
		}
	}

	/**
	 * Initialize the Page Builder Extension Plugin
	 */
	add_action( 'init' , array( 'Impeka_WPBakery_Extension_Plugin' , 'init' ), 12 );


	function impeka_wpb_ext_body_class( $classes ){
		$impeka_wpb_ext_ver = 'grve-wpb-ext-ver-' . IMPEKA_WPB_EXT_VERSION;
		return array_merge( $classes, array( $impeka_wpb_ext_ver ) );
	}
	add_filter( 'body_class', 'impeka_wpb_ext_body_class' );

	/**
	 * Page Builder Extentions
	 */
	function impeka_wpb_ext_add_vc_extentions() {
		if ( function_exists( 'impeka_grve_info') && class_exists( 'WPBakeryShortCode' ) ) {
			require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'includes/impeka-wpb-vc-helper.php';
			require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'includes/impeka-wpb-vc-remove.php';
			require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'includes/impeka-wpb-vc-add.php';
		}
	}
	add_action( 'init', 'impeka_wpb_ext_add_vc_extentions', 5 );

	require_once IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'includes/impeka-wpb-ext-functions.php';

}

//Omit closing PHP tag to avoid accidental whitespace output errors.