<?php

/*
 *	Helper functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		http://greatives.eu
 */

 /**
 * Generic Parameters to reuse
 * Used in vc shortcodes
 */


if( !function_exists( 'impeka_wpb_ext_add_animation' ) ) {
	function impeka_wpb_ext_add_animation() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "CSS Animation", "impeka-wpb-extension"),
			"param_name" => "animation",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => '',
				esc_html__( "Fade In", "impeka-wpb-extension" ) => "fade-in",
				esc_html__( "Fade In Up", "impeka-wpb-extension" ) => "fade-in-up",
				esc_html__( "Fade In Up Big", "impeka-wpb-extension" ) => "fade-in-up-big",
				esc_html__( "Fade In Down", "impeka-wpb-extension" ) => "fade-in-down",
				esc_html__( "Fade In Down Big", "impeka-wpb-extension" ) => "fade-in-down-big",
				esc_html__( "Fade In Left", "impeka-wpb-extension" ) => "fade-in-left",
				esc_html__( "Fade In Left Big", "impeka-wpb-extension" ) => "fade-in-left-big",
				esc_html__( "Fade In Right", "impeka-wpb-extension" ) => "fade-in-right",
				esc_html__( "Fade In Right Big", "impeka-wpb-extension" ) => "fade-in-right-big",
				esc_html__( "Zoom In", "impeka-wpb-extension" ) => "zoom-in",
			),
			"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_animation_clipping' ) ) {
	function impeka_wpb_ext_add_animation_clipping() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__("CSS Animation", "impeka-wpb-extension" ),
			"param_name" => "animation",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => '',
				esc_html__( "Fade In", "impeka-wpb-extension" ) => "fade-in",
				esc_html__( "Fade In Up", "impeka-wpb-extension" ) => "fade-in-up",
				esc_html__( "Fade In Up Big", "impeka-wpb-extension" ) => "fade-in-up-big",
				esc_html__( "Fade In Down", "impeka-wpb-extension" ) => "fade-in-down",
				esc_html__( "Fade In Down Big", "impeka-wpb-extension" ) => "fade-in-down-big",
				esc_html__( "Fade In Left", "impeka-wpb-extension" ) => "fade-in-left",
				esc_html__( "Fade In Left Big", "impeka-wpb-extension" ) => "fade-in-left-big",
				esc_html__( "Fade In Right", "impeka-wpb-extension" ) => "fade-in-right",
				esc_html__( "Fade In Right Big", "impeka-wpb-extension" ) => "fade-in-right-big",
				esc_html__( "Zoom In", "impeka-wpb-extension" ) => "zoom-in",
				esc_html__( "Clipping Animation", "impeka-wpb-extension" ) => "clipping-animation",
				esc_html__( "Appear Animation", "impeka-wpb-extension" ) => "appear-animation",
			),
			"description" => esc_html__("Select type of animation if you want this column to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_clipping' ) ) {
	function impeka_wpb_ext_add_clipping() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__("CSS Clipping Animation", "impeka-wpb-extension" ),
			"param_name" => "clipping_animation",
			"value" => array(
				esc_html__( "Clipping Up", "impeka-wpb-extension" ) => "clipping-up",
				esc_html__( "Clipping Down", "impeka-wpb-extension" ) => "clipping-down",
				esc_html__( "Clipping Left", "impeka-wpb-extension" ) => "clipping-left",
				esc_html__( "Clipping Right", "impeka-wpb-extension" ) => "clipping-right",
				esc_html__( "Colored Clipping Up", "impeka-wpb-extension" ) => "colored-clipping-up",
				esc_html__( "Colored Clipping Down", "impeka-wpb-extension" ) => "colored-clipping-down",
				esc_html__( "Colored Clipping Left", "impeka-wpb-extension" ) => "colored-clipping-left",
				esc_html__( "Colored Clipping Right", "impeka-wpb-extension" ) => "colored-clipping-right",
			),
			'dependency' => array(
				'element' => 'animation',
				'value' => 'clipping-animation',
			),
			"description" => esc_html__("Select type of animation if you want this column to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_appear' ) ) {
	function impeka_wpb_ext_add_appear() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__("CSS Appear Animation", "impeka-wpb-extension" ),
			"param_name" => "appear_animation",
			"value" => array(
				esc_html__( "Appear Up", "impeka-wpb-extension" ) => "appear-up",
				esc_html__( "Appear Down", "impeka-wpb-extension" ) => "appear-down",
				esc_html__( "Appear Left", "impeka-wpb-extension" ) => "appear-left",
				esc_html__( "Appear Right", "impeka-wpb-extension" ) => "appear-right",
			),
			'dependency' => array(
				'element' => 'animation',
				'value' => 'appear-animation',
			),
			"description" => esc_html__("Select type of animation if you want this column to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_clipping_colors' ) ) {
	function impeka_wpb_ext_add_clipping_colors() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Clipping Color", "impeka-wpb-extension" ),
			"param_name" => "clipping_animation_colors",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"std" => 'black',
			"description" => esc_html__( "Select clipping color", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'clipping_animation',
				'value' => array( 'colored-clipping-up', 'colored-clipping-down', 'colored-clipping-left', 'colored-clipping-right' )
			),
			"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_animation_delay' ) ) {
	function impeka_wpb_ext_add_animation_delay() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__('Css Animation Delay', 'impeka-wpb-extension'),
			"param_name" => "animation_delay",
			"value" => '0',
			"description" => esc_html__( "Add delay in milliseconds.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'animation',
				'value_not_equal_to' => array( '' )
			),
			"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_animation_duration' ) ) {
	function impeka_wpb_ext_add_animation_duration() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "CSS Animation Duration", "impeka-wpb-extension"),
			"param_name" => "animation_duration",
			"value" => array(
				esc_html__( "Very Fast", "impeka-wpb-extension" ) => "very-fast",
				esc_html__( "Fast", "impeka-wpb-extension" ) => "fast",
				esc_html__( "Normal", "impeka-wpb-extension" ) => "normal",
				esc_html__( "Slow", "impeka-wpb-extension" ) => "slow",
				esc_html__( "Very Slow", "impeka-wpb-extension" ) => "very-slow",
			),
			"std" => 'normal',
			"description" => esc_html__("Select the duration for your animated element.", 'impeka-wpb-extension' ),
			"dependency" => array(
				'element' => 'animation',
				'value_not_equal_to' => array( '' )
			),
			"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_margin_bottom' ) ) {
	function impeka_wpb_ext_add_margin_bottom() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__('Bottom margin', 'impeka-wpb-extension'),
			"param_name" => "margin_bottom",
			"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_el_class' ) ) {
	function impeka_wpb_ext_add_el_class() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__( "Extra class name", "impeka-wpb-extension" ),
			"param_name" => "el_class",
			"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_align' ) ) {
	function impeka_wpb_ext_add_align( $std = "left" ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Alignment", "impeka-wpb-extension" ),
			"param_name" => "align",
			"value" => array(
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
			),
			"description" => '',
			"std" => $std,
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_inherit_align' ) ) {
	function impeka_wpb_ext_add_inherit_align( $std = "inherit" ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Alignment", "impeka-wpb-extension" ),
			"param_name" => "align",
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
			),
			"description" => 'Inherits its value from its column text align definition.',
			"std" => $std,
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_radius' ) ) {
	function impeka_wpb_ext_add_radius( $std = "5" ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Radius", "impeka-wpb-extension" ),
			"param_name" => "radius",
			"value" => array(
				esc_html__( "none", "impeka-wpb-extension" ) => '',
				esc_html__( "5px", "impeka-wpb-extension" ) => '5',
				esc_html__( "10px", "impeka-wpb-extension" ) => '10',
				esc_html__( "15px", "impeka-wpb-extension" ) => '15',
				esc_html__( "20px", "impeka-wpb-extension" ) => '20',
				esc_html__( "25px", "impeka-wpb-extension" ) => '25',
				esc_html__( "30px", "impeka-wpb-extension" ) => '30',
				esc_html__( "35px", "impeka-wpb-extension" ) => '35',
				esc_html__( "40px", "impeka-wpb-extension" ) => '40',
				esc_html__( "45px", "impeka-wpb-extension" ) => '45',
				esc_html__( "50px", "impeka-wpb-extension" ) => '50',
			),
			"description" => '',
			"std" => $std,
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_shadow' ) ) {
	function impeka_wpb_ext_add_shadow() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension"),
			"param_name" => "shadow",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => '',
				esc_html__( "Small", "impeka-wpb-extension" ) => 'small-shadow',
				esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium-shadow',
				esc_html__( "Large", "impeka-wpb-extension" ) => 'large-shadow',
			),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_order_by' ) ) {
	function impeka_wpb_ext_add_order_by() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Order By", "impeka-wpb-extension" ),
			"param_name" => "order_by",
			"value" => array(
				esc_html__( "Date", "impeka-wpb-extension" ) => 'date',
				esc_html__( "Last modified date", "impeka-wpb-extension" ) => 'modified',
				esc_html__( "Number of comments", "impeka-wpb-extension" ) => 'comment_count',
				esc_html__( "Title", "impeka-wpb-extension" ) => 'title',
				esc_html__( "Author", "impeka-wpb-extension" ) => 'author',
				esc_html__( "Random", "impeka-wpb-extension" ) => 'rand',
				esc_html__( "Post Order", "impeka-wpb-extension" ) => 'menu_order',
				esc_html__( "Post In", "impeka-wpb-extension" ) => 'post__in',
			),
			"description" => '',
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_order' ) ) {
	function impeka_wpb_ext_add_order() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Order", "impeka-wpb-extension" ),
			"param_name" => "order",
			"value" => array(
				esc_html__( "Descending", "impeka-wpb-extension" ) => 'DESC',
				esc_html__( "Ascending", "impeka-wpb-extension" ) => 'ASC'
			),
			"dependency" => array( 'element' => "order_by", 'value' => array( 'date', 'modified', 'comment_count', 'name', 'author', 'title', 'menu_order' ) ),
			"description" => '',
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_slideshow_speed' ) ) {
	function impeka_wpb_ext_add_slideshow_speed() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__( "Slideshow Speed", "impeka-wpb-extension" ),
			"param_name" => "slideshow_speed",
			"value" => '3000',
			"description" => esc_html__( "Slideshow Speed in ms.", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_pagination_speed' ) ) {
	function impeka_wpb_ext_add_pagination_speed() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__( "Pagination Speed", "impeka-wpb-extension" ),
			"param_name" => "pagination_speed",
			"value" => '400',
			"description" => esc_html__( "Pagination Speed in ms.", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_navigation' ) ) {
	function impeka_wpb_ext_add_navigation( $std = '' ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Navigation Visibility", "impeka-wpb-extension" ),
			"param_name" => "nav_visibility",
			'value' => array(
				esc_html__( 'No' , 'impeka-wpb-extension' ) => '',
				esc_html__( 'Yes' , 'impeka-wpb-extension' ) => 'yes',
			),
			"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
			"std" => $std,
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_navigation_icon' ) ) {
	function impeka_wpb_ext_add_navigation_icon( $std = '' ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Navigation Icon", "impeka-wpb-extension" ),
			"param_name" => "nav_icon",
			'value' => array(
				esc_html__( 'Icon 1' , 'impeka-wpb-extension' ) => 'arrow-1',
				esc_html__( 'Icon 2' , 'impeka-wpb-extension' ) => 'arrow-2',
				esc_html__( 'Icon 3' , 'impeka-wpb-extension' ) => 'arrow-3',
			),
			"description" => esc_html__( "Select your Navigation icon.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => 'nav_visibility', 'value_not_equal_to' => array( '' ) ),
			"std" => $std,
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_navigation_icon_color' ) ) {
	function impeka_wpb_ext_add_navigation_icon_color( $std = 'black' ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Icon Color", "impeka-wpb-extension" ),
			"param_name" => "nav_icon_color",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"description" => esc_html__( "Select your Navigation icon color.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => 'nav_visibility', 'value_not_equal_to' => array( '' ) ),
			"std" => $std,
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_navigation_shape' ) ) {
	function impeka_wpb_ext_add_navigation_shape() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Navigation shape", "impeka-wpb-extension" ),
			"param_name" => "nav_shape",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => '',
				esc_html__( "Square", "impeka-wpb-extension" ) => 'square',
				esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
				esc_html__( "Circle", "impeka-wpb-extension" ) => 'circle',
			),
			"description" => esc_html__( "Select your Navigation shape.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => 'nav_visibility', 'value_not_equal_to' => array( '' ) ),
			"std" => "circle",
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_navigation_shape_type' ) ) {
	function impeka_wpb_ext_add_navigation_shape_type() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Shape type", "impeka-wpb-extension" ),
			"param_name" => "nav_shape_type",
			"value" => array(
				esc_html__( "Simple", "impeka-wpb-extension" ) => 'simple',
				esc_html__( "Outline", "impeka-wpb-extension" ) => 'outline',
			),
			"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
			"description" => esc_html__( "Select your Navigation shape type.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => 'nav_shape', 'value_not_equal_to' => array( '' ) ),
			"std" => "simple",
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_navigation_shape_color' ) ) {
	function impeka_wpb_ext_add_navigation_shape_color() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Shape Color", "impeka-wpb-extension" ),
			"param_name" => "nav_shape_color",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"description" => esc_html__( "Select your Navigation shape color.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => 'nav_shape', 'value_not_equal_to' => array( '' ) ),
			"std" => "white",
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_auto_height' ) ) {
	function impeka_wpb_ext_add_auto_height() {
		return array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Auto Height", "impeka-wpb-extension" ),
			"param_name" => "auto_height",
			"value" => array( esc_html__( "Select if you want smooth auto height", "impeka-wpb-extension" ) => 'yes' ),
		);
	}
}

//Filters
if( !function_exists( 'impeka_wpb_ext_add_filter' ) ) {
	function impeka_wpb_ext_add_filter( $std = '' ) {
		return array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Filter", "impeka-wpb-extension" ),
			"param_name" => "filter",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => '',
				esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
			),
			"std" => $std,
			"description" => esc_html__( "If selected, an isotope filter will be displayed.", "impeka-wpb-extension" ) . " " . esc_html__( "Enable Filter ( Only for All or Multiple Categories )", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "mode", 'value' => array( 'grid', 'masonry' ) ),
			"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_filter_all_text' ) ) {
	function impeka_wpb_ext_add_filter_all_text() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__( "Filter All Text", "impeka-wpb-extension" ),
			"param_name" => "filter_all_text",
			"value" => esc_html__( "All", "impeka-wpb-extension" ),
			"description" => esc_html__( "Type the text to show all filters ( Default is: All ).","impeka-wpb-extension" ),
			"dependency" => array( 'element' => "filter", 'value' => array( 'yes' ) ),
			"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_filter_order_by' ) ) {
	function impeka_wpb_ext_add_filter_order_by( $std = '' ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Filter Order By", "impeka-wpb-extension" ),
			"param_name" => "filter_order_by",
			"value" => array(
				esc_html__( "Default ( Unordered )", "impeka-wpb-extension" ) => '',
				esc_html__( "ID", "impeka-wpb-extension" ) => 'id',
				esc_html__( "Slug", "impeka-wpb-extension" ) => 'slug',
				esc_html__( "Title", "impeka-wpb-extension" ) => 'title',
			),
			"std" => $std,
			"description" => '',
			"dependency" => array( 'element' => "filter", 'value' => array( 'yes' ) ),
			"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_filter_order' ) ) {
	function impeka_wpb_ext_add_filter_order( $std = 'ASC' ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Filter Order", "impeka-wpb-extension" ),
			"param_name" => "filter_order",
			"value" => array(
				esc_html__( "Ascending", "impeka-wpb-extension" ) => 'ASC',
				esc_html__( "Descending", "impeka-wpb-extension" ) => 'DESC',
			),
			"std" => $std,
			"dependency" => array( 'element' => "filter", 'value' => array( 'yes' ) ),
			"description" => '',
			"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_filter_style' ) ) {
	function impeka_wpb_ext_add_filter_style( $std = 'simple' ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Filter Style", "impeka-wpb-extension" ),
			"param_name" => "filter_style",
			"value" => array(
				esc_html__( "Simple", "impeka-wpb-extension" ) => 'simple',
				esc_html__( "Button", "impeka-wpb-extension" ) => 'button',
				esc_html__( "Classic", "impeka-wpb-extension" ) => 'classic',
				esc_html__( "Splitted", "impeka-wpb-extension" ) => 'splitted',
				esc_html__( "Count", "impeka-wpb-extension" ) => 'count',
			),
			"std" => $std,
			"dependency" => array( 'element' => "filter", 'value' => array( 'yes' ) ),
			"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_filter_shape' ) ) {
	function impeka_wpb_ext_add_filter_shape( $std = 'square' ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Filter Shape", "impeka-wpb-extension" ),
			"param_name" => "filter_shape",
			"value" => array(
				esc_html__( "Square", "impeka-wpb-extension" ) => 'square',
				esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
				esc_html__( "Extra Round", "impeka-wpb-extension" ) => 'extra-round',
			),
			"std" => $std,
			"dependency" => array( 'element' => "filter_style", 'value' => array( 'button' ) ),
			"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_filter_color' ) ) {
	function impeka_wpb_ext_add_filter_color( $std = 'primary-1' ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Filter Color", "impeka-wpb-extension" ),
			"param_name" => "filter_color",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"std" => $std,
			"dependency" => array( 'element' => "filter_style", 'value' => array( 'button' ) ),
			"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_filter_align' ) ) {
	function impeka_wpb_ext_add_filter_align( $std = 'left' ) {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Filter Alignment", "impeka-wpb-extension" ),
			"param_name" => "filter_align",
			"value" => array(
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
			),
			"std" => $std,
			"description" => '',
			"dependency" => array( 'element' => "filter_style", 'value_not_equal_to' => array( 'splitted' ) ),
			"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_add_filter_gototop' ) ) {
	function impeka_wpb_ext_add_filter_gototop( $std = 'yes' ) {
		return array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Filter Go To Top", "impeka-wpb-extension" ),
			"param_name" => "filter_gototop",
			"value" => array(
				esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
				esc_html__( "No", "impeka-wpb-extension" ) => 'no',
			),
			"std" => $std,
			"description" => esc_html__( "Animate to the top of the filter after clicking ( Excludes Infinite Scroll and Load more ).", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "filter", 'value' => array( 'yes' ) ),
			"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
		);
	}
}

//Title Headings/Tags
if( !function_exists( 'impeka_wpb_ext_get_heading_tag' ) ) {
	function impeka_wpb_ext_get_heading_tag( $std = '' ) {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
			"param_name" => "heading_tag",
			"value" => array(
				esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
				esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
				esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
				esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
				esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
				esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
				esc_html__( "div", "impeka-wpb-extension" ) => 'div',
			),
			"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			"std" => $std,
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_get_heading' ) ) {
	function impeka_wpb_ext_get_heading( $std = '' ) {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Title Size/Typography", "impeka-wpb-extension" ),
			"param_name" => "heading",
			"value" => array(
				esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
				esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
				esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
				esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
				esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
				esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
				esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
				esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
				esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
				esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
				esc_html__( "Page Title", "impeka-wpb-extension" ) => 'page-title',
				esc_html__( "Feature Title", "impeka-wpb-extension" ) => 'feature-title',
			),
			"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			"std" => $std,
		);
	}
}

// Heading Increase
if( !function_exists( 'impeka_wpb_ext_get_heading_increase' ) ) {
	function impeka_wpb_ext_get_heading_increase() {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Increase Heading Size", "impeka-wpb-extension" ),
			"param_name" => "increase_heading",
			"value" => array(
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
				esc_html__( "120%", "impeka-wpb-extension" ) => '120',
				esc_html__( "140%", "impeka-wpb-extension" ) => '140',
				esc_html__( "160%", "impeka-wpb-extension" ) => '160',
				esc_html__( "180%", "impeka-wpb-extension" ) => '180',
				esc_html__( "200%", "impeka-wpb-extension" ) => '200',
				esc_html__( "250%", "impeka-wpb-extension" ) => '250',
				esc_html__( "300%", "impeka-wpb-extension" ) => '300',
			),
			"description" => esc_html__( "Set the percentage you want to increase your Headings size.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_get_heading_increase_reset' ) ) {
	function impeka_wpb_ext_get_heading_increase_reset() {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Reset Heading Size", "impeka-wpb-extension" ),
			"param_name" => "increase_heading_reset",
			"value" => array(
				esc_html__( "Never", "impeka-wpb-extension" ) => '',
				esc_html__( "on Small Desktop and below", "impeka-wpb-extension" ) => 'desktop-sm',
				esc_html__( "on Tablet Landscape and below", "impeka-wpb-extension" ) => 'tablet',
				esc_html__( "on Tablet Portrait and below", "impeka-wpb-extension" ) => 'tablet-sm',
				esc_html__( "on Mobile Ladscape and below", "impeka-wpb-extension" ) => 'mobile',
			),
			"description" => esc_html__( "Select if you want to reset the header size in some devices in case size is too large.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "increase_heading", 'value_not_equal_to' => array( '100' ) ),
			'edit_field_class' => 'vc_col-sm-6',
		);
	}
}


if( !function_exists( 'impeka_wpb_ext_get_heading_blog' ) ) {
	function impeka_wpb_ext_get_heading_blog( $std = '' ) {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Title Size", "impeka-wpb-extension" ),
			"param_name" => "heading",
			"value" => array(
				esc_html__( "Auto", "impeka-wpb-extension" ) => 'auto',
				esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
				esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
				esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
				esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
				esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
				esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
				esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
				esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
				esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
				esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
				esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
			),
			"description" => esc_html__( "Title size and typography", "impeka-wpb-extension" ),
			"std" => $std,
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_get_custom_font_family' ) ) {
	function impeka_wpb_ext_get_custom_font_family( $std = '' ) {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Custom Font Family", "impeka-wpb-extension" ),
			"param_name" => "custom_font_family",
			"value" => array(
				esc_html__( "Same as Typography", "impeka-wpb-extension" ) => '',
				esc_html__( "Custom Font Family 1", "impeka-wpb-extension" ) => 'custom-font-1',
				esc_html__( "Custom Font Family 2", "impeka-wpb-extension" ) => 'custom-font-2',
				esc_html__( "Custom Font Family 3", "impeka-wpb-extension" ) => 'custom-font-3',
				esc_html__( "Custom Font Family 4", "impeka-wpb-extension" ) => 'custom-font-4',

			),
			"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "impeka-wpb-extension" ),
			"std" => $std,
		);
	}
}

//Split Title
if( !function_exists( 'impeka_wpb_ext_get_split_title' ) ) {
	function impeka_wpb_ext_get_split_title() {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Split Title", "impeka-wpb-extension" ),
			"param_name" => "split_title",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => '',
				esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
			),
			"description" => esc_html__( "Split Title", "impeka-wpb-extension" ),
		);
	}
}

if( !function_exists( 'impeka_wpb_ext_get_split_title_space' ) ) {
	function impeka_wpb_ext_get_split_title_space() {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Split Title Space", "impeka-wpb-extension" ),
			"param_name" => "split_title_space",
			"value" => array(
				esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
				esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
				esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
			),
			"description" => esc_html__( "Split Title Space", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "split_title", 'value' => array( 'yes' ) ),
		);
	}
}

function impeka_wpb_ext_get_social_links_params() {
	global $impeka_grve_social_list_extended;

	$social_params = array();
	if ( isset( $impeka_grve_social_list_extended ) ) {

		foreach ( $impeka_grve_social_list_extended as $social_item ) {

			$social_params[] = array(
				"type" => "textfield",
				"heading" => esc_html( $social_item['title'] ),
				"param_name" => $social_item['url'],
				"value" => "",
				"group" => esc_html__( "Social Links", "impeka-wpb-extension" ),
			);
		}
	}

	return $social_params;
}

//Button Parameters

function impeka_wpb_ext_get_button_params( $group = 'button', $index = '' ) {

	$init_title = '';
	$admin_label = false;
	switch( $group ) {
		case 'first':
			$group_string = esc_html__( "First Button", "impeka-wpb-extension" );
		break;
		case 'second':
			$group_string = esc_html__( "Second Button", "impeka-wpb-extension" );
		break;
		case 'third':
			$group_string = esc_html__( "Third Button", "impeka-wpb-extension" );
		break;
		case 'split-content':
		case 'media-box':
		case 'image-text':
			$group_string = esc_html__( "Read More Button", "impeka-wpb-extension" );
		break;
		case 'button':
		default:
			$group_string = esc_html__( "Button", "impeka-wpb-extension" );
			$init_title = 'Button';
			$admin_label = true;
		break;
	}

	$btn_params = array(
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Button Text", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_text",
			"save_always" => true,
			"admin_label" => $admin_label,
			"value" => $init_title,
			"description" => esc_html__( "Text of the button.", "impeka-wpb-extension" ),
			"group" => $group_string,
		),
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Screen Reader Text", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_sr_text",
			"value" => "",
			"description" => esc_html__( "Additional informative text for screen readers.", "impeka-wpb-extension" ),
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Type", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_type",
			"value" => array(
				esc_html__( "Simple", "impeka-wpb-extension" ) => 'simple',
				esc_html__( "Outline", "impeka-wpb-extension" ) => 'outline',
				esc_html__( "Line", "impeka-wpb-extension" ) => 'line',
				esc_html__( "Only Text", "impeka-wpb-extension" ) => 'only-text',
				esc_html__( "Video", "impeka-wpb-extension" ) => 'video',
			),
			"description" => esc_html__( "Select button type.", "impeka-wpb-extension" ),
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Line Position", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_line_position",
			"value" => array(
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
				esc_html__( "Bottom", "impeka-wpb-extension" ) => 'bottom',
				esc_html__( "Bottom Advanced", "impeka-wpb-extension" ) => 'bottom-advanced',
			),
			"description" => esc_html__( "Select button line position.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'line' ) ),
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Color", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_color",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"description" => esc_html__( "Color of the button.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'outline', 'line', 'only-text', 'video' ) ),
			"group" => $group_string,
			"std" => 'primary-1',
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Color", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_color_gradient",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
			"std" => 'primary-1',
			"description" => esc_html__( "Color of the button.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'simple' ) ),
			"group" => $group_string,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Line Color", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_line_color",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"description" => esc_html__( "Color of the button line.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'line' ) ),
			"group" => $group_string,
			"std" => 'primary-1',
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Hover Color", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_hover_color",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"description" => esc_html__( "Color of the button.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'only-text' ) ),
			"group" => $group_string,
			"std" => 'black',
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Hover Color", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_hover_color_gradient",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
			"std" => 'black',
			"description" => esc_html__( "Color of the button.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'simple', 'outline' ) ),
			"group" => $group_string,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Hover Action", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_hover_action",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => '',
				esc_html__( "Pulse", "impeka-wpb-extension" ) => 'pulse',
			),
			"description" => '',
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'simple', 'outline' ) ),
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Size", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_size",
			"value" => array(
				esc_html__( "Extra Small", "impeka-wpb-extension" ) => 'extrasmall',
				esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
				esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
				esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
				esc_html__( "Extra Large", "impeka-wpb-extension" ) => 'extralarge',
			),
			"description" => '',
			"std" => 'medium',
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Shape", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_shape",
			"value" => array(
				esc_html__( "Square", "impeka-wpb-extension" ) => 'square',
				esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
				esc_html__( "Extra Round", "impeka-wpb-extension" ) => 'extra-round',
			),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'simple', 'outline' ) ),
			"description" => '',
			"std" => 'square',
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Shadow", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_shadow",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => '',
				esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
				esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
				esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
			),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'simple' ) ),
			"description" => '',
			"std" => '',
			"group" => $group_string,
		),
		array(
			"type" => "vc_link",
			"heading" => esc_html__( "Button Link", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_link",
			"value" => "",
			"description" => esc_html__( "Enter link.", "impeka-wpb-extension" ),
			"group" => $group_string,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Button Icon Type', 'impeka-wpb-extension' ),
			'value' => array(
				esc_html__( 'None', 'impeka-wpb-extension' ) => 'none',
				esc_html__( 'Theme SVG Icon', 'impeka-wpb-extension' ) => 'icon-svg',
				esc_html__( 'Icon library', 'impeka-wpb-extension' ) => 'icon-library',
			),
			'param_name' => 'btn' . $index . '_icon_type',
			"std" => 'none',
			'description' => esc_html__( 'Select icon type.', 'impeka-wpb-extension' ),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value_not_equal_to' => array( 'line', 'video' ) ),
			"group" => $group_string,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'SVG Icon', 'impeka-wpb-extension' ),
			'value' => array(
				esc_html__( 'Arrow 1', 'impeka-wpb-extension' ) => 'arrow-1',
				esc_html__( 'Arrow 2', 'impeka-wpb-extension' ) => 'arrow-2',
			),
			'param_name' => 'btn' . $index . '_svg_icon',
			'description' => esc_html__( 'Select an svg icon.', 'impeka-wpb-extension' ),
			"dependency" => array( 'element' => "btn" . $index . "_icon_type", 'value' => array( 'icon-svg' ) ),
			"group" => $group_string,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon library', 'impeka-wpb-extension' ),
			'value' => array(
				esc_html__( 'Font Awesome', 'impeka-wpb-extension' ) => 'fontawesome',
				esc_html__( 'Open Iconic', 'impeka-wpb-extension' ) => 'openiconic',
				esc_html__( 'Typicons', 'impeka-wpb-extension' ) => 'typicons',
				esc_html__( 'Entypo', 'impeka-wpb-extension' ) => 'entypo',
				esc_html__( 'Linecons', 'impeka-wpb-extension' ) => 'linecons',
				esc_html__( 'Simple Line Icons', 'impeka-wpb-extension' ) => 'simplelineicons',
				esc_html__( 'Elegant Line Icons', 'impeka-wpb-extension' ) => 'etlineicons',
			),
			'param_name' => 'btn' . $index . '_icon_library',
			'description' => esc_html__( 'Select icon library.', 'impeka-wpb-extension' ),
			"dependency" => array( 'element' => "btn" . $index . "_icon_type", 'value' => array( 'icon-library' ) ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
			'param_name' => 'btn' . $index . '_icon_fontawesome',
			'value' => 'fas fa-adjust',
			'settings' => array(
				'emptyIcon' => false,
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'fontawesome',
			),
			'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
			'param_name' => 'btn' . $index . '_icon_openiconic',
			'value' => 'vc-oi vc-oi-dial',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'openiconic',
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'openiconic',
			),
			'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
			'param_name' => 'btn' . $index . '_icon_typicons',
			'value' => 'typcn typcn-adjust-brightness',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'typicons',
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'typicons',
			),
			'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
			'param_name' => 'btn' . $index . '_icon_entypo',
			'value' => 'entypo-icon entypo-icon-note',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'entypo',
				'iconsPerPage' => 300,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'entypo',
			),
			'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
			'param_name' => 'btn' . $index . '_icon_linecons',
			'value' => 'vc_li vc_li-heart',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'linecons',
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'linecons',
			),
			'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
			'param_name' => 'btn' . $index . '_icon_simplelineicons',
			'value' => 'smp-icon-user',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'simplelineicons',
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'simplelineicons',
			),
			'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
			'param_name' => 'btn' . $index . '_icon_etlineicons',
			'value' => 'et-icon-mobile',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'etlineicons',
				'iconsPerPage' => 100,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'etlineicons',
			),
			'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Icon Shape", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_video_icon_shape",
			"value" => array(
				esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
				esc_html__( "Circle", "impeka-wpb-extension" ) => 'circle',
			),
			"description" => esc_html__( "Shape of the button icon.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'video' ) ),
			"group" => $group_string,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Icon Shape Type", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_video_icon_shape_type",
			"value" => array(
				esc_html__( "Simple", "impeka-wpb-extension" ) => 'simple',
				esc_html__( "Outline", "impeka-wpb-extension" ) => 'outline',
			),
			"description" => esc_html__( "Select video icon shape type.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_type", 'value' => array( 'video' ) ),
			"group" => $group_string,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Icon Shape Color", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_video_icon_shape_color",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"description" => esc_html__( "Color of the video icon shape color.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_video_icon_shape_type", 'value' => array( 'simple', 'outline' ) ),
			"group" => $group_string,
			"std" => 'primary-1',
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Icon Shape Hover Color", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_video_icon_shape_hover_color",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"description" => esc_html__( "Hover color of the video icon shape .", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_video_icon_shape_type", 'value' => array( 'simple' ) ),
			"group" => $group_string,
			"std" => 'black',
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "SVG Icon Shape", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_svg_icon_shape",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => '',
				esc_html__( "Circle", "impeka-wpb-extension" ) => 'circle',
			),
			"description" => esc_html__( "Shape of the svg icon.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_svg_icon", 'value' => array( 'arrow-1' ) ),
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "SVG Icon Shape Type", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_svg_icon_shape_type",
			"value" => array(
				esc_html__( "Simple", "impeka-wpb-extension" ) => 'simple',
				esc_html__( "Outline", "impeka-wpb-extension" ) => 'outline',
			),
			"description" => esc_html__( "Select svg icon shape type.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_svg_icon_shape", 'value' => array( 'circle' ) ),
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "SVG Icon Color", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_svg_icon_color",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"description" => esc_html__( "Color of the svg icon.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_svg_icon_shape", 'value' => array( 'circle' ) ),
			"group" => $group_string,
			"std" => 'white',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "SVG Icon Shape Color", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_svg_icon_shape_color",
			"param_holder_class" => "grve-colored-dropdown",
			"value" => impeka_wpb_ext_get_color_array(),
			"description" => esc_html__( "Color of the svg icon shape.", "impeka-wpb-extension" ),
			"dependency" => array( 'element' => "btn" . $index . "_svg_icon_shape", 'value' => array( 'circle' ) ),
			"group" => $group_string,
			"std" => 'primary-1',
		),
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Button class name", "impeka-wpb-extension" ),
			"param_name" => "btn" . $index . "_class",
			"description" => esc_html__( "If you wish to style your button differently, then use this field to add a class name and then refer to it in your css file.", "impeka-wpb-extension" ),
			"group" => $group_string,
		),
	);
	return $btn_params;
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
