<?php

/*
 *	Helper functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		http://greatives.eu
 */

 /**
 * Helper function to get array value with fallback
 */
if ( !function_exists( 'impeka_wpb_ext_array_value' ) ) {
	function impeka_wpb_ext_array_value( $input_array, $id, $fallback = false, $param = false ) {

		if ( $fallback == false ) $fallback = '';
		$output = ( isset($input_array[$id]) && $input_array[$id] !== '' ) ? $input_array[$id] : $fallback;
		if ( !empty($input_array[$id]) && $param ) {
			$output = ( isset($input_array[$id][$param]) && $input_array[$id][$param] !== '' ) ? $input_array[$id][$param] : $fallback;
		}
		return $output;
	}
}

 /**
 * Helper function to get array of colors
 */
if( !function_exists( 'impeka_wpb_ext_get_color_array' ) ) {
	function impeka_wpb_ext_get_color_array( $options = ['primary', 'standard'] ) {

		$colors = array();

		if( in_array('none', $options ) ) {
			$colors[ esc_html__( 'None', 'impeka-wpb-extension' ) ] = 'none';
		}

		if( in_array('default', $options ) ) {
			$colors[ esc_html__( 'Default', 'impeka-wpb-extension' ) ] = 'default';
		}

		if( in_array('transparent', $options ) ) {
			$colors[ esc_html__( 'Transparent', 'impeka-wpb-extension' ) ] = 'transparent';
		}

		if( in_array('inherit', $options ) ) {
			$colors[ esc_html__( 'Inherit', 'impeka-wpb-extension' ) ] = 'inherit';
		}

		if( in_array('primary', $options ) ) {
			$colors[ esc_html__( 'Primary 1', 'impeka-wpb-extension' ) ] = 'primary-1';
			$colors[ esc_html__( 'Primary 2', 'impeka-wpb-extension' ) ] = 'primary-2';
			$colors[ esc_html__( 'Primary 3', 'impeka-wpb-extension' ) ] = 'primary-3';
			$colors[ esc_html__( 'Primary 4', 'impeka-wpb-extension' ) ] = 'primary-4';
			$colors[ esc_html__( 'Primary 5', 'impeka-wpb-extension' ) ] = 'primary-5';
			$colors[ esc_html__( 'Primary 6', 'impeka-wpb-extension' ) ] = 'primary-6';
		}
		if( in_array('gradient', $options ) ) {
			$colors[ esc_html__( 'Gradient 1', 'impeka-wpb-extension' ) ] = 'gradient-1';
			$colors[ esc_html__( 'Gradient 2', 'impeka-wpb-extension' ) ] = 'gradient-2';
			$colors[ esc_html__( 'Gradient 3', 'impeka-wpb-extension' ) ] = 'gradient-3';
		}

		if( in_array('single-gradient', $options ) ) {
			$colors[ esc_html__( 'Gradient', 'impeka-wpb-extension' ) ] = 'gradient';
		}

		if( in_array('black-white', $options ) ) {
			$colors[ esc_html__( 'Black', 'impeka-wpb-extension' ) ] = 'black';
			$colors[ esc_html__( 'White', 'impeka-wpb-extension' ) ] = 'white';
		}

		if( in_array('standard', $options ) ) {
			$colors[ esc_html__( 'Green', 'impeka-wpb-extension' ) ] = 'green';
			$colors[ esc_html__( 'Orange', 'impeka-wpb-extension' ) ] = 'orange';
			$colors[ esc_html__( 'Red', 'impeka-wpb-extension' ) ] = 'red';
			$colors[ esc_html__( 'Blue', 'impeka-wpb-extension' ) ] = 'blue';
			$colors[ esc_html__( 'Aqua', 'impeka-wpb-extension' ) ] = 'aqua';
			$colors[ esc_html__( 'Purple', 'impeka-wpb-extension' ) ] = 'purple';
			$colors[ esc_html__( 'Black', 'impeka-wpb-extension' ) ] = 'black';
			$colors[ esc_html__( 'Grey', 'impeka-wpb-extension' ) ] = 'grey';
			$colors[ esc_html__( 'Dark Grey', 'impeka-wpb-extension' ) ] = 'dark-grey';
			$colors[ esc_html__( 'Light Grey', 'impeka-wpb-extension' ) ] = 'light-grey';
			$colors[ esc_html__( 'White', 'impeka-wpb-extension' ) ] = 'white';
		}

		if( in_array('custom', $options ) ) {
			$colors[ esc_html__( 'Custom', 'impeka-wpb-extension' ) ] = 'custom';
		}

		if( in_array('dominant', $options ) ) {
			$colors[ esc_html__( 'Image Dominant', 'impeka-wpb-extension' ) ] = 'dominant';
		}

		return $colors;
	}
}

if ( !function_exists( 'impeka_wpb_ext_starts_with' ) ) {
	function impeka_wpb_ext_starts_with( $haystack, $needle ) {
		 $length = strlen($needle);
		 return (substr($haystack, 0, $length) === $needle);
	}
}

/**
 * Helper function to get custom fields with fallback
 */
if ( !function_exists( 'impeka_wpb_ext_post_meta' ) ) {
	function impeka_wpb_ext_post_meta( $id, $fallback = false ) {
		$post_id = get_the_ID();
		if ( $fallback == false ) $fallback = '';
		$post_meta = get_post_meta( $post_id, $id, true );
		$output = ( $post_meta !== '' ) ? $post_meta : $fallback;
		return $output;
	}
}

/**
 * Helper function to print filters
 */
function impeka_wpb_print_filters( $atts = array() ) {
	if ( function_exists( 'impeka_grve_print_filters' ) ) {
		impeka_grve_print_filters( $atts );
	}
}
function impeka_wpb_print_pagination( $params = array() ) {
	if ( function_exists( 'impeka_grve_paginate_links' ) ) {
		impeka_grve_paginate_links( 'element', $params );
	}
}

function impeka_wpb_ext_locate_template( $path, $params = null ) {
	$located = locate_template( array(
		'impeka-wpb-extension' . DIRECTORY_SEPARATOR . $path,
	) );
	$plugin_path = IMPEKA_WPB_EXT_PLUGIN_DIR_PATH . 'templates' . DIRECTORY_SEPARATOR . $path;
	if ( ! $located && file_exists( $plugin_path ) ) {
		$final_file = $plugin_path;
	} elseif ( $located ) {
		$final_file = $located;
	}
	if( is_array( $params ) && count( $params ) ) {
		extract( $params );
	}
	ob_start();
	$final_file = apply_filters( 'impeka_wpb_ext_locate_template', $final_file, $params, $path );
	include( $final_file );
	return ob_get_clean();
}

function impeka_wpb_ext_get_grid_layout_atts( $params = array() ) {
	if ( function_exists( 'impeka_grve_get_grid_layout_atts' ) ) {
		return impeka_grve_get_grid_layout_atts( $params );
	} else {
		return array();
	}
}
function impeka_wpb_ext_post_bg_image_container( $options = array() ) {
	if ( function_exists( 'impeka_grve_print_post_bg_image_container' ) ) {
		impeka_grve_print_post_bg_image_container( $options );
	}
}
function impeka_wpb_ext_get_video_icon( $color = 'white', $position = '' ) {
	if ( function_exists( 'impeka_grve_get_video_icon' ) ) {
		return impeka_grve_get_video_icon( $color, $position );
	}
}
function impeka_wpb_ext_print_image_filters( $atts = array() ) {
	if ( function_exists( 'impeka_grve_print_image_filters' ) ) {
		impeka_grve_print_image_filters( $atts );
	}
}

function impeka_wpb_ext_increase_heading_reset( $increase_heading_reset, $title_classes = array() ) {
	switch( $increase_heading_reset ) {
		case 'desktop-sm':
			$title_classes[] = 'grve-desktop-sm-reset-increase-heading';
			$title_classes[] = 'grve-tablet-reset-increase-heading';
			$title_classes[] = 'grve-tablet-sm-reset-increase-heading';
			$title_classes[] = 'grve-mobile-reset-increase-heading';
		break;
		case 'tablet':
			$title_classes[] = 'grve-tablet-reset-increase-heading';
			$title_classes[] = 'grve-tablet-sm-reset-increase-heading';
			$title_classes[] = 'grve-mobile-reset-increase-heading';
		break;
		case 'tablet-sm':
			$title_classes[] = 'grve-tablet-sm-reset-increase-heading';
			$title_classes[] = 'grve-mobile-reset-increase-heading';
		break;
		case 'mobile':
			$title_classes[] = 'grve-mobile-reset-increase-heading';
		break;
		default:
		break;
	}
	return $title_classes;
}

function impeka_wpb_ext_get_image_html( $atts = array() ) {

	$image = impeka_wpb_ext_array_value( $atts, 'image' );
	$retina_image = impeka_wpb_ext_array_value( $atts, 'retina_image' );
	$image_mode_size = impeka_wpb_ext_array_value( $atts, 'image_mode_size' );
	$fallback_image_mode_size = impeka_wpb_ext_array_value( $atts, 'fallback_image_mode_size', $image_mode_size );
	$image_popup_size_mode = impeka_wpb_ext_array_value( $atts, 'image_popup_size_mode' );
	$image_load_mode = impeka_wpb_ext_array_value( $atts, 'image_load_mode' );
	$column_space = impeka_wpb_ext_array_value( $atts, 'column_space', 'auto' );
	$wrapper = impeka_wpb_ext_array_value( $atts, 'wrapper', 'no' );

	$image_html = '';
	if ( !empty( $image ) ) {
		if ( !is_numeric( $image ) ) {
			$img_id = $image;
			if( 'yes' == $wrapper ) {
				$image_html = impeka_wpb_ext_get_fallback_image_wrapper( 'full', 'custom', $image );
			} else {
				$image_html = impeka_wpb_ext_get_fallback_image( 'full', 'custom', $image );
			}
		} else {
			$img_id = preg_replace('/[^\d]/', '', $image);
			$img_src = wp_get_attachment_image_src( $img_id, 'full' );
			if( $img_src !== false ) {
				$img_url = $img_src[0];
				if ( !empty( $retina_image ) ) {
					$img_retina_id = preg_replace('/[^\d]/', '', $retina_image);
					$img_retina_src = wp_get_attachment_image_src( $img_retina_id, 'full' );
					if( $img_retina_src !== false ) {
						$retina_url = $img_retina_src[0];
						$image_srcset = $img_url . ' 1x,' . $retina_url . ' 2x';
						if( 'yes' == $wrapper ) {
							$image_html = impeka_wpb_ext_get_attachment_image( $img_id, $image_mode_size , "", array( 'srcset'=> $image_srcset, 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
						} else {
							$image_html = wp_get_attachment_image( $img_id, $image_mode_size , "", array( 'srcset'=> $image_srcset, 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
						}
					} else {
						if( 'yes' == $wrapper ) {
							$image_html = impeka_wpb_ext_get_attachment_image( $img_id, $image_mode_size , "", array( 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
						} else {
							$image_html = wp_get_attachment_image( $img_id, $image_mode_size , "", array( 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
						}
					}
				} else {
					if( 'yes' == $wrapper ) {
						$image_html = impeka_wpb_ext_get_attachment_image( $img_id, $image_mode_size , "", array( 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
					} else {
						$image_html = wp_get_attachment_image( $img_id, $image_mode_size , "", array( 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
					}
				}
			}
		}
	}

	if ( empty( $image_html ) ) {
		if( 'yes' == $wrapper ) {
			$image_html = impeka_wpb_ext_get_fallback_image_wrapper( $fallback_image_mode_size  );
		} else {
			$image_html = impeka_wpb_ext_get_fallback_image( $fallback_image_mode_size  );
		}
	}

	return $image_html;
}

function impeka_wpb_ext_get_image_popup_url( $atts = array() ) {
	$image = impeka_wpb_ext_array_value( $atts, 'image' );
	$retina_image = impeka_wpb_ext_array_value( $atts, 'retina_image' );
	$image_popup_size_mode = impeka_wpb_ext_array_value( $atts, 'image_popup_size_mode' );
	$img_url = '';
	if ( !empty( $image ) ) {
		if ( !is_numeric( $image ) ) {
			$img_url = impeka_wpb_ext_get_fallback_image( 'full', 'url', $image );
		} else {
			$img_id = preg_replace('/[^\d]/', '', $image);
			$img_src = wp_get_attachment_image_src( $img_id, $image_popup_size_mode );
			if( $img_src !== false ) {
				$img_url = $img_src[0];
				if ( !empty( $retina_image ) ) {
					$img_retina_id = preg_replace('/[^\d]/', '', $retina_image);
					$img_retina_src = wp_get_attachment_image_src( $img_retina_id, $image_popup_size_mode );
					if( $img_retina_src !== false ) {
						$img_url = $img_retina_src[0];	
					}
				}
			}
		}
	}
	if ( empty( $img_url ) ) {
		$img_url = impeka_wpb_ext_get_fallback_image( $image_popup_size_mode, 'url'  );
	}
	return $img_url;
}

function impeka_wpb_ext_img_style( $bg_image = '' , $bg_image_size = 'full' ) {
	$style = '';

	if((int)$bg_image > 0 && ($attachment_src = wp_get_attachment_image_src( $bg_image, $bg_image_size )) !== false) {
		$image_url = $attachment_src[0];
		$style .= "background-image: url(" . esc_url( $image_url ) . ");";
	} else {
		$image_url = impeka_wpb_ext_get_fallback_image( $bg_image_size ,'url' );
		$style .= "background-image: url(" . esc_url( $image_url ) . ");";
	}
	return ' style="' . $style . '"';
}

function impeka_wpb_ext_img_url( $bg_image = '' , $bg_image_size = 'full' ) {
	$image_url = "";
	if((int)$bg_image > 0 && ($attachment_src = wp_get_attachment_image_src( $bg_image, $bg_image_size )) !== false) {
		$image_url = $attachment_src[0];
	}
	return $image_url;
}

function impeka_wpb_ext_construct_icon( $atts ) {
	vc_icon_element_fonts_enqueue( $atts['i_type'] );

	$class = 'grve-icon';

	if ( isset( $atts[ 'i_icon_' . $atts['i_type'] ] ) ) {
		$class .= ' ' . $atts[ 'i_icon_' . $atts['i_type'] ];
	} else {
		$class .= ' fa fa-adjust';
	}

	return '<span class="' . $class . '"></span>';
}

function impeka_wpb_ext_build_svg_icon( $icon_options = array() ) {
	if ( function_exists( 'impeka_grve_build_svg_icon' ) ) {
		return impeka_grve_build_svg_icon( $icon_options );
	}
}

function impeka_wpb_ext_get_svg_icon( $icon = 'arrow-1' ) {
	if ( function_exists('impeka_grve_get_svg_icon') ) {
		return impeka_grve_get_svg_icon( $icon );
	}
}

function impeka_wpb_ext_print_close_icon( $icon_color = 'white' ) {
	if ( function_exists('impeka_grve_print_close_icon') ) {
		return impeka_grve_print_close_icon( $icon_color );
	}
}

 /**
 * Generates a button
 * Used in shortcodes to display a button
 */
function impeka_wpb_ext_get_button( $btn_options, $index = '' ) {

	//Icon Library
	$btn_icon_type = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_icon_type' );
	$icon_class = '';
	if( 'icon-library' == $btn_icon_type ) {
		$btn_icon_library = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_icon_library' );
		$btn_icon_fontawesome = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_icon_fontawesome' );
		$btn_icon_openiconic = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_icon_openiconic' );
		$btn_icon_typicons = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_icon_typicons' );
		$btn_icon_entypo = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_icon_entypo' );
		$btn_icon_linecons = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_icon_linecons' );
		$btn_icon_simplelineicons = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_icon_simplelineicons' );
		$btn_icon_etlineicons = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_icon_etlineicons' );

		$icon_class = isset( ${"btn_icon_" . $btn_icon_library} ) ? esc_attr( ${"btn_icon_" . $btn_icon_library} ) : 'fas fa-adjust';
		if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ) {
			vc_icon_element_fonts_enqueue( $btn_icon_library );
		}
	}

	//Extra Class
	$btn_fluid = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_fluid' );
	$btn_fluid_height = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_fluid_height' );
	$extra_class = '';
	if ( 'yes' == $btn_fluid ) {
		$extra_class = 'grve-fullwidth-btn grve-fluid-btn-' . $btn_fluid_height;
	}

	//Link
	$btn_link = impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_link' );
	$link_atts = impeka_wpb_ext_get_link_attributes( $btn_link );

    $button_params = array(
		'link_atts' => $link_atts,
		'text' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_text' ),
		'sr_text' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_sr_text' ),
		'type' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_type' ),
		'size' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_size' ),
		'color' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_color' ),
		'hover_color' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_hover_color' ),
		'color_gradient' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_color_gradient' ),
		'hover_color_gradient' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_hover_color_gradient' ),
		'line_color' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_line_color' ),
		'line_position' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_line_position' ),
		'shape' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_shape' ),
		'shadow' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_shadow' ),
		'hover_action' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_hover_action' ),
		'icon_type' => $btn_icon_type,
		'icon_class' => $icon_class,
		'svg_icon' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_svg_icon' ),
		'svg_icon_shape' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_svg_icon_shape' ),
		'svg_icon_shape_type' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_svg_icon_shape_type' ),
		'svg_icon_color' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_svg_icon_color' ),
		'svg_icon_shape_color' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_svg_icon_shape_color' ),
		'video_icon_shape' =>  impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_video_icon_shape' ),
		'video_icon_shape_type' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_video_icon_shape_type' ),
		'video_icon_shape_color' =>impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_video_icon_shape_color' ),
		'video_icon_shape_hover_color' =>impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_video_icon_shape_hover_color' ),
		'class' => impeka_wpb_ext_array_value( $btn_options, 'btn' . $index . '_class' ),
		'extra_class' => $extra_class,
	);

	ob_start();
	get_template_part( 'templates/general/button', '', $button_params );
	return ob_get_clean();

}

function impeka_wpb_ext_has_link( $link = '' ) {

	$has_link = false;

	if ( !empty( $link ) ){
		$link = vc_build_link( $link );
		if ( strlen( $link['url'] ) > 0 ) {
			$has_link = true;
		}
	}
	return $has_link;

}

function impeka_wpb_ext_get_link_attributes( $link = '', $class = '', $style = ''  ) {
	$attributes = array();
	$a_href = $a_title = $a_target = $a_rel = '';
	$use_link = false;

	if ( !empty( $link ) ){
		$link = vc_build_link( $link );
		if ( strlen( $link['url'] ) > 0 ) {
			$use_link = true;
			$a_href = $link['url'];
			$a_title = $link['title'];
			$a_target = $link['target'];
			$a_rel = $link['rel'];
		}
	}

	if ( $use_link ) {
		$attributes[] = 'href="' . esc_url( $a_href ) . '"';
		if ( ! empty( $a_title ) ) {
			$attributes[] = 'title="' . esc_attr( trim( $a_title ) ) . '"';
		}
		if ( ! empty( $a_target ) ) {
			$attributes[] = 'target="' . esc_attr( trim( $a_target ) ) . '"';
		}
		if ( ! empty( $a_rel ) ) {
			$attributes[] = 'rel="' . esc_attr( trim( $a_rel ) ) . '"';
		}
	} else {
		$attributes[] = 'href="#"';
	}


	if ( ! empty( $class ) ) {
		$attributes[] = 'class="' . esc_attr( $class ) . '"';
	}
	if ( ! empty( $style ) ) {
		$attributes[] = 'style="' . esc_attr( $style ) . '"';
	}

	return $attributes;
}

 /**
 * Fetch Post Categories
 * Used in shortcodes to generate the list of used categories ( back end )
 */
function impeka_wpb_ext_get_post_categories( $term_slug = 'category' ) {
	$category = array( esc_html__( "All Categories", "impeka-wpb-extension" ) => "" );

	$cats = get_terms( $term_slug );
	if ( is_array( $cats ) ) {
	  foreach ( $cats as $cat ) {
		$category[$cat->name] = $cat->term_id;
	  }
	}
	return $category;
}

 /**
 * Fetch Menus
 * Used in shortcodes to generate the list of menus ( back end )
 */
function impeka_wpb_ext_get_menus() {
	$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );

	$custom_menus = array( esc_html__( "None", "impeka-wpb-extension" ) => "" );
	if ( is_array( $menus ) && ! empty( $menus ) ) {
		foreach ( $menus as $single_menu ) {
			if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->term_id ) ) {
				$custom_menus[ $single_menu->name ] = $single_menu->term_id;
			}
		}
	}
	return $custom_menus;
}

 /**
 * Fetch Area Items
 * Used in shortcodes to generate the list of area items ( back end )
 */
function impeka_wpb_ext_get_area_items() {
	$area_items = array( esc_html__( "None", "impeka-wpb-extension" ) => "" );
	$area_item_posts = get_posts( array(
		'posts_per_page' => '-1',
		'orderby' => 'post_title',
		'post_status'=>'publish',
		'post_type' => 'area-item',
	) );
	if ( !empty( $area_item_posts ) ) {
		foreach ( $area_item_posts as $post ) {
			$area_items[ esc_html( $post->post_title ) ] = $post->ID;
		}
		wp_reset_postdata();
	}
	return $area_items;
}

 /**
 * Generates dimension string to concat in attribute style
 */
function impeka_wpb_ext_build_dimension( $dimension, $value ) {
	$fixed_dimension = '';

	if( ! empty( $dimension ) &&  ! empty( $value )  ) {
		$fixed_dimension .= $dimension . ': '.(preg_match('/(px|em|\%|pt|cm)$/', $value) ? $value : $value.'px').';';
	}
	return $fixed_dimension;
}

 /**
 * Generates margin-bottom string to concat in attribute style
 */
function impeka_wpb_ext_build_margin_bottom_style( $margin_bottom ) {
	$style = '';
	if( $margin_bottom != '' ) {
		$style .= 'margin-bottom: '.(preg_match('/(px|em|\%|pt|cm)$/', $margin_bottom) ? $margin_bottom : $margin_bottom .'px').';';
		$style = esc_attr( $style );
	}
	return $style;
}

 /**
 * Generates padding-top string to concat in attribute style
 */
function impeka_wpb_ext_build_padding_top_style( $padding_top ) {
	$style = '';
	if( $padding_top != '' ) {
		$style .= 'padding-top: '.(preg_match('/(px|em|\%|pt|cm)$/', $padding_top) ? $padding_top : $padding_top.'px').';';
		$style = esc_attr( $style );
	}
	return $style;
}

 /**
 * Generates padding-bottom string to concat in attribute style
 */
function impeka_wpb_ext_build_padding_bottom_style( $padding_bottom ) {
	$style = '';
	if( $padding_bottom != '' ) {
		$style .= 'padding-bottom: '.(preg_match('/(px|em|\%|pt|cm)$/', $padding_bottom) ? $padding_bottom : $padding_bottom.'px').';';
		$style = esc_attr( $style );
	}
	return $style;
}

/**
 * Get CSS Color
 */
function impeka_wpb_ext_get_css_color( $prefix, $color ) {
	$rgb_color = preg_match( '/rgba/', $color ) ? preg_replace( array( '/\s+/', '/^rgba\((\d+)\,(\d+)\,(\d+)\,([\d\.]+)\)$/' ), array( '', 'rgb($1,$2,$3)' ), $color ) : $color;
	$string = $prefix . ':' . $rgb_color . ';';
	if ( $rgb_color !== $color ) $string .= $prefix . ':' . $color . ';';
	return $string;
}

 /**
 * Prints blog class depending on the blog style
 */
function impeka_wpb_ext_get_blog_class( $impeka_wpb_ext_blog_mode = 'large'  ) {

	switch( $impeka_wpb_ext_blog_mode ) {

		case 'small':
			$impeka_wpb_ext_blog_mode_class = 'grve-blog grve-blog-small grve-isotope';
			break;
		case 'masonry':
			$impeka_wpb_ext_blog_mode_class = 'grve-blog grve-blog-columns grve-blog-masonry grve-isotope';
			break;
		case 'grid':
			$impeka_wpb_ext_blog_mode_class = 'grve-blog grve-blog-columns grve-blog-grid grve-isotope';
			break;
		case 'large':
		default:
			$impeka_wpb_ext_blog_mode_class = 'grve-blog grve-blog-large grve-non-isotope';
			break;

	}

	return $impeka_wpb_ext_blog_mode_class;

}

/**
 * Returns excerpt
 */
function impeka_wpb_ext_excerpt( $excerpt_length = '15', $excerpt_more = "", $excerpt_more_text = "" ) {
	if ( function_exists('impeka_grve_excerpt') ) {
		return impeka_grve_excerpt( $excerpt_length, $excerpt_more, $excerpt_more_text );
	}
	return "";
}

 /**
 * Prints post date
 */
function impeka_wpb_ext_print_post_date( $mode = '') {
		if( 'list' == $mode ) {
			echo '<li class="grve-post-date">';
		}
		global $post;
?>
	<time datetime="<?php echo mysql2date( 'c', $post->post_date ); ?>">
		<?php echo esc_html( get_the_date() ); ?>
	</time>
<?php
		if( 'list' == $mode ) {
			echo '</li>';
		}
}

function impeka_wpb_ext_get_image_size( $image_mode = 'full', $index = 1 ) {
	if ( function_exists( 'impeka_grve_get_image_size' ) ) {
		return impeka_grve_get_image_size( $image_mode, $index );
	} else {
		return $image_mode;
	}
}

function impeka_wpb_ext_get_fallback_image_attr( $size = '' ) {
	$image_atts = array();
	if ( function_exists( 'impeka_grve_get_fallback_image_attr' ) ) {
		return impeka_grve_get_fallback_image_attr( $size );
	} else {
		return $image_atts;
	}
}

function impeka_wpb_ext_get_attachment_image( $id, $size = 'thumbnail', $icon = false, $attr = '' ) {
	if ( function_exists( 'impeka_grve_get_attachment_image' ) ) {
		return impeka_grve_get_attachment_image( $id, $size , $icon, $attr );
	} else {
		return wp_get_attachment_image( $id, $size , $icon, $attr );
	}
}

function impeka_wpb_ext_the_post_thumbnail( $size = 'thumbnail', $attr = '' ) {
	if ( function_exists( 'impeka_grve_the_post_thumbnail' ) ) {
		impeka_grve_the_post_thumbnail( $size , $attr );
	} else {
		the_post_thumbnail( $size, $attr );
	}
}

function impeka_wpb_ext_get_fallback_image( $size = '', $mode = '', $url= '' ) {
	if ( function_exists( 'impeka_grve_get_fallback_image' ) ) {
		return impeka_grve_get_fallback_image( $size, $mode, $url );
	}
	return '';
}

function impeka_wpb_ext_get_fallback_image_wrapper( $size = '', $mode = '', $url= '' ) {
	if ( function_exists( 'impeka_grve_get_fallback_image_wrapper' ) ) {
		return impeka_grve_get_fallback_image_wrapper( $size, $mode, $url );
	}
	return '';
}

function impeka_wpb_ext_get_custom_masonry_data( $size = 'square' ) {
	if ( function_exists( 'impeka_grve_get_custom_masonry_data' ) ) {
		return impeka_grve_get_custom_masonry_data( $size );
	}
	return array(
		'class' => "grve-image-square",
		'image_size' => 'impeka-grve-small-square',
	);
}

function impeka_wpb_ext_get_masonry_data( $index, $columns ) {
	if ( function_exists( 'impeka_grve_get_masonry_data' ) ) {
		return impeka_grve_get_masonry_data( $index, $columns );
	}
	return array(
		'class' => "grve-image-square",
		'image_size' => 'impeka-grve-small-square',
	);
}

function impeka_wpb_ext_get_broken_grid_data( $index, $layout ) {
	if ( function_exists( 'impeka_grve_get_broken_grid_data' ) ) {
		return impeka_grve_get_broken_grid_data( $index, $layout );
	}
	return array(
		'class' => "grve-image-square",
		'image_size' => 'impeka-grve-small-square',
	);
}

function impeka_wpb_ext_get_all_image_sizes() {
    global $_wp_additional_image_sizes;
    $default_image_sizes = get_intermediate_image_sizes();
    foreach ( $default_image_sizes as $size ) {
        $image_sizes[ $size ][ 'width' ] = intval( get_option( "{$size}_size_w" ) );
        $image_sizes[ $size ][ 'height' ] = intval( get_option( "{$size}_size_h" ) );
        $image_sizes[ $size ][ 'crop' ] = get_option( "{$size}_crop" ) ? get_option( "{$size}_crop" ) : false;
    }
    if ( isset( $_wp_additional_image_sizes ) && count( $_wp_additional_image_sizes ) ) {
        $image_sizes = array_merge( $image_sizes, $_wp_additional_image_sizes );
    }
    return $image_sizes;
}

function impeka_wpb_ext_add_image_dimensions( $options ) {
    $image_sizes = impeka_wpb_ext_get_all_image_sizes();
	$new_options =  array();

	foreach ( $options as $desc => $image_mode ) {
		$size = impeka_wpb_ext_get_image_size( $image_mode );
		if ( isset( $image_sizes[$size] ) ) {
			$dim = ' - ' . $image_sizes[$size]['width'] . 'x' . $image_sizes[$size]['height'] ;
			$new_options[ $desc . $dim ] = $image_mode;
		} else {
			$new_options[ $desc  ] = $image_mode;
		}
    }
    return $new_options;
}
add_filter( 'impeka_wpb_ext_image_options', 'impeka_wpb_ext_add_image_dimensions' );


function impeka_wpb_ext_text_to_bool( $value ) {
	if ( 'yes' == $value ) {
		return 'true';
	}
	return 'false';
}

function impeka_wpb_ext_unautop( $s ) {
    $s = str_replace("<p>", "", $s);
    $s = str_replace("</p>", "\n\n", $s);
    return $s;
}

function impeka_wpb_ext_auto_br( $s ) {
    $s = str_replace("<p>", "", $s);
    $s = str_replace("</p>", "<br>", $s);
    return $s;
}
//Replace all default templates.
add_filter( 'vc_load_default_templates_action', 'impeka_wpb_ext_add_custom_templates' );

function impeka_wpb_ext_add_custom_templates() {
	$data = array();
	return $data;
}

/**
 * Prints post structured data
 */
function impeka_wpb_ext_print_structured_data() {
	if( function_exists( 'impeka_grve_print_post_structured_data' ) ) {
		impeka_grve_print_post_structured_data();
	}
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
