<?php
/*
 *	Greatives Page Builder Shortcode Extensions
 *
 * 	@author		Greatives Team
 * 	@URI		http://greatives.eu
 */

function impeka_wpb_integrate_with_vc() {

	vc_map( array(
		'name' => esc_html__( 'Row', 'impeka-wpb-extension' ),
		'is_container' => true,
		'icon' => 'icon-wpb-row',
		'show_settings_on_create' => false,
		'category' => esc_html__( 'Content', 'impeka-wpb-extension' ),
		'class' => 'vc_main-sortable-element',
		'base' => 'vc_row',
		'description' => esc_html__( 'Place content elements inside the row', 'impeka-wpb-extension' ),
		'params' => array(),
		'js_view' => 'VcRowView',
	));
	vc_map( array(
		'name' => esc_html__( 'Inner Row', 'impeka-wpb-extension' ),
		'content_element' => false,
		'is_container' => true,
		'icon' => 'icon-wpb-row',
		'weight' => 1000,
		'show_settings_on_create' => false,
		'base' => 'vc_row_inner',
		'description' => esc_html__( 'Place content elements inside the inner row', 'impeka-wpb-extension' ),
		'params' => array(),
		'js_view' => 'VcRowView',
	));
	vc_map( array(
		'name' => esc_html__( 'Column', 'impeka-wpb-extension' ),
		'icon' => 'icon-wpb-row',
		'is_container' => true,
		'content_element' => false,
		'base' => 'vc_column',
		'description' => esc_html__( 'Place content elements inside the column', 'impeka-wpb-extension' ),
		'params' => array(),
		'js_view' => 'VcColumnView',
	));
	vc_map( array(
		'name' => esc_html__( 'Inner Column', 'impeka-wpb-extension' ),
		'icon' => 'icon-wpb-row',
		'class' => '',
		'wrapper_class' => '',
		'controls' => 'full',
		'allowed_container_element' => false,
		'content_element' => false,
		'is_container' => true,
		'base' => 'vc_column_inner',
		'description' => esc_html__( 'Place content elements inside the inner column', 'impeka-wpb-extension' ),
		'params' => array(),
		'js_view' => 'VcColumnView',
	));
	vc_map( array(
		'name' => esc_html__( 'Section', 'impeka-wpb-extension' ),
		'is_container' => true,
		'icon' => 'icon-wpb-vc_section',
		'show_settings_on_create' => false,
		'base' => 'vc_section',
		"category"  => esc_html__('Content', 'impeka-wpb-extension'),
		'as_parent' => array(
			'only' => 'vc_row, impeka_area_item, impeka_modal',
		),
		'as_child' => array(
			'only' => '', // Only root
		),
		'class' => 'vc_main-sortable-element',
		'description' => esc_html__( 'Group multiple rows in section', 'impeka-wpb-extension' ),
		'params' => array(
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Disable section', 'impeka-wpb-extension' ),
				'param_name' => 'disable_element',
				'description' => esc_html__( 'If checked the section won\'t be visible on the public side of your website. You can switch it back any time.', 'impeka-wpb-extension' ),
				'value' => array( esc_html__( 'Yes', 'impeka-wpb-extension' ) => 'yes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__('Section ID', "impeka-wpb-extension" ),
				"param_name" => "el_id",
				"description" => esc_html__("If you wish you can type an id to use it as bookmark.", "impeka-wpb-extension" ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Extra class name", "impeka-wpb-extension" ),
				"param_name" => "el_class",
				"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "impeka-wpb-extension" ),
			),
		),
		'js_view' => 'VcSectionView',
	));

};

add_action( 'vc_before_init', 'impeka_wpb_integrate_with_vc' );


if ( function_exists( 'vc_add_param' ) ) {

	//Generic css aniation for elements

	$impeka_grve_add_animation = array(
		"type" => "dropdown",
		"heading" => esc_html__("CSS Animation", "impeka-wpb-extension" ),
		"param_name" => "animation",
		"admin_label" => true,
		"value" => array(
			esc_html__( "No", "impeka-wpb-extension" ) => '',
			esc_html__( "Fade In", "impeka-wpb-extension" ) => "fade-in",
			esc_html__( "Fade In Up", "impeka-wpb-extension" ) => "fade-in-up",
			esc_html__( "Fade In Up Big", "impeka-wpb-extension" ) => "fade-in-up-big",
			esc_html__( "Fade In Down", "impeka-wpb-extension" ) => "fade-in-down",
			esc_html__( "Fade In Down Big", "impeka-wpb-extension" ) => "fade-in-down-big",
			esc_html__( "Fade In Left", "impeka-wpb-extension" ) => "fade-in-left",
			esc_html__( "Fade In Left Big", "impeka-wpb-extension" ) => "fade-in-left-big",
			esc_html__( "Fade In Right", "impeka-wpb-extension" ) => "fade-in-right",
			esc_html__( "Fade In Right Big", "impeka-wpb-extension" ) => "fade-in-right-big",
			esc_html__( "Zoom In", "impeka-wpb-extension" ) => "zoom-in",
		),
		"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
		"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
	);

	$impeka_grve_add_column_animation = array(
		"type" => "dropdown",
		"heading" => esc_html__("CSS Animation", "impeka-wpb-extension" ),
		"param_name" => "animation",
		"admin_label" => true,
		"value" => array(
			esc_html__( "No", "impeka-wpb-extension" ) => '',
			esc_html__( "Fade In", "impeka-wpb-extension" ) => "fade-in",
			esc_html__( "Fade In Up", "impeka-wpb-extension" ) => "fade-in-up",
			esc_html__( "Fade In Up Big", "impeka-wpb-extension" ) => "fade-in-up-big",
			esc_html__( "Fade In Down", "impeka-wpb-extension" ) => "fade-in-down",
			esc_html__( "Fade In Down Big", "impeka-wpb-extension" ) => "fade-in-down-big",
			esc_html__( "Fade In Left", "impeka-wpb-extension" ) => "fade-in-left",
			esc_html__( "Fade In Left Big", "impeka-wpb-extension" ) => "fade-in-left-big",
			esc_html__( "Fade In Right", "impeka-wpb-extension" ) => "fade-in-right",
			esc_html__( "Fade In Right Big", "impeka-wpb-extension" ) => "fade-in-right-big",
			esc_html__( "Zoom In", "impeka-wpb-extension" ) => "zoom-in",
			esc_html__( "Clipping Animation", "impeka-wpb-extension" ) => "clipping",
		),
		"description" => esc_html__("Select type of animation if you want this column to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
		"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
	);

	$impeka_grve_add_column_clipping_animation = array(
		"type" => "dropdown",
		"heading" => esc_html__("CSS Clipping Animation", "impeka-wpb-extension" ),
		"param_name" => "clipping_animation",
		"admin_label" => true,
		"value" => array(
			esc_html__( "Clipping Up", "impeka-wpb-extension" ) => "clipping-up",
			esc_html__( "Clipping Down", "impeka-wpb-extension" ) => "clipping-down",
			esc_html__( "Clipping Left", "impeka-wpb-extension" ) => "clipping-left",
			esc_html__( "Clipping Right", "impeka-wpb-extension" ) => "clipping-right",
			esc_html__( "Colored Clipping Up", "impeka-wpb-extension" ) => "colored-clipping-up",
			esc_html__( "Colored Clipping Down", "impeka-wpb-extension" ) => "colored-clipping-down",
			esc_html__( "Colored Clipping Left", "impeka-wpb-extension" ) => "colored-clipping-left",
			esc_html__( "Colored Clipping Right", "impeka-wpb-extension" ) => "colored-clipping-right",
		),
		'dependency' => array(
			'element' => 'animation',
			'value' => 'clipping',
		),
		"description" => esc_html__("Select type of animation if you want this column to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
		"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
	);


	$impeka_grve_add_clipping_animation_colors = array(
		"type" => "dropdown",
		"heading" => esc_html__( "Clipping Color", "impeka-wpb-extension" ),
		"param_name" => "clipping_animation_colors",
		"param_holder_class" => "grve-colored-dropdown",
		"value" => impeka_wpb_ext_get_color_array(),
		"std" => 'black',
		"description" => esc_html__( "Select clipping color", "impeka-wpb-extension" ),
		"dependency" => array(
			'element' => 'clipping_animation',
			'value' => array( 'colored-clipping-up', 'colored-clipping-down', 'colored-clipping-left', 'colored-clipping-right' )
		),
		"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
	);

	$impeka_grve_add_animation_delay = array(
		"type" => "textfield",
		"heading" => esc_html__( 'Css Animation Delay', "impeka-wpb-extension" ),
		"param_name" => "animation_delay",
		"value" => '0',
		"description" => esc_html__( "Add delay in milliseconds.", "impeka-wpb-extension" ),
		"dependency" => array(
			'element' => 'animation',
			'value_not_equal_to' => array( '' )
		),
		"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
	);

	$impeka_grve_add_animation_duration = array(
		"type" => "dropdown",
		"heading" => esc_html__("CSS Animation Duration", "impeka-wpb-extension" ),
		"param_name" => "animation_duration",
		"value" => array(
			esc_html__( "Very Fast", "impeka-wpb-extension" ) => "very-fast",
			esc_html__( "Fast", "impeka-wpb-extension" ) => "fast",
			esc_html__( "Normal", "impeka-wpb-extension" ) => "normal",
			esc_html__( "Slow", "impeka-wpb-extension" ) => "slow",
			esc_html__( "Very Slow", "impeka-wpb-extension" ) => "very-slow",
		),
		"std" => 'normal',
		"description" => esc_html__("Select the duration for your animated element.", "impeka-wpb-extension" ),
		"dependency" => array(
			'element' => 'animation',
			'value_not_equal_to' => array( '' )
		),
		"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
	);

	$impeka_grve_add_animation_hover = array(
		"type" => "dropdown",
		"heading" => esc_html__("Hover Animation", "impeka-wpb-extension" ),
		"param_name" => "hover_animation",
		"value" => array(
			esc_html__( "None", "impeka-wpb-extension" ) => "",
			esc_html__( "Slide Up", "impeka-wpb-extension" ) => "slide-up",
			esc_html__( "Slide Down", "impeka-wpb-extension" ) => "slide-down",
			esc_html__( "Slide Left", "impeka-wpb-extension" ) => "slide-left",
			esc_html__( "Slide Right", "impeka-wpb-extension" ) => "slide-right",
			esc_html__( "Emphasized", "impeka-wpb-extension" ) => "emphasized",
			esc_html__( "Magnetism", "impeka-wpb-extension" ) => "magnetism",
		),
		"description" => esc_html__("Select the hover animation.", "impeka-wpb-extension" ),
		"group" => esc_html__( "Effect", "impeka-wpb-extension" ),
	);

	$impeka_grve_add_margin_bottom = array(
		"type" => "textfield",
		"heading" => esc_html__( 'Bottom margin', "impeka-wpb-extension" ),
		"param_name" => "margin_bottom",
		"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
	);

	$impeka_grve_add_el_class = array(
		"type" => "textfield",
		"heading" => esc_html__("Extra class name", "impeka-wpb-extension" ),
		"param_name" => "el_class",
		"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "impeka-wpb-extension" ),
	);
	$impeka_grve_add_el_wrapper_class = array(
		"type" => "textfield",
		"heading" => esc_html__("Wrapper class name", "impeka-wpb-extension" ),
		"param_name" => "el_wrapper_class",
		"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "impeka-wpb-extension" ),
	);

	$impeka_grve_add_el_id =array(
		'type' => 'el_id',
		'heading' => esc_html__( 'Element ID', "impeka-wpb-extension" ),
		'param_name' => 'el_id',
		'description' => esc_html__( 'Enter element ID (Note: make sure it is unique and valid).', "impeka-wpb-extension" ),
	);

	$impeka_grve_column_order_list = array(
		esc_html__( "Default", "impeka-wpb-extension" ) => '',
		esc_html__( "order 1", "impeka-wpb-extension" ) => '1',
		esc_html__( "order 2", "impeka-wpb-extension" ) => '2',
		esc_html__( "order 3", "impeka-wpb-extension" ) => '3',
		esc_html__( "order 4", "impeka-wpb-extension" ) => '4',
		esc_html__( "order 5", "impeka-wpb-extension" ) => '5',
		esc_html__( "order 6", "impeka-wpb-extension" ) => '6',
	);

	$impeka_grve_column_width_list = array(
		esc_html__( '1 column - 1/12', "impeka-wpb-extension" ) => '1/12',
		esc_html__( '2 columns - 1/6', "impeka-wpb-extension" ) => '1/6',
		esc_html__( '3 columns - 1/4', "impeka-wpb-extension" ) => '1/4',
		esc_html__( '4 columns - 1/3', "impeka-wpb-extension" ) => '1/3',
		esc_html__( '5 columns - 5/12', "impeka-wpb-extension" ) => '5/12',
		esc_html__( '6 columns - 1/2', "impeka-wpb-extension" ) => '1/2',
		esc_html__( '7 columns - 7/12', "impeka-wpb-extension" ) => '7/12',
		esc_html__( '8 columns - 2/3', "impeka-wpb-extension" ) => '2/3',
		esc_html__( '9 columns - 3/4', "impeka-wpb-extension" ) => '3/4',
		esc_html__( '10 columns - 5/6', "impeka-wpb-extension" ) => '5/6',
		esc_html__( '11 columns - 11/12', "impeka-wpb-extension" ) => '11/12',
		esc_html__( '12 columns - 1/1', "impeka-wpb-extension" ) => '1/1'
	);

	$impeka_grve_column_desktop_hide_list = array(
		esc_html__( 'Default value from width attribute', "impeka-wpb-extension") => '',
		esc_html__( 'Hide', "impeka-wpb-extension" ) => 'hide',
	);

	$impeka_grve_column_width_tablet_list = array(
		esc_html__( 'Default value from width attribute', "impeka-wpb-extension") => '',
		esc_html__( 'Hide', "impeka-wpb-extension" ) => 'hide',
		esc_html__( '1 column - 1/12', "impeka-wpb-extension" ) => '1-12',
		esc_html__( '2 columns - 1/6', "impeka-wpb-extension" ) => '1-6',
		esc_html__( '3 columns - 1/4', "impeka-wpb-extension" ) => '1-4',
		esc_html__( '4 columns - 1/3', "impeka-wpb-extension" ) => '1-3',
		esc_html__( '5 columns - 5/12', "impeka-wpb-extension" ) => '5-12',
		esc_html__( '6 columns - 1/2', "impeka-wpb-extension" ) => '1-2',
		esc_html__( '7 columns - 7/12', "impeka-wpb-extension" ) => '7-12',
		esc_html__( '8 columns - 2/3', "impeka-wpb-extension" ) => '2-3',
		esc_html__( '9 columns - 3/4', "impeka-wpb-extension" ) => '3-4',
		esc_html__( '10 columns - 5/6', "impeka-wpb-extension" ) => '5-6',
		esc_html__( '11 columns - 11/12', "impeka-wpb-extension" ) => '11-12',
		esc_html__( '12 columns - 1/1', "impeka-wpb-extension" ) => '1',
	);

	$impeka_grve_column_width_tablet_sm_list = array(
		esc_html__( 'Inherit from Tablet Landscape', "impeka-wpb-extension") => '',
		esc_html__( 'Hide', "impeka-wpb-extension" ) => 'hide',
		esc_html__( '1 column - 1/12', "impeka-wpb-extension" ) => '1-12',
		esc_html__( '2 columns - 1/6', "impeka-wpb-extension" ) => '1-6',
		esc_html__( '3 columns - 1/4', "impeka-wpb-extension" ) => '1-4',
		esc_html__( '4 columns - 1/3', "impeka-wpb-extension" ) => '1-3',
		esc_html__( '5 columns - 5/12', "impeka-wpb-extension" ) => '5-12',
		esc_html__( '6 columns - 1/2', "impeka-wpb-extension" ) => '1-2',
		esc_html__( '7 columns - 7/12', "impeka-wpb-extension" ) => '7-12',
		esc_html__( '8 columns - 2/3', "impeka-wpb-extension" ) => '2-3',
		esc_html__( '9 columns - 3/4', "impeka-wpb-extension" ) => '3-4',
		esc_html__( '10 columns - 5/6', "impeka-wpb-extension" ) => '5-6',
		esc_html__( '11 columns - 11/12', "impeka-wpb-extension" ) => '11-12',
		esc_html__( '12 columns - 1/1', "impeka-wpb-extension" ) => '1',
	);
	$impeka_grve_column_mobile_width_list = array(
		esc_html__( 'Default value 12 columns - 1/1', "impeka-wpb-extension" ) => '',
		esc_html__( 'Hide', "impeka-wpb-extension" ) => 'hide',
		esc_html__( '3 columns - 1/4', "impeka-wpb-extension" ) => '1-4',
		esc_html__( '4 columns - 1/3', "impeka-wpb-extension" ) => '1-3',
		esc_html__( '6 columns - 1/2', "impeka-wpb-extension" ) => '1-2',
		esc_html__( '12 columns - 1/1', "impeka-wpb-extension" ) => '1',
	);

	//Add additional column options for Page Builder 5.5
	if ( defined( 'WPB_VC_VERSION' ) && version_compare( WPB_VC_VERSION, '5.5', '>=' ) ) {
		$impeka_grve_extra_list = array(
			esc_html__( '20% - 1/5', "impeka-wpb-extension" ) => '1/5',
			esc_html__( '40% - 2/5', "impeka-wpb-extension" ) => '2/5',
			esc_html__( '60% - 3/5', "impeka-wpb-extension" ) => '3/5',
			esc_html__( '80% - 4/5', "impeka-wpb-extension" ) => '4/5',
		);
		$impeka_grve_column_width_list = array_merge( $impeka_grve_column_width_list, $impeka_grve_extra_list);

		$impeka_grve_extra_list_simplified = array(
			esc_html__( '20% - 1/5', "impeka-wpb-extension" ) => '1-5',
			esc_html__( '40% - 2/5', "impeka-wpb-extension" ) => '2-5',
			esc_html__( '60% - 3/5', "impeka-wpb-extension" ) => '3-5',
			esc_html__( '80% - 4/5', "impeka-wpb-extension" ) => '4-5',
		);
		$impeka_grve_column_width_tablet_list = array_merge( $impeka_grve_column_width_tablet_list, $impeka_grve_extra_list_simplified );
		$impeka_grve_column_width_tablet_sm_list = array_merge( $impeka_grve_column_width_tablet_sm_list, $impeka_grve_extra_list_simplified );
		$impeka_grve_column_mobile_width_list = array_merge( $impeka_grve_column_mobile_width_list, $impeka_grve_extra_list_simplified );
	}

	$impeka_grve_column_gap_list = array(
		esc_html__( 'No Gap', "impeka-wpb-extension" ) => 'none',
		esc_html__( 'Default', "impeka-wpb-extension" ) => 'default',
		esc_html__( '5px', "impeka-wpb-extension" ) => '5',
		esc_html__( '10px', "impeka-wpb-extension" ) => '10',
		esc_html__( '15px', "impeka-wpb-extension" ) => '15',
		esc_html__( '20px', "impeka-wpb-extension" ) => '20',
		esc_html__( '25px', "impeka-wpb-extension" ) => '25',
		esc_html__( '30px', "impeka-wpb-extension" ) => '30',
		esc_html__( '35px', "impeka-wpb-extension" ) => '35',
		esc_html__( '40px', "impeka-wpb-extension" ) => '40',
		esc_html__( '45px', "impeka-wpb-extension" ) => '45',
		esc_html__( '50px', "impeka-wpb-extension" ) => '50',
		esc_html__( '55px', "impeka-wpb-extension" ) => '55',
		esc_html__( '60px', "impeka-wpb-extension" ) => '60',
	);

	$impeka_grve_column_vertical_gap_list = array(
		esc_html__( 'No Gap', "impeka-wpb-extension" ) => 'none',
		esc_html__( '5px', "impeka-wpb-extension" ) => '5',
		esc_html__( '10px', "impeka-wpb-extension" ) => '10',
		esc_html__( '15px', "impeka-wpb-extension" ) => '15',
		esc_html__( '20px', "impeka-wpb-extension" ) => '20',
		esc_html__( '25px', "impeka-wpb-extension" ) => '25',
		esc_html__( '30px', "impeka-wpb-extension" ) => '30',
		esc_html__( '35px', "impeka-wpb-extension" ) => '35',
		esc_html__( '40px', "impeka-wpb-extension" ) => '40',
		esc_html__( '45px', "impeka-wpb-extension" ) => '45',
		esc_html__( '50px', "impeka-wpb-extension" ) => '50',
		esc_html__( '55px', "impeka-wpb-extension" ) => '55',
		esc_html__( '60px', "impeka-wpb-extension" ) => '60',
	);

	$impeka_grve_position_list = array(
		esc_html__( "None", "impeka-wpb-extension" ) => '',
		esc_html__( "1x", "impeka-wpb-extension" ) => '1x',
		esc_html__( "2x", "impeka-wpb-extension" ) => '2x',
		esc_html__( "3x", "impeka-wpb-extension" ) => '3x',
		esc_html__( "4x", "impeka-wpb-extension" ) => '4x',
		esc_html__( "5x", "impeka-wpb-extension" ) => '5x',
		esc_html__( "6x", "impeka-wpb-extension" ) => '6x',
		esc_html__( "-1x", "impeka-wpb-extension" ) => 'minus-1x',
		esc_html__( "-2x", "impeka-wpb-extension" ) => 'minus-2x',
		esc_html__( "-3x", "impeka-wpb-extension" ) => 'minus-3x',
		esc_html__( "-4x", "impeka-wpb-extension" ) => 'minus-4x',
		esc_html__( "-5x", "impeka-wpb-extension" ) => 'minus-5x',
		esc_html__( "-6x", "impeka-wpb-extension" ) => 'minus-6x',
	);

	$impeka_grve_separator_list = array(
		esc_html__( "None", "impeka-wpb-extension" ) => '',
		esc_html__( "Wave Right", "impeka-wpb-extension" ) => 'wave-right-separator',
		esc_html__( "Wave Left", "impeka-wpb-extension" ) => 'wave-left-separator',
		esc_html__( "Triangle", "impeka-wpb-extension" ) => 'triangle-separator',
		esc_html__( "Large Triangle", "impeka-wpb-extension" ) => 'large-triangle-separator',
		esc_html__( "Curve", "impeka-wpb-extension" ) => 'curve-separator',
		esc_html__( "Curve Left", "impeka-wpb-extension" ) => 'curve-left-separator',
		esc_html__( "Curve Right", "impeka-wpb-extension" ) => 'curve-right-separator',
		esc_html__( "Tilt Left", "impeka-wpb-extension" ) => 'tilt-left-separator',
		esc_html__( "Tilt Right", "impeka-wpb-extension" ) => 'tilt-right-separator',
		esc_html__( "Tilt Alt Left", "impeka-wpb-extension" ) => 'tilt-alt-left-separator',
		esc_html__( "Tilt Alt Right", "impeka-wpb-extension" ) => 'tilt-alt-right-separator',
		esc_html__( "Round Split", "impeka-wpb-extension" ) => 'round-split-separator',
		esc_html__( "Line", "impeka-wpb-extension" ) => 'line-separator',
		esc_html__( "Torn Paper", "impeka-wpb-extension" ) => 'torn-paper-separator',
	);

	$impeka_grve_separator_size_list = array(
		esc_html__( "30px", "impeka-wpb-extension" ) => '30px',
		esc_html__( "60px", "impeka-wpb-extension" ) => '60px',
		esc_html__( "90px", "impeka-wpb-extension" ) => '90px',
		esc_html__( "120px", "impeka-wpb-extension" ) => '120px',
		esc_html__( "150px", "impeka-wpb-extension" ) => '150px',
		esc_html__( "180px", "impeka-wpb-extension" ) => '180px',
		esc_html__( "200px", "impeka-wpb-extension" ) => '200px',
		esc_html__( "300px", "impeka-wpb-extension" ) => '300px',
		esc_html__( "10%", "impeka-wpb-extension" ) => '10%',
		esc_html__( "20%", "impeka-wpb-extension" ) => '20%',
		esc_html__( "30%", "impeka-wpb-extension" ) => '30%',
		esc_html__( "40%", "impeka-wpb-extension" ) => '40%',
		esc_html__( "50%", "impeka-wpb-extension" ) => '50%',
		esc_html__( "60%", "impeka-wpb-extension" ) => '60%',
		esc_html__( "70%", "impeka-wpb-extension" ) => '70%',
		esc_html__( "80%", "impeka-wpb-extension" ) => '80%',
		esc_html__( "90%", "impeka-wpb-extension" ) => '90%',
		esc_html__( "100%", "impeka-wpb-extension" ) => '100%',
	);

	//Title Headings/Tags
	if( !function_exists( 'impeka_grve_get_heading_tag' ) ) {
		function impeka_grve_get_heading_tag( $std = '' ) {
			return	array(
				"type" => "dropdown",
				"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
				"param_name" => "heading_tag",
				"value" => array(
					esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
					esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
					esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
					esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
					esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
					esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
					esc_html__( "div", "impeka-wpb-extension" ) => 'div',
				),
				"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
				"std" => $std,
				"group" => esc_html__( "Titles & Styles", "impeka-wpb-extension" ),
			);
		}
	}

	if( !function_exists( 'impeka_grve_get_heading' ) ) {
		function impeka_grve_get_heading( $std = '' ) {
			return	array(
				"type" => "dropdown",
				"heading" => esc_html__( "Title Size/Typography", "impeka-wpb-extension" ),
				"param_name" => "heading",
				"value" => array(
					esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
					esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
					esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
					esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
					esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
					esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
					esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
					esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
					esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
					esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
				),
				"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
				"std" => $std,
				"group" => esc_html__( "Titles & Styles", "impeka-wpb-extension" ),
			);
		}
	}
	if( !function_exists( 'impeka_grve_get_custom_font_family' ) ) {
		function impeka_grve_get_custom_font_family( $std = '' ) {
			return	array(
				"type" => "dropdown",
				"heading" => esc_html__( "Custom Font Family", "impeka-wpb-extension" ),
				"param_name" => "custom_font_family",
				"value" => array(
					esc_html__( "Same as Typography", "impeka-wpb-extension" ) => '',
					esc_html__( "Custom Font Family 1", "impeka-wpb-extension" ) => 'custom-font-1',
					esc_html__( "Custom Font Family 2", "impeka-wpb-extension" ) => 'custom-font-2',
					esc_html__( "Custom Font Family 3", "impeka-wpb-extension" ) => 'custom-font-3',
					esc_html__( "Custom Font Family 4", "impeka-wpb-extension" ) => 'custom-font-4',

				),
				"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "impeka-wpb-extension" ),
				"std" => $std,
				"group" => esc_html__( "Titles & Styles", "impeka-wpb-extension" ),
			);
		}
	}

	function impeka_grve_rc_style_params( $tag = 'vc_row' ) {

		vc_add_param( $tag,
			array(
				"type" => 'impeka_param_label',
				"heading" => esc_html__( "Colors Settings", "impeka-wpb-extension"),
				"param_name" => "label_color_settings",
				'value' => '',
				"std" => '',
				"description" => esc_html__( "Define your color preference for fonts, headings, links.", "impeka-wpb-extension" ),
				'group' => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "colorpicker",
				"heading" => esc_html__('Font Color', "impeka-wpb-extension" ),
				"param_name" => "rc_font_color",
				"description" => esc_html__("Select font color", "impeka-wpb-extension" ),
				'edit_field_class' => 'vc_col-sm-6',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Heading Color", "impeka-wpb-extension" ),
				"param_name" => "rc_heading_color",
				"param_holder_class" => "grve-colored-dropdown",
				"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
				"std" => 'default',
				"description" => esc_html__( "Select heading color", "impeka-wpb-extension" ),
				'edit_field_class' => 'vc_col-sm-6',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Link Color", "impeka-wpb-extension" ),
				"param_name" => "rc_link_color",
				"param_holder_class" => "grve-colored-dropdown",
				"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard', 'inherit'] ),
				"std" => 'default',
				"description" => esc_html__( "Select link color", "impeka-wpb-extension" ),
				'edit_field_class' => 'vc_col-sm-6',
				'group' => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Link Hover Color", "impeka-wpb-extension" ),
				"param_name" => "rc_link_hover_color",
				"param_holder_class" => "grve-colored-dropdown",
				"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
				"std" => 'default',
				"description" => esc_html__( "Select link hover color", "impeka-wpb-extension" ),
				'edit_field_class' => 'vc_col-sm-6',
				'group' => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => 'dropdown',
				"heading" => esc_html__( "Background Type", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_type",
				"description" => esc_html__( "Select Background type", "impeka-wpb-extension" ),
				"value" => array(
					esc_html__( "None", "impeka-wpb-extension" ) => '',
					esc_html__( "Color", "impeka-wpb-extension" ) => 'color',
					esc_html__( "Gradient Color", "impeka-wpb-extension" ) => 'gradient',
					esc_html__( "Animated Color", "impeka-wpb-extension" ) => 'animated-color',
					esc_html__( "Image", "impeka-wpb-extension" ) => 'image',
					esc_html__( "Hosted Video", "impeka-wpb-extension" ) => 'hosted_video',
					esc_html__( "YouTube/Vimeo Video", "impeka-wpb-extension" ) => 'video',
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'YouTube/Vimeo link', "impeka-wpb-extension" ),
				'param_name' => 'rc_bg_video_url',
				'value' => 'https://www.youtube.com/watch?v=0s4_7BuszuQ',
				// default video url
				'description' => esc_html__( 'Add YouTube/Vimeo link.', "impeka-wpb-extension" ),
				'dependency' => array(
					'element' => 'rc_bg_type',
					'value' => 'video',
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Video Popup Button", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_video_button",
				"value" => array(
					esc_html__( 'None', "impeka-wpb-extension" ) => '',
					esc_html__( 'Devices only', "impeka-wpb-extension" ) => 'device',
					esc_html__( 'Always visible', "impeka-wpb-extension" ) => 'all',
				),
				"description" => esc_html__( "Select video popup button behavior", "impeka-wpb-extension" ),
				'dependency' => array(
					'element' => 'rc_bg_type',
					'value' => 'video',
				),
				"std" => '',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Video Button Position", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_video_button_position",
				"value" => array(
					esc_html__( 'Left Top', "impeka-wpb-extension" ) => 'left-top',
					esc_html__( 'Left Bottom', "impeka-wpb-extension" ) => 'left-bottom',
					esc_html__( 'Center Center', "impeka-wpb-extension" ) => 'center-center',
					esc_html__( 'Right Top', "impeka-wpb-extension" ) => 'right-top',
					esc_html__( 'Right Bottom', "impeka-wpb-extension" ) => 'right-bottom',
				),
				"description" => esc_html__( "Select position for video popup", "impeka-wpb-extension" ),
				'dependency' => array(
					'element' => 'rc_bg_video_button',
					'value_not_equal_to' => array( '' )
				),
				"std" => 'center-center',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "colorpicker",
				"heading" => esc_html__( "Custom Background Color", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_color",
				"description" => esc_html__( "Select background color", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'color', 'image', 'hosted_video', 'video' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "colorpicker",
				"heading" => esc_html__( "Custom Color 1", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_gradient_color_1",
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'gradient' )
				),
				"std" => 'rgba(3,78,144,1)',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "colorpicker",
				"heading" => esc_html__( "Custom Color 2", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_gradient_color_2",
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'gradient' )
				),
				"std" => 'rgba(25,180,215,1)',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Gradient Direction", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_gradient_direction",
				"value" => array(
					esc_html__( "Left to Right", "impeka-wpb-extension" ) => '90',
					esc_html__( "Left Top to Right Bottom", "impeka-wpb-extension" ) => '135',
					esc_html__( "Left Bottom to Right Top", "impeka-wpb-extension" ) => '45',
					esc_html__( "Bottom to Top", "impeka-wpb-extension" ) => '180',
				),
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'gradient' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "colorpicker",
				"heading" => esc_html__( "Animated Color 1", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_animated_color_1",
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'animated-color' )
				),
				"std" => 'rgba(3,78,144,1)',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "colorpicker",
				"heading" => esc_html__( "Animated Color 2", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_animated_color_2",
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'animated-color' )
				),
				"std" => 'rgba(25,180,215,1)',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "attach_image",
				"heading" => esc_html__('Background Image', "impeka-wpb-extension" ),
				"param_name" => "rc_bg_image",
				"value" => '',
				"description" => esc_html__("Select background image. Used also as fallback for video.", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'image', 'hosted_video', 'video' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Background Image Type", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_image_type",
				"value" => array(
					esc_html__( "Default", "impeka-wpb-extension" ) => '',
					esc_html__( "Parallax", "impeka-wpb-extension" ) => 'parallax',
					esc_html__( "Horizontal Parallax Left to Right", "impeka-wpb-extension" ) => 'horizontal-parallax-lr',
					esc_html__( "Horizontal Parallax Right to Left", "impeka-wpb-extension" ) => 'horizontal-parallax-rl',
					esc_html__( "Animated", "impeka-wpb-extension" ) => 'animated',
					esc_html__( "Horizontal Animation", "impeka-wpb-extension" ) => 'horizontal',
					esc_html__( "Fixed Image", "impeka-wpb-extension" ) => 'fixed',
					esc_html__( "Image usage as Pattern", "impeka-wpb-extension" ) => 'pattern'
				),
				"description" => esc_html__( "Select how a background image will be displayed", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'image' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Background Image Size", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_image_size",
				"value" => array(
					esc_html__( "--Inherit--", "impeka-wpb-extension" ) => '',
					esc_html__( "Responsive", "impeka-wpb-extension" ) => 'responsive',
					esc_html__( "Extra Extra Large", "impeka-wpb-extension" ) => 'extra-extra-large',
					esc_html__( "Full", "impeka-wpb-extension" ) => 'full',
				),
				"description" => esc_html__( "Select the size of your background image", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'image' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Background Image Vertical Position", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_image_vertical_position",
				"value" => array(
					esc_html__( "Top", "impeka-wpb-extension" ) => 'top',
					esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
					esc_html__( "Bottom", "impeka-wpb-extension" ) => 'bottom',
				),
				"description" => esc_html__( "Select vertical position for background image", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_image_type',
					'value' => array( 'horizontal-parallax-lr', 'horizontal-parallax-rl', 'horizontal' )
				),
				"std" => 'center',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Background  Position", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_position",
				"value" => array(
					esc_html__( 'Left Top', "impeka-wpb-extension" ) => 'left-top',
					esc_html__( 'Left Center', "impeka-wpb-extension" ) => 'left-center',
					esc_html__( 'Left Bottom', "impeka-wpb-extension" ) => 'left-bottom',
					esc_html__( 'Center Top', "impeka-wpb-extension" ) => 'center-top',
					esc_html__( 'Center Center', "impeka-wpb-extension" ) => 'center-center',
					esc_html__( 'Center Bottom', "impeka-wpb-extension" ) => 'center-bottom',
					esc_html__( 'Right Top', "impeka-wpb-extension" ) => 'right-top',
					esc_html__( 'Right Center', "impeka-wpb-extension" ) => 'right-center',
					esc_html__( 'Right Bottom', "impeka-wpb-extension" ) => 'right-bottom',
				),
				"description" => esc_html__( "Select position for background image", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_image_type',
					'value' => array( '', 'animated' )
				),
				"std" => 'center-center',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Background Position ( Tablet Portrait )", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_tablet_sm_position",
				"value" => array(
					esc_html__( 'Inherit from above', "impeka-wpb-extension" ) => '',
					esc_html__( 'Left Top', "impeka-wpb-extension" ) => 'left-top',
					esc_html__( 'Left Center', "impeka-wpb-extension" ) => 'left-center',
					esc_html__( 'Left Bottom', "impeka-wpb-extension" ) => 'left-bottom',
					esc_html__( 'Center Top', "impeka-wpb-extension" ) => 'center-top',
					esc_html__( 'Center Center', "impeka-wpb-extension" ) => 'center-center',
					esc_html__( 'Center Bottom', "impeka-wpb-extension" ) => 'center-bottom',
					esc_html__( 'Right Top', "impeka-wpb-extension" ) => 'right-top',
					esc_html__( 'Right Center', "impeka-wpb-extension" ) => 'right-center',
					esc_html__( 'Right Bottom', "impeka-wpb-extension" ) => 'right-bottom',
				),
				"description" => esc_html__( "Tablet devices with portrait orientation and below.", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_image_type',
					'value' => array( '', 'animated' )
				),
				"std" => '',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Parallax Sensor", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_parallax_threshold",
				"value" => array(
					esc_html__( "Low", "impeka-wpb-extension" ) => '0.1',
					esc_html__( "Normal", "impeka-wpb-extension" ) => '0.3',
					esc_html__( "High", "impeka-wpb-extension" ) => '0.5',
					esc_html__( "Max", "impeka-wpb-extension" ) => '0.8',
				),
				"description" => esc_html__( "Define the appearance for the parallax effect. Note that you get greater image zoom when you increase the parallax sensor.", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_image_type',
					'value' => array( 'parallax', 'horizontal-parallax-lr', 'horizontal-parallax-rl' )
				),
				"std" => '0.3',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "textfield",
				"heading" => esc_html__("WebM File URL", "impeka-wpb-extension"),
				"param_name" => "rc_bg_video_webm",
				"description" => esc_html__( "Fill WebM and mp4 format for browser compatibility", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'hosted_video' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "textfield",
				"heading" => esc_html__( "MP4 File URL", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_video_mp4",
				"description" => esc_html__( "Fill mp4 format URL", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'hosted_video' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "textfield",
				"heading" => esc_html__( "OGV File URL", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_video_ogv",
				"description" => esc_html__( "Fill OGV format URL ( optional )", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'hosted_video' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Loop", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_video_loop",
				"value" => array(
					esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					esc_html__( "No", "impeka-wpb-extension" ) => 'no',
				),
				"std" => 'yes',
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'hosted_video' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Allow on devices", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_video_device",
				"value" => array(
					esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',

				),
				"std" => 'no',
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'hosted_video' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => 'checkbox',
				"heading" => esc_html__( "Pattern overlay", "impeka-wpb-extension"),
				"param_name" => "rc_bg_pattern_overlay",
				"description" => esc_html__( "If selected, a pattern will be added.", "impeka-wpb-extension" ),
				"value" => Array(esc_html__( "Add pattern", "impeka-wpb-extension" ) => 'yes'),
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'image', 'hosted_video', 'video' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);
		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Color overlay", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_color_overlay",
				"param_holder_class" => "grve-colored-dropdown",
				"value" => impeka_wpb_ext_get_color_array( ['none', 'primary', 'black-white', 'custom', 'single-gradient'] ),
				"std" => 'none',
				"dependency" => array(
					'element' => 'rc_bg_type',
					'value' => array( 'image', 'hosted_video', 'video' )
				),
				"description" => esc_html__( "A color overlay for the media", "impeka-wpb-extension" ),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "colorpicker",
				"heading" => esc_html__('Custom Color Overlay', "impeka-wpb-extension" ),
				"param_name" => "rc_bg_color_overlay_custom",
				"dependency" => array(
					'element' => 'rc_bg_color_overlay',
					'value' => array( 'custom' )
				),
				"std" => 'rgba(255,255,255,0.1)',
				"description" => esc_html__("Select custom color overlay", "impeka-wpb-extension" ),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "colorpicker",
				"heading" => esc_html__('Gradient Color Overlay 1', "impeka-wpb-extension" ),
				"param_name" => "rc_bg_gradient_overlay_custom_1",
				"dependency" => array(
					'element' => 'rc_bg_color_overlay',
					'value' => array( 'gradient' )
				),
				"std" => 'rgba(3,78,144,0.9)',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "colorpicker",
				"heading" => esc_html__('Gradient Color Overlay 2', "impeka-wpb-extension" ),
				"param_name" => "rc_bg_gradient_overlay_custom_2",
				"dependency" => array(
					'element' => 'rc_bg_color_overlay',
					'value' => array( 'gradient' )
				),
				"std" => 'rgba(25,180,215,0.9)',
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Gradient Direction", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_gradient_overlay_direction",
				"value" => array(
					esc_html__( "Left to Right", "impeka-wpb-extension" ) => '90',
					esc_html__( "Left Top to Right Bottom", "impeka-wpb-extension" ) => '135',
					esc_html__( "Left Bottom to Right Top", "impeka-wpb-extension" ) => '45',
					esc_html__( "Bottom to Top", "impeka-wpb-extension" ) => '180',
				),
				"dependency" => array(
					'element' => 'rc_bg_color_overlay',
					'value' => array( 'gradient' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Opacity overlay", "impeka-wpb-extension" ),
				"param_name" => "rc_bg_opacity_overlay",
				"value" => array(
					esc_html__( "10%", "impeka-wpb-extension" ) => '10',
					esc_html__( "20%", "impeka-wpb-extension" ) => '20',
					esc_html__( "30%", "impeka-wpb-extension" ) => '30',
					esc_html__( "40%", "impeka-wpb-extension" ) => '40',
					esc_html__( "50%", "impeka-wpb-extension" ) => '50',
					esc_html__( "60%", "impeka-wpb-extension" ) => '60',
					esc_html__( "70%", "impeka-wpb-extension" ) => '70',
					esc_html__( "80%", "impeka-wpb-extension" ) => '80',
					esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				),
				"description" => esc_html__( "Opacity of the overlay", "impeka-wpb-extension" ),
				"dependency" => array(
					'element' => 'rc_bg_color_overlay',
					'value_not_equal_to' => array( '', 'custom', 'gradient' )
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

		vc_add_param( $tag,
			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension" ),
				"param_name" => "rc_add_shadow",
				"value" => array(
					esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					esc_html__( "Small Shadow", "impeka-wpb-extension" ) => 'small-shadow',
					esc_html__( "Medium Shadow", "impeka-wpb-extension" ) => 'medium-shadow',
					esc_html__( "Large Shadow", "impeka-wpb-extension" ) => 'large-shadow',
				),
				"group" => esc_html__( "Style", "impeka-wpb-extension" ),
			)
		);

	}


	vc_add_param('vc_tta_tabs', impeka_grve_get_heading_tag('h3') );
	vc_add_param('vc_tta_tabs', impeka_grve_get_heading('h6') );
	vc_add_param('vc_tta_tabs', impeka_grve_get_custom_font_family() );
	vc_add_param( "vc_tta_tabs",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Go to Top", 'impeka-wpb-extension' ),
			"param_name" => "tab_go_top",
			"value" => array(
				esc_html__( "No", 'impeka-wpb-extension' ) => 'no',
				esc_html__( "Yes", 'impeka-wpb-extension' ) => 'yes',
			),
			"description" => esc_html__( "Animate tabs to the top of the screen after clicking.", 'impeka-wpb-extension' ),
			"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_tta_tabs",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Responsive Behavior", 'impeka-wpb-extension' ),
			"param_name" => "tab_collapse_all",
			"value" => array(
				esc_html__( "No", 'impeka-wpb-extension' ) => 'no',
				esc_html__( "Yes", 'impeka-wpb-extension' ) => 'yes',
			),
			"description" => esc_html__( "Select if you want to allow collapse all tabs (switches in accordion on mobile).", 'impeka-wpb-extension' ),
			"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
		)
	);
	vc_add_param('vc_tta_tour', impeka_grve_get_heading_tag('h3') );
	vc_add_param('vc_tta_tour', impeka_grve_get_heading('h6') );
	vc_add_param('vc_tta_tour', impeka_grve_get_custom_font_family() );
	vc_add_param( "vc_tta_tour",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Go to Top", 'impeka-wpb-extension' ),
			"param_name" => "tab_go_top",
			"value" => array(
				esc_html__( "No", 'impeka-wpb-extension' ) => 'no',
				esc_html__( "Yes", 'impeka-wpb-extension' ) => 'yes',
			),
			"description" => esc_html__( "Animate tabs to the top of the screen after clicking.", 'impeka-wpb-extension' ),
			"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_tta_tour",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Responsive Behavior", 'impeka-wpb-extension' ),
			"param_name" => "tab_collapse_all",
			"value" => array(
				esc_html__( "No", 'impeka-wpb-extension' ) => 'no',
				esc_html__( "Yes", 'impeka-wpb-extension' ) => 'yes',
			),
			"description" => esc_html__( "Select if you want to allow collapse all tabs (switches in accordion on mobile).", 'impeka-wpb-extension' ),
			"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
		)
	);
	vc_add_param('vc_tta_accordion', impeka_grve_get_heading_tag('h3') );
	vc_add_param('vc_tta_accordion', impeka_grve_get_heading('h6') );
	vc_add_param('vc_tta_accordion', impeka_grve_get_custom_font_family() );
	vc_add_param('vc_tta_accordion',
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Go to Top", 'impeka-wpb-extension' ),
			"param_name" => "accordion_go_top",
			"value" => array(
				esc_html__( "No", 'impeka-wpb-extension' ) => 'no',
				esc_html__( "Yes", 'impeka-wpb-extension' ) => 'yes',
			),
			"description" => esc_html__( "Animate accordion to the top of the screen after clicking.", 'impeka-wpb-extension' ),
			"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Row Type", "impeka-wpb-extension" ),
			"param_name" => "section_type",
			"value" => array(
				esc_html__( "Full Width Background", "impeka-wpb-extension" ) => 'fullwidth-background',
				esc_html__( "Full Width Content", "impeka-wpb-extension" ) => 'fullwidth',
				esc_html__( "Container Width", "impeka-wpb-extension" ) => 'container-width',
			),
			"description" => esc_html__( "Select row type", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Row Height", "impeka-wpb-extension" ),
			"param_name" => "height_ratio",
			"value" => array(
				esc_html__( "Auto", "impeka-wpb-extension" ) => 'auto',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"description" => esc_html__( "Select your row height", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Top padding", "impeka-wpb-extension" ),
			"param_name" => "padding_top_multiplier",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => '',
				esc_html__( "1x", "impeka-wpb-extension" ) => '1x',
				esc_html__( "2x", "impeka-wpb-extension" ) => '2x',
				esc_html__( "3x", "impeka-wpb-extension" ) => '3x',
				esc_html__( "4x", "impeka-wpb-extension" ) => '4x',
				esc_html__( "5x", "impeka-wpb-extension" ) => '5x',
				esc_html__( "6x", "impeka-wpb-extension" ) => '6x',
				esc_html__( "Custom", "impeka-wpb-extension" ) => 'custom',
			),
			"std" => '1x',
			"description" => esc_html__( "Select padding top for your section.", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Custom Top padding", "impeka-wpb-extension" ),
			"param_name" => "padding_top",
			"dependency" => array(
				'element' => 'padding_top_multiplier',
				'value' => array( 'custom' )
			),
			"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Bottom padding", "impeka-wpb-extension" ),
			"param_name" => "padding_bottom_multiplier",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => '',
				esc_html__( "1x", "impeka-wpb-extension" ) => '1x',
				esc_html__( "2x", "impeka-wpb-extension" ) => '2x',
				esc_html__( "3x", "impeka-wpb-extension" ) => '3x',
				esc_html__( "4x", "impeka-wpb-extension" ) => '4x',
				esc_html__( "5x", "impeka-wpb-extension" ) => '5x',
				esc_html__( "6x", "impeka-wpb-extension" ) => '6x',
				esc_html__( "Custom", "impeka-wpb-extension" ) => 'custom',
			),
			"std" => '1x',
			"description" => esc_html__( "Select padding bottom for your section.", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Custom Bottom padding", "impeka-wpb-extension" ),
			"param_name" => "padding_bottom",
			"dependency" => array(
				'element' => 'padding_bottom_multiplier',
				'value' => array( 'custom' )
			),
			"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
		"type" => "textfield",
		"heading" => esc_html__( 'Bottom margin', "impeka-wpb-extension" ),
		"param_name" => "rc_margin_bottom",
		"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Disable row', 'impeka-wpb-extension' ),
			'param_name' => 'disable_element',
			'description' => esc_html__( 'If checked the row won\'t be visible on the public side of your website. You can switch it back any time.', 'impeka-wpb-extension' ),
			'value' => array( esc_html__( 'Yes', 'impeka-wpb-extension' ) => 'yes' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__('Section ID', "impeka-wpb-extension" ),
			"param_name" => "section_id",
			"description" => esc_html__("If you wish you can type an id to use it as bookmark.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row", $impeka_grve_add_el_class );
	vc_add_param( "vc_row", $impeka_grve_add_el_wrapper_class );

	impeka_grve_rc_style_params( "vc_row" );

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "On Scroll Effect", "impeka-wpb-extension" ),
			"param_name" => "rc_bg_image_scroll_effect",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => '',
				esc_html__( "Hide/Show Background on Scroll", "impeka-wpb-extension" ) => 'opacity-scroll-effect',
			),
			"description" => esc_html__( "Select how the row background will be displayed on scroll", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"group" => esc_html__( "Style", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Initial Opacity", "impeka-wpb-extension" ),
			"param_name" => "rc_bg_image_initial_opacity",
			'edit_field_class' => 'vc_col-sm-6',
			"value" => array(
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
				esc_html__( "95%", "impeka-wpb-extension" ) => '95',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "85%", "impeka-wpb-extension" ) => '85',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "75%", "impeka-wpb-extension" ) => '75',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "65%", "impeka-wpb-extension" ) => '65',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "55%", "impeka-wpb-extension" ) => '55',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "45%", "impeka-wpb-extension" ) => '45',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "35%", "impeka-wpb-extension" ) => '35',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "25%", "impeka-wpb-extension" ) => '25',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "15%", "impeka-wpb-extension" ) => '15',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "0", "impeka-wpb-extension" ) => '0',
			),
			"description" => esc_html__( "Define the opacity background at first", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'rc_bg_image_scroll_effect',
				'value' => array( 'opacity-scroll-effect' )
			),
			"std" => '100',
			"group" => esc_html__( "Style", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Final Opacity", "impeka-wpb-extension" ),
			"param_name" => "rc_bg_image_final_opacity",
			'edit_field_class' => 'vc_col-sm-6',
			"value" => array(
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
				esc_html__( "95%", "impeka-wpb-extension" ) => '95',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "85%", "impeka-wpb-extension" ) => '85',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "75%", "impeka-wpb-extension" ) => '75',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "65%", "impeka-wpb-extension" ) => '65',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "55%", "impeka-wpb-extension" ) => '55',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "45%", "impeka-wpb-extension" ) => '45',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "35%", "impeka-wpb-extension" ) => '35',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "25%", "impeka-wpb-extension" ) => '25',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "15%", "impeka-wpb-extension" ) => '15',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "0", "impeka-wpb-extension" ) => '0',
			),
			"description" => esc_html__( "Define the opacity background at last", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'rc_bg_image_scroll_effect',
				'value' => array( 'opacity-scroll-effect' )
			),
			"std" => '0',
			"group" => esc_html__( "Style", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Scroll Effect Offset", "impeka-wpb-extension" ),
			"param_name" => "rc_bg_image_scroll_effect_offset",
			"value" => array(
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
			),
			"description" => esc_html__( "Define the offset for the scroll effect.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'rc_bg_image_scroll_effect',
				'value' => array( 'opacity-scroll-effect' )
			),
			"std" => '50',
			"group" => esc_html__( "Style", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Columns Gap", "impeka-wpb-extension" ),
			"param_name" => "columns_gap",
			'value' => $impeka_grve_column_gap_list,
			"description" => esc_html__( "Select gap between columns in row.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Inner Columns", "impeka-wpb-extension" ),
			"std" => 'default',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Equal Column Height", "impeka-wpb-extension" ),
			"param_name" => "equal_column_height",
			"description" => esc_html__( "Select if you need the same height for the columns of this row. Recommended for multiple columns with different background colors.", "impeka-wpb-extension" ),
			"value" => Array(esc_html__( "Equal Height Columns", "impeka-wpb-extension" ) => 'equal'),
			"group" => esc_html__( "Inner Columns", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Reverse columns in RTL', "impeka-wpb-extension" ),
			'param_name' => 'rtl_reverse',
			'description' => esc_html__( 'If checked columns will be reversed in RTL.', "impeka-wpb-extension" ),
			'value' => array( esc_html__( 'Yes', "impeka-wpb-extension" ) => 'yes' ),
			"group" => esc_html__( "Inner Columns", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Visibility", "impeka-wpb-extension"),
			"param_name" => "label_visibility",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "If selected, row will be hidden on desktops/laptops and devices.", "impeka-wpb-extension" ),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Desktop Visibility", "impeka-wpb-extension"),
			"param_name" => "desktop_visibility",
			"value" => Array(esc_html__( "Hide", "impeka-wpb-extension" ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Tablet Landscape Visibility", "impeka-wpb-extension"),
			"param_name" => "tablet_visibility",
			"value" => Array(esc_html__( "Hide", "impeka-wpb-extension" ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Tablet Portrait Visibility", "impeka-wpb-extension"),
			"param_name" => "tablet_sm_visibility",
			"value" => Array(esc_html__( "Hide", "impeka-wpb-extension" ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Mobile Visibility", "impeka-wpb-extension"),
			"param_name" => "mobile_visibility",
			"value" => Array(esc_html__( "Hide", "impeka-wpb-extension" ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Columns Vertical Gap", "impeka-wpb-extension"),
			"param_name" => "label_columns_vertical_gap",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Select the vertical gap for the columns of this row on Tablets (Landscape, Portrait) and mobiles. This will affect once the columns have 100% width ( 1/1 ).", "impeka-wpb-extension" ),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_columns_vertical_gap",
			'value' => $impeka_grve_column_vertical_gap_list,
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			"std" => 'none',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_sm_columns_vertical_gap",
			'value' => $impeka_grve_column_vertical_gap_list,
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			"std" => 'none',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_columns_vertical_gap",
			'value' => $impeka_grve_column_vertical_gap_list,
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			"std" => '30',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Equal Column Height", "impeka-wpb-extension"),
			"param_name" => "label_equal_column_height",
			"description" => esc_html__( "Select if you wish to keep or disable the Equal Column Height.", "impeka-wpb-extension" ),
			'value' => '',
			"std" => '',
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_landscape_equal_column_height",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "None", "impeka-wpb-extension" ) => 'false',
			),
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_portrait_equal_column_height",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "None", "impeka-wpb-extension" ) => 'false',
			),
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Row Height", "impeka-wpb-extension"),
			"param_name" => "label_height_ratio",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Select if you wish to keep or disable the Row height.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_height_ratio",
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
				esc_html__( "Auto", "impeka-wpb-extension" ) => '0',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_sm_height_ratio",
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
				esc_html__( "Auto", "impeka-wpb-extension" ) => '0',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"std" => 'inherit',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_height_ratio",
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
				esc_html__( "Auto", "impeka-wpb-extension" ) => '0',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"std" => 'inherit',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Top Separator", "impeka-wpb-extension" ),
			"param_name" => "separator_top",
			"description" => esc_html__( "Select Top Separator type", "impeka-wpb-extension" ),
			"value" => $impeka_grve_separator_list,
			"group" => esc_html__( "Separators", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Top Separator Size", "impeka-wpb-extension" ),
			"param_name" => "separator_top_size",
			"description" => esc_html__( "Select Top Separator size", "impeka-wpb-extension" ),
			"value" => $impeka_grve_separator_size_list,
			"std" => '90px',
			"dependency" => array(
				'element' => 'separator_top',
				'value_not_equal_to' => array( '' )
			),
			"group" => esc_html__( "Separators", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Top Separator Color', "impeka-wpb-extension" ),
			"param_name" => "separator_top_color",
			"dependency" => array(
				'element' => 'separator_top',
				'value_not_equal_to' => array( '' )
			),
			"std" => '#ffffff',
			"description" => esc_html__("Select top separator color", "impeka-wpb-extension" ),
			"group" => esc_html__( "Separators", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Hide Separator", "impeka-wpb-extension" ),
			"param_name" => "separator_top_hide",
			"value" => array(
				esc_html__( "Never", "impeka-wpb-extension" ) => '',
				esc_html__( "on Tablet Landscape and below", "impeka-wpb-extension" ) => 'tablet',
				esc_html__( "on Tablet Portrait and below", "impeka-wpb-extension" ) => 'tablet-sm',
				esc_html__( "on Mobile Ladscape and below", "impeka-wpb-extension" ) => 'mobile',
			),
			"description" => esc_html__( "Select if you want to hide the top separator in some devices.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'separator_top',
				'value_not_equal_to' => array( '' )
			),
			"group" => esc_html__( "Separators", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__('Top Separator z-index', "impeka-wpb-extension" ),
			"param_name" => "separator_top_z_index",
			"dependency" => array(
				'element' => 'separator_top',
				'value_not_equal_to' => array( '' )
			),
			"std" => '0',
			"description" => esc_html__("Enter top separator z-index", "impeka-wpb-extension" ),
			"group" => esc_html__( "Separators", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Bottom Separator", "impeka-wpb-extension" ),
			"param_name" => "separator_bottom",
			"description" => esc_html__( "Select Bottom Separator type", "impeka-wpb-extension" ),
			"value" => $impeka_grve_separator_list,
			"group" => esc_html__( "Separators", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Bottom Separator Size", "impeka-wpb-extension" ),
			"param_name" => "separator_bottom_size",
			"description" => esc_html__( "Select Bottom Separator size", "impeka-wpb-extension" ),
			"value" => $impeka_grve_separator_size_list,
			"std" => '90px',
			"dependency" => array(
				'element' => 'separator_bottom',
				'value_not_equal_to' => array( '' )
			),
			"group" => esc_html__( "Separators", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Bottom Separator Color', "impeka-wpb-extension" ),
			"param_name" => "separator_bottom_color",
			"dependency" => array(
				'element' => 'separator_bottom',
				'value_not_equal_to' => array( '' )
			),
			"std" => '#ffffff',
			"description" => esc_html__("Select bottom separator color", "impeka-wpb-extension" ),
			"group" => esc_html__( "Separators", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Hide Separator", "impeka-wpb-extension" ),
			"param_name" => "separator_bottom_hide",
			"value" => array(
				esc_html__( "Never", "impeka-wpb-extension" ) => '',
				esc_html__( "on Tablet Landscape and below", "impeka-wpb-extension" ) => 'tablet',
				esc_html__( "on Tablet Portrait and below", "impeka-wpb-extension" ) => 'tablet-sm',
				esc_html__( "on Mobile Ladscape and below", "impeka-wpb-extension" ) => 'mobile',
			),
			"description" => esc_html__( "Select if you want to hide the bottom separator in some devices.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'separator_bottom',
				'value_not_equal_to' => array( '' )
			),
			"group" => esc_html__( "Separators", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__('Bottom Separator z-index', "impeka-wpb-extension" ),
			"param_name" => "separator_bottom_z_index",
			"dependency" => array(
				'element' => 'separator_bottom',
				'value_not_equal_to' => array( '' )
			),
			"std" => '0',
			"description" => esc_html__("Enter bottom separator z-index", "impeka-wpb-extension" ),
			"group" => esc_html__( "Separators", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Scrolling Section Options", "impeka-wpb-extension"),
			"param_name" => "label_scrolling_section",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Used only with Scrolling Full Screen Sections and Section Navigation templates.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Scrolling Options", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Header Skin", "impeka-wpb-extension" ),
			"param_name" => "scroll_header_skin",
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
				esc_html__( "Dark", "impeka-wpb-extension" ) => 'dark',
				esc_html__( "Light", "impeka-wpb-extension" ) => 'light',
				esc_html__( "Default", "impeka-wpb-extension" ) => 'default',
			),
			"std" => 'inherit',
			"description" => esc_html__( "Select header skin", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			"group" => esc_html__( "Scrolling Options", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__('Scrolling Section Title', "impeka-wpb-extension" ),
			"param_name" => "scroll_section_title",
			"description" => esc_html__("If you wish you can type a title for the side dot navigation.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			"group" => esc_html__( "Scrolling Options", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Row Height", "impeka-wpb-extension" ),
			"param_name" => "height_ratio",
			"value" => array(
				esc_html__( "Auto", "impeka-wpb-extension" ) => 'auto',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"description" => esc_html__( "Select your row height", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Top padding", "impeka-wpb-extension" ),
			"param_name" => "padding_top_multiplier",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => '',
				esc_html__( "1x", "impeka-wpb-extension" ) => '1x',
				esc_html__( "2x", "impeka-wpb-extension" ) => '2x',
				esc_html__( "3x", "impeka-wpb-extension" ) => '3x',
				esc_html__( "4x", "impeka-wpb-extension" ) => '4x',
				esc_html__( "5x", "impeka-wpb-extension" ) => '5x',
				esc_html__( "6x", "impeka-wpb-extension" ) => '6x',
				esc_html__( "Custom", "impeka-wpb-extension" ) => 'custom',
			),
			"description" => esc_html__( "Select padding top for your section.", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Custom Top padding", "impeka-wpb-extension" ),
			"param_name" => "padding_top",
			"dependency" => array(
				'element' => 'padding_top_multiplier',
				'value' => array( 'custom' )
			),
			"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Bottom padding", "impeka-wpb-extension" ),
			"param_name" => "padding_bottom_multiplier",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => '',
				esc_html__( "1x", "impeka-wpb-extension" ) => '1x',
				esc_html__( "2x", "impeka-wpb-extension" ) => '2x',
				esc_html__( "3x", "impeka-wpb-extension" ) => '3x',
				esc_html__( "4x", "impeka-wpb-extension" ) => '4x',
				esc_html__( "5x", "impeka-wpb-extension" ) => '5x',
				esc_html__( "6x", "impeka-wpb-extension" ) => '6x',
				esc_html__( "Custom", "impeka-wpb-extension" ) => 'custom',
			),
			"description" => esc_html__( "Select padding bottom for your section.", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Custom Bottom padding", "impeka-wpb-extension" ),
			"param_name" => "padding_bottom",
			"dependency" => array(
				'element' => 'padding_bottom_multiplier',
				'value' => array( 'custom' )
			),
			"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
		"type" => "textfield",
		"heading" => esc_html__( 'Bottom margin', "impeka-wpb-extension" ),
		"param_name" => "rc_margin_bottom",
		"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Disable row', 'impeka-wpb-extension' ),
			'param_name' => 'disable_element',
			'description' => esc_html__( 'If checked the row won\'t be visible on the public side of your website. You can switch it back any time.', 'impeka-wpb-extension' ),
			'value' => array( esc_html__( 'Yes', 'impeka-wpb-extension' ) => 'yes' ),
		)
	);

	vc_add_param( "vc_row_inner", $impeka_grve_add_el_id );
	vc_add_param( "vc_row_inner", $impeka_grve_add_el_class );
	vc_add_param( "vc_row_inner", $impeka_grve_add_el_wrapper_class );

	impeka_grve_rc_style_params( "vc_row_inner" );

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Columns Gap", "impeka-wpb-extension" ),
			"param_name" => "columns_gap",
			'value' => $impeka_grve_column_gap_list,
			"description" => esc_html__( "Select gap between columns in row.", "impeka-wpb-extension" ),
			"group" => esc_html__( "Inner Columns", "impeka-wpb-extension" ),
			"std" => 'default',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Equal Column Height", "impeka-wpb-extension" ),
			"param_name" => "equal_column_height",
			"description" => esc_html__( "Select if you need the same height for the columns of this row. Recommended for multiple columns with different background colors.", "impeka-wpb-extension" ),
			"value" => Array(esc_html__( "Equal Height Columns", "impeka-wpb-extension" ) => 'equal'),
			"group" => esc_html__( "Inner Columns", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Reverse columns in RTL', "impeka-wpb-extension" ),
			'param_name' => 'rtl_reverse',
			'description' => esc_html__( 'If checked columns will be reversed in RTL.', "impeka-wpb-extension" ),
			'value' => array( esc_html__( 'Yes', "impeka-wpb-extension" ) => 'yes' ),
			"group" => esc_html__( "Inner Columns", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Visibility", "impeka-wpb-extension"),
			"param_name" => "label_visibility",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "If selected, row will be hidden on desktops/laptops and devices.", "impeka-wpb-extension" ),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Desktop Visibility", "impeka-wpb-extension"),
			"param_name" => "desktop_visibility",
			"value" => Array(esc_html__( "Hide", "impeka-wpb-extension" ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Tablet Landscape Visibility", "impeka-wpb-extension"),
			"param_name" => "tablet_visibility",
			"value" => Array(esc_html__( "Hide", "impeka-wpb-extension" ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Tablet Portrait Visibility", "impeka-wpb-extension"),
			"param_name" => "tablet_sm_visibility",
			"value" => Array(esc_html__( "Hide", "impeka-wpb-extension" ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Mobile Visibility", "impeka-wpb-extension"),
			"param_name" => "mobile_visibility",
			"value" => Array(esc_html__( "Hide", "impeka-wpb-extension" ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Columns Vertical Gap", "impeka-wpb-extension"),
			"param_name" => "label_columns_vertical_gap",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Select the vertical gap for the columns of this row on Tablets (Landscape, Portrait) and mobiles. This will affect once the columns have 100% width ( 1/1 ).", "impeka-wpb-extension" ),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_columns_vertical_gap",
			'value' => $impeka_grve_column_vertical_gap_list,
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			"std" => 'none',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_sm_columns_vertical_gap",
			'value' => $impeka_grve_column_vertical_gap_list,
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			"std" => 'none',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_columns_vertical_gap",
			'value' => $impeka_grve_column_vertical_gap_list,
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			"std" => '30',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Equal Column Height", "impeka-wpb-extension"),
			"param_name" => "label_equal_column_height",
			"description" => esc_html__( "Select if you wish to keep or disable the Equal Column Height.", "impeka-wpb-extension" ),
			'value' => '',
			"std" => '',
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_landscape_equal_column_height",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "None", "impeka-wpb-extension" ) => 'false',
			),
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_portrait_equal_column_height",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "None", "impeka-wpb-extension" ) => 'false',
			),
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Row Height", "impeka-wpb-extension"),
			"param_name" => "label_height_ratio",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Select if you wish to keep or disable the Row height.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_height_ratio",
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
				esc_html__( "Auto", "impeka-wpb-extension" ) => '0',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_sm_height_ratio",
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
				esc_html__( "Auto", "impeka-wpb-extension" ) => '0',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"std" => 'inherit',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_height_ratio",
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
				esc_html__( "Auto", "impeka-wpb-extension" ) => '0',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"std" => 'inherit',
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Column Width", "impeka-wpb-extension" ),
			'param_name' => 'width',
			'value' => $impeka_grve_column_width_list,
			'description' => esc_html__( "Select column width.", "impeka-wpb-extension" ),
			"std" => '1/1',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Content Width", "impeka-wpb-extension" ),
			"param_name" => "content_width",
			"value" => array(
				esc_html__( "5%", "impeka-wpb-extension" ) => '5',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "15%", "impeka-wpb-extension" ) => '15',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "25%", "impeka-wpb-extension" ) => '25',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "35%", "impeka-wpb-extension" ) => '35',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "45%", "impeka-wpb-extension" ) => '45',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "55%", "impeka-wpb-extension" ) => '55',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "65%", "impeka-wpb-extension" ) => '65',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "75%", "impeka-wpb-extension" ) => '75',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "85%", "impeka-wpb-extension" ) => '85',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "95%", "impeka-wpb-extension" ) => '95',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
				esc_html__( "Custom", "impeka-wpb-extension" ) => 'custom',
			),
			"description" => esc_html__( "Select the content width.", "impeka-wpb-extension" ),
			"std" => '100',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Custom Content Width", "impeka-wpb-extension" ),
			"param_name" => "custom_content_width",
			"dependency" => array(
				'element' => 'content_width',
				'value' => array( 'custom' )
			),
			"description" => esc_html__( "You can use px, em, vh, vw, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Horizontal Content Position", "impeka-wpb-extension" ),
			"param_name" => "horizontal_content_position",
			"value" => array(
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Select the horizontal position of the content.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Vertical Content Position", "impeka-wpb-extension" ),
			"param_name" => "vertical_content_position",
			"value" => array(
				esc_html__( "Top", "impeka-wpb-extension" ) => 'top',
				esc_html__( "Middle", "impeka-wpb-extension" ) => 'middle',
				esc_html__( "Bottom", "impeka-wpb-extension" ) => 'bottom',
			),
			"description" => esc_html__( "Select the vertical position of the content.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column 100% Height", "impeka-wpb-extension" ),
			"description" => esc_html__( "Select if you need this column to have 100% height of the parent row.", "impeka-wpb-extension" ),
			"param_name" => "full_height",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => 'no',
				esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
			),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Text Align", "impeka-wpb-extension" ),
			"param_name" => "text_align",
			"value" => array(
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			"description" => esc_html__( "Select the text align of the content.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column", $impeka_grve_add_el_id );
	vc_add_param( "vc_column", $impeka_grve_add_el_class );
	vc_add_param( "vc_column", $impeka_grve_add_el_wrapper_class );


	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Add Column Link", "impeka-wpb-extension" ),
			"param_name" => "add_column_link",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => '',
				esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
			),
			"description" => esc_html__( "Select if you need this column to have link.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "vc_link",
			"heading" => esc_html__( "Column Link", "impeka-wpb-extension" ),
			"param_name" => "column_link",
			"value" => "",
			"description" => esc_html__( "Enter Column link.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'add_column_link',
				'value' => array( 'yes', 'gradient' )
			),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Column Link Class", "impeka-wpb-extension" ),
			"param_name" => "column_link_class",
			"value" => "",
			"description" => esc_html__( "Enter extra class name for your link.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'add_column_link',
				'value' => array( 'yes', 'gradient' )
			),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Block Content", "impeka-wpb-extension" ),
			"param_name" => "block_content",
			"value" => impeka_grve_get_privacy_switch_ids(),
			"description" => esc_html__( "Select the blocking content id to block.", "impeka-wpb-extension" ),
		)
	);

	impeka_grve_rc_style_params( "vc_column" );

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Expand Column Background", "impeka-wpb-extension" ),
			"param_name" => "expand_column_bg",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => '',
				esc_html__( "Expand Left", "impeka-wpb-extension" ) => 'expand-bg-left',
				esc_html__( "Expand Right", "impeka-wpb-extension" ) => 'expand-bg-right',
			),
			"description" => esc_html__( "Select the expand column of the background.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'color', 'image', 'gradient' )
			),
			"group" => esc_html__( "Style", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column", $impeka_grve_add_column_animation );
	vc_add_param( "vc_column", $impeka_grve_add_column_clipping_animation );
	vc_add_param( "vc_column", $impeka_grve_add_clipping_animation_colors );
	vc_add_param( "vc_column", $impeka_grve_add_animation_delay );
	vc_add_param( "vc_column", $impeka_grve_add_animation_duration );

	vc_add_param( "vc_column",
		array(
			'type' => 'grve_css_editor',
			'heading' => esc_html__( 'CSS box', "impeka-wpb-extension" ),
			'param_name' => 'grve_css',
			'wrapper_selector' => 'grve-column-wrapper',
			'group' => esc_html__( 'Design Options', "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Sticky Column", "impeka-wpb-extension" ),
			"param_name" => "column_sticky",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => 'no',
				esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
			),
			"description" => esc_html__( "Activate this to stick the Column when scrolling.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Effect', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "textfield",
			"heading" => esc_html__( 'Sticky Top Offset', "impeka-wpb-extension" ),
			"param_name" => "column_sticky_offset",
			"description" => esc_html__( "Enter a number in pixel to initial sticking position.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'column_sticky',
				'value' => array( 'yes' )
			),
			'group' => esc_html__( 'Effect', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column", $impeka_grve_add_animation_hover );

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect", "impeka-wpb-extension" ),
			"param_name" => "column_effect",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => 'none',
				esc_html__( "Vertical Parallax", "impeka-wpb-extension" ) => 'vertical-parallax',
				esc_html__( "Mouse Move X and Y", "impeka-wpb-extension" ) => 'mouse-move-x-y',
				esc_html__( "Mouse Move X", "impeka-wpb-extension" ) => 'mouse-move-x',
				esc_html__( "Mouse Move Y", "impeka-wpb-extension" ) => 'mouse-move-y',
			),
			"dependency" => array(
				'element' => 'column_sticky',
				'value' => array( 'no' )
			),
			"description" => esc_html__( "Select column effect behaviour. Notice that the Mouse Move Effect does not affect on devices.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Effect', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect Sensitive", "impeka-wpb-extension" ),
			"param_name" => "column_effect_sensitive",
			"value" => array(
				esc_html__( "Low", "impeka-wpb-extension" ) => '1',
				esc_html__( "Normal", "impeka-wpb-extension" ) => '2',
				esc_html__( "High", "impeka-wpb-extension" ) => '5',
				esc_html__( "Max", "impeka-wpb-extension" ) => '10',
			),
			"std" => '2',
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'mouse-move-x-y', 'mouse-move-x', 'mouse-move-y' )
			),
			'edit_field_class' => 'vc_col-sm-6',
			"description" => esc_html__( "Select column effect sensitive", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Effect', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect Invert Motion", "impeka-wpb-extension" ),
			"param_name" => "column_effect_invert",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => 'false',
				esc_html__( "Yes", "impeka-wpb-extension" ) => 'true',
			),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'mouse-move-x-y', 'mouse-move-x', 'mouse-move-y' )
			),
			'edit_field_class' => 'vc_col-sm-6',
			"description" => esc_html__( "Select if you want to enable invert motion effect on this column.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Effect', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Column Width", "impeka-wpb-extension"),
			"param_name" => "label_column_width",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define your column width for desktops/laptops and devices. Width attribute is defined under General tab.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Desktop", "impeka-wpb-extension" ),
			"param_name" => "desktop_hide",
			"value" => $impeka_grve_column_desktop_hide_list,
			"description" => esc_html__( "Define your column width for Desktop.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_width",
			"value" => $impeka_grve_column_width_tablet_list,
			"description" => esc_html__( "Define your column width for Tablet Landscape.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_sm_width",
			"value" => $impeka_grve_column_width_tablet_sm_list,
			"description" => esc_html__( "Define your column width for Tablet Portrait.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_width",
			"value" => $impeka_grve_column_mobile_width_list,
			"description" => esc_html__( "Define your column width for Mobile.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);


	vc_add_param( "vc_column",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Content Width", "impeka-wpb-extension"),
			"param_name" => "label_content_width",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define your column content width for devices. Default is defined under General > Content Width.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			'param_name' => 'tablet_content_width',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "5%", "impeka-wpb-extension" ) => '5',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "15%", "impeka-wpb-extension" ) => '15',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "25%", "impeka-wpb-extension" ) => '25',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "35%", "impeka-wpb-extension" ) => '35',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "45%", "impeka-wpb-extension" ) => '45',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "55%", "impeka-wpb-extension" ) => '55',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "65%", "impeka-wpb-extension" ) => '65',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "75%", "impeka-wpb-extension" ) => '75',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "85%", "impeka-wpb-extension" ) => '85',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "95%", "impeka-wpb-extension" ) => '95',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Tablet Landscape.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			'param_name' => 'tablet_sm_content_width',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "5%", "impeka-wpb-extension" ) => '5',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "15%", "impeka-wpb-extension" ) => '15',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "25%", "impeka-wpb-extension" ) => '25',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "35%", "impeka-wpb-extension" ) => '35',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "45%", "impeka-wpb-extension" ) => '45',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "55%", "impeka-wpb-extension" ) => '55',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "65%", "impeka-wpb-extension" ) => '65',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "75%", "impeka-wpb-extension" ) => '75',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "85%", "impeka-wpb-extension" ) => '85',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "95%", "impeka-wpb-extension" ) => '95',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Tablet Portrait.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Mobile", "impeka-wpb-extension" ),
			'param_name' => 'mobile_content_width',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "5%", "impeka-wpb-extension" ) => '5',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "15%", "impeka-wpb-extension" ) => '15',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "25%", "impeka-wpb-extension" ) => '25',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "35%", "impeka-wpb-extension" ) => '35',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "45%", "impeka-wpb-extension" ) => '45',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "55%", "impeka-wpb-extension" ) => '55',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "65%", "impeka-wpb-extension" ) => '65',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "75%", "impeka-wpb-extension" ) => '75',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "85%", "impeka-wpb-extension" ) => '85',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "95%", "impeka-wpb-extension" ) => '95',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Mobile.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Horizontal Content Position", "impeka-wpb-extension"),
			"param_name" => "label_content_position",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Select the horizontal position of the content  for devices.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			'param_name' => 'tablet_horizontal_content_position',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content horizontal position for Tablet Landscape.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			'param_name' => 'tablet_sm_horizontal_content_position',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content horizontal position for Tablet Portrait.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Mobile", "impeka-wpb-extension" ),
			'param_name' => 'mobile_horizontal_content_position',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content horizontal position for Tablet Mobile.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Column Effect", "impeka-wpb-extension"),
			"param_name" => "label_column_effect",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define your column effect for devices. Default values are defined under Effect & Positions > Column Effect.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_landscape_column_effect",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Disable Effect", "impeka-wpb-extension" ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Tablet Landscape.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_portrait_column_effect",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Disable Effect", "impeka-wpb-extension" ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Tablet Portrait.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_column_effect",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Disable Effect", "impeka-wpb-extension" ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Mobile.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Text Align", "impeka-wpb-extension"),
			"param_name" => "label_text_align",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define your text align for devices. Default values are defined under General > Text Align.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_text_align",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Tablet Landscape.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_sm_text_align",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Tablet Portrait.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_text_align",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Mobile.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Column Order", "impeka-wpb-extension"),
			"param_name" => "label_column_order",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define the column order in which they appear in the grid for devices.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_column_order",
			"value" => $impeka_grve_column_order_list,
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your column order for Tablet Landscape.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_sm_column_order",
			"value" => $impeka_grve_column_order_list,
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your column order for Tablet Portrait.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_column_order",
			"value" => $impeka_grve_column_order_list,
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your column order for Mobile.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Expand Column Background", "impeka-wpb-extension"),
			"param_name" => "label_expand_column_bg",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define the expand column background for devices. Default is defined under Style > Expand Column Background.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'expand_column_bg',
				'value_not_equal_to' => array( '' )
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			'param_name' => 'tablet_expand_column_bg',
			"value" => array(
				esc_html__( "Default", "impeka-wpb-extension" ) => '',
				esc_html__( "Reset", "impeka-wpb-extension" ) => 'reset',
				esc_html__( "Both Sides", "impeka-wpb-extension" ) => 'both-sides',
			),
			"dependency" => array(
				'element' => 'expand_column_bg',
				'value_not_equal_to' => array( '' )
			),
			"description" => esc_html__( "Define the expand column for Tablet Landscape.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			'param_name' => 'tablet_sm_expand_column_bg',
			"value" => array(
				esc_html__( "Default", "impeka-wpb-extension" ) => '',
				esc_html__( "Reset", "impeka-wpb-extension" ) => 'reset',
				esc_html__( "Both Sides", "impeka-wpb-extension" ) => 'both-sides',
			),
			"dependency" => array(
				'element' => 'expand_column_bg',
				'value_not_equal_to' => array( '' )
			),
			"description" => esc_html__( "Define the expand column for Tablet Portrait.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Mobile", "impeka-wpb-extension" ),
			'param_name' => 'mobile_expand_column_bg',
			"value" => array(
				esc_html__( "Default", "impeka-wpb-extension" ) => '',
				esc_html__( "Reset", "impeka-wpb-extension" ) => 'reset',
				esc_html__( "Both Sides", "impeka-wpb-extension" ) => 'both-sides',
			),
			"dependency" => array(
				'element' => 'expand_column_bg',
				'value_not_equal_to' => array( '' )
			),
			"description" => esc_html__( "Define the expand column for Mobile.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Column Width", "impeka-wpb-extension" ),
			'param_name' => 'width',
			'value' => $impeka_grve_column_width_list,
			'description' => esc_html__( "Select column width.", "impeka-wpb-extension" ),
			"std" => '1/1',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Content Width", "impeka-wpb-extension" ),
			"param_name" => "content_width",
			"value" => array(
				esc_html__( "5%", "impeka-wpb-extension" ) => '5',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "15%", "impeka-wpb-extension" ) => '15',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "25%", "impeka-wpb-extension" ) => '25',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "35%", "impeka-wpb-extension" ) => '35',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "45%", "impeka-wpb-extension" ) => '45',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "55%", "impeka-wpb-extension" ) => '55',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "65%", "impeka-wpb-extension" ) => '65',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "75%", "impeka-wpb-extension" ) => '75',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "85%", "impeka-wpb-extension" ) => '85',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "95%", "impeka-wpb-extension" ) => '95',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
				esc_html__( "Custom", "impeka-wpb-extension" ) => 'custom',
			),
			"description" => esc_html__( "Select the content width.", "impeka-wpb-extension" ),
			"std" => '100',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Custom Content Width", "impeka-wpb-extension" ),
			"param_name" => "custom_content_width",
			"dependency" => array(
				'element' => 'content_width',
				'value' => array( 'custom' )
			),
			"description" => esc_html__( "You can use px, em, vh, vw, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Horizontal Content Position", "impeka-wpb-extension" ),
			"param_name" => "horizontal_content_position",
			"value" => array(
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Select the horizontal position of the content.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Vertical Content Position", "impeka-wpb-extension" ),
			"param_name" => "vertical_content_position",
			"value" => array(
				esc_html__( "Top", "impeka-wpb-extension" ) => 'top',
				esc_html__( "Middle", "impeka-wpb-extension" ) => 'middle',
				esc_html__( "Bottom", "impeka-wpb-extension" ) => 'bottom',
			),
			"description" => esc_html__( "Select the vertical position of the content.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column 100% Height", "impeka-wpb-extension" ),
			"description" => esc_html__( "Select if you need this column to have 100% height of the parent row.", "impeka-wpb-extension" ),
			"param_name" => "full_height",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => 'no',
				esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
			),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Text Align", "impeka-wpb-extension" ),
			"param_name" => "text_align",
			"value" => array(
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			"description" => esc_html__( "Select the text align of the content.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner", $impeka_grve_add_el_id );
	vc_add_param( "vc_column_inner", $impeka_grve_add_el_class );
	vc_add_param( "vc_column_inner", $impeka_grve_add_el_wrapper_class );

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Add Column Link", "impeka-wpb-extension" ),
			"param_name" => "add_column_link",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => '',
				esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
			),
			"description" => esc_html__( "Select if you need this column to have link.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "vc_link",
			"heading" => esc_html__( "Column Link", "impeka-wpb-extension" ),
			"param_name" => "column_link",
			"value" => "",
			"description" => esc_html__( "Enter Column link.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'add_column_link',
				'value' => array( 'yes', 'gradient' )
			),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Column Link Class", "impeka-wpb-extension" ),
			"param_name" => "column_link_class",
			"value" => "",
			"description" => esc_html__( "Enter extra class name for your link.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'add_column_link',
				'value' => array( 'yes', 'gradient' )
			),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Block Content", "impeka-wpb-extension" ),
			"param_name" => "block_content",
			"value" => impeka_grve_get_privacy_switch_ids(),
			"description" => esc_html__( "Select the blocking content id to block.", "impeka-wpb-extension" ),
		)
	);

	impeka_grve_rc_style_params( "vc_column_inner" );

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Expand Column Background", "impeka-wpb-extension" ),
			"param_name" => "expand_column_bg",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => '',
				esc_html__( "Expand Left", "impeka-wpb-extension" ) => 'expand-bg-left',
				esc_html__( "Expand Right", "impeka-wpb-extension" ) => 'expand-bg-right',
			),
			"description" => esc_html__( "Select the expand column of the background.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'color', 'image', 'gradient' )
			),
			"group" => esc_html__( "Style", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner", $impeka_grve_add_column_animation );
	vc_add_param( "vc_column_inner", $impeka_grve_add_column_clipping_animation );
	vc_add_param( "vc_column_inner", $impeka_grve_add_clipping_animation_colors );
	vc_add_param( "vc_column_inner", $impeka_grve_add_animation_delay );
	vc_add_param( "vc_column_inner", $impeka_grve_add_animation_duration );

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'grve_css_editor',
			'heading' => esc_html__( 'CSS box', "impeka-wpb-extension" ),
			'param_name' => 'grve_css',
			'wrapper_selector' => 'grve-column-wrapper-inner',
			'group' => esc_html__( 'Design Options', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner", $impeka_grve_add_animation_hover );

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect", "impeka-wpb-extension" ),
			"param_name" => "column_effect",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => 'none',
				esc_html__( "Vertical Parallax", "impeka-wpb-extension" ) => 'vertical-parallax',
				esc_html__( "Mouse Move X and Y", "impeka-wpb-extension" ) => 'mouse-move-x-y',
				esc_html__( "Mouse Move X", "impeka-wpb-extension" ) => 'mouse-move-x',
				esc_html__( "Mouse Move Y", "impeka-wpb-extension" ) => 'mouse-move-y',
			),
			"description" => esc_html__( "Select column effect behaviour. Notice that the Mouse Move Effect does not affect on devices.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Effect', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect Sensitive", "impeka-wpb-extension" ),
			"param_name" => "column_effect_sensitive",
			"value" => array(
				esc_html__( "Low", "impeka-wpb-extension" ) => '1',
				esc_html__( "Normal", "impeka-wpb-extension" ) => '2',
				esc_html__( "High", "impeka-wpb-extension" ) => '4',
				esc_html__( "Max", "impeka-wpb-extension" ) => '6',
			),
			"std" => '2',
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'mouse-move-x-y', 'mouse-move-x', 'mouse-move-y' )
			),
			'edit_field_class' => 'vc_col-sm-6',
			"description" => esc_html__( "Select column effect sensitive", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Effect', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect Invert Motion", "impeka-wpb-extension" ),
			"param_name" => "column_effect_invert",
			"value" => array(
				esc_html__( "No", "impeka-wpb-extension" ) => 'false',
				esc_html__( "Yes", "impeka-wpb-extension" ) => 'true',
			),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'mouse-move-x-y', 'mouse-move-x', 'mouse-move-y' )
			),
			'edit_field_class' => 'vc_col-sm-6',
			"description" => esc_html__( "Select if you want to enable invert motion effect on this column.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Effect', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Column Width", "impeka-wpb-extension"),
			"param_name" => "label_column_width",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define your column width for desktops/laptops and devices. Width attribute is defined under General tab.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Desktop", "impeka-wpb-extension" ),
			"param_name" => "desktop_hide",
			"value" => $impeka_grve_column_desktop_hide_list,
			"description" => esc_html__( "Define your column width for Desktop.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_width",
			"value" => $impeka_grve_column_width_tablet_list,
			"description" => esc_html__( "Define your column width for Tablet Landscape.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_sm_width",
			"value" => $impeka_grve_column_width_tablet_sm_list,
			"description" => esc_html__( "Define your column width for Tablet Portrait.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_width",
			"value" => $impeka_grve_column_mobile_width_list,
			"description" => esc_html__( "Define your column width for Mobile.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Content Width", "impeka-wpb-extension"),
			"param_name" => "label_content_width",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define your column content width for devices. Default is defined under General > Content Width.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			'param_name' => 'tablet_content_width',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "5%", "impeka-wpb-extension" ) => '5',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "15%", "impeka-wpb-extension" ) => '15',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "25%", "impeka-wpb-extension" ) => '25',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "35%", "impeka-wpb-extension" ) => '35',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "45%", "impeka-wpb-extension" ) => '45',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "55%", "impeka-wpb-extension" ) => '55',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "65%", "impeka-wpb-extension" ) => '65',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "75%", "impeka-wpb-extension" ) => '75',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "85%", "impeka-wpb-extension" ) => '85',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "95%", "impeka-wpb-extension" ) => '95',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Tablet Landscape.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			'param_name' => 'tablet_sm_content_width',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "5%", "impeka-wpb-extension" ) => '5',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "15%", "impeka-wpb-extension" ) => '15',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "25%", "impeka-wpb-extension" ) => '25',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "35%", "impeka-wpb-extension" ) => '35',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "45%", "impeka-wpb-extension" ) => '45',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "55%", "impeka-wpb-extension" ) => '55',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "65%", "impeka-wpb-extension" ) => '65',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "75%", "impeka-wpb-extension" ) => '75',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "85%", "impeka-wpb-extension" ) => '85',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "95%", "impeka-wpb-extension" ) => '95',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Tablet Portrait.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Mobile", "impeka-wpb-extension" ),
			'param_name' => 'mobile_content_width',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "5%", "impeka-wpb-extension" ) => '5',
				esc_html__( "10%", "impeka-wpb-extension" ) => '10',
				esc_html__( "15%", "impeka-wpb-extension" ) => '15',
				esc_html__( "20%", "impeka-wpb-extension" ) => '20',
				esc_html__( "25%", "impeka-wpb-extension" ) => '25',
				esc_html__( "30%", "impeka-wpb-extension" ) => '30',
				esc_html__( "35%", "impeka-wpb-extension" ) => '35',
				esc_html__( "40%", "impeka-wpb-extension" ) => '40',
				esc_html__( "45%", "impeka-wpb-extension" ) => '45',
				esc_html__( "50%", "impeka-wpb-extension" ) => '50',
				esc_html__( "55%", "impeka-wpb-extension" ) => '55',
				esc_html__( "60%", "impeka-wpb-extension" ) => '60',
				esc_html__( "65%", "impeka-wpb-extension" ) => '65',
				esc_html__( "70%", "impeka-wpb-extension" ) => '70',
				esc_html__( "75%", "impeka-wpb-extension" ) => '75',
				esc_html__( "80%", "impeka-wpb-extension" ) => '80',
				esc_html__( "85%", "impeka-wpb-extension" ) => '85',
				esc_html__( "90%", "impeka-wpb-extension" ) => '90',
				esc_html__( "95%", "impeka-wpb-extension" ) => '95',
				esc_html__( "100%", "impeka-wpb-extension" ) => '100',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Mobile.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Horizontal Content Position", "impeka-wpb-extension"),
			"param_name" => "label_content_position",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Select the horizontal position of the content  for devices.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			'param_name' => 'tablet_horizontal_content_position',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content horizontal position for Tablet Landscape.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			'param_name' => 'tablet_sm_horizontal_content_position',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content horizontal position for Tablet Portrait.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Mobile", "impeka-wpb-extension" ),
			'param_name' => 'mobile_horizontal_content_position',
			"value" => array(
				esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content horizontal position for Tablet Mobile.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Column Effect", "impeka-wpb-extension"),
			"param_name" => "label_column_effect",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define your column effect for devices. Default values are defined under Effect & Positions > Column Effect.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_landscape_column_effect",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Disable Effect", "impeka-wpb-extension" ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Tablet Landscape.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_portrait_column_effect",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Disable Effect", "impeka-wpb-extension" ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Tablet Portrait.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_column_effect",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Disable Effect", "impeka-wpb-extension" ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Mobile.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Text Align", "impeka-wpb-extension"),
			"param_name" => "label_text_align",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define your text align for devices. Default values are defined under General > Text Align.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_text_align",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Tablet Landscape.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_sm_text_align",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Tablet Portrait.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_text_align",
			"value" => array(
				esc_html__( "Default values", "impeka-wpb-extension" ) => '',
				esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
				esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
				esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Mobile.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Column Order", "impeka-wpb-extension"),
			"param_name" => "label_column_order",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define the column order in which they appear in the grid for devices.", "impeka-wpb-extension" ),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			"param_name" => "tablet_column_order",
			"value" => $impeka_grve_column_order_list,
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your column order for Tablet Landscape.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			"param_name" => "tablet_sm_column_order",
			"value" => $impeka_grve_column_order_list,
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your column order for Tablet Portrait.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", "impeka-wpb-extension" ),
			"param_name" => "mobile_column_order",
			"value" => $impeka_grve_column_order_list,
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your column order for Mobile.", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'impeka_param_label',
			"heading" => esc_html__( "Expand Column Background", "impeka-wpb-extension"),
			"param_name" => "label_expand_column_bg",
			'value' => '',
			"std" => '',
			"description" => esc_html__( "Define the expand column background for devices. Default is defined under Style > Expand Column Background.", "impeka-wpb-extension" ),
			"dependency" => array(
				'element' => 'expand_column_bg',
				'value_not_equal_to' => array( '' )
			),
			'group' => esc_html__( 'Width & Responsiveness', "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Landscape", "impeka-wpb-extension" ),
			'param_name' => 'tablet_expand_column_bg',
			"value" => array(
				esc_html__( "Default", "impeka-wpb-extension" ) => '',
				esc_html__( "Reset", "impeka-wpb-extension" ) => 'reset',
				esc_html__( "Both Sides", "impeka-wpb-extension" ) => 'both-sides',
			),
			"dependency" => array(
				'element' => 'expand_column_bg',
				'value_not_equal_to' => array( '' )
			),
			"description" => esc_html__( "Define the expand column for Tablet Landscape.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Portrait", "impeka-wpb-extension" ),
			'param_name' => 'tablet_sm_expand_column_bg',
			"value" => array(
				esc_html__( "Default", "impeka-wpb-extension" ) => '',
				esc_html__( "Reset", "impeka-wpb-extension" ) => 'reset',
				esc_html__( "Both Sides", "impeka-wpb-extension" ) => 'both-sides',
			),
			"dependency" => array(
				'element' => 'expand_column_bg',
				'value_not_equal_to' => array( '' )
			),
			"description" => esc_html__( "Define the expand column for Tablet Portrait.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Mobile", "impeka-wpb-extension" ),
			'param_name' => 'mobile_expand_column_bg',
			"value" => array(
				esc_html__( "Default", "impeka-wpb-extension" ) => '',
				esc_html__( "Reset", "impeka-wpb-extension" ) => 'reset',
				esc_html__( "Both Sides", "impeka-wpb-extension" ) => 'both-sides',
			),
			"dependency" => array(
				'element' => 'expand_column_bg',
				'value_not_equal_to' => array( '' )
			),
			"description" => esc_html__( "Define the expand column for Mobile.", "impeka-wpb-extension" ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", "impeka-wpb-extension" ),
		)
	);

	vc_add_param( "vc_widget_sidebar",
		array(
			'type' => 'hidden',
			'param_name' => 'title',
			'value' => '',
		)
	);

	if ( defined( 'WPB_VC_VERSION' ) && version_compare( WPB_VC_VERSION, '4.6', '>=') ) {

		vc_add_param( "vc_tta_tabs",
			array(
				'type' => 'hidden',
				'param_name' => 'no_fill_content_area',
				'value' => '',
			)
		);

		vc_add_param( "vc_tta_tabs",
			array(
				'type' => 'hidden',
				'param_name' => 'tab_position',
				'value' => 'top',
			)
		);

		vc_add_param( "vc_tta_accordion",
			array(
				'type' => 'hidden',
				'param_name' => 'no_fill',
				'value' => '',
			)
		);

		vc_add_param( "vc_tta_tour",
			array(
				'type' => 'hidden',
				'param_name' => 'no_fill_content_area',
				'value' => '',
			)
		);
	}

	vc_add_param( "vc_column_text",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Text Style", "impeka-wpb-extension" ),
			"param_name" => "text_style",
			"value" => array(
				esc_html__( "None", "impeka-wpb-extension" ) => '',
				esc_html__( "Leader", "impeka-wpb-extension" ) => 'leader-text',
				esc_html__( "Subtitle", "impeka-wpb-extension" ) => 'subtitle',
				esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
				esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
				esc_html__( "Page Description", "impeka-wpb-extension" ) => 'page-description',
			),
			"description" => esc_html__( "Select your text style", "impeka-wpb-extension" ),
		)
	);
	vc_add_param( "vc_column_text", $impeka_grve_add_animation );
	vc_add_param( "vc_column_text", $impeka_grve_add_animation_delay );
	vc_add_param( "vc_column_text", $impeka_grve_add_animation_duration );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
