<?php
/*
*	Greatives Page Builder Shortcode helper functions
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

function impeka_wpb_ext_social_elements_visibility() {
	$visibility = apply_filters( 'impeka_wpb_ext_social_elements_visibility', false );
	return $visibility;
}
function impeka_wpb_ext_wp_elements_visibility() {
	$visibility = apply_filters( 'impeka_wpb_ext_wp_elements_visibility', false );
	return $visibility;
}
function impeka_wpb_ext_grid_visibility() {
	$visibility = impeka_grve_visibility( 'vc_grid_visibility' );
	$visibility = apply_filters( 'impeka_wpb_ext_grid_visibility', $visibility );
	return $visibility;
}
function impeka_wpb_ext_charts_visibility() {
	$visibility = impeka_grve_visibility( 'vc_charts_visibility' );
	$visibility = apply_filters( 'impeka_wpb_ext_charts_visibility', $visibility );
	return $visibility;
}
function impeka_wpb_ext_woo_visibility() {
	$visibility = impeka_grve_visibility( 'vc_woo_visibility' );
	$visibility = apply_filters( 'impeka_wpb_ext_woo_visibility', $visibility );
	return $visibility;
}
function impeka_wpb_ext_other_elements_visibility() {
	$visibility = apply_filters( 'impeka_wpb_ext_other_elements_visibility', false );
	return $visibility;
}

function impeka_wpb_ext_admin_body_class( $string ){
	if ( vc_is_frontend_editor() ) {
		$body_classes = impeka_grve_body_class( array() );
		$string .= implode( ' ', $body_classes );
	}
	return $string;
}
add_filter( 'admin_body_class', 'impeka_wpb_ext_admin_body_class' );


function impeka_wpb_ext_build_shortcode_img_srcset( $bg_image = '' , $bg_image_size = '' ) {
	$srcset = wp_get_attachment_image_srcset( $bg_image ,$bg_image_size );
	if ( empty( $srcset ) ) {
		$srcset = impeka_wpb_ext_shortcode_img_url( $bg_image ,$bg_image_size );
	}
	return $srcset;
}

function impeka_wpb_ext_build_shortcode_img_style( $bg_image = '' , $bg_image_size = '' ) {

	$has_image = false;
	$style = '';
	if ( !is_numeric( $bg_image ) ) {
		$image_url = impeka_wpb_ext_get_fallback_image( 'full', 'url', $bg_image );
		$style .= "background-image: url(" . esc_url( $image_url ) . ");";
		return ' style="'.$style.'"';
	} else if((int)$bg_image > 0 && ($attachment_src = wp_get_attachment_image_src( $bg_image, 'impeka-grve-fullscreen' )) !== false) {

		$image_url = $attachment_src[0];
		//Adaptive Background URL
		if ( empty ( $bg_image_size ) ) {
			$bg_image_size = impeka_grve_option( 'row_section_bg_size' );
		}
		$image_url = impeka_grve_get_adaptive_url( $bg_image, $bg_image_size );

		$has_image = true;
		$style .= "background-image: url(" . esc_url( $image_url ) . ");";
	} else {
		$image_url = impeka_grve_get_fallback_image( $bg_image_size ,'url' );
		$style .= "background-image: url(" . esc_url( $image_url ) . ");";
	}
	return ' style="'.$style.'"';

}

function impeka_wpb_ext_shortcode_img_url( $bg_image = '' , $bg_image_size = '' ) {
	if((int)$bg_image > 0 && ($attachment_src = wp_get_attachment_image_src( $bg_image, 'impeka-grve-fullscreen' )) !== false) {
		$image_url = $attachment_src[0];
		if ( empty ( $bg_image_size ) ) {
			$bg_image_size = impeka_grve_option( 'row_section_bg_size' );
		}
		$image_url = impeka_grve_get_adaptive_url( $bg_image, $bg_image_size );
	} else {
		$image_url = '';
	}
	return $image_url;

}

function impeka_wpb_ext_shortcode_custom_css_class( $param_value, $prefix = '' ) {
	$css_class = preg_match( '/\s*\.([^\{]+)\s*\{\s*([^\}]+)\s*\}\s*/', $param_value ) ? $prefix . preg_replace( '/\s*\.([^\{]+)\s*\{\s*([^\}]+)\s*\}\s*/', '$1', $param_value ) : '';
	return $css_class;
}

function impeka_wpb_ext_shortcode_grve_css_class( $param_value ) {
	$regexr = preg_match( '/(?:grve\-wpb\-[0-9]*)/', $param_value, $matches );
	$css_class = isset( $matches[0] ) ? $matches[0] : '';
	return $css_class;
}

function impeka_wpb_ext_build_shortcode_style( $item = array() ) {
	$bg_color = impeka_wpb_ext_array_value( $item, 'bg_color' );
	$bg_gradient_color_1 = impeka_wpb_ext_array_value( $item, 'bg_gradient_color_1' );
	$bg_gradient_color_2 = impeka_wpb_ext_array_value( $item, 'bg_gradient_color_2' );
	$bg_gradient_direction = impeka_wpb_ext_array_value( $item, 'bg_gradient_direction' );
	$font_color = impeka_wpb_ext_array_value( $item, 'font_color' );
	$padding_top = impeka_wpb_ext_array_value( $item, 'padding_top');
	$padding_bottom = impeka_wpb_ext_array_value( $item, 'padding_bottom' );
	$margin_bottom = impeka_wpb_ext_array_value( $item, 'margin_bottom' );
	$position_top = impeka_wpb_ext_array_value( $item, 'position_top' );
	$position_bottom = impeka_wpb_ext_array_value( $item, 'position_bottom' );
	$position_left = impeka_wpb_ext_array_value( $item, 'position_left' );
	$position_right = impeka_wpb_ext_array_value( $item, 'position_right' );
	$z_index = impeka_wpb_ext_array_value( $item, 'z_index' );
	$content_width = impeka_wpb_ext_array_value( $item, 'content_width' );
	$custom_content_width = impeka_wpb_ext_array_value( $item, 'custom_content_width' );
	$height = impeka_wpb_ext_array_value( $item, 'height' );

	$style = '';

	if(!empty($bg_color)) {
		$style .= impeka_wpb_ext_get_css_color( 'background-color', $bg_color );
	}

	if( !empty($bg_gradient_color_1) && !empty($bg_gradient_color_2) && !empty($bg_gradient_direction) ) {
		$style .= impeka_wpb_ext_get_css_color( 'background-color', $bg_gradient_color_1 );
		$style .= 'background: linear-gradient(' . $bg_gradient_direction . 'deg,' . $bg_gradient_color_1 . ' 0%,' . $bg_gradient_color_2 .' 100%);';
	}


	if( !empty($font_color) ) {
		$style .= impeka_wpb_ext_get_css_color( 'color', $font_color );
	}
	if( $padding_top != '' ) {
		$style .= 'padding-top: '.(preg_match('/(px|em|\%|pt|cm|vh|vw)$/', $padding_top) ? $padding_top : $padding_top.'px').';';
	}
	if( $padding_bottom != '' ) {
		$style .= 'padding-bottom: '.(preg_match('/(px|em|\%|pt|cm|vh|vw)$/', $padding_bottom) ? $padding_bottom : $padding_bottom.'px').';';
	}
	if( $margin_bottom != '' ) {
		$style .= 'margin-bottom: '.(preg_match('/(px|em|\%|pt|cm)$/', $margin_bottom) ? $margin_bottom : $margin_bottom.'px').';';
	}
	if( $position_top != '' ) {
		$style .= 'top: '.(preg_match('/(px|em|\%|pt|cm)$/', $position_top) ? $position_top : $position_top.'px').';';
	}
	if( $position_bottom != '' ) {
		$style .= 'bottom: '.(preg_match('/(px|em|\%|pt|cm)$/', $position_bottom) ? $position_bottom : $position_bottom.'px').';';
	}
	if( $position_left != '' ) {
		$style .= 'left: '.(preg_match('/(px|em|\%|pt|cm)$/', $position_left) ? $position_left : $position_left.'px').';';
	}
	if( $position_right != '' ) {
		$style .= 'right: '.(preg_match('/(px|em|\%|pt|cm)$/', $position_right) ? $position_right : $position_right.'px').';';
	}
	if( $z_index != '' ) {
		$style .= 'z-index:' . $z_index;
	}
	if( $content_width == 'custom' && !empty ( $custom_content_width ) ) {
		$style .= 'max-width: '.(preg_match('/(px|em|\%|pt|cm|vh|vw)$/', $custom_content_width) ? $custom_content_width : $custom_content_width.'px').';';
	}
	if( !empty($height) && $height != 'auto' ) {
		$style .= 'height:' . $height .'vh';
	}

	return empty($style) ? $style : ' style="'.$style.'"';
}



/*
 * Returns a string with element design
 */

function impeka_wpb_ext_screen_sizes() {
	return array(
		'desktop'            => '',
		'tablet_landscape'  => '1200',
		'tablet_portrait'   => '959',
		'mobile_landscape'  => '767',
	);
}

function impeka_wpb_ext_parse_shortcodes_custom_css( $content ) {
	$css = '';

	if ( ! preg_match( '/(?:grve\-wpb\-[0-9]*)/', $content ) ) {
		return $css;
	}

	WPBMap::addAllMappedShortcodes();
	preg_match_all( '/' . get_shortcode_regex() . '/', $content, $shortcodes );
	foreach ( $shortcodes[2] as $index => $tag ) {
		$shortcode = WPBMap::getShortCode( $tag );
		$attr_array = shortcode_parse_atts( trim( $shortcodes[3][ $index ] ) );
		if ( isset( $shortcode['params'] ) && ! empty( $shortcode['params'] ) ) {
			foreach ( $shortcode['params'] as $param ) {
				if ( isset( $param['type'] ) && 'grve_css_editor' === $param['type'] && isset( $attr_array[ $param['param_name'] ] ) ) {
					$wrapper_selector = isset( $param['wrapper_selector'] ) ? $param['wrapper_selector'] : '';
					$css .= impeka_wpb_ext_design_styles( $attr_array[ $param['param_name'] ], $wrapper_selector );
				}
			}
		}
	}
	foreach ( $shortcodes[5] as $shortcode_content ) {
		$css .= impeka_wpb_ext_parse_shortcodes_custom_css( $shortcode_content );
	}
	return $css;
}

function impeka_wpb_ext_build_shortcodes_custom_css( $css, $post_id ) {
	if( !impeka_wpb_ext_is_page_editable() ) {
		$post = get_post( $post_id );
		$content = $post->post_content;
		$css .= impeka_wpb_ext_parse_shortcodes_custom_css( $content );
	}
	return $css;
}
add_filter( 'vc_base_build_shortcodes_custom_css', 'impeka_wpb_ext_build_shortcodes_custom_css', 9, 2 );

function impeka_wpb_ext_design_styles( $object, $wrapper_selector = '' ) {
	$output = '';

	if ( !empty( $object) ) {
		$object = str_replace('``','"', $object );

		$main_selector = impeka_wpb_ext_shortcode_grve_css_class( $object );
		$outer_selector = $inner_selector = '.' . $main_selector;
		if ( !empty( $wrapper_selector ) ) {
			$inner_selector = '.' . $main_selector . ' .' . $wrapper_selector;
		}

		$object     = json_decode( $object, true );
		$sizes      = impeka_wpb_ext_screen_sizes();

		$selectors  = array_unique([$outer_selector, $inner_selector]);

		$pattern    = '/^(\d*(?:\.\d+)?)\s*(px|\%|vh|vw)?$/'; //Allow positive numbers units: px/%
		$pattern_margin    = '/^(-?\d*(?:\.\d+)?)\s*(px|\%|vh|vw)?$/'; //Allow positive/negative numbers units: px/%

		if ( $object !== null ){
			foreach ( $object as $screen => $properties ) {
				if ( $screen !== 'desktop' ) {
					$output .= ' @media only screen and (max-width:'.$sizes[$screen].'px) {';
				}
				foreach ( $selectors as $selector ) {
					$property_values = '';
					foreach ( $properties as $prop_key => $prop_value ) {
						$property = '';

						if ( $selector === $outer_selector && strpos($prop_key, 'margin') !== false ) {
							$regexr = preg_match( $pattern_margin, $prop_value, $matches );
							$value = isset( $matches[1] ) ? (float) $matches[1] : 0;
							$unit = isset( $matches[2] ) ? $matches[2] : 'px';
							$prop_value = $value . $unit;
							$property .= ' ' . $prop_key . ': ' . $prop_value . ' !important;';
						} elseif ( $selector === $outer_selector && strpos($prop_key, 'z-index') !== false ) {
							$property .= ' ' . $prop_key . ': ' . $prop_value . ' !important;';
						} elseif ( $selector === $inner_selector && strpos($prop_key, 'border') !== false ) {
							if ( strpos($prop_key, 'radius') !== false ) {
								$regexr = preg_match( $pattern, $prop_value, $matches );
								$value = isset( $matches[1] ) ? (float) $matches[1] : 0;
								$unit = isset( $matches[2] ) ? $matches[2] : 'px';
								$prop_value = $value . $unit;
								$property .= ' ' . $prop_key . ': ' . $prop_value . ' !important;';
							} else {
								$property .= ' ' . ( $prop_key === 'border-style' || $prop_key === 'border-color' ? $prop_key : $prop_key . '-width' ) . ': ' . $prop_value . ( $prop_key === 'border-style' || $prop_key === 'border-color' ? '' : 'px' ) . ' !important;';
							}
						} elseif ( $selector === $inner_selector && strpos($prop_key, 'padding') !== false ) {
							$regexr = preg_match( $pattern, $prop_value, $matches );
							$value = isset( $matches[1] ) ? (float) $matches[1] : 0;
							$unit = isset( $matches[2] ) ? $matches[2] : 'px';
							$prop_value = $value . $unit;
							$property .= ' ' . $prop_key . ': ' . $prop_value . ' !important;';
						}
						if ( $property ) {
							$property_values .= $property;
						}
					}
					if ( $property_values ) {
						$output .= $selector . '{';
						$output .= $property_values;
						$output .= '}';
					}

				}
				if ( $screen !== 'desktop' ) {
					$output .= '}';
				}
			}
		}
	}

	return $output;
}


function impeka_wpb_ext_is_page_editable() {
	$is_editable = false;
	if ( function_exists( 'vc_is_page_editable' ) && vc_is_page_editable() ) {
		$is_editable = true;
	}
	return $is_editable;
}

if ( !impeka_wpb_ext_grid_visibility() ) {

	//Remove Builder Grid Menu
	function impeka_wpb_ext_remove_vc_menu_items( ){
		remove_menu_page( 'edit.php?post_type=vc_grid_item' );
		remove_submenu_page( 'vc-general', 'edit.php?post_type=vc_grid_item' );
	}
	add_filter( 'admin_menu', 'impeka_wpb_ext_remove_vc_menu_items' );

	//Remove grid element shortcodes
	function impeka_wpb_ext_remove_shortcodes_from_vc_grid_element( $shortcodes ) {
		unset( $shortcodes['vc_icon'] );
		unset( $shortcodes['vc_button2'] );
		unset( $shortcodes['vc_btn'] );
		unset( $shortcodes['vc_custom_heading'] );
		unset( $shortcodes['vc_single_image'] );
		unset( $shortcodes['vc_empty_space'] );
		unset( $shortcodes['vc_separator'] );
		unset( $shortcodes['vc_text_separator'] );
		unset( $shortcodes['vc_gitem_post_title'] );
		unset( $shortcodes['vc_gitem_post_excerpt'] );
		unset( $shortcodes['vc_gitem_post_date'] );
		unset( $shortcodes['vc_gitem_image'] );
		unset( $shortcodes['vc_gitem_post_meta'] );

	  return $shortcodes;
	}
	add_filter( 'vc_grid_item_shortcodes', 'impeka_wpb_ext_remove_shortcodes_from_vc_grid_element', 100 );
}
//Remove all default templates.
add_filter( 'vc_load_default_templates', 'impeka_wpb_ext_remove_custom_template_array' );
function impeka_wpb_ext_remove_custom_template_array( $data ) {
	return array();
}

/**
 * VC Disable Updater Functions
 */
function impeka_wpb_ext_disable_updater_dialog() {

	$auto_updater = impeka_grve_visibility( 'vc_auto_updater' );
	if( !$auto_updater ) {
		global $vc_manager;

		if ( $vc_manager && method_exists( $vc_manager , 'disableUpdater' ) ) {
			$vc_manager->disableUpdater( true );
		}
	}
}
add_action( 'vc_before_init', 'impeka_wpb_ext_disable_updater_dialog', 9 );

function impeka_wpb_ext_disable_updater() {
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		$auto_updater = true;
		if ( function_exists( 'impeka_grve_visibility' ) ) {
			$auto_updater = impeka_grve_visibility( 'vc_auto_updater' );
		}
		if( !$auto_updater ) {
			global $vc_manager;

			if ( $vc_manager && method_exists( $vc_manager , 'updater' ) ) {
				$updater = $vc_manager->updater();
				remove_filter( 'upgrader_pre_download', array( $updater, 'preUpgradeFilter' ), 10, 4 );
				remove_action( 'wp_ajax_nopriv_vc_check_license_key', array( $updater, 'checkLicenseKeyFromRemote' ) );

				if ( $updater && method_exists( $updater , 'updateManager' ) ) {
					$updatingManager = $updater->updateManager();
					remove_filter( 'pre_set_site_transient_update_plugins', array( $updatingManager, 'check_update' ) );
					remove_filter( 'plugins_api', array( $updatingManager, 'check_info' ), 10, 3 );
					if ( function_exists( 'vc_plugin_name' ) ) {
						remove_action( 'after_plugin_row_' . vc_plugin_name(), 'wp_plugin_update_row', 10, 2 );
						remove_action( 'in_plugin_update_message-' . vc_plugin_name(), array( $updatingManager, 'addUpgradeMessageLink' ) );
					}
				}
			}
			if ( $vc_manager && method_exists( $vc_manager , 'license' ) ) {
				$license = $vc_manager->license();
				remove_action( 'admin_notices', array( $license, 'adminNoticeLicenseActivation' ) );
			}
		}
		if ( function_exists( 'vc_plugin_name' ) ) {
			add_action( 'in_plugin_update_message-' . vc_plugin_name(), 'impeka_wpb_ext_updater_notification', 11 );
		}
	}
}
add_action( 'admin_init', 'impeka_wpb_ext_disable_updater', 99 );

function impeka_wpb_ext_updater_notification() {
	echo "<br>" .
		esc_html__( 'Note: In every new release of the Theme the latest compatible version of Page Builder is included.', "impeka-wpb-extension" ) .
		" " .
		sprintf( '<a href="//docs.greatives.eu/tutorials/bundled-plugins/" target="_blank">%s</a>', esc_html__( 'Theme Bundled Plugins', "impeka-wpb-extension" ) );
}

function impeka_wpb_ext_license_tab_notice() {
	$auto_updater = impeka_grve_visibility( 'vc_auto_updater' );
	if( $auto_updater ) {
		$screen = get_current_screen();
		if ( 'visual-composer_page_vc-updater' == $screen->id ) {
			echo '<div class="error"><p><strong>'. esc_html__( 'Activating Page Builder plugin is optional and NOT required for the functionality of the Theme. In every new release of the Theme the latest compatible version of Page Builder is included.', "impeka-wpb-extension" ) .'</strong></p></div>';
		}
	}
}
add_action( 'admin_notices', 'impeka_wpb_ext_license_tab_notice' );


/**
 * Force Page Builder to initialize as "built into the theme". This will hide certain tabs under the Settings->Page Builder page
 */
if ( ! function_exists( 'impeka_wpb_ext_vc_set_as_theme' ) ) {
	function impeka_wpb_ext_vc_set_as_theme() {
		vc_set_as_theme();
	}
}
add_action( 'vc_before_init', 'impeka_wpb_ext_vc_set_as_theme' );


/**
 * Remove Page Builder Redirect on activation
 */
remove_action( 'vc_activation_hook', 'vc_page_welcome_set_redirect' );
remove_action( 'init', 'vc_page_welcome_redirect' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
