<?php
/*
*	Greatives Page Builder Remove Unsupported Elements
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

if ( function_exists( 'vc_remove_element' ) ) {

	add_action( 'init', 'impeka_wpb_ext_remove_vc_shortcodes' );

	if ( !function_exists( 'impeka_wpb_ext_remove_vc_shortcodes' ) && function_exists( 'vc_remove_element' ) ) {

		function impeka_wpb_ext_remove_vc_shortcodes() {

			if ( !impeka_wpb_ext_social_elements_visibility() ) {
				//Social
				vc_remove_element("vc_facebook");
				vc_remove_element("vc_flickr");
				vc_remove_element("vc_googleplus");
				vc_remove_element("vc_pinterest");
				vc_remove_element("vc_tweetmeme");
			}

			if ( !impeka_wpb_ext_wp_elements_visibility() ) {
				//WordPress
				vc_remove_element('vc_wp_custommenu');
				vc_remove_element('vc_wp_tagcloud');
				vc_remove_element('vc_wp_archives');
				vc_remove_element('vc_wp_calendar');
				vc_remove_element('vc_wp_pages');
				vc_remove_element('vc_wp_links');
				vc_remove_element('vc_wp_posts');
				vc_remove_element('vc_wp_categories');
				vc_remove_element('vc_wp_rss');
				vc_remove_element('vc_wp_text');
				vc_remove_element('vc_wp_meta');
				vc_remove_element('vc_wp_recentcomments');
			}

			if ( !impeka_wpb_ext_grid_visibility() ) {
				//Grid Item related
				vc_remove_element('vc_basic_grid');
				vc_remove_element('vc_media_grid');
				vc_remove_element('vc_masonry_grid');
				vc_remove_element('vc_masonry_media_grid');
				vc_remove_element('vc_icon');
				vc_remove_element('vc_single_image');
				vc_remove_element('vc_separator');
				vc_remove_element("vc_text_separator");
				vc_remove_element('vc_btn');
				vc_remove_element('vc_button2');
				vc_remove_element('vc_empty_space');
			}

			if ( !impeka_wpb_ext_charts_visibility() ) {
				//Charts
				vc_remove_element('vc_round_chart');
				vc_remove_element('vc_line_chart');
			}

			if ( !impeka_wpb_ext_woo_visibility() ) {
				//WooCommerce
				vc_remove_element('recent_products');
				vc_remove_element('featured_products');
				vc_remove_element('product');
				vc_remove_element('products');
				vc_remove_element('add_to_cart');
				vc_remove_element('add_to_cart_url');
				vc_remove_element('product_page');
				vc_remove_element('product_category');
				vc_remove_element('product_categories');
				vc_remove_element('sale_products');
				vc_remove_element('best_selling_products');
				vc_remove_element('top_rated_products');
				vc_remove_element('product_attribute');
				vc_remove_element('related_products');
			}

			if ( !impeka_wpb_ext_other_elements_visibility() ) {
				//Other
				vc_remove_element("vc_toggle");
				vc_remove_element("vc_message");
				vc_remove_element("vc_pie");
				vc_remove_element("vc_progress_bar");
				vc_remove_element("vc_tour");
				vc_remove_element('vc_teaser_grid');
				vc_remove_element('vc_posts_grid');
				vc_remove_element('vc_posts_slider');
				vc_remove_element('vc_gallery');
				vc_remove_element('vc_button');
				vc_remove_element('vc_cta_button');
				vc_remove_element('vc_cta_button2');
				vc_remove_element('vc_carousel');
				vc_remove_element('vc_images_carousel');
				vc_remove_element('vc_video');
				vc_remove_element('vc_gmaps');
				vc_remove_element('vc_cta');
				vc_remove_element('vc_tabs');
				vc_remove_element('vc_tab');
				vc_remove_element('vc_accordion');
				vc_remove_element('vc_accordion_tab');
				vc_remove_element('vc_tta_pageable');
				vc_remove_element('vc_zigzag');
				vc_remove_element('vc_hoverbox');
			}

		}
	}
}

if ( function_exists( 'vc_remove_param' ) ) {

	vc_remove_param('vc_tta_tabs', 'title');
	vc_remove_param('vc_tta_tabs', 'style');
	vc_remove_param('vc_tta_tabs', 'shape');
	vc_remove_param('vc_tta_tabs', 'color');
	vc_remove_param('vc_tta_tabs', 'no_fill_content_area');
	vc_remove_param('vc_tta_tabs', 'spacing');
	vc_remove_param('vc_tta_tabs', 'gap');
	vc_remove_param('vc_tta_tabs', 'pagination_style');
	vc_remove_param('vc_tta_tabs', 'pagination_color');
	vc_remove_param('vc_tta_tabs', 'tab_position');
	vc_remove_param('vc_tta_tabs', 'autoplay');
	vc_remove_param('vc_tta_tabs', 'css_animation');

	vc_remove_param('vc_tta_accordion', 'title');
	vc_remove_param('vc_tta_accordion', 'style');
	vc_remove_param('vc_tta_accordion', 'shape');
	vc_remove_param('vc_tta_accordion', 'color');
	vc_remove_param('vc_tta_accordion', 'no_fill_content_area');
	vc_remove_param('vc_tta_accordion', 'spacing');
	vc_remove_param('vc_tta_accordion', 'gap');
	vc_remove_param('vc_tta_accordion', 'pagination_style');
	vc_remove_param('vc_tta_accordion', 'pagination_color');
	vc_remove_param('vc_tta_accordion', 'autoplay');
	vc_remove_param('vc_tta_accordion', 'css_animation');

	vc_remove_param('vc_tta_tour', 'title');
	vc_remove_param('vc_tta_tour', 'style');
	vc_remove_param('vc_tta_tour', 'shape');
	vc_remove_param('vc_tta_tour', 'color');
	vc_remove_param('vc_tta_tour', 'no_fill_content_area');
	vc_remove_param('vc_tta_tour', 'spacing');
	vc_remove_param('vc_tta_tour', 'gap');
	vc_remove_param('vc_tta_tour', 'pagination_style');
	vc_remove_param('vc_tta_tour', 'pagination_color');
	vc_remove_param('vc_tta_tour', 'autoplay');
	vc_remove_param('vc_tta_tour', 'css_animation');

	vc_remove_param('vc_column_text', 'css_animation');

	vc_remove_param('vc_widget_sidebar', 'title');
}

if ( is_admin() ) {
	if ( ! function_exists('impeka_wpb_ext_remove_vc_boxes') ) {
		function impeka_wpb_ext_remove_vc_boxes(){
			$post_types = get_post_types( '', 'names' );
			foreach ( $post_types as $post_type ) {
				remove_meta_box('vc_teaser',  $post_type, 'side');
			}
		}
	}
	add_action('do_meta_boxes', 'impeka_wpb_ext_remove_vc_boxes');
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
