<?php
/**
 * Animated Text Shortcode
 */

function impeka_wpb_ext_animated_text_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'animated-text.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_animated_text', 'impeka_wpb_ext_animated_text_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_animated_text_shortcode_params' ) ) {
	function impeka_wpb_ext_animated_text_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Animated text", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add a animated text", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-animated-text",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "textarea_safe",
					"heading" => esc_html__("Animated Text", "impeka-wpb-extension"),
					"param_name" => "animated_text",
					"description" => 'Text within <b>|</b> will be animated, for example: <strong>|Sample text|</strong>. <br />Text separator is <b>;</b> for example: <strong>|Sample text; new line|</strong> which will create new lines at ;',
					"value" => "|Sample Text;Use your own values!|",
					"save_always" => true,
					"admin_label" => true,
				),
				impeka_wpb_ext_get_heading_tag( "h3" ),
				impeka_wpb_ext_get_heading( "h3" ),
				impeka_wpb_ext_get_heading_increase(),
				impeka_wpb_ext_get_heading_increase_reset(),
				impeka_wpb_ext_get_custom_font_family(),
				impeka_wpb_ext_add_inherit_align(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Style", "impeka-wpb-extension"),
					"param_name" => "style",
					"admin_label" => true,
					"value" => array(
						esc_html__( "Lines", "impeka-wpb-extension" )  => "style-1",
						esc_html__( "Words", "impeka-wpb-extension" )  => "style-2",
						esc_html__( "Characters", "impeka-wpb-extension" )  => "style-3",
					),
					"group" => esc_html__( "Animation", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_animated_text', 'impeka_wpb_ext_animated_text_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
