<?php
/**
 * Area Item Shortcode
 */

function impeka_wpb_ext_area_item_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'area-item.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_area_item', 'impeka_wpb_ext_area_item_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_area_item_shortcode_params' ) ) {
	function impeka_wpb_ext_area_item_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Area Item", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add an area item", "impeka-wpb-extension" ),
			"base" => $tag,
			'allowed_container_element' => false,
			'is_container' => true,
			'class' => 'wpb_vc_row vc_main-sortable-element',
			"icon" => "icon-wpb-grve-area-item",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"show_settings_on_create" => true,
			'as_child' => array(
				'only' => 'vc_section',
			),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Area Item", "impeka-wpb-extension" ),
					"param_name" => "area_id",
					"admin_label" => true,
					'save_always' => true,
					"value" => impeka_wpb_ext_get_area_items(),
					"description" => esc_html__( "Select area item to display.", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_area_item', 'impeka_wpb_ext_area_item_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
