<?php
/**
 * Blog Carousel Shortcode
 */

function impeka_wpb_ext_blog_carousel_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'blog-carousel.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_blog_carousel', 'impeka_wpb_ext_blog_carousel_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_blog_carousel_shortcode_params' ) ) {
	function impeka_wpb_ext_blog_carousel_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Blog Carousel", "impeka-wpb-extension" ),
			"description" => esc_html__( "Display a Blog Carousel element", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-blog-carousel",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Type", "impeka-wpb-extension" ),
					"param_name" => "type",
					"admin_label" => true,
					"value" => array(
						esc_html__( 'Classic', 'impeka-wpb-extension' ) => 'classic',
						esc_html__( 'Advanced', 'impeka-wpb-extension' ) => 'advanced',
					),
					"description" => esc_html__( "Select your Carousel Type.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Media Area Visibility", "impeka-wpb-extension" ),
					"param_name" => "media_area",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"std" => "yes",
					"description" => esc_html__( "Select if you want to enable/disable media area", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
					"param_name" => "image_load_mode",
					'value' => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
						esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
						esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
						esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
					),
					"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_area", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Size", "impeka-wpb-extension" ),
					"param_name" => "image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
						esc_html__( 'Landscape Medium Crop', 'impeka-wpb-extension' ) => 'landscape-medium',
						esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
						esc_html__( 'Portrait Medium Crop', 'impeka-wpb-extension' ) => 'portrait-medium',
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
					) ),
					"std" => 'landscape',
					"description" => esc_html__( "Select your Image Size.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_area", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items per page", "impeka-wpb-extension" ),
					"param_name" => "items_per_page",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					"description" => esc_html__( "Number of items per page", "impeka-wpb-extension" ),
					"std" => '3',
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Tablet Landscape", "impeka-wpb-extension" ),
					"param_name" => "items_tablet_landscape",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					"std" => '2',
					"description" => esc_html__( "Select number of items on tablet devices, landscape orientation.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Tablet Portrait", "impeka-wpb-extension" ),
					"param_name" => "items_tablet_portrait",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					"std" => '2',
					"description" => esc_html__( "Select number of items on tablet devices, portrait orientation.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Mobile", "impeka-wpb-extension" ),
					"param_name" => "items_mobile",
					"value" => array(
						'1' => '1',
						'2' => '2',
					),
					"std" => '1',
					"description" => esc_html__( "Select number of items on mobile devices.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Items to show", "impeka-wpb-extension" ),
					"param_name" => "posts_per_page",
					"value" => "10",
					"description" => esc_html__( "Maximum Items to Show", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between items", "impeka-wpb-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"description" => esc_html__( "Add gutter among items.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "type", 'value' => array( 'classic' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "impeka-wpb-extension" ),
					"param_name" => "gutter_size",
					"value" => '40',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Excerpt Length", "impeka-wpb-extension" ),
					"param_name" => "excerpt_length",
					"description" => esc_html__( "Type how many words you want to display in your post excerpts.", "impeka-wpb-extension" ),
					"value" => '15',
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Read More", "impeka-wpb-extension" ),
					"param_name" => "excerpt_more",
					"description" => esc_html__( "Adds a read more button after the excerpt or more quicktag", "impeka-wpb-extension" ),
					"value" => array( esc_html__( "Add more button", "impeka-wpb-extension" ) => 'yes' ),
				),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Read More Text", "impeka-wpb-extension" ),
					"param_name" => "excerpt_more_text",
					"description" => esc_html__( "Type how many words you want to display in your post excerpts.", "impeka-wpb-extension" ),
					"value" => 'read more',
					"dependency" => array( 'element' => "excerpt_more", 'value' => array( 'yes' ) ),
				),
				impeka_wpb_ext_add_order_by(),
				impeka_wpb_ext_add_order(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				//Styles
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Style", "impeka-wpb-extension" ),
					"param_name" => "style",
					"value" => array(
						esc_html__( "Style 1", "impeka-wpb-extension" ) => 'style-1',
						esc_html__( "Style 2", "impeka-wpb-extension" ) => 'style-2',
						esc_html__( "Style 3", "impeka-wpb-extension" ) => 'style-3',
					),
					'description' => esc_html__( "Select your blog style", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Heading Color", "impeka-wpb-extension" ),
					"param_name" => "heading_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the heading color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2', 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the text color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2', 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Meta Color", "impeka-wpb-extension" ),
					"param_name" => "meta_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the meta color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2', 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Background Color", "impeka-wpb-extension" ),
					"param_name" => "bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the background color", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2', 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border Color", "impeka-wpb-extension" ),
					"param_name" => "border_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the border color", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "impeka-wpb-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'gradient', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the overlay color ( only if Featured Image is set ).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "impeka-wpb-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array(
						esc_html__( "Default", "impeka-wpb-extension" ) => 'default',
						esc_html__( "0%", "impeka-wpb-extension" ) => '0',
						esc_html__( "10%", "impeka-wpb-extension" ) => '10',
						esc_html__( "20%", "impeka-wpb-extension" ) => '20',
						esc_html__( "30%", "impeka-wpb-extension" ) => '30',
						esc_html__( "40%", "impeka-wpb-extension" ) => '40',
						esc_html__( "50%", "impeka-wpb-extension" ) => '50',
						esc_html__( "60%", "impeka-wpb-extension" ) => '60',
						esc_html__( "70%", "impeka-wpb-extension" ) => '70',
						esc_html__( "80%", "impeka-wpb-extension" ) => '80',
						esc_html__( "90%", "impeka-wpb-extension" ) => '90',
						esc_html__( "100%", "impeka-wpb-extension" ) => '100',
					),
					"std" => 'default',
					"description" => esc_html__( "Choose the overlay opacity ( only if Featured Image is set ).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
					),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "type", 'value' => array( 'advanced' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
					"param_name" => "radius",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
						esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
						esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
						esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
						esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
						esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
						esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
						esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
					),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
				),
				//Titles
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Title Tag", "impeka-wpb-extension" ),
					"param_name" => "title_heading_tag",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "div", "impeka-wpb-extension" ) => 'div',
					),
					"description" => esc_html__( "Post Title Tag for SEO", "impeka-wpb-extension" ),
					"std" => 'h3',
					"group" => esc_html__( "Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "title_heading",
					"value" => array(
						esc_html__( "Auto", "impeka-wpb-extension" ) => 'auto',
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Post Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"std" => 'auto',
					"group" => esc_html__( "Titles", "impeka-wpb-extension" ),
				),
				//Navigation
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Behavior", 'impeka-wpb-extension'),
					"param_name" => "label_behavior",
					'value' => '',
					"std" => '',
					"description" => esc_html__( "Configure the carousel behavior", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Loop", "impeka-wpb-extension" ),
					"param_name" => "loop",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Autoplay", "impeka-wpb-extension" ),
					"param_name" => "auto_play",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Slideshow Speed", "impeka-wpb-extension" ),
					"param_name" => "slideshow_speed",
					"value" => '3000',
					"description" => esc_html__( "Slideshow Speed in ms.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "type", 'value' => array( 'classic' ) ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Pause on Hover", "impeka-wpb-extension" ),
					"param_name" => "pause_hover",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"std" => "no",
					"description" => esc_html__( "If selected, carousel will be paused on hover", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "type", 'value' => array( 'classic' ) ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Navigation", 'impeka-wpb-extension'),
					"param_name" => "label_pagination",
					'value' => '',
					"std" => '',
					"description" => esc_html__( "Configure the carousel navigation", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_navigation( 'yes' ),
				impeka_wpb_ext_add_navigation_icon( 'arrow-1' ),
				impeka_wpb_ext_add_navigation_icon_color( 'black' ),
				impeka_wpb_ext_add_navigation_shape(),
				impeka_wpb_ext_add_navigation_shape_type(),
				impeka_wpb_ext_add_navigation_shape_color(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Pagination", "impeka-wpb-extension" ),
					"param_name" => "pagination",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"std" => "yes",
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Pagination Speed", "impeka-wpb-extension" ),
					"param_name" => "pagination_speed",
					"value" => '400',
					"description" => esc_html__( "Pagination Speed in ms ( Only available for Classic Carousel ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Extras", 'impeka-wpb-extension'),
					"description" => esc_html__( "Extras display settings", "impeka-wpb-extension" ),
					"param_name" => "label_extras",
					'value' => '',
					"std" => '',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Link Type", "impeka-wpb-extension" ),
					"param_name" => "link_type",
					'value' => array(
						esc_html__( 'Classic Post' , 'impeka-wpb-extension' ) => 'item',
						esc_html__( 'Quick View' , 'impeka-wpb-extension' ) => 'quick-view',
					),
					"description" => esc_html__( "Select the link type of your post items.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Author Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_author",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the author field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Date Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_date",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the date field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Comments Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_comments",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the comments field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Like Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_like",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the like field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Categories Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_categories",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the categories field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Categories Mode", "impeka-wpb-extension" ),
					"param_name" => "categories_mode",
					"value" => array(
						esc_html__( "All", "impeka-wpb-extension" ) => 'all',
						esc_html__( "First / Primary", "impeka-wpb-extension" ) => 'one',

					),
					"std" => 'all',
					"dependency" => array( 'element' => "show_categories", 'value' => array( 'yes' ) ),
					"description" => esc_html__( "Select your category mode", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Exclude Posts", "impeka-wpb-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Categories", "impeka-wpb-extension" ),
					"param_name" => "categories",
					"value" => impeka_wpb_ext_get_post_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "impeka-wpb-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_blog_carousel', 'impeka_wpb_ext_blog_carousel_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
