<?php
/**
 * Blog Leader Shortcode
 */

function impeka_wpb_ext_blog_leader_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'blog-leader.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_blog_leader', 'impeka_wpb_ext_blog_leader_shortcode' );


/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_blog_leader_shortcode_params' ) ) {
	function impeka_wpb_ext_blog_leader_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Blog Leader", "impeka-wpb-extension" ),
			"description" => esc_html__( "Display a Blog element in leader style", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-blog-leader",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Number of Posts", "impeka-wpb-extension" ),
					"param_name" => "posts_per_page",
					"value" => array(
						esc_html__( "Leader Only", "impeka-wpb-extension" ) => '1',
						esc_html__( "Leader + 2 columns", "impeka-wpb-extension" ) => '3',
						esc_html__( "Leader + 3 columns", "impeka-wpb-extension" ) => '4',
						esc_html__( "Leader + 4 columns", "impeka-wpb-extension" ) => '5',
					),
					"description" => esc_html__( "Enter how many posts you want to display.", "impeka-wpb-extension" ),
					"std" => '4',
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
					"param_name" => "image_load_mode",
					'value' => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
						esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
						esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
						esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
					),
					"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Mode", "impeka-wpb-extension" ),
					"param_name" => "image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
					) ),
					"description" => esc_html__( "Select your Blog Image Mode.", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Excerpt length", "impeka-wpb-extension" ),
					"param_name" => "excerpt_length",
					"description" => esc_html__( "Type how many words you want to display in your post excerpts.", "impeka-wpb-extension" ),
					"value" => '30',
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Read More", "impeka-wpb-extension" ),
					"param_name" => "excerpt_more",
					"description" => esc_html__( "Adds a read more button after the excerpt or more quicktag", "impeka-wpb-extension" ),
					"value" => array( esc_html__( "Add more button", "impeka-wpb-extension" ) => 'yes' ),
				),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Read More Text", "impeka-wpb-extension" ),
					"param_name" => "excerpt_more_text",
					"description" => esc_html__( "Type your read more text.", "impeka-wpb-extension" ),
					"value" => 'read more',
					"dependency" => array( 'element' => "excerpt_more", 'value' => array( 'yes' ) ),
				),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				impeka_wpb_ext_add_order_by(),
				impeka_wpb_ext_add_order(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Leader Style", "impeka-wpb-extension" ),
					"param_name" => "leader_style",
					'value' => array(
						esc_html__( 'Horizontal', 'impeka-wpb-extension' ) => '',
						esc_html__( 'Vertical', 'impeka-wpb-extension' ) => "vertical",
					),
					"description" => esc_html__( "Select your Post Leader Style.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Leader Background Color", "impeka-wpb-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'gradient', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "This affects the Background of the item.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Leader Background Opacity", "impeka-wpb-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array( '0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100' ),
					"std" => '30',
					"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Styles", "impeka-wpb-extension" ),
				),
				//Titles & Styles
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Title Tag", "impeka-wpb-extension" ),
					"param_name" => "heading_tag",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "div", "impeka-wpb-extension" ) => 'div',
					),
					"description" => esc_html__( "Post Title Tag for SEO", "impeka-wpb-extension" ),
					"std" => 'h2',
					"group" => esc_html__( "Titles & Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Leader Post Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Leader Post Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"std" => 'h2',
					"group" => esc_html__( "Titles & Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Small Post Titles Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "small_post_heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Small Post Titles size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"std" => 'h5',
					"group" => esc_html__( "Titles & Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Extras", 'impeka-wpb-extension'),
					"description" => esc_html__( "Extras display settings", "impeka-wpb-extension" ),
					"param_name" => "label_extras",
					'value' => '',
					"std" => '',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Author Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_author",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the author field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Date Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_date",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the date field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Comments Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_comments",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the comments field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Like Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_like",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the like field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				//Categories
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Exclude Posts", "impeka-wpb-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__( "Categories", "impeka-wpb-extension" ),
					"param_name" => "categories",
					"value" => impeka_wpb_ext_get_post_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "impeka-wpb-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_blog_leader', 'impeka_wpb_ext_blog_leader_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
