<?php
/**
 * Blog Shortcode
 */

function impeka_wpb_ext_blog_shortcode( $atts, $content = '' ) {
	return impeka_wpb_ext_locate_template( 'blog.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_blog', 'impeka_wpb_ext_blog_shortcode' );


/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_blog_shortcode_params' ) ) {
	function impeka_wpb_ext_blog_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Blog", "impeka-wpb-extension" ),
			"description" => esc_html__( "Display a Blog element in multiple styles", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-blog",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Blog Mode", "impeka-wpb-extension" ),
					"param_name" => "mode",
					"admin_label" => true,
					'value' => array(
						esc_html__( 'Large Media', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Small Media', 'impeka-wpb-extension' ) => 'small',
						esc_html__( 'Masonry' , 'impeka-wpb-extension' ) => 'masonry',
						esc_html__( 'Grid' , 'impeka-wpb-extension' ) => 'grid',
					),
					"description" => esc_html__( "Select your Blog Mode.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Media Area Visibility", "impeka-wpb-extension" ),
					"param_name" => "media_area",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"std" => "yes",
					"description" => esc_html__( "Select if you want to enable/disable media area", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
					"param_name" => "image_load_mode",
					'value' => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
						esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
						esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
						esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
					),
					"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_area", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Featured Image Priority", "impeka-wpb-extension" ),
					"param_name" => "image_prio",
					"description" => esc_html__( "Featured image is displayed instead of media element", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_area", 'value' => array( 'yes' ) ),
					"value" => array( esc_html__( "Featured Image Priority", "impeka-wpb-extension" ) => 'yes' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Width", "impeka-wpb-extension" ),
					"param_name" => "image_width",
					'value' => array(
						esc_html__( "Normal", "impeka-wpb-extension" ) => 'normal',
						esc_html__( "Wide", "impeka-wpb-extension" ) => 'wide',
					),
					"std" => 'normal',
					"description" => esc_html__( "Select the feature image width.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'large' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Size", "impeka-wpb-extension" ),
					"param_name" => "image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Landscape Large Wide Crop', 'impeka-wpb-extension' ) => 'landscape-large-wide',
						esc_html__( 'Landscape Medium Crop', 'impeka-wpb-extension' ) => 'landscape-medium',
						esc_html__( 'Resize ( Extra Extra Large )' , 'impeka-wpb-extension' ) => 'extra-extra-large',
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
					) ),
					"std" => 'landscape-large-wide',
					"description" => esc_html__( "Select your Blog Image Size.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'large' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Grid Image Size", "impeka-wpb-extension" ),
					"param_name" => "grid_image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
						esc_html__( 'Landscape Medium Crop', 'impeka-wpb-extension' ) => 'landscape-medium',
						esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
						esc_html__( 'Portrait Medium Crop', 'impeka-wpb-extension' ) => 'portrait-medium',
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
					) ),
					"std" => 'landscape',
					"description" => esc_html__( "Select your Blog Grid Image Size.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'small', 'grid' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Masonry Image Size", "impeka-wpb-extension" ),
					"param_name" => "masonry_image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
					) ),
					"std" => 'medium',
					"description" => esc_html__( "Select your Blog Masonry Image Size.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Large Screen Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_large_screen",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5'
					),
					"std" => '3',
					"description" => esc_html__( "Select your Blog Columns.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'grid', 'masonry' ) ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Columns", "impeka-wpb-extension" ),
					"param_name" => "columns",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5'
					),
					"std" => '3',
					"description" => esc_html__( "Select your Blog Columns.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'grid', 'masonry' ) ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Landscape Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_tablet_landscape",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, landscape orientation.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'grid', 'masonry' ) ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Portrait Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_tablet_portrait",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, portrait orientation.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'grid', 'masonry' ) ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Mobile Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_mobile",
					"value" => array(
						'1' => '1',
						'2' => '2',
					),
					"std" => '1',
					"description" => esc_html__( "Select responsive column on mobile devices.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'grid', 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between items", "impeka-wpb-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"description" => esc_html__( "Add gutter among items.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'grid', 'masonry' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "impeka-wpb-extension" ),
					"param_name" => "gutter_size",
					"value" => '40',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Auto excerpt", "impeka-wpb-extension" ),
					"param_name" => "auto_excerpt",
					"description" => esc_html__( "Adds automatic excerpt to all posts in Large Media style. If auto excerpt is not selected, blog will show all content, a desired 'cut-off' point can be inserted in each post with more quicktag.", "impeka-wpb-extension" ),
					"value" => array( esc_html__( "Activate auto excerpt.", "impeka-wpb-extension" ) => 'yes' ),
					"std" => 'yes',
					"dependency" => array( 'element' => "mode", 'value' => array( 'large' ) ),
				),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Excerpt Length", "impeka-wpb-extension" ),
					"param_name" => "excerpt_length_large",
					"description" => esc_html__( "Type how many words you want to display in your post excerpts.", "impeka-wpb-extension" ),
					"value" => '55',
					"dependency" => array( 'element' => "auto_excerpt", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Excerpt Length", "impeka-wpb-extension" ),
					"param_name" => "excerpt_length",
					"description" => esc_html__( "Type how many words you want to display in your post excerpts.", "impeka-wpb-extension" ),
					"value" => '30',
					"dependency" => array( 'element' => "mode", 'value' => array( 'small', 'grid', 'masonry' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Read More", "impeka-wpb-extension" ),
					"param_name" => "excerpt_more",
					"description" => esc_html__( "Adds a read more button after the excerpt or more quicktag", "impeka-wpb-extension" ),
					"value" => array( esc_html__( "Add more button", "impeka-wpb-extension" ) => 'yes' ),
				),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Read More Text", "impeka-wpb-extension" ),
					"param_name" => "excerpt_more_text",
					"description" => esc_html__( "Enter the title for your read more link", "impeka-wpb-extension" ),
					"value" => 'read more',
					"dependency" => array( 'element' => "excerpt_more", 'value' => array( 'yes' ) ),
				),
				impeka_wpb_ext_add_order_by(),
				impeka_wpb_ext_add_order(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "CSS Animation", "impeka-wpb-extension"),
					"param_name" => "animation",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Fade In", "impeka-wpb-extension" ) => "fade-in",
						esc_html__( "Fade In Up", "impeka-wpb-extension" ) => "fade-in-up",
						esc_html__( "Fade In Down", "impeka-wpb-extension" ) => "fade-in-down",
						esc_html__( "Fade In Left", "impeka-wpb-extension" ) => "fade-in-left",
						esc_html__( "Fade In Right", "impeka-wpb-extension" ) => "fade-in-right",
						esc_html__( "Zoom In", "impeka-wpb-extension" ) => "zoom-in",
					),
					"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
					"std" => "",
				),
				impeka_wpb_ext_add_margin_bottom(),
				array(
					"type" => "el_id",
					"heading" => esc_html__( "Element ID", "impeka-wpb-extension" ),
					'description' => esc_html__( "Enter element ID (Note: make sure it is unique)", "impeka-wpb-extension" ),
					"param_name" => "el_id",
					'settings' => array(
						'auto_generate' => true,
					),
				),
				impeka_wpb_ext_add_el_class(),
				//Styles
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Style", "impeka-wpb-extension" ),
					"param_name" => "style",
					"value" => array(
						esc_html__( "Style 1", "impeka-wpb-extension" ) => 'style-1',
						esc_html__( "Style 2", "impeka-wpb-extension" ) => 'style-2',
						esc_html__( "Style 3", "impeka-wpb-extension" ) => 'style-3',
					),
					'description' => esc_html__( "Select your blog style", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'grid', 'masonry' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Style", "impeka-wpb-extension" ),
					"param_name" => "small_style",
					"value" => array(
						esc_html__( "Style 1", "impeka-wpb-extension" ) => 'style-small-1',
						esc_html__( "Style 2", "impeka-wpb-extension" ) => 'style-small-2',
					),
					'description' => esc_html__( "Select your blog style", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'small' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Custom Overview Style", "impeka-wpb-extension" ),
					"param_name" => "custom_overview",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"std" => "no",
					'description' => esc_html__( "Select if you want to overwrite the style from each post", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'grid', 'masonry' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Heading Color", "impeka-wpb-extension" ),
					"param_name" => "heading_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the heading color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2', 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the text color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2', 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Meta Color", "impeka-wpb-extension" ),
					"param_name" => "meta_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the meta color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2', 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Background Color", "impeka-wpb-extension" ),
					"param_name" => "bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'gradient', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the background color", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2', 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border Color", "impeka-wpb-extension" ),
					"param_name" => "border_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the border color", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "impeka-wpb-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'gradient', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the overlay color ( only if Featured Image is set ).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "impeka-wpb-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array(
						esc_html__( "Default", "impeka-wpb-extension" ) => 'default',
						esc_html__( "0%", "impeka-wpb-extension" ) => '0',
						esc_html__( "10%", "impeka-wpb-extension" ) => '10',
						esc_html__( "20%", "impeka-wpb-extension" ) => '20',
						esc_html__( "30%", "impeka-wpb-extension" ) => '30',
						esc_html__( "40%", "impeka-wpb-extension" ) => '40',
						esc_html__( "50%", "impeka-wpb-extension" ) => '50',
						esc_html__( "60%", "impeka-wpb-extension" ) => '60',
						esc_html__( "70%", "impeka-wpb-extension" ) => '70',
						esc_html__( "80%", "impeka-wpb-extension" ) => '80',
						esc_html__( "90%", "impeka-wpb-extension" ) => '90',
						esc_html__( "100%", "impeka-wpb-extension" ) => '100',
					),
					"std" => 'default',
					"description" => esc_html__( "Choose the overlay opacity ( only if Featured Image is set ).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-3' ) ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
					),
					"std" => 'none',
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
					"param_name" => "radius",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
						esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
						esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
						esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
						esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
						esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
						esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
						esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
					),
					"std" => 'none',
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Indicator", "impeka-wpb-extension" ),
					"param_name" => "indicator",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Arrow", "impeka-wpb-extension" ) => 'arrow',
						esc_html__( "Plus", "impeka-wpb-extension" ) => 'plus',
						esc_html__( "Text", "impeka-wpb-extension" ) => 'text',
					),
					"std" => 'none',
					"description" => esc_html__( "Choose the indicator.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-2', 'style-3' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Indicator Text", "impeka-wpb-extension" ),
					"param_name" => "indicator_text",
					"value" => 'More',
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "indicator", 'value' => array( 'text' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Indicator Color", "impeka-wpb-extension" ),
					"param_name" => "indicator_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'primary-1',
					"description" => esc_html__( "Choose the indicator color.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "indicator", 'value_not_equal_to' => array( 'none' ) ),
				),
				//Titles
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Title Tag", "impeka-wpb-extension" ),
					"param_name" => "title_heading_tag",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "div", "impeka-wpb-extension" ) => 'div',
					),
					"description" => esc_html__( "Post Title Tag for SEO", "impeka-wpb-extension" ),
					"std" => 'h3',
					"group" => esc_html__( "Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "title_heading",
					"value" => array(
						esc_html__( "Auto", "impeka-wpb-extension" ) => 'auto',
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Post Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"std" => 'auto',
					"group" => esc_html__( "Titles", "impeka-wpb-extension" ),
				),
				//Pagination
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Pagination", 'impeka-wpb-extension'),
					"description" => esc_html__( "Define the items to show per page or the total items number according to the selected display style.", "impeka-wpb-extension" ),
					"param_name" => "label_pagination",
					'value' => '',
					"std" => '',
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Posts per Page", "impeka-wpb-extension" ),
					"param_name" => "posts_per_page",
					"value" => "10",
					"description" => esc_html__( "Enter how many posts per page you want to display.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Display Style", "impeka-wpb-extension" ),
					"param_name" => "display_style",
					"value" => array(
						esc_html__( "Show All", "impeka-wpb-extension" ) => '',
						esc_html__( "Pagination", "impeka-wpb-extension" ) => 'pagination',
						esc_html__( "Load More", "impeka-wpb-extension" ) => 'load-more',
						esc_html__( "Infinite Scroll", "impeka-wpb-extension" ) => 'infinite-scroll',
					),
					"std" => 'pagination',
					"description" => esc_html__( "Select Show All or define your pagination style.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'small','grid', 'masonry' ) ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Display Style", "impeka-wpb-extension" ),
					"param_name" => "display_large_style",
					"value" => array(
						esc_html__( "Show All", "impeka-wpb-extension" ) => '',
						esc_html__( "Pagination", "impeka-wpb-extension" ) => 'pagination',
					),
					"std" => 'pagination',
					"description" => esc_html__( "Select Show All or define your pagination style.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'large' ) ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Load More Title", "impeka-wpb-extension" ),
					"param_name" => "load_more_title",
					"value" => 'Load More',
					"description" => esc_html__( "Title for load more.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "display_style", 'value' => array( 'load-more' ) ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Extras", 'impeka-wpb-extension'),
					"description" => esc_html__( "Extras display settings", "impeka-wpb-extension" ),
					"param_name" => "label_extras",
					'value' => '',
					"std" => '',
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Link Type", "impeka-wpb-extension" ),
					"param_name" => "link_type",
					'value' => array(
						esc_html__( 'Classic Post' , 'impeka-wpb-extension' ) => 'item',
						esc_html__( 'Quick View' , 'impeka-wpb-extension' ) => 'quick-view',
					),
					"description" => esc_html__( "Select the link type of your post items.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Author Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_author",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the author field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Date Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_date",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the date field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Comments Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_comments",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the comments field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Like Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_like",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the like field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Categories Field Visibility", "impeka-wpb-extension" ),
					"param_name" => "show_categories",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',

					),
					"description" => esc_html__( "Enable or Disable the categories field of your blog overview.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Categories Mode", "impeka-wpb-extension" ),
					"param_name" => "categories_mode",
					"value" => array(
						esc_html__( "All", "impeka-wpb-extension" ) => 'all',
						esc_html__( "First / Primary", "impeka-wpb-extension" ) => 'one',

					),
					"std" => 'all',
					"dependency" => array( 'element' => "show_categories", 'value' => array( 'yes' ) ),
					"description" => esc_html__( "Select your category mode", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				//Filters
				impeka_wpb_ext_add_filter(),
				impeka_wpb_ext_add_filter_all_text(),
				impeka_wpb_ext_add_filter_order_by(),
				impeka_wpb_ext_add_filter_order(),
				impeka_wpb_ext_add_filter_style(),
				impeka_wpb_ext_add_filter_shape(),
				impeka_wpb_ext_add_filter_color(),
				impeka_wpb_ext_add_filter_align(),
				impeka_wpb_ext_add_filter_gototop(),
				//Categories
				array(
					"type" => "textfield",
					"heading" => esc_html__("Exclude Posts", "impeka-wpb-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Categories", "impeka-wpb-extension" ),
					"param_name" => "categories",
					"value" => impeka_wpb_ext_get_post_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "impeka-wpb-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_blog', 'impeka_wpb_ext_blog_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
