<?php
/**
 * Button Group Shortcode
 */

function impeka_wpb_ext_button_group_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'button-group.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_button_group', 'impeka_wpb_ext_button_group_shortcode' );


/**
 * Add shortcode container class
 */

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_impeka_button_group extends WPBakeryShortCodesContainer {
    }
}

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_button_group_shortcode_params' ) ) {
	function impeka_wpb_ext_button_group_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Button Group", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add multiple buttons in a group", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon" => "icon-wpb-grve-button-group",
			"category" => esc_html__( "Content", "js_composer" ),
			"content_element" => true,
			"controls" => "full",
			"show_settings_on_create" => true,
			"as_parent" => array('only' => 'impeka_button'),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Item Spacing", "impeka-wpb-extension" ),
					"param_name" => "item_space",
					"value" => array( '0', '1', '5', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55', '60' ),
					"std" => '30',
					"description" => esc_html__( "Set the space between the buttons in px.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_inherit_align(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				array(
					"type" => "el_id",
					"heading" => esc_html__( "Element ID", "impeka-wpb-extension" ),
					'description' => esc_html__( "Enter element ID (Note: make sure it is unique)", "impeka-wpb-extension" ),
					"param_name" => "el_id",
					'settings' => array(
						'auto_generate' => true,
					),
				),
			),
			"js_view" => 'VcColumnView',
			'default_content' => '[impeka_button][impeka_button]',
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_button_group', 'impeka_wpb_ext_button_group_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
