<?php
/**
 * Button Shortcode
 */

function impeka_wpb_ext_button_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'button.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_button', 'impeka_wpb_ext_button_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_button_shortcode_params' ) ) {
	function impeka_wpb_ext_button_shortcode_params( $tag ) {

		return array(
			"name" => esc_html__( "Button", "impeka-wpb-extension" ),
			"description" => esc_html__( "Several styles, sizes and colors for your buttons", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-button",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Button Dimensions", "impeka-wpb-extension" ),
						"param_name" => "btn_fluid",
						'value' => array(
							esc_html__( 'Auto' , 'impeka-wpb-extension' ) => '',
							esc_html__( 'Fluid ( Full Width )' , 'impeka-wpb-extension' ) => 'yes',
							esc_html__( 'Custom' , 'impeka-wpb-extension' ) => 'custom',
						),
						"std" => '',
						"description" => esc_html__( "Select dimensions for your button.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Button Height", "impeka-wpb-extension" ),
						"param_name" => "btn_fluid_height",
						'value' => array(
							esc_html__( 'Short' , 'impeka-wpb-extension' ) => 'short',
							esc_html__( 'Medium' , 'impeka-wpb-extension' ) => 'medium',
							esc_html__( 'Tall' , 'impeka-wpb-extension' ) => 'tall',
						),
						"std" => 'medium',
						"description" => esc_html__( "Select height for your fluid button.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "btn_fluid", 'value' => array( 'yes' ) ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Button Width", "impeka-wpb-extension" ),
						"param_name" => "btn_custom_width",
						"value" => "250",
						"description" => esc_html__( "Enter the width for your button (Note: CSS measurement units allowed).", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "btn_fluid", 'value' => array( 'custom' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Alignment", "impeka-wpb-extension" ),
						"param_name" => "align",
						"value" => array(
							esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
							esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
							esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
							esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
						),
						"description" => '( Inherit )Inherits its value from its column text align definition.',
						"dependency" => array( 'element' => "btn_fluid", 'value_not_equal_to' => array( 'yes' ) ),
					),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
				),
				//Button Tab
				impeka_wpb_ext_get_button_params(),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_button', 'impeka_wpb_ext_button_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
