<?php
/**
 * Callout Shortcode
 */

function impeka_wpb_ext_callout_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'callout.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_callout', 'impeka_wpb_ext_callout_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_callout_shortcode_params' ) ) {
	function impeka_wpb_ext_callout_shortcode_params( $tag ) {

		return array(
			"name" => esc_html__( "Callout", "impeka-wpb-extension" ),
			"description" => esc_html__( "Two different styles for interesting callouts", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-callout",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
						"param_name" => "title",
						"value" => "Sample Title",
						"description" => esc_html__( "Enter your title.", "impeka-wpb-extension" ),
						"admin_label" => true,
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
						"param_name" => "title_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
						"description" => esc_html__( "Select the color of your title.", "impeka-wpb-extension" ),
					),
					impeka_wpb_ext_get_heading_tag( "h3" ),
					impeka_wpb_ext_get_heading( "h3" ),
					impeka_wpb_ext_get_custom_font_family(),
					array(
						"type" => "textarea",
						"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
						"param_name" => "content",
						"value" => "Sample Text",
						"description" => esc_html__( "Enter your text.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
						"param_name" => "text_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
						"description" => esc_html__( "Select the color of your text.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Text Style", "impeka-wpb-extension" ),
						"param_name" => "text_style",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Leader", "impeka-wpb-extension" ) => 'leader-text',
							esc_html__( "Subtitle", "impeka-wpb-extension" ) => 'subtitle',
							esc_html__( "Page Description", "impeka-wpb-extension" ) => 'page-description',
						),
						"description" => esc_html__( "Select your text style.", 'impeka-wpb-extension' ),
					),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
				),
				//Button Tab
				impeka_wpb_ext_get_button_params(),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_callout', 'impeka_wpb_ext_callout_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
