<?php
/**
 * Double Image Text Shortcode
 */

function impeka_wpb_ext_cascading_image_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'cascading-image.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_cascading_image', 'impeka_wpb_ext_cascading_image_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_cascading_image_shortcode_params' ) ) {
	function impeka_wpb_ext_cascading_image_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Cascading Images", "impeka-wpb-extension" ),
			"description" => esc_html__( "Combine images", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-double-image-text",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(

				array(
					'type' => 'param_group',
					'param_name' => 'image_item',
					'heading' => esc_html__( "Image", "impeka-wpb-extension" ),
					"description" => esc_html__( "Configure your images.", "impeka-wpb-extension" ),
					'value' => urlencode( json_encode( array(
						array(
							'label' => 'Image 1',
							'offset_x' => '',
							'offset_y' => '',
						),
						array(
							'label' => 'Image 2',
							'offset_x' => '10%',
							'offset_y' => '10%',
						),
					) ) ),
					'params' => array(
						array(
							"type" => "textfield",
							"heading" => esc_html__( "Label", "impeka-wpb-extension" ),
							"param_name" => "label",
							"value" => "",
							"description" => esc_html__( "Enter your image label ( only for backend ).", "impeka-wpb-extension" ),
							"admin_label" => true,
						),
						array(
							"type" => "dropdown",
							"heading" => esc_html__( "Image Size", "impeka-wpb-extension" ),
							"param_name" => "image_mode",
							'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
								esc_html__( 'Full ( Custom )', 'impeka-wpb-extension' ) => '',
								esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
								esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
								esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
								esc_html__( 'Resize ( Extra Extra Large )', 'impeka-wpb-extension' ) => 'extra-extra-large',
								esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
								esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
								esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
								esc_html__( 'Thumbnail', 'impeka-wpb-extension' ) => 'thumbnail',
							) ),
							"std" => '',
							"description" => esc_html__( "Select your Image Size.", "impeka-wpb-extension" ),
							"group" => esc_html__( "First Image", "impeka-wpb-extension" ),
						),
						array(
							"type" => "attach_image",
							"heading" => esc_html__( "Image", "impeka-wpb-extension" ),
							"param_name" => "image",
							"value" => '',
							"description" => esc_html__( "Select an image.", "impeka-wpb-extension" ),
							"group" => esc_html__( "First Image", "impeka-wpb-extension" ),
							'edit_field_class' => 'vc_col-sm-6',
						),
						array(
							"type" => "attach_image",
							"heading" => esc_html__( "Retina Image", "impeka-wpb-extension" ),
							"param_name" => "retina_image",
							"value" => '',
							"description" => esc_html__( "Select a 2x image.", "impeka-wpb-extension" ),
							"group" => esc_html__( "First Image", "impeka-wpb-extension" ),
							"dependency" => array( 'element' => "image_mode", 'value' => array( '' ) ),
							'edit_field_class' => 'vc_col-sm-6',
						),
						array(
							"type" => "textfield",
							"heading" => esc_html__( "Offset X", "impeka-wpb-extension" ),
							"param_name" => "offset_x",
							"value" => '',
							"std" => '',
							"description" => '',
							"admin_label" => true,
						),
						array(
							"type" => "textfield",
							"heading" => esc_html__( "Offset Y", "impeka-wpb-extension" ),
							"param_name" => "offset_y",
							"value" =>'',
							"std" => '',
							"description" => '',
							"admin_label" => true,
						),
						array(
							"type" => "dropdown",
							"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
							"param_name" => "radius",
							"value" => array(
								esc_html__( "None", "impeka-wpb-extension" ) => 'none',
								esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
								esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
								esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
								esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
								esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
								esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
								esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
								esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
								esc_html__( "Circle", "impeka-wpb-extension" ) => 'circle',
							),
							"description" => '',
						),
						array(
							"type" => "dropdown",
							"heading" => esc_html__( "Shadow", "impeka-wpb-extension" ),
							"param_name" => "shadow",
							"value" => array(
								esc_html__( "None", "impeka-wpb-extension" ) => 'none',
								esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
								esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
								esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
							),
						),
						impeka_wpb_ext_add_animation(),
						impeka_wpb_ext_add_animation_delay(),
						impeka_wpb_ext_add_animation_duration(),
					),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
					"param_name" => "image_load_mode",
					'value' => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
						esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
						esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
						esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
					),
					"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
				),
				array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Image Width", "impeka-wpb-extension" ),
						"param_name" => "image_width",
						'value' => array(
							esc_html__( 'Auto', 'impeka-wpb-extension' ) => 'auto',
							esc_html__( 'Column Width', 'impeka-wpb-extension' ) => '100',
							
						),
						"std" => 'auto',
						"description" => esc_html__( "Select if you want your image to fill the column space.", "impeka-wpb-extension" ),
					),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_cascading_image', 'impeka_wpb_ext_cascading_image_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
