<?php
/**
 * Content Slider Shortcode
 */

function impeka_wpb_ext_content_slider_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'content-slider.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_content_slider', 'impeka_wpb_ext_content_slider_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_content_slider_shortcode_params' ) ) {
	function impeka_wpb_ext_content_slider_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Slider with Content", "impeka-wpb-extension" ),
			"description" => esc_html__( "Display a slider with content", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-content-slider",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Type", "impeka-wpb-extension" ),
					"param_name" => "post_type",
					'value' => array(
						esc_html__( 'Post', 'impeka-wpb-extension' ) => 'post',
						esc_html__( 'Portfolio', 'impeka-wpb-extension' ) => 'portfolio',
						esc_html__( 'Product', 'impeka-wpb-extension' ) => 'product',
					),
					"description" => esc_html__( "Select the post type.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Number of Posts", "impeka-wpb-extension" ),
					"param_name" => "posts_per_page",
					"value" => array( '2','3','4','5','6','7','8', '9', '10' ),
					"description" => esc_html__( "Enter how many posts you want to display.", "impeka-wpb-extension" ),
					"std" => '4',
				),
				impeka_wpb_ext_get_heading_tag( "h3" ),
				impeka_wpb_ext_get_heading( "h3" ),
				impeka_wpb_ext_get_custom_font_family(),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Excerpt Length", "impeka-wpb-extension" ),
					"param_name" => "excerpt_length",
					"description" => esc_html__( "Type how many words you want to display in your post excerpts.", "impeka-wpb-extension" ),
					"value" => '15',
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Read More", "impeka-wpb-extension" ),
					"param_name" => "excerpt_more",
					"description" => esc_html__( "Adds a read more button after the excerpt or more quicktag", "impeka-wpb-extension" ),
					"value" => array( esc_html__( "Add more button", "impeka-wpb-extension" ) => 'yes' ),
				),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Read More Text", "impeka-wpb-extension" ),
					"param_name" => "excerpt_more_text",
					"description" => esc_html__( "Enter the title for your read more link", "impeka-wpb-extension" ),
					"value" => 'read more',
					"dependency" => array( 'element' => "excerpt_more", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Autoplay", "impeka-wpb-extension" ),
					"param_name" => "auto_play",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
				),
				impeka_wpb_ext_add_slideshow_speed(),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Pause on Hover", "impeka-wpb-extension" ),
					"param_name" => "pause_hover",
					"value" => array( esc_html__( "If selected, slider will be paused on hover", "impeka-wpb-extension" ) => 'yes' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "impeka-wpb-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "This affects the Background Overlay of the item.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "impeka-wpb-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array( 'default', '0', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55', '60', '65', '70', '75', '80', '85', '90', '95', '100' ),
					"std" => 'default',
					"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the title color.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the text color.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small-shadow',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium-shadow',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large-shadow',
					),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
					"param_name" => "radius",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
						esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
						esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
						esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
						esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
						esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
						esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
						esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
					),
					"std" => 'none',
				),
				impeka_wpb_ext_add_order_by(),
				impeka_wpb_ext_add_order(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Exclude Posts", "impeka-wpb-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__( "Categories", "impeka-wpb-extension" ),
					"param_name" => "categories",
					"value" => impeka_wpb_ext_get_post_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'post' ) ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Portfolio Categories", "impeka-wpb-extension" ),
					"param_name" => "portfolio_categories",
					"value" => impeka_wpb_ext_get_post_categories( 'portfolio_category' ),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'portfolio' ) ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Product Categories", "impeka-wpb-extension" ),
					"param_name" => "product_categories",
					"value" => impeka_wpb_ext_get_post_categories( 'product_cat' ),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'product' ) ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "impeka-wpb-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_content_slider', 'impeka_wpb_ext_content_slider_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
