<?php
/**
 * Countdown Shortcode
 */

function impeka_wpb_ext_countdown_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'countdown.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_countdown', 'impeka_wpb_ext_countdown_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_countdown_shortcode_params' ) ) {
	function impeka_wpb_ext_countdown_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Countdown", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add a countdown element", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-countdown",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Final Date", "impeka-wpb-extension" ),
					"param_name" => "final_date",
					"value" => "",
					"description" => esc_html__( "Accepted formats: YYYY/MM/DD , MM/DD/YYYY , YYYY/MM/DD hh:mm:ss , MM/DD/YYYY hh:mm:ss ( e.g: 2021/12/25 )", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Countdown Display", "impeka-wpb-extension" ),
					"param_name" => "countdown_format",
					"value" => array(
						esc_html__( "Days Hours Minutes", "impeka-wpb-extension" ) => 'D|H|M',
						esc_html__( "Days Hours Minutes Seconds", "impeka-wpb-extension" ) => 'D|H|M|S',
						esc_html__( "Weeks Days Hours", "impeka-wpb-extension" ) => 'w|d|H',
						esc_html__( "Weeks Days Hours Minutes Seconds", "impeka-wpb-extension" ) => 'w|d|H|M|S',
					),
					"std" => 'D|H|M|S',
					"description" => esc_html__( "Select the countdown display.", "impeka-wpb-extension" ),
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Countdown Style", "impeka-wpb-extension" ),
					"param_name" => "countdown_style",
					"value" => array(
						esc_html__( "Style 1", "impeka-wpb-extension" ) => '1',
						esc_html__( "Style 2", "impeka-wpb-extension" ) => '2',
						esc_html__( "Style 3", "impeka-wpb-extension" ) => '3',
					),
					"std" => '1',
					"description" => esc_html__( "Select the countdown style.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Numbers size", "impeka-wpb-extension" ),
					"param_name" => "numbers_size",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
						esc_html__( "Page Title", "impeka-wpb-extension" ) => 'page-title',
						esc_html__( "Feature Title", "impeka-wpb-extension" ) => 'feature-title',
					),
					"description" => esc_html__( "Numbers size and typography", "impeka-wpb-extension" ),
					"std" => 'h3',
				),
				impeka_wpb_ext_get_heading_increase(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text size", "impeka-wpb-extension" ),
					"param_name" => "text_size",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Text size and typography", "impeka-wpb-extension" ),
					"std" => 'small-text',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Background Color", "impeka-wpb-extension" ),
					"param_name" => "bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'white',
					"description" => esc_html__( "Background Color of the counter items.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "countdown_style", 'value' => array( '2' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Numbers Color", "impeka-wpb-extension" ),
					"param_name" => "numbers_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'black',
					"description" => esc_html__( "Color of the numbers.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'black',
					"description" => esc_html__( "Color of the text.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_countdown', 'impeka_wpb_ext_countdown_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
