<?php
/**
 * Counter Shortcode
 */

function impeka_wpb_ext_counter_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'counter.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_counter', 'impeka_wpb_ext_counter_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_counter_shortcode_params' ) ) {
	function impeka_wpb_ext_counter_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Counter", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add a counter with icon and title", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-counter",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Start Number", "impeka-wpb-extension" ),
					"param_name" => "counter_start_val",
					"value" => "0",
					"description" => esc_html__( "Enter counter start number.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter End Number", "impeka-wpb-extension" ),
					"param_name" => "counter_end_val",
					"value" => "100",
					"description" => esc_html__( "Enter counter end number.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Counter Thousands Separator Visiblility", "impeka-wpb-extension" ),
					"param_name" => "counter_thousands_separator_vis",
					"description" => esc_html__( "If selected, thousands separator will not be shown.", "impeka-wpb-extension" ),
					"value" => array( esc_html__( "Disable Thousands Separator.", "impeka-wpb-extension" ) => 'yes' ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Thousands Separator", "impeka-wpb-extension" ),
					"param_name" => "counter_thousands_separator",
					"value" => ",",
					"description" => esc_html__( "Enter thousands separator.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-4',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Decimal Points", "impeka-wpb-extension" ),
					"param_name" => "counter_decimal_points",
					"value" => "0",
					"description" => esc_html__( "Number of decimal points.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-4',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Decimal Separator", "impeka-wpb-extension" ),
					"param_name" => "counter_decimal_separator",
					"value" => ".",
					"description" => esc_html__( "Enter decimal separator.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-4',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Prefix", "impeka-wpb-extension" ),
					"param_name" => "counter_prefix",
					"value" => "",
					"description" => esc_html__( "Enter counter prefix.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Prefix space", "impeka-wpb-extension" ),
					"param_name" => "counter_prefix_space",
					"description" => esc_html__( "Add space after prefix", "impeka-wpb-extension" ),
					"value" => array( esc_html__( "Add space", "impeka-wpb-extension" ) => 'yes' ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Suffix", "impeka-wpb-extension" ),
					"param_name" => "counter_suffix",
					"value" => "",
					"description" => esc_html__( "Enter counter suffix.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Suffix space", "impeka-wpb-extension" ),
					"param_name" => "counter_suffix_space",
					"description" => esc_html__( "Add space before suffix", "impeka-wpb-extension" ),
					"value" => array( esc_html__( "Add space", "impeka-wpb-extension" ) => 'yes' ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Counter Color", "impeka-wpb-extension" ),
					"param_name" => "counter_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'primary-1',
					"description" => esc_html__( "Color of the counter.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Counter Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "counter_heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Select counter text size.", "impeka-wpb-extension" ),
					"std" => 'h2',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Increase Counter Size", "impeka-wpb-extension" ),
					"param_name" => "increase_counter_heading",
					"value" => array(
						esc_html__( "100%", "impeka-wpb-extension" ) => '100',
						esc_html__( "120%", "impeka-wpb-extension" ) => '120',
						esc_html__( "140%", "impeka-wpb-extension" ) => '140',
						esc_html__( "160%", "impeka-wpb-extension" ) => '160',
						esc_html__( "180%", "impeka-wpb-extension" ) => '180',
						esc_html__( "200%", "impeka-wpb-extension" ) => '200',
						esc_html__( "250%", "impeka-wpb-extension" ) => '250',
						esc_html__( "300%", "impeka-wpb-extension" ) => '300',
					),
					"description" => esc_html__( "Set the percentage you want to increase your Headings size.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Counter Custom Font Family", "impeka-wpb-extension" ),
					"param_name" => "counter_custom_font_family",
					"value" => array(
						esc_html__( "Same as Typography", "impeka-wpb-extension" ) => '',
						esc_html__( "Custom Font Family 1", "impeka-wpb-extension" ) => 'custom-font-1',
						esc_html__( "Custom Font Family 2", "impeka-wpb-extension" ) => 'custom-font-2',
						esc_html__( "Custom Font Family 3", "impeka-wpb-extension" ) => 'custom-font-3',
						esc_html__( "Custom Font Family 4", "impeka-wpb-extension" ) => 'custom-font-4',

					),
					"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "impeka-wpb-extension" ),
					"std" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon type", "impeka-wpb-extension" ),
					"param_name" => "icon_type",
					"value" => array(
						esc_html__( "No Icon", "impeka-wpb-extension" ) => '',
						esc_html__( "Icon", "impeka-wpb-extension" ) => 'icon',
						esc_html__( "SVG", "impeka-wpb-extension" ) => 'svg',
						esc_html__( "Animated SVG", "impeka-wpb-extension" ) => 'animated-svg',
					),
					"description" => '',
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Icon SVG", "impeka-wpb-extension" ),
					"param_name" => "icon_svg",
					"value" => '',
					"description" => esc_html__( "Select an svg icon. Note: SVG mime type must be enabled in WordPress", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'svg', 'animated-svg' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__('SVG Animation Duration', 'impeka-wpb-extension'),
					"param_name" => "animated_svg_animation_duration",
					"value" => '100',
					"description" => esc_html__( "Add delay in milliseconds.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'animated-svg' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon size", "impeka-wpb-extension" ),
					"param_name" => "icon_size",
					"value" => array(
						esc_html__( "Extra Large", "impeka-wpb-extension" ) => 'extra-large',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
					),
					"std" => 'medium',
					"description" => '',
					"dependency" => array( 'element' => 'icon_type', 'value_not_equal_to' => array( '' ) ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon library', 'impeka-wpb-extension' ),
					'value' => array(
						esc_html__( 'Font Awesome', 'impeka-wpb-extension' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'impeka-wpb-extension' ) => 'openiconic',
						esc_html__( 'Typicons', 'impeka-wpb-extension' ) => 'typicons',
						esc_html__( 'Entypo', 'impeka-wpb-extension' ) => 'entypo',
						esc_html__( 'Linecons', 'impeka-wpb-extension' ) => 'linecons',
						esc_html__( 'Simple Line Icons', 'impeka-wpb-extension' ) => 'simplelineicons',
						esc_html__( 'Elegant Line Icons', 'impeka-wpb-extension' ) => 'etlineicons',
					),
					'param_name' => 'icon_library',
					'description' => esc_html__( 'Select icon library.', 'impeka-wpb-extension' ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon' ) ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_fontawesome',
					'value' => 'fas fa-adjust',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'fontawesome',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'openiconic',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'openiconic',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'typicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'typicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'entypo',
						'iconsPerPage' => 300, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'entypo',
					),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'linecons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'linecons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_simplelineicons',
					'value' => 'smp-icon-user',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'simplelineicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'simplelineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_etlineicons',
					'value' => 'et-icon-mobile',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'etlineicons',
						'iconsPerPage' => 100,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'etlineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Color", "impeka-wpb-extension" ),
					"param_name" => "icon_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'primary-1',
					"description" => esc_html__( "Color of the icon.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon', 'svg', 'animated-svg' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
					"param_name" => "title",
					"value" => "Sample Title",
					"description" => esc_html__( "Enter counter title.", "impeka-wpb-extension" ),
					"save_always" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
					"description" => esc_html__( "Select the color of your title.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_get_heading_tag( "h3" ),
				impeka_wpb_ext_get_heading( "h3" ),
				impeka_wpb_ext_get_custom_font_family(),
				impeka_wpb_ext_add_inherit_align(),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_counter', 'impeka_wpb_ext_counter_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
