<?php
/**
 * Contact Form Shortcode
 */

function impeka_wpb_ext_contact_form_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'custom-contact-form.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_contact_form', 'impeka_wpb_ext_contact_form_shortcode' );


/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_contact_form_shortcode_params' ) ) {
	function impeka_wpb_ext_contact_form_shortcode_params( $tag ) {

		$cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );

		$contact_forms = array();
		if ( $cf7 ) {
			foreach ( $cf7 as $cform ) {
				$contact_forms[ $cform->post_title ] = $cform->ID;
			}
		} else {
			$contact_forms[ esc_html__( 'No contact forms found', 'impeka-wpb-extension' ) ] = 0;
		}

		return array(
			"name" => esc_html__( "Custom Contact Form 7", "impeka-wpb-extension" ),
			"description" => esc_html__( "Place Contact Form 7", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-contactform7",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Select Contact Form", "impeka-wpb-extension"),
					"param_name" => "id",
					"value" => $contact_forms,
					"description" => esc_html__("Choose previously created contact form from the drop down list.", 'impeka-wpb-extension' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Style", "impeka-wpb-extension" ),
					"param_name" => "text_style",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => '',
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Quote Text", "impeka-wpb-extension" ) => 'quote-text',
					),
					'std' => '',
					"description" => esc_html__( "Select your text style.", 'impeka-wpb-extension' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Inputs Shape", "impeka-wpb-extension"),
					"param_name" => "inputs_shape",
					"value" => array(
						esc_html__( "Square", "impeka-wpb-extension" ) => "",
						esc_html__( "Round", "impeka-wpb-extension" ) => "round",
						esc_html__( "Extra Round", "impeka-wpb-extension" ) => "extra-round",
					),
					"description" => esc_html__("Select the shape for your contact form inputs.", 'impeka-wpb-extension' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Input Fields Background Color", "impeka-wpb-extension" ),
					"param_name" => "input_bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
					"description" => esc_html__("Select the background color for your contact form inputs.", 'impeka-wpb-extension' ),
					"std" => 'light-grey',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Input Fields Text Color", "impeka-wpb-extension" ),
					"param_name" => "input_text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					'description' => esc_html__( "Select a text color for your contact form inputs.", "impeka-wpb-extension" ),
					"std" => 'black',
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Input Fields Placeholder Color", "impeka-wpb-extension" ),
					"param_name" => "input_placeholder_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					'description' => esc_html__( "Select a placeholder color for your contact form inputs", "impeka-wpb-extension" ),
					"std" => 'black',
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Inputs Fields Borders", "impeka-wpb-extension"),
					"param_name" => "inputs_borders",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => "",
						esc_html__( "Solid", "impeka-wpb-extension" ) => "solid",
						esc_html__( "Underline", "impeka-wpb-extension" ) => "underline",
					),
					"std" => 'solid',
					"description" => esc_html__("Select the shape for your contact form inputs.", 'impeka-wpb-extension' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Input Fields Border Color", "impeka-wpb-extension" ),
					"param_name" => "input_border_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					'description' => esc_html__( "Select a border color for your contact form inputs", "impeka-wpb-extension" ),
					"std" => 'grey',
					"dependency" => array( 'element' => "inputs_borders", 'value' => array( 'solid', 'underline' ) ),
				),
				//Focus
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Input Fields Background Color", "impeka-wpb-extension" ),
					"param_name" => "input_focus_bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit', 'transparent', 'primary', 'standard'] ),
					"description" => esc_html__("Select the background color for your contact form inputs.", 'impeka-wpb-extension' ),
					"std" => 'inherit',
					"group" => esc_html__( "Focus", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Input Fields Text Color", "impeka-wpb-extension" ),
					"param_name" => "input_focus_text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit','primary', 'standard'] ),
					'description' => esc_html__( "Select a text color for your contact form inputs", "impeka-wpb-extension" ),
					"std" => 'inherit',
					'edit_field_class' => 'vc_col-sm-6',
					"group" => esc_html__( "Focus", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Input Fields Placeholder Color", "impeka-wpb-extension" ),
					"param_name" => "input_focus_placeholder_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit','primary', 'standard'] ),
					'description' => esc_html__( "Select a placeholder color for your contact form inputs", "impeka-wpb-extension" ),
					"std" => 'inherit',
					'edit_field_class' => 'vc_col-sm-6',
					"group" => esc_html__( "Focus", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Input Fields Borders Color", "impeka-wpb-extension" ),
					"param_name" => "input_focus_border_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit','primary', 'standard'] ),
					'description' => esc_html__( "Select a border color for your contact form inputs", "impeka-wpb-extension" ),
					"std" => 'inherit',
					"dependency" => array( 'element' => "inputs_borders", 'value' => array( 'solid', 'underline' ) ),
					"group" => esc_html__( "Focus", "impeka-wpb-extension" ),
				),
				//Button
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Button Type", "impeka-wpb-extension"),
					"param_name" => "button_type",
					"value" => array(
						esc_html__( "Simple", "impeka-wpb-extension" ) => "simple",
						esc_html__( "Outline", "impeka-wpb-extension" ) => "outline",
					),
					"std" => 'simple',
					"description" => esc_html__( "Select button type.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Button", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Button Color", "impeka-wpb-extension" ),
					"param_name" => "button_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"description" => esc_html__( "Color of the button.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "button_type", 'value' => array( 'simple', 'outline' ) ),
					'edit_field_class' => 'vc_col-sm-6',
					"group" => esc_html__( "Button", "impeka-wpb-extension" ),
					"std" => 'primary-1',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Button Hover Color", "impeka-wpb-extension" ),
					"param_name" => "button_hover_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"description" => esc_html__( "Color of the button.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "button_type", 'value' => array( 'simple', 'outline' ) ),
					'edit_field_class' => 'vc_col-sm-6',
					"group" => esc_html__( "Button", "impeka-wpb-extension" ),
					"std" => 'black',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Button Size", "impeka-wpb-extension" ),
					"param_name" => "button_size",
					"value" => array(
						esc_html__( "Extra Small", "impeka-wpb-extension" ) => 'extrasmall',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
						esc_html__( "Extra Large", "impeka-wpb-extension" ) => 'extralarge',
					),
					"description" => '',
					"std" => 'medium',
					"group" => esc_html__( "Button", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Button Shape", "impeka-wpb-extension" ),
					"param_name" => "button_shape",
					"value" => array(
						esc_html__( "Square", "impeka-wpb-extension" ) => 'square',
						esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
						esc_html__( "Extra Round", "impeka-wpb-extension" ) => 'extra-round',
					),
					"dependency" => array( 'element' => "button_type", 'value' => array( 'simple', 'outline', 'gradient' ) ),
					"description" => '',
					"std" => 'square',
					"group" => esc_html__( "Button", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_contact_form', 'impeka_wpb_ext_contact_form_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
