<?php
/**
 * Divider Shortcode
 */

function impeka_wpb_ext_divider_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'divider.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_divider', 'impeka_wpb_ext_divider_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_divider_shortcode_params' ) ) {
	function impeka_wpb_ext_divider_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Divider", "impeka-wpb-extension" ),
			"description" => esc_html__( "Insert dividers, just spaces or different lines", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-divider",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Line type", "impeka-wpb-extension" ),
					"param_name" => "line_type",
					"value" => array(
						esc_html__( "Line", "impeka-wpb-extension" ) => 'line',
						esc_html__( "Double Line", "impeka-wpb-extension" ) => 'double-line',
						esc_html__( "Dashed Line", "impeka-wpb-extension" ) => 'dashed-line',
						esc_html__( "Back to Top", "impeka-wpb-extension" ) => 'top-line',
						esc_html__( "Vertical Line", "impeka-wpb-extension" ) => 'vertical-line',
						esc_html__( "Custom Line", "impeka-wpb-extension" ) => 'custom-line',
					),
					"description" => '',
					"admin_label" => true,
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Line Width", "impeka-wpb-extension" ),
					"param_name" => "line_width",
					"value" => "50",
					"description" => esc_html__( "Enter the width for your line (Note: CSS measurement units allowed).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "line_type", 'value' => array( 'custom-line', 'vertical-line' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Line Height", "impeka-wpb-extension" ),
					"param_name" => "vertical_line_height",
					"value" => array( '1x', '2x', '3x', '4x' , '5x', '6x', 'custom' ),
					"std" => '3x',
					"description" => esc_html__( "Select the height for your line.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "line_type", 'value' => array( 'vertical-line' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Line Height Custom", "impeka-wpb-extension" ),
					"param_name" => "vertical_line_height_custom",
					"value" => "50",
					"description" => esc_html__( "Enter the height for your line (Note: CSS measurement units allowed).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "vertical_line_height", 'value' => array( 'custom' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Line Height", "impeka-wpb-extension" ),
					"param_name" => "line_height",
					"value" => array( '1', '2', '3', '4' , '5', '6', '7', '8', '9' , '10' ),
					"std" => '2',
					"description" => esc_html__( "Enter the height for your line in px.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "line_type", 'value' => array( 'custom-line' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Line Color", "impeka-wpb-extension" ),
					"param_name" => "line_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'standard', 'custom'] ),
					"std" => 'primary-1',
					"description" => esc_html__( "Color for the line.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "line_type", 'value' => array( 'custom-line', 'vertical-line' ) ),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( "Custom Line Color", "impeka-wpb-extension" ),
					'param_name' => 'line_color_custom',
					'description' => esc_html__( "Select a custom color for your line", "impeka-wpb-extension" ),
					"std" => '#000000',
					"dependency" => array( 'element' => "line_color", 'value' => array( 'custom' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Divider Alignment", "impeka-wpb-extension" ),
					"param_name" => "align",
					"value" => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
						esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
						esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
						esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
					),
					"description" => '( Inherit )Inherits its value from its column text align definition.',
					"dependency" => array( 'element' => "line_type", 'value' => array( 'custom-line', 'vertical-line' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Line Loop Animation", "impeka-wpb-extension" ),
					"param_name" => "line_loop_animation",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => '',
						esc_html__( "Top to Bottom", "impeka-wpb-extension" ) => 'top-bottom',
						esc_html__( "Bottom to Top", "impeka-wpb-extension" ) => 'bottom-top',
					),
					"description" => 'Select loop animation for your line.',
					"dependency" => array( 'element' => "line_type", 'value' => array( 'vertical-line' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Back to Top Title", "impeka-wpb-extension" ),
					"param_name" => "backtotop_title",
					"value" => "Back to top",
					"description" => esc_html__( "Set Back to top title.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "line_type", 'value' => array( 'top-line' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Top padding", "impeka-wpb-extension" ),
					"param_name" => "padding_top",
					"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Bottom padding", "impeka-wpb-extension" ),
					"param_name" => "padding_bottom",
					"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_divider', 'impeka_wpb_ext_divider_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.