<?php
/**
 * Dropcap Shortcode
 */

function impeka_wpb_ext_dropcap_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'dropcap.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_dropcap', 'impeka_wpb_ext_dropcap_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_dropcap_shortcode_params' ) ) {
	function impeka_wpb_ext_dropcap_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Dropcap", "impeka-wpb-extension" ),
			"description" => esc_html__( "Two separate styles for your dropcaps", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-dropcap",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Style", "impeka-wpb-extension" ),
					"param_name" => "dropcap_style",
					"value" => array(
						esc_html__( "Style 1", "impeka-wpb-extension" ) => '1',
						esc_html__( "Style 2", "impeka-wpb-extension" ) => '2',
					),
					"description" => esc_html__( "Style of the dropcap.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textarea",
					"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
					"param_name" => "content",
					"value" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut dapibus nunc at ullamcorper porttitor.",
					"description" => esc_html__( "Type your dropcap text.", "impeka-wpb-extension" ),
				),
				array(
						"type" => "dropdown",
						"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
						"param_name" => "text_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
						"description" => esc_html__( "Select the color of your text.", "impeka-wpb-extension" ),
					),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Dropcap Color", "impeka-wpb-extension" ),
					"param_name" => "color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'primary-1',
					"description" => esc_html__( "First character background color", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_dropcap', 'impeka_wpb_ext_dropcap_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
