<?php
/**
 * Empty Space Shortcode
 */

function impeka_wpb_ext_empty_space_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'empty-space.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_empty_space', 'impeka_wpb_ext_empty_space_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_empty_space_shortcode_params' ) ) {
	function impeka_wpb_ext_empty_space_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Empty Space", "impeka-wpb-extension" ),
			"description" => esc_html__( "Blank space with custom height", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-empty-space",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Height", 'impeka-wpb-extension' ),
					"param_name" => "height_multiplier",
					"value" => array(
						esc_html__( "1x", 'impeka-wpb-extension' ) => '1x',
						esc_html__( "2x", 'impeka-wpb-extension' ) => '2x',
						esc_html__( "3x", 'impeka-wpb-extension' ) => '3x',
						esc_html__( "4x", 'impeka-wpb-extension' ) => '4x',
						esc_html__( "5x", 'impeka-wpb-extension' ) => '5x',
						esc_html__( "6x", 'impeka-wpb-extension' ) => '6x',
						esc_html__( "Custom", 'impeka-wpb-extension' ) => 'custom',
					),
					"std" => '1x',
					"admin_label" => true,
					"description" => esc_html__( "Select empty space height.", 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Custom Height', 'impeka-wpb-extension' ),
					'param_name' => 'height',
					'value' => '32px',
					'description' => esc_html__( 'Enter empty space height (Note: CSS measurement units allowed).', 'impeka-wpb-extension' ),
					"dependency" => array(
						'element' => 'height_multiplier',
						'value' => array( 'custom' )
					),
				),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_empty_space', 'impeka_wpb_ext_empty_space_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.