<?php
/**
 * Fancy Box Shortcode
 */

function impeka_wpb_ext_fancy_box_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'fancy-box.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_fancy_box', 'impeka_wpb_ext_fancy_box_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_fancy_box_shortcode_params' ) ) {
	function impeka_wpb_ext_fancy_box_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Fancy Box", "impeka-wpb-extension" ),
			"description" => esc_html__( "Create easily appealing fancy boxes", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-fancy-box",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
					"param_name" => "title",
					"value" => "",
					"description" => esc_html__( "Enter your title.", "impeka-wpb-extension" ),
					"admin_label" => true,
				),
				impeka_wpb_ext_get_heading_tag( "h3" ),
				impeka_wpb_ext_get_heading( "h3" ),
				impeka_wpb_ext_get_custom_font_family(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard', 'custom'] ),
					"std" => 'inherit',
					"description" => esc_html__( "Select the color of your title.", "impeka-wpb-extension" ),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( "Custom Title Color", "impeka-wpb-extension" ),
					'param_name' => 'title_color_custom',
					'description' => esc_html__( "Select a custom color for your title", "impeka-wpb-extension" ),
					"std" => '#e1e1e1',
					"dependency" => array( 'element' => "title_color", 'value' => array( 'custom' ) ),
				),
				array(
					"type" => "textarea",
					"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
					"param_name" => "content",
					"value" => "",
					"description" => esc_html__( "Enter your text.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard', 'custom'] ),
					"std" => 'inherit',
					"description" => esc_html__( "Select the color of your text.", "impeka-wpb-extension" ),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( "Custom Text Color", "impeka-wpb-extension" ),
					'param_name' => 'text_color_custom',
					'description' => esc_html__( "Select a custom color for your text", "impeka-wpb-extension" ),
					"std" => '#e1e1e1',
					"dependency" => array( 'element' => "text_color", 'value' => array( 'custom' ) ),
				),
				impeka_wpb_ext_add_align(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Background Color", "impeka-wpb-extension" ),
					"param_name" => "content_bg",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['transparent', 'primary', 'gradient', 'standard'] ),
					"std" => 'transparent',
					"description" => esc_html__( "Background color of the fancy box.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Hover Background Color", "impeka-wpb-extension" ),
					"param_name" => "content_bg_hover",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
					"std" => 'primary-1',
					"description" => esc_html__( "Background hover color of the fancy box.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
					"param_name" => "radius",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => '',
						esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
						esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
						esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
						esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
						esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
						esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
						esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
						esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
					),
					"description" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small-shadow',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium-shadow',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large-shadow',
					),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Read More Title", "impeka-wpb-extension" ),
					"param_name" => "read_more_title",
					"value" => "",
					"description" => esc_html__( "Enter your title for your link.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "vc_link",
					"heading" => esc_html__( "Read More Link", "impeka-wpb-extension" ),
					"param_name" => "read_more_link",
					"value" => "",
					"description" => esc_html__( "Enter read more link.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Read More Link Class", "impeka-wpb-extension" ),
					"param_name" => "read_more_class",
					"value" => "",
					"description" => esc_html__( "Enter extra class name for your link.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon type", "impeka-wpb-extension" ),
					"param_name" => "icon_type",
					"value" => array(
						esc_html__( "No Icon", "impeka-wpb-extension" ) => '',
						esc_html__( "Icon", "impeka-wpb-extension" ) => 'icon',
					),
					"description" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon size", "impeka-wpb-extension" ),
					"param_name" => "icon_size",
					"value" => array(
						esc_html__( "Extra Large", "impeka-wpb-extension" ) => 'extra-large',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
					),
					"std" => 'medium',
					"description" => '',
					"dependency" => array( 'element' => 'icon_type', 'value_not_equal_to' => array( '' ) ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon library', 'impeka-wpb-extension' ),
					'value' => array(
						esc_html__( 'Font Awesome', 'impeka-wpb-extension' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'impeka-wpb-extension' ) => 'openiconic',
						esc_html__( 'Typicons', 'impeka-wpb-extension' ) => 'typicons',
						esc_html__( 'Entypo', 'impeka-wpb-extension' ) => 'entypo',
						esc_html__( 'Linecons', 'impeka-wpb-extension' ) => 'linecons',
						esc_html__( 'Simple Line Icons', 'impeka-wpb-extension' ) => 'simplelineicons',
						esc_html__( 'Elegant Line Icons', 'impeka-wpb-extension' ) => 'etlineicons',
					),
					'param_name' => 'icon_library',
					'description' => esc_html__( 'Select icon library.', 'impeka-wpb-extension' ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon' ) ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_fontawesome',
					'value' => 'fas fa-adjust',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'fontawesome',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'openiconic',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'openiconic',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'typicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'typicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'entypo',
						'iconsPerPage' => 300, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'entypo',
					),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'linecons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'linecons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_simplelineicons',
					'value' => 'smp-icon-user',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'simplelineicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'simplelineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_etlineicons',
					'value' => 'et-icon-mobile',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'etlineicons',
						'iconsPerPage' => 100,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'etlineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Color", "impeka-wpb-extension" ),
					"param_name" => "icon_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'primary-1',
					"description" => esc_html__( "Color of the icon.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon' ) ),
				),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_fancy_box', 'impeka_wpb_ext_fancy_box_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
