<?php
/**
 * Flexible Carousel Shortcode
 */

function impeka_wpb_ext_flexible_carousel_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'flexible-carousel.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_flexible_carousel', 'impeka_wpb_ext_flexible_carousel_shortcode' );


/**
 * Add shortcode container class
 */

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_impeka_flexible_carousel extends WPBakeryShortCodesContainer {
    }
}

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_flexible_carousel_shortcode_params' ) ) {
	function impeka_wpb_ext_flexible_carousel_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Flexible Carousel", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add a flexible carousel with elements", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon" => "icon-wpb-grve-flexible-carousel",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"content_element" => true,
			"controls" => "full",
			"show_settings_on_create" => true,
			"as_parent" => array('only' => 'vc_row,vc_column,vc_row_inner,vc_column_inner,vc_column_text,vc_custom_heading,vc_empty_space,impeka_single_image,impeka_button,impeka_image_text,impeka_team,impeka_divider,impeka_icon,impeka_icon_box,impeka_social,impeka_callout,impeka_slogan,impeka_title,impeka_fancy_box'),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Type", "impeka-wpb-extension" ),
					"param_name" => "type",
					"admin_label" => true,
					"value" => array(
						esc_html__( 'Classic', 'impeka-wpb-extension' ) => 'classic',
						esc_html__( 'Advanced', 'impeka-wpb-extension' ) => 'advanced',
					),
					"description" => esc_html__( "Select your Carousel Type.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items per page", "impeka-wpb-extension" ),
					"param_name" => "items_per_page",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"description" => esc_html__( "Number of items per page", "impeka-wpb-extension" ),
					"std" => '4',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Tablet Landscape", "impeka-wpb-extension" ),
					"param_name" => "items_tablet_landscape",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"std" => '3',
					"description" => esc_html__( "Select number of items on tablet devices, landscape orientation.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Tablet Portrait", "impeka-wpb-extension" ),
					"param_name" => "items_tablet_portrait",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"std" => '3',
					"description" => esc_html__( "Select number of items on tablet devices, portrait orientation.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Mobile", "impeka-wpb-extension" ),
					"param_name" => "items_mobile",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"std" => '1',
					"description" => esc_html__( "Select number of items on mobile devices.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between items", "impeka-wpb-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"description" => esc_html__( "Add gutter among items.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "type", 'value' => array( 'classic' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "impeka-wpb-extension" ),
					"param_name" => "gutter_size",
					"value" => '30',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				//Navigation
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Behavior", 'impeka-wpb-extension'),
					"param_name" => "label_behavior",
					'value' => '',
					"std" => '',
					"description" => esc_html__( "Configure the carousel behavior", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Loop", "impeka-wpb-extension" ),
					"param_name" => "loop",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Autoplay", "impeka-wpb-extension" ),
					"param_name" => "auto_play",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Slideshow Speed", "impeka-wpb-extension" ),
					"param_name" => "slideshow_speed",
					"value" => '3000',
					"description" => esc_html__( "Slideshow Speed in ms.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "type", 'value' => array( 'classic' ) ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Pause on Hover", "impeka-wpb-extension" ),
					"param_name" => "pause_hover",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"std" => "no",
					"description" => esc_html__( "If selected, carousel will be paused on hover", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "type", 'value' => array( 'classic' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Auto Height", "impeka-wpb-extension" ),
					"param_name" => "auto_height",
					"value" => array( esc_html__( "Select if you want smooth auto height", "impeka-wpb-extension" ) => 'yes' ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Navigation", 'impeka-wpb-extension'),
					"param_name" => "label_pagination",
					'value' => '',
					"std" => '',
					"description" => esc_html__( "Configure the carousel navigation", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_navigation( 'yes' ),
				impeka_wpb_ext_add_navigation_icon( 'arrow-1' ),
				impeka_wpb_ext_add_navigation_icon_color( 'black' ),
				impeka_wpb_ext_add_navigation_shape(),
				impeka_wpb_ext_add_navigation_shape_type(),
				impeka_wpb_ext_add_navigation_shape_color(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Pagination", "impeka-wpb-extension" ),
					"param_name" => "pagination",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"std" => "no",
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Pagination Speed", "impeka-wpb-extension" ),
					"param_name" => "pagination_speed",
					"value" => '400',
					"description" => esc_html__( "Pagination Speed in ms. ( Only available for classic type )", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "pagination", 'value' => array( 'yes' ) ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
			),
			"js_view" => 'VcColumnView',
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_flexible_carousel', 'impeka_wpb_ext_flexible_carousel_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
