<?php
/**
 * Fluent Form Shortcode
 */

function impeka_wpb_ext_fluent_form_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'fluent-form.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_fluent_form', 'impeka_wpb_ext_fluent_form_shortcode' );


/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_fluent_form_shortcode_params' ) ) {
	function impeka_wpb_ext_fluent_form_shortcode_params( $tag ) {
		$contact_forms = array();
		$ff_list = wpFluent()->table('fluentform_forms')->select(['id', 'title'])->orderBy('id', 'DESC')->get();
		if ($ff_list) {
			foreach ($ff_list as $form) {
				$contact_forms[$form->title] = $form->id;
			}
		} else {
			$contact_forms[ esc_html__( 'No fluent forms found', 'impeka-wpb-extension' ) ] = 0;
		}

		return array(
			"name" => esc_html__( "Fluent Form", "impeka-wpb-extension" ),
			"description" => esc_html__( "Place Fluent Form", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-contactform7",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Select Fluent Form", "impeka-wpb-extension"),
					"param_name" => "id",
					"value" => $contact_forms,
					"description" => esc_html__("Choose previously created fluent form from the drop down list.", 'impeka-wpb-extension' ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_fluent_form', 'impeka_wpb_ext_fluent_form_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
