<?php
/**
 * Google Map Shortcode
 */

function impeka_wpb_ext_gmap_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'gmap.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_gmap', 'impeka_wpb_ext_gmap_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_gmap_shortcode_params' ) ) {
	function impeka_wpb_ext_gmap_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Google Map", "impeka-wpb-extension" ),
			"description" => esc_html__( "Freely place your Google Map", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-gmap",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Map Zoom", "impeka-wpb-extension" ),
					"param_name" => "map_zoom",
					"value" => array( '1', '2', '3' ,'4', '5', '6', '7', '8' ,'9' ,'10' ,'11' ,'12', '13', '14', '15', '16', '17', '18', '19' ),
					"std" => '14',
					"description" => esc_html__( "Zoom of the map.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Map Height", "impeka-wpb-extension" ),
					"param_name" => "map_height",
					"value" => "280",
					"description" => esc_html__( "Type map height.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Disable Custom Style", "impeka-wpb-extension" ),
					"param_name" => "map_disable_style",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"description" => esc_html__( "Select if you want to disable custom map style.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Map Mode", "impeka-wpb-extension" ),
					"param_name" => "map_mode",
					"value" => array(
						esc_html__( "Single Marker", "impeka-wpb-extension" ) => '',
						esc_html__( "Multiple Markers", "impeka-wpb-extension" ) => 'multiple',
					),
					"description" => esc_html__( "Select if you want to disable custom map style.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Map Points", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Global Marker Type", "impeka-wpb-extension" ),
					"param_name" => "map_marker_type",
					"value" => array(
						esc_html__( "Image", "impeka-wpb-extension" ) => '',
						esc_html__( "Pulse Dot Icon", "impeka-wpb-extension" ) => 'pulse-dot',
						esc_html__( "Dot Icon", "impeka-wpb-extension" ) => 'dot',
					),
					"description" => esc_html__( "Select the type of your marker.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Map Points", "impeka-wpb-extension" ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Global Custom marker", "impeka-wpb-extension" ),
					"param_name" => "map_marker",
					"value" => '',
					"description" => esc_html__( "Select an icon for the custom marker.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "map_marker_type", 'value' => array( '' ) ),
					"group" => esc_html__( "Map Points", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Background Color", "impeka-wpb-extension" ),
					"param_name" => "map_marker_bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'primary-1',
					"description" => esc_html__( "Background color of the marker.", "impeka-wpb-extension" ),
					"std" => 'primary-1',
					"dependency" => array( 'element' => "map_marker_type", 'value_not_equal_to' => array( '' ) ),
					"group" => esc_html__( "Map Points", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Map Latitude", "impeka-wpb-extension" ),
					"param_name" => "map_lat",
					"value" => "51.516221",
					"description" => esc_html__( "Type map Latitude.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "map_mode", 'value' => array( '' ) ),
					"group" => esc_html__( "Map Points", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Map Longtitude", "impeka-wpb-extension" ),
					"param_name" => "map_lng",
					"value" => "-0.136986",
					"description" => esc_html__( "Type map Longtitude.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "map_mode", 'value' => array( '' ) ),
					"group" => esc_html__( "Map Points", "impeka-wpb-extension" ),
				),
				array(
					'type' => 'param_group',
					'param_name' => 'map_points',
					'heading' => esc_html__( "Map Points", "impeka-wpb-extension" ),
					"description" => esc_html__( "Configure your map points.", "impeka-wpb-extension" ),
					'value' => urlencode( json_encode( array(
						array(
							'title' => 'Point 1',
							'lat' => '51.516221',
							'lng' => '-0.136986',
						),
					) ) ),
					'params' => array(
						array(
							"type" => "textfield",
							"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
							"param_name" => "title",
							"value" => "",
							"description" => esc_html__( "Enter your point title.", "impeka-wpb-extension" ),
							"admin_label" => true,
						),
						array(
							"type" => "attach_image",
							"heading" => esc_html__( "Marker", "impeka-wpb-extension" ),
							"param_name" => "marker",
							"value" => '',
							"description" => esc_html__( "Select an icon for your point marker. Note: if empty global marker will be used instead.", "impeka-wpb-extension" ),
						),
						array(
							'type' => 'textfield',
							'value' => '51.516221',
							'heading' => 'Latitude',
							'param_name' => 'lat',
						),
						array(
							'type' => 'textfield',
							'value' => '-0.136986',
							'heading' => 'Longitude',
							'param_name' => 'lng',
						),
						array(
							"type" => "textarea",
							"heading" => esc_html__( "Info Text", "impeka-wpb-extension" ),
							"param_name" => "infotext",
							"value" => "",
							"description" => esc_html__( "Enter your info text.", "impeka-wpb-extension" ),
						),
						array(
							"type" => "dropdown",
							"heading" => esc_html__( "Open Info Text Onload", "impeka-wpb-extension" ),
							"param_name" => "infotext_open",
							"value" => array(
								esc_html__( "No", "impeka-wpb-extension" ) => 'no',
								esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
							),
							"description" => esc_html__( "Select if you want to open info text on load.", "impeka-wpb-extension" ),
						),
						array(
							"type" => "textfield",
							"heading" => esc_html__( "Link Text", "impeka-wpb-extension" ),
							"param_name" => "link_text",
							"value" => "",
							"description" => esc_html__( "Enter your link text.", "impeka-wpb-extension" ),
						),
						array(
							"type" => "vc_link",
							"heading" => esc_html__( "Link", "impeka-wpb-extension" ),
							"param_name" => "link",
							"value" => "",
							"description" => esc_html__( "Enter your link.", "impeka-wpb-extension" ),
						),
						array(
							"type" => "textfield",
							"heading" => esc_html__( "Link Class", "impeka-wpb-extension" ),
							"param_name" => "link_class",
							"value" => "",
							"description" => esc_html__( "Enter your link class.", "impeka-wpb-extension" ),
						),
					),
					"dependency" => array( 'element' => "map_mode", 'value' => array( 'multiple' ) ),
					"group" => esc_html__( "Map Points", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_gmap', 'impeka_wpb_ext_gmap_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
