<?php
/**
 * Icon Box Shortcode
 */

function impeka_wpb_ext_icon_box_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'icon-box.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_icon_box', 'impeka_wpb_ext_icon_box_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_icon_box_shortcode_params' ) ) {
	function impeka_wpb_ext_icon_box_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Icon Box", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add an icon, character or image with title and text", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-icon-box",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Box Type", "impeka-wpb-extension" ),
					"param_name" => "icon_box_type",
					"value" => array(
						esc_html__( "Top Icon", "impeka-wpb-extension" ) => 'top-icon',
						esc_html__( "Side Icon", "impeka-wpb-extension" ) => 'side-icon',
					),
					'description' => esc_html__( 'Select icon box type.', 'impeka-wpb-extension' ),
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Box Layout", "impeka-wpb-extension" ),
					"param_name" => "icon_box_layout",
					"value" => array(
						esc_html__( "Layout 1", "impeka-wpb-extension" ) => 'layout-1',
						esc_html__( "Layout 2", "impeka-wpb-extension" ) => 'layout-2',
					),
					"std" => 'layout-1',
					"dependency" => array( 'element' => "icon_box_type", 'value' => array( 'side-icon' ) ),
					"description" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Alignment", "impeka-wpb-extension" ),
					"param_name" => "icon_top_align",
					"value" => array(
						esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
						esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
						esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
						esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
					),
					"std" => 'center',
					"dependency" => array( 'element' => "icon_box_type", 'value' => array( 'top-icon' ) ),
					"description" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Alignment", "impeka-wpb-extension" ),
					"param_name" => "icon_side_align",
					"value" => array(
						esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
						esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
						esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
					),
					"dependency" => array( 'element' => "icon_box_type", 'value' => array( 'side-icon' ) ),
					"description" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Type", "impeka-wpb-extension" ),
					"param_name" => "icon_type",
					"value" => array(
						esc_html__( "Icon", "impeka-wpb-extension" ) => 'icon',
						esc_html__( "Image", "impeka-wpb-extension" ) => 'image',
						esc_html__( "SVG", "impeka-wpb-extension" ) => 'svg',
						esc_html__( "Animated SVG", "impeka-wpb-extension" ) => 'animated-svg',
						esc_html__( "Character", "impeka-wpb-extension" ) => 'char',
					),
					"description" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon size", "impeka-wpb-extension" ),
					"param_name" => "icon_size",
					"value" => array(
						esc_html__( "Extra Large", "impeka-wpb-extension" ) => 'extra-large',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Extra Small", "impeka-wpb-extension" ) => 'extra-small',
					),
					"std" => 'medium',
					"dependency" => array( 'element' => "icon_type", 'value_not_equal_to' => array( 'image' ) ),
					"description" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Vertical Align", "impeka-wpb-extension" ),
					"param_name" => "icon_vertical_align",
					"value" => array(
						esc_html__( "Top", "impeka-wpb-extension" ) => 'top',
						esc_html__( "Middle", "impeka-wpb-extension" ) => 'middle',
					),
					"std" => 'middle',
					"dependency" => array( 'element' => "icon_box_type", 'value' => array( 'side-icon' ) ),
					"description" => '',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon library', 'impeka-wpb-extension' ),
					'value' => array(
						esc_html__( 'Font Awesome', 'impeka-wpb-extension' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'impeka-wpb-extension' ) => 'openiconic',
						esc_html__( 'Typicons', 'impeka-wpb-extension' ) => 'typicons',
						esc_html__( 'Entypo', 'impeka-wpb-extension' ) => 'entypo',
						esc_html__( 'Linecons', 'impeka-wpb-extension' ) => 'linecons',
						esc_html__( 'Simple Line Icons', 'impeka-wpb-extension' ) => 'simplelineicons',
						esc_html__( 'Elegant Line Icons', 'impeka-wpb-extension' ) => 'etlineicons',
					),
					'param_name' => 'icon_library',
					'description' => esc_html__( 'Select icon library.', 'impeka-wpb-extension' ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon' ) ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_fontawesome',
					'value' => 'fas fa-adjust',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'fontawesome',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'openiconic',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'openiconic',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'typicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'typicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'entypo',
						'iconsPerPage' => 300, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'entypo',
					),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'linecons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'linecons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_simplelineicons',
					'value' => 'smp-icon-user',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'simplelineicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'simplelineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_etlineicons',
					'value' => 'et-icon-mobile',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'etlineicons',
						'iconsPerPage' => 100,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'etlineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Color", "impeka-wpb-extension" ),
					"param_name" => "icon_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'gradient', 'standard', 'custom'] ),
					"std" => 'primary-1',
					"description" => esc_html__( "Color of the icon ( Gradient colors are not available for Icon SVG ).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon', 'svg', 'animated-svg', 'char' ) ),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( "Custom Icon Color", "impeka-wpb-extension" ),
					'param_name' => 'icon_color_custom',
					'description' => esc_html__( "Select a custom color for your icon", "impeka-wpb-extension" ),
					"std" => '#000000',
					"dependency" => array( 'element' => "icon_color", 'value' => array( 'custom' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon shape", "impeka-wpb-extension" ),
					"param_name" => "icon_shape",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'no-shape',
						esc_html__( "Square", "impeka-wpb-extension" ) => 'square',
						esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
						esc_html__( "Circle", "impeka-wpb-extension" ) => 'circle',
					),
					"description" => '',
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon', 'svg', 'animated-svg', 'char' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Shape type", "impeka-wpb-extension" ),
					"param_name" => "shape_type",
					"value" => array(
						esc_html__( "Simple", "impeka-wpb-extension" ) => 'simple',
						esc_html__( "Outline", "impeka-wpb-extension" ) => 'outline',
					),
					"description" => esc_html__( "Select shape type.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Shape Color", "impeka-wpb-extension" ),
					"param_name" => "icon_shape_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'gradient', 'standard', 'custom'] ),
					"std" => 'grey',
					"description" => esc_html__( "This affects to the Background of the simple shape type. Alternatively, affects to the line shape type.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( "Custom Icon Shape Color", "impeka-wpb-extension" ),
					'param_name' => 'icon_shape_color_custom',
					'description' => esc_html__( "Select a custom color for your shape", "impeka-wpb-extension" ),
					"std" => '#e1e1e1',
					"dependency" => array( 'element' => "icon_shape_color", 'value' => array( 'custom' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Enable Advanced Hover", "impeka-wpb-extension" ),
					"param_name" => "icon_animation",
					"value" => array( esc_html__( "If selected, you will have advanced hover.", "impeka-wpb-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "icon_box_type", 'value' => array( 'top-icon' ) ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Icon SVG", "impeka-wpb-extension" ),
					"param_name" => "icon_svg",
					"value" => '',
					"description" => esc_html__( "Select an svg icon. Note: SVG mime type must be enabled in WordPress", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'svg', 'animated-svg' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__('SVG Animation Duration', 'impeka-wpb-extension'),
					"param_name" => "animated_svg_animation_duration",
					"value" => '100',
					"description" => esc_html__( "Add delay in milliseconds.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'animated-svg' ) ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Icon Image", "impeka-wpb-extension" ),
					"param_name" => "icon_image",
					"value" => '',
					"description" => esc_html__( "Select an icon image.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'image' ) ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Retina Icon Image", "impeka-wpb-extension" ),
					"param_name" => "retina_icon_image",
					"value" => '',
					"description" => esc_html__( "Select a 2x icon.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'image' ) ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
					"param_name" => "image_load_mode",
					'value' => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
						esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
						esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
						esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
					),
					"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'image' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Character", "impeka-wpb-extension" ),
					"param_name" => "icon_char",
					"value" => "A",
					"description" => esc_html__( "Type a single character.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'char' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
					"param_name" => "title",
					"value" => "",
					"description" => esc_html__( "Enter icon box title.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
					"description" => esc_html__( "Select the color of your title.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_get_heading_tag( "h3" ),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Body Text", "impeka-wpb-extension" ) => 'body-text',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
						esc_html__( "Page Title", "impeka-wpb-extension" ) => 'page-title',
						esc_html__( "Feature Title", "impeka-wpb-extension" ) => 'feature-title',
					),
					"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"std" => 'h3',
				),
				impeka_wpb_ext_get_custom_font_family(),
				array(
					"type" => "textarea",
					"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
					"param_name" => "content",
					"value" => "",
					"description" => esc_html__( "Enter your content.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
					"description" => esc_html__( "Select the color of your text.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Style", "impeka-wpb-extension" ),
					"param_name" => "text_style",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => '',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
					),
					"description" => esc_html__( "Select your text style.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "vc_link",
					"heading" => esc_html__( "Link", "impeka-wpb-extension" ),
					"param_name" => "link",
					"value" => "",
					"description" => esc_html__( "Enter link.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Link Class", "impeka-wpb-extension" ),
					"param_name" => "link_class",
					"value" => "",
					"description" => esc_html__( "Enter extra class name for your link.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_icon_box', 'impeka_wpb_ext_icon_box_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
