<?php
/**
 * Icon Shortcode
 */

function impeka_wpb_ext_icon_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'icon.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_icon', 'impeka_wpb_ext_icon_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_icon_shortcode_params' ) ) {
	function impeka_wpb_ext_icon_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Icon", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add an icon", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-icon",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Type", "impeka-wpb-extension" ),
					"param_name" => "icon_type",
					"value" => array(
						esc_html__( "Icon", "impeka-wpb-extension" ) => 'icon',
						esc_html__( 'Theme SVG Icon', 'impeka-wpb-extension' ) => 'theme-icon-svg',
						esc_html__( "SVG", "impeka-wpb-extension" ) => 'svg',
						esc_html__( "Animated SVG", "impeka-wpb-extension" ) => 'animated-svg',
					),
					"description" => '',
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon size", "impeka-wpb-extension" ),
					"param_name" => "icon_size",
					"value" => array(
						esc_html__( "Extra Large", "impeka-wpb-extension" ) => 'extra-large',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Extra Small", "impeka-wpb-extension" ) => 'extra-small',
					),
					"std" => 'medium',
					"description" => '',
				),
				impeka_wpb_ext_add_inherit_align(),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'SVG Icon', 'impeka-wpb-extension' ),
					'value' => array(
						esc_html__( 'Arrow 1', 'impeka-wpb-extension' ) => 'arrow-1',
						esc_html__( 'Arrow 2', 'impeka-wpb-extension' ) => 'arrow-2',
						esc_html__( 'Video', 'impeka-wpb-extension' ) => 'video-1',
						esc_html__( 'Plus', 'impeka-wpb-extension' ) => 'plus',
						esc_html__( 'Quote', 'impeka-wpb-extension' ) => 'quote-1',
						esc_html__( 'Link', 'impeka-wpb-extension' ) => 'link',
						esc_html__( 'Backlink', 'impeka-wpb-extension' ) => 'backlink',
						esc_html__( 'Search', 'impeka-wpb-extension' ) => 'search',
						esc_html__( 'Share', 'impeka-wpb-extension' ) => 'share',
						esc_html__( 'Heart', 'impeka-wpb-extension' ) => 'heart',
						esc_html__( 'Tooltip', 'impeka-wpb-extension' ) => 'tooltip',
						esc_html__( 'Burger', 'impeka-wpb-extension' ) => 'burger-2',
					),
					'param_name' => 'theme_icon',
					'description' => esc_html__( 'Select an svg icon.', 'impeka-wpb-extension' ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'theme-icon-svg' ) ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon library', 'impeka-wpb-extension' ),
					'value' => array(
						esc_html__( 'Font Awesome', 'impeka-wpb-extension' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'impeka-wpb-extension' ) => 'openiconic',
						esc_html__( 'Typicons', 'impeka-wpb-extension' ) => 'typicons',
						esc_html__( 'Entypo', 'impeka-wpb-extension' ) => 'entypo',
						esc_html__( 'Linecons', 'impeka-wpb-extension' ) => 'linecons',
						esc_html__( 'Simple Line Icons', 'impeka-wpb-extension' ) => 'simplelineicons',
						esc_html__( 'Elegant Line Icons', 'impeka-wpb-extension' ) => 'etlineicons',
					),
					'param_name' => 'icon_library',
					'description' => esc_html__( 'Select icon library.', 'impeka-wpb-extension' ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon' ) ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_fontawesome',
					'value' => 'fas fa-adjust',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'fontawesome',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'openiconic',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'openiconic',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'typicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'typicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'entypo',
						'iconsPerPage' => 300, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'entypo',
					),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'linecons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'linecons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_simplelineicons',
					'value' => 'smp-icon-user',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'simplelineicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'simplelineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_etlineicons',
					'value' => 'et-icon-mobile',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'etlineicons',
						'iconsPerPage' => 100,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'etlineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Icon SVG", "impeka-wpb-extension" ),
					"param_name" => "icon_svg",
					"value" => '',
					"description" => esc_html__( "Select an svg icon. Note: SVG mime type must be enabled in WordPress", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'svg', 'animated-svg' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__('SVG Animation Duration', 'impeka-wpb-extension'),
					"param_name" => "animated_svg_animation_duration",
					"value" => '100',
					"description" => esc_html__( "Add delay in milliseconds.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'animated-svg' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Color", "impeka-wpb-extension" ),
					"param_name" => "icon_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'standard', 'custom'] ),
					"std" => 'primary-1',
					"description" => esc_html__( "Color of the icon ( Gradient colors are not available for Icon SVG ).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon', 'svg', 'animated-svg', 'theme-icon-svg' ) ),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( "Custom Icon Color", "impeka-wpb-extension" ),
					'param_name' => 'icon_color_custom',
					'description' => esc_html__( "Select a custom color for your icon", "impeka-wpb-extension" ),
					"std" => '#000000',
					"dependency" => array( 'element' => "icon_color", 'value' => array( 'custom' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon shape", "impeka-wpb-extension" ),
					"param_name" => "icon_shape",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => '',
						esc_html__( "Square", "impeka-wpb-extension" ) => 'square',
						esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
						esc_html__( "Circle", "impeka-wpb-extension" ) => 'circle',
					),
					"description" => '',
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon', 'svg', 'animated-svg', 'theme-icon-svg' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Shape type", "impeka-wpb-extension" ),
					"param_name" => "shape_type",
					"value" => array(
						esc_html__( "Simple", "impeka-wpb-extension" ) => 'simple',
						esc_html__( "Outline", "impeka-wpb-extension" ) => 'outline',
					),
					"description" => esc_html__( "Select shape type.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Shape Color", "impeka-wpb-extension" ),
					"param_name" => "icon_shape_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'gradient', 'standard', 'custom'] ),
					"std" => 'grey',
					"description" => esc_html__( "This affects to the Background of the simple shape type. Alternatively, affects to the line shape type.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( "Custom Icon Shape Color", "impeka-wpb-extension" ),
					'param_name' => 'icon_shape_color_custom',
					'description' => esc_html__( "Select a custom color for your shape", "impeka-wpb-extension" ),
					"std" => '#e1e1e1',
					"dependency" => array( 'element' => "icon_shape_color", 'value' => array( 'custom' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Loop Animation", "impeka-wpb-extension" ),
					"param_name" => "loop_animation",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => '',
						esc_html__( "Pulse", "impeka-wpb-extension" ) => 'animation-1',
					),
					"description" => esc_html__( "Select loop animation for your icon.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
				),
				array(
					"type" => "vc_link",
					"heading" => esc_html__( "Link", "impeka-wpb-extension" ),
					"param_name" => "link",
					"value" => "",
					"description" => esc_html__( "Enter link.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Link Class", "impeka-wpb-extension" ),
					"param_name" => "link_class",
					"value" => "",
					"description" => esc_html__( "Enter extra class name for your link.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_icon', 'impeka_wpb_ext_icon_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
