<?php
/**
 * Gallery Shortcode
 */

function impeka_wpb_ext_gallery_advanced_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'image-gallery-advanced.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_gallery_advanced', 'impeka_wpb_ext_gallery_advanced_shortcode' );

/**
 * Add shortcode HTML Holder thumbnails
 */

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Impeka_Gallery_Advanced extends WPBakeryShortCode {
		public function singleParamHtmlHolder( $param, $value ) {
			$output = '';
			$output = parent::singleParamHtmlHolder( $param, $value );
			$param_name = isset( $param['param_name'] ) ? $param['param_name'] : '';
			
			if ( 'ids' === $param_name ) {
				$images_ids = empty( $value ) ? array() : explode( ',', trim( $value ) );
				$output .= '<ul class="attachment-thumbnails' . ( empty( $images_ids ) ? ' image-exists' : '' ) . '" data-name="' . esc_attr( $param_name ) . '">';
				foreach ( $images_ids as $image ) {
					$img = wpb_getImageBySize( array(
						'attach_id' => (int) $image,
						'thumb_size' => 'thumbnail',
					) );
					$output .= ( $img ? '<li>' . $img['thumbnail'] . '</li>' : '<li><img width="150" height="150" src="' . vc_asset_url( 'vc/blank.gif' ) . '" class="attachment-thumbnail" alt="" title="" /></li>' );
				}
				$output .= '</ul>';
				$output .= '</br>';
			}
			return $output;
		}
	}
}

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_gallery_advanced_shortcode_params' ) ) {
	function impeka_wpb_ext_gallery_advanced_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Advanced Image Gallery", "impeka-wpb-extension" ),
			"description" => esc_html__( "Numerous styles, multiple columns for galleries", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "wpb_vc_gallery",
			"icon"      => "icon-wpb-grve-gallery",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Images Mode", "impeka-wpb-extension" ),
					"param_name" => "images_mode",
					'value' => array(
						esc_html__( "Gallery Images", "impeka-wpb-extension" ) => 'default',
						esc_html__( "Single Images", "impeka-wpb-extension" ) => 'single',
					),
					"admin_label" => true,
					"std" => 'default',
					"description" => esc_html__( "Select how to add your images( Add images from gallery or add separate images with different settings for each image ).", "impeka-wpb-extension" ),
				),
				array(
					"type"			=> "attach_images",
					"class"			=> "",
					"heading"		=> esc_html__( "Attach Images", "impeka-wpb-extension" ),
					"param_name"	=> "ids",
					"value" => '',
					"description"	=> esc_html__( "Select your gallery images.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "images_mode", 'value' => array( 'default' ) ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Image Link Mode", "impeka-wpb-extension" ),
					"param_name" => "link_type",
					"value" => array(
						esc_html__( "Image Popup", "impeka-wpb-extension" ) => 'popup',
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
					),
					"description" => esc_html__( "Choose the image link mode.", "impeka-wpb-extension" ),
					"std" => 'popup',
					"dependency" => array( 'element' => "images_mode", 'value' => array( 'default' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Popup Size", "impeka-wpb-extension" ),
					"param_name" => "image_popup_size",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Large' , 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Extra Extra Large' , 'impeka-wpb-extension' ) => 'extra-extra-large',
						esc_html__( 'Full' , 'impeka-wpb-extension' ) => 'full',
					) ),
					"dependency" => array( 'element' => "link_type", 'value' => array( 'popup' ) ),
					"description" => esc_html__( "Select size for your popup image.", "impeka-wpb-extension" ),
					"std" => 'extra-extra-large',
				),
				array(
					'type' => 'param_group',
					'param_name' => 'single_image_ids',
					'heading' => esc_html__( "Images", "impeka-wpb-extension" ),
					"description" => esc_html__( "Configure your images.", "impeka-wpb-extension" ),
					'value' => urlencode( json_encode( array(
						array(
							'label' => 'Image 1',
							'img' => '',
							'img_link_type' => 'popup',
							'img_popup_size' => 'extra-extra-large',
							
						),
						array(
							'label' => 'Image 2',
							'img' => '',
							'img_link_type' => 'popup',
							'img_popup_size' => 'extra-extra-large',
						),
						array(
							'label' => 'Image 3',
							'img' => '',
							'img_link_type' => 'popup',
							'img_popup_size' => 'extra-extra-large',
						),
					) ) ),
					'params' => array(
						array(
							"type" => "textfield",
							"heading" => esc_html__( "Label", "impeka-wpb-extension" ),
							"param_name" => "label",
							"value" => "",
							"description" => esc_html__( "Enter your image label ( only for editor purposes ).", "impeka-wpb-extension" ),
							"admin_label" => true,
						),
						array(
							"type" => "attach_image",
							"heading" => esc_html__( "Image", "impeka-wpb-extension" ),
							"param_name" => "img",
							"value" => '',
							"description" => esc_html__( "Select an image.", "impeka-wpb-extension" ),
						),
						array(
							"type" => "dropdown",
							"heading" => esc_html__( "Link Type", "impeka-wpb-extension" ),
							"param_name" => "img_link_type",
							'value' => array(
								esc_html__( "None", "impeka-wpb-extension" ) => 'none',
								esc_html__( "Image Popup", "impeka-wpb-extension" ) => 'popup',
								esc_html__( "Video Popup", "impeka-wpb-extension" ) => 'video-popup',
								esc_html__( "Custom Link", "impeka-wpb-extension" ) => 'custom-link',
							),
							"std" => 'popup',
							"description" => esc_html__( "Select the link type of your image.", "impeka-wpb-extension" ),
						),
						array(
							"type" => "dropdown",
							"heading" => esc_html__( "Image Popup Size", "impeka-wpb-extension" ),
							"param_name" => "img_popup_size",
							'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
								esc_html__( 'Large' , 'impeka-wpb-extension' ) => 'large',
								esc_html__( 'Extra Extra Large' , 'impeka-wpb-extension' ) => 'extra-extra-large',
								esc_html__( 'Full' , 'impeka-wpb-extension' ) => 'full',
							) ),
							"dependency" => array( 'element' => "img_link_type", 'value' => array( 'popup' ) ),
							"description" => esc_html__( "Select size for your popup image.", "impeka-wpb-extension" ),
							"std" => 'extra-extra-large',
						),
						array(
							"type" => "textfield",
							"heading" => esc_html__( "Video Link", "impeka-wpb-extension" ),
							"param_name" => "img_video_link",
							"value" => "",
							"description" => esc_html__( "Type a YouTube/Vimeo URL.", "impeka-wpb-extension" ) . '</br>' . esc_html__( 'Example:', 'impeka-wpb-extension' ) . ' ' .'https://www.youtube.com/watch?v=0s4_7BuszuQ',
							"dependency" => array( 'element' => "img_link_type", 'value' => array( 'video-popup') ),
						),
						array(
							"type" => "dropdown",
							"heading" => esc_html__( "Video Icon Color", "impeka-wpb-extension" ),
							"param_name" => "video_icon_color",
							"param_holder_class" => "grve-colored-dropdown",
							"value" => impeka_wpb_ext_get_color_array( ['none', 'primary', 'standard'] ),
							"std" => 'none',
							"dependency" => array( 'element' => "img_link_type", 'value' => array( 'video-popup') ),
						),
						array(
							"type" => "vc_link",
							"heading" => esc_html__( "Link", "impeka-wpb-extension" ),
							"param_name" => "img_link",
							"value" => "",
							"description" => esc_html__( "Enter image link.", "impeka-wpb-extension" ),
							"dependency" => array( 'element' => "img_link_type", 'value' => array( 'custom-link') ),
						),
						array(
							"type" => "textfield",
							"heading" => esc_html__( "Filter Categories", "impeka-wpb-extension" ),
							"param_name" => "img_filter_categories",
							"value" => "",
							"description" => esc_html__( "Type your filter categories seaparated by | e.g: Cars|Flowers.", "impeka-wpb-extension" ),
						),
					),
					"dependency" => array( 'element' => "images_mode", 'value' => array( 'single' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
					"param_name" => "image_load_mode",
					'value' => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
						esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
						esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
						esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
					),
					"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gallery Mode", "impeka-wpb-extension" ),
					"param_name" => "mode",
					"value" => array(
						esc_html__( "Grid", "impeka-wpb-extension" ) => 'grid',
						esc_html__( "Masonry", "impeka-wpb-extension" ) => 'masonry',
					),
					"description" => esc_html__( "Select your gallery mode.", "impeka-wpb-extension" ),
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Grid Image Size", "impeka-wpb-extension" ),
					"param_name" => "grid_image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
						esc_html__( 'Landscape Medium Crop', 'impeka-wpb-extension' ) => 'landscape-medium',
						esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
						esc_html__( 'Portrait Medium Crop', 'impeka-wpb-extension' ) => 'portrait-medium',
						esc_html__( 'Resize ( Extra Extra Large )', 'impeka-wpb-extension' ) => 'extra-extra-large',
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
					) ),
					"std" => 'square',
					"description" => esc_html__( "Select your Grid Image Size.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'grid' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Masonry Image Size", "impeka-wpb-extension" ),
					"param_name" => "masonry_image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Autocrop', 'impeka-wpb-extension' ) => '',
						esc_html__( 'Resize ( Extra Extra Large )', 'impeka-wpb-extension' ) => 'extra-extra-large',
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
					) ),
					"std" => '',
					"description" => esc_html__( "Select your Masonry Image Size.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'masonry' ) ),
				),
				//Gallery ( grid /masonry )
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Large Screen Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_large_screen",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					"std" => '3',
					"description" => esc_html__( "Select your Columns.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Columns", "impeka-wpb-extension" ),
					"param_name" => "columns",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					"std" => '3',
					"description" => esc_html__( "Select number of columns.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Landscape Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_tablet_landscape",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, landscape orientation.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Portrait Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_tablet_portrait",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, portrait orientation.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Mobile Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_mobile",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
					),
					"std" => '1',
					"description" => esc_html__( "Select responsive column on mobile devices.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between images", "impeka-wpb-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"description" => esc_html__( "Add gutter among images.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "impeka-wpb-extension" ),
					"param_name" => "gutter_size",
					"value" => '30',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "CSS Animation", "impeka-wpb-extension"),
					"param_name" => "animation",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Fade In", "impeka-wpb-extension" ) => "fade-in",
						esc_html__( "Fade In Up", "impeka-wpb-extension" ) => "fade-in-up",
						esc_html__( "Fade In Down", "impeka-wpb-extension" ) => "fade-in-down",
						esc_html__( "Fade In Left", "impeka-wpb-extension" ) => "fade-in-left",
						esc_html__( "Fade In Right", "impeka-wpb-extension" ) => "fade-in-right",
						esc_html__( "Zoom In", "impeka-wpb-extension" ) => "zoom-in",
					),
					"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
					"std" => "zoom-in",
				),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				//Titles & Hovers
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Title & Caption Visibility", "impeka-wpb-extension" ),
					"param_name" => "title_caption",
					'value' => array(
						esc_html__( 'None' , 'impeka-wpb-extension' ) => 'none',
						esc_html__( 'Title and Caption' , 'impeka-wpb-extension' ) => 'title-caption',
						esc_html__( 'Title Only' , 'impeka-wpb-extension' ) => 'title-only',
						esc_html__( 'Caption Only' , 'impeka-wpb-extension' ) => 'caption-only',
					),
					"description" => esc_html__( "Define the visibility for your image title - caption.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
					"param_name" => "title_heading_tag",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "div", "impeka-wpb-extension" ) => 'div',
					),
					"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
					"std" => 'h3',
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "title_heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Image Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"std" => 'h3',
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Title Custom Font Family", "impeka-wpb-extension" ),
					"param_name" => "title_custom_font_family",
					"value" => array(
						esc_html__( "Same as Typography", "impeka-wpb-extension" ) => '',
						esc_html__( "Custom Font Family 1", "impeka-wpb-extension" ) => 'custom-font-1',
						esc_html__( "Custom Font Family 2", "impeka-wpb-extension" ) => 'custom-font-2',
						esc_html__( "Custom Font Family 3", "impeka-wpb-extension" ) => 'custom-font-3',
						esc_html__( "Custom Font Family 4", "impeka-wpb-extension" ) => 'custom-font-4',

					),
					"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "impeka-wpb-extension" ),
					"std" => '',
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Hover Style", "impeka-wpb-extension" ),
					"param_name" => "hover_style",
					'value' => array(
						esc_html__( 'Text below image' , 'impeka-wpb-extension' ) => 'style-1',
						esc_html__( 'Split text on hover' , 'impeka-wpb-extension' ) => 'style-2',
						esc_html__( 'Text on media' , 'impeka-wpb-extension' ) => 'style-3',
						esc_html__( 'Tilt media on hover' , 'impeka-wpb-extension' ) => 'style-4',
						esc_html__( 'Cursor effect' , 'impeka-wpb-extension' ) => 'style-5',
						esc_html__( 'Mouse move effect' , 'impeka-wpb-extension' ) => 'style-6',
						esc_html__( 'Gradient Overlay' , 'impeka-wpb-extension' ) => 'style-7',
					),
					"description" => esc_html__( "Select the hover style for the portfolio overview.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the title color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Background Color", "impeka-wpb-extension" ),
					"param_name" => "title_bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
					"std" => 'transparent',
					"description" => esc_html__( "Choose the title background color ( available only for Cursor effect style ).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Description/Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the description/text color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'caption-only' ) ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Description/Text Background Color", "impeka-wpb-extension" ),
					"param_name" => "text_bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
					"std" => 'transparent',
					"description" => esc_html__( "Choose the description/text background color ( available only for Cursor effect style ).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'caption-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Indicator", "impeka-wpb-extension" ),
					"param_name" => "indicator",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Arrow", "impeka-wpb-extension" ) => 'arrow',
						esc_html__( "Plus", "impeka-wpb-extension" ) => 'plus',
						esc_html__( "Text", "impeka-wpb-extension" ) => 'text',
					),
					"std" => 'none',
					"description" => esc_html__( "Choose the indicator.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "hover_style", 'value_not_equal_to' => array( 'style-5' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Indicator Text", "impeka-wpb-extension" ),
					"param_name" => "indicator_text",
					"value" => 'More',
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "indicator", 'value' => array( 'text' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Indicator Color", "impeka-wpb-extension" ),
					"param_name" => "indicator_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'primary-1',
					"description" => esc_html__( "Choose the indicator color.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "indicator", 'value_not_equal_to' => array( 'none' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "impeka-wpb-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'gradient', 'standard', 'dominant'] ),
					"std" => 'white',
					"description" => esc_html__( "Choose the image color overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "hover_style", 'value_not_equal_to' => array( 'style-7' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "impeka-wpb-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array( '0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100' ),
					"std" => '90',
					"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Effect", "impeka-wpb-extension" ),
					"param_name" => "image_effect",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Grayscale Image", "impeka-wpb-extension" ) => 'grayscale-image',
						esc_html__( "Colored on Hover", "impeka-wpb-extension" ) => 'grayscale-image-hover',
					),
					"description" => esc_html__( "Choose the grayscale effect.", "impeka-wpb-extension" ),
					"std" => 'none',
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border radius", "impeka-wpb-extension" ),
					"param_name" => "radius",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
						esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
						esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
						esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
						esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
						esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
						esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
						esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
					),
					"description" => '',
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
					),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				//Filters
								array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Filter", "impeka-wpb-extension" ),
					"param_name" => "filter",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"description" => esc_html__( "If selected, an isotope filter will be displayed.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "images_mode", 'value' => array( 'single' ) ),
					"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_filter_all_text(),
				impeka_wpb_ext_add_filter_order_by(),
				impeka_wpb_ext_add_filter_order(),
				impeka_wpb_ext_add_filter_style(),
				impeka_wpb_ext_add_filter_shape(),
				impeka_wpb_ext_add_filter_color(),
				impeka_wpb_ext_add_filter_align(),
				impeka_wpb_ext_add_filter_gototop(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_gallery_advanced', 'impeka_wpb_ext_gallery_advanced_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
