<?php
/**
* Single Image Shortcode
*/

function impeka_wpb_ext_single_image_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'image-single.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_single_image', 'impeka_wpb_ext_single_image_shortcode' );

/**
* Add shortcode to Page Builder
*/

if( !function_exists( 'impeka_wpb_ext_single_image_shortcode_params' ) ) {
	function impeka_wpb_ext_single_image_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Single Image", "impeka-wpb-extension" ),
			"description" => esc_html__( "Image or Video popup in various uses", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-single-image",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Type", "impeka-wpb-extension" ),
						"param_name" => "image_type",
						"value" => array(
							esc_html__( "Image", "impeka-wpb-extension" ) => 'image',
							esc_html__( "Image With Content", "impeka-wpb-extension" ) => 'image-content',
						),
						"description" => esc_html__( "Select your image type.", "impeka-wpb-extension" ),
						"admin_label" => true,
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Size", "impeka-wpb-extension" ),
						"param_name" => "image_mode",
						'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
							esc_html__( 'Full ( Custom )', 'impeka-wpb-extension' ) => '',
							esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
							esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
							esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
							esc_html__( 'Resize ( Extra Extra Large )', 'impeka-wpb-extension' ) => 'extra-extra-large',
							esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
							esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
							esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
							esc_html__( 'Thumbnail', 'impeka-wpb-extension' ) => 'thumbnail',
						) ),
						"std" => '',
						"description" => esc_html__( "Select your Image Size.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "attach_image",
						"heading" => esc_html__( "Image", "impeka-wpb-extension" ),
						"param_name" => "image",
						"value" => '',
						"description" => esc_html__( "Select an image.", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "attach_image",
						"heading" => esc_html__( "Retina Image", "impeka-wpb-extension" ),
						"param_name" => "retina_image",
						"value" => '',
						"description" => esc_html__( "Select a 2x image.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_mode", 'value' => array( '' ) ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
						"param_name" => "image_load_mode",
						'value' => array(
							esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
							esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
							esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
							esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
						),
						"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Column Space", "impeka-wpb-extension" ),
						"param_name" => "image_column_space",
						"value" => array(
							esc_html__( "Auto", "impeka-wpb-extension" ) => 'auto',
							esc_html__( "100%", "impeka-wpb-extension" ) => '100',
							esc_html__( "125%", "impeka-wpb-extension" ) => '125',
							esc_html__( "150%", "impeka-wpb-extension" ) => '150',
							esc_html__( "175%", "impeka-wpb-extension" ) => '175',
							esc_html__( "200%", "impeka-wpb-extension" ) => '200',
							esc_html__( "225%", "impeka-wpb-extension" ) => '225',
							esc_html__( "250%", "impeka-wpb-extension" ) => '250',
						),
						"description" => esc_html__( "Define the max width of the image on this column. Setting percentage larger than 100% the image overflows out of the column. Default is the image resolution.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_type", 'value' => array( 'image' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Reset Image Column Space", "impeka-wpb-extension" ),
						"param_name" => "image_column_space_reset",
						"value" => array(
							esc_html__( "Never", "impeka-wpb-extension" ) => '',
							esc_html__( "on Tablet Landscape and below", "impeka-wpb-extension" ) => 'tablet',
							esc_html__( "on Tablet Portrait and below", "impeka-wpb-extension" ) => 'tablet-sm',
							esc_html__( "on Mobile Ladscape and below", "impeka-wpb-extension" ) => 'mobile',
						),
						"description" => esc_html__( "Select if you want to reset the image size to auto in some devices.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_column_space", 'value_not_equal_to' => array( 'auto', '100' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Alignment", "impeka-wpb-extension" ),
						"param_name" => "inherit_align",
						"value" => array(
							esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
							esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
							esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
							esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
						),
						"description" => 'Inherits its value from its column text align definition.',
						"std" => 'center',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Effect", "impeka-wpb-extension" ),
						"param_name" => "image_effect",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Grayscale Image", "impeka-wpb-extension" ) => 'grayscale-image',
							esc_html__( "Colored on Hover", "impeka-wpb-extension" ) => 'grayscale-image-hover',
						),
						"std" => '',
						"description" => esc_html__( "Choose the image effect.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
						"param_name" => "radius",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => 'none',
							esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
							esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
							esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
							esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
							esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
							esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
							esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
							esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
							esc_html__( "Circle", "impeka-wpb-extension" ) => 'circle',
						),
						"description" => '',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Shadow", "impeka-wpb-extension" ),
						"param_name" => "shadow",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => 'none',
							esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
							esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
							esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
						),
					),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
				),
				//Extras
				array(
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Link Type", "impeka-wpb-extension" ),
						"param_name" => "link_type",
						'value' => array(
							esc_html__( "None", "impeka-wpb-extension" ) => 'none',
							esc_html__( "Image Popup", "impeka-wpb-extension" ) => 'image-popup',
							esc_html__( "Video Popup", "impeka-wpb-extension" ) => 'video-popup',
							esc_html__( "Gallery Popup", "impeka-wpb-extension" ) => 'gallery-popup',
							esc_html__( "Custom Link", "impeka-wpb-extension" ) => 'custom-link',
						),
						"description" => esc_html__( "Select the link type of your single image.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Popup Size", "impeka-wpb-extension" ),
						"param_name" => "image_popup_size",
						'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
							esc_html__( 'Large' , 'impeka-wpb-extension' ) => 'large',
							esc_html__( 'Extra Extra Large' , 'impeka-wpb-extension' ) => 'extra-extra-large',
							esc_html__( 'Full' , 'impeka-wpb-extension' ) => 'full',
						) ),
						"std" => 'extra-extra-large',
						"dependency" => array( 'element' => "link_type", 'value' => array( 'image-popup', 'gallery-popup' ) ),
						"description" => esc_html__( "Select size for your popup image.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Popup Title & Caption Visibility", "impeka-wpb-extension" ),
						"param_name" => "image_popup_title_caption",
						'value' => array(
							esc_html__( 'None' , 'impeka-wpb-extension' ) => 'none',
							esc_html__( 'Title and Caption' , 'impeka-wpb-extension' ) => 'title-caption',
							esc_html__( 'Title Only' , 'impeka-wpb-extension' ) => 'title-only',
							esc_html__( 'Caption Only' , 'impeka-wpb-extension' ) => 'caption-only',
						),
						"dependency" => array( 'element' => "link_type", 'value' => array( 'image-popup', 'gallery-popup' ) ),
						"description" => esc_html__( "Define the visibility for your popup image title - caption.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),
					array(
						"type"			=> "attach_images",
						"class"			=> "",
						"heading"		=> esc_html__( "Attach Images", "impeka-wpb-extension" ),
						"param_name"	=> "ids",
						"value" => '',
						"description"	=> esc_html__( "Select your gallery images.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "link_type", 'value' => array( 'gallery-popup' ) ),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),

					array(
						"type" => "textfield",
						"heading" => esc_html__( "Video Link", "impeka-wpb-extension" ),
						"param_name" => "video_link",
						"value" => "",
						"description" => esc_html__( "Type video URL e.g Vimeo/YouTube.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "link_type", 'value' => array( 'video-popup') ),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Video Icon Color", "impeka-wpb-extension" ),
						"param_name" => "video_icon_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"std" => 'primary-1',
						"dependency" => array( 'element' => "link_type", 'value' => array( 'video-popup') ),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),
					array(
						"type" => "vc_link",
						"heading" => esc_html__( "Link", "impeka-wpb-extension" ),
						"param_name" => "link",
						"value" => "",
						"description" => esc_html__( "Enter link.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "link_type", 'value' => array( 'custom-link' ) ),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Link Class", "impeka-wpb-extension" ),
						"param_name" => "link_class",
						"value" => "",
						"description" => esc_html__( "Enter extra class name for your link.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "link_type", 'value' => array( 'custom-link' ) ),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),
				),
				//Titles & Hovers Tab
				array(
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Style - Hovers", "impeka-wpb-extension" ),
						"param_name" => "hover_style",
						'value' => array(
							esc_html__( 'Text below image' , 'impeka-wpb-extension' ) => 'style-1',
							esc_html__( 'Split text on hover' , 'impeka-wpb-extension' ) => 'style-2',
							esc_html__( 'Text on media' , 'impeka-wpb-extension' ) => 'style-3',
							esc_html__( 'Tilt media on hover' , 'impeka-wpb-extension' ) => 'style-4',
							esc_html__( 'Cursor effect' , 'impeka-wpb-extension' ) => 'style-5',
							esc_html__( 'Mouse move effect' , 'impeka-wpb-extension' ) => 'style-6',
							esc_html__( 'Gradient Overlay' , 'impeka-wpb-extension' ) => 'style-7',
						),
						"description" => esc_html__( "Select the hover style for the portfolio overview.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_type", 'value' => array( 'image-content' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
						"param_name" => "title_heading_tag",
						"value" => array(
							esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
							esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
							esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
							esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
							esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
							esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
							esc_html__( "div", "impeka-wpb-extension" ) => 'div',
						),
						"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
						"std" => 'h3',
						"dependency" => array( 'element' => "image_type", 'value' => array( 'image-content' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Size/Typography", "impeka-wpb-extension" ),
						"param_name" => "title_heading",
						"value" => array(
							esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
							esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
							esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
							esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
							esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
							esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
							esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
							esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
							esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
							esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
						),
						"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
						"std" => 'h3',
						"dependency" => array( 'element' => "image_type", 'value' => array( 'image-content' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Custom Font Family", "impeka-wpb-extension" ),
						"param_name" => "title_custom_font_family",
						"value" => array(
							esc_html__( "Same as Typography", "impeka-wpb-extension" ) => '',
							esc_html__( "Custom Font Family 1", "impeka-wpb-extension" ) => 'custom-font-1',
							esc_html__( "Custom Font Family 2", "impeka-wpb-extension" ) => 'custom-font-2',
							esc_html__( "Custom Font Family 3", "impeka-wpb-extension" ) => 'custom-font-3',
							esc_html__( "Custom Font Family 4", "impeka-wpb-extension" ) => 'custom-font-4',

						),
						"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "impeka-wpb-extension" ),
						"std" => '',
						"dependency" => array( 'element' => "image_type", 'value' => array( 'image-content' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
						"param_name" => "title_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
						"std" => 'default',
						"description" => esc_html__( "Choose the title color.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_type", 'value' => array( 'image-content' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Background Color", "impeka-wpb-extension" ),
						"param_name" => "title_bg_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
						"std" => 'transparent',
						"description" => esc_html__( "Choose the title background color.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "hover_style", 'value' => array( 'style-5' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Description/Text Color", "impeka-wpb-extension" ),
						"param_name" => "text_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
						"std" => 'default',
						"description" => esc_html__( "Choose the description/text color.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_type", 'value' => array( 'image-content' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Description/Text Background Color", "impeka-wpb-extension" ),
						"param_name" => "text_bg_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
						"std" => 'transparent',
						"description" => esc_html__( "Choose the description/text background color.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "hover_style", 'value' => array( 'style-5' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
						"param_name" => "custom_title",
						"value" => "",
						"description" => esc_html__( "Enter your title.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_type", 'value' => array( 'image-content' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textarea",
						"heading" => esc_html__( "Caption", "impeka-wpb-extension" ),
						"param_name" => "custom_caption",
						"value" => "",
						"description" => esc_html__( "Enter your caption.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_type", 'value' => array( 'image-content' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Hover Overlay Color", "impeka-wpb-extension" ),
						"param_name" => "overlay_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['primary', 'gradient', 'standard', 'dominant'] ),
						"std" => 'black',
						"description" => esc_html__( "Choose the image color overlay.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "hover_style", 'value_not_equal_to' => array( 'style-7' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Hover Overlay Opacity", "impeka-wpb-extension" ),
						"param_name" => "overlay_opacity",
						"value" => array( '0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100' ),
						"std" => '80',
						"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_type", 'value' => array( 'image-content' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
				),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation_clipping(),
					impeka_wpb_ext_add_clipping(),
					impeka_wpb_ext_add_clipping_colors(),
					impeka_wpb_ext_add_appear(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_single_image', 'impeka_wpb_ext_single_image_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
