<?php
/**
 * Slider Shortcode
 */

function impeka_wpb_ext_slider_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'image-slider.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_slider', 'impeka_wpb_ext_slider_shortcode' );

/**
 * Add shortcode HTML Holder thumbnails
 */

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Impeka_Slider extends WPBakeryShortCode {
		public function singleParamHtmlHolder( $param, $value ) {
			$output = '';
			$output = parent::singleParamHtmlHolder( $param, $value );
			$param_name = isset( $param['param_name'] ) ? $param['param_name'] : '';
			if ( 'ids' === $param_name ) {
				$images_ids = empty( $value ) ? array() : explode( ',', trim( $value ) );
				$output .= '<ul class="attachment-thumbnails' . ( empty( $images_ids ) ? ' image-exists' : '' ) . '" data-name="' . esc_attr( $param_name ) . '">';
				foreach ( $images_ids as $image ) {
					$img = wpb_getImageBySize( array(
						'attach_id' => (int) $image,
						'thumb_size' => 'thumbnail',
					) );
					$output .= ( $img ? '<li>' . $img['thumbnail'] . '</li>' : '<li><img width="150" height="150" src="' . vc_asset_url( 'vc/blank.gif' ) . '" class="attachment-thumbnail" alt="" title="" /></li>' );
				}
				$output .= '</ul>';
				$output .= '<a href="javascript:;" class="column_edit_trigger' . ( ! empty( $images_ids ) ? ' image-exists' : '' ) . '">' . esc_html__( 'Add images', 'js_composer' ) . '</a>';
			}
			return $output;
		}
	}
}

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_slider_shortcode_params' ) ) {
	function impeka_wpb_ext_slider_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Slider", "impeka-wpb-extension" ),
			"description" => esc_html__( "Create a simple slider", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "wpb_vc_gallery",
			"icon"      => "icon-wpb-grve-slider",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type"			=> "attach_images",
						"class"			=> "",
						"heading"		=> esc_html__( "Attach Images", "impeka-wpb-extension" ),
						"param_name"	=> "ids",
						"value" => '',
						"description"	=> esc_html__( "Select your slider images.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
						"param_name" => "image_load_mode",
						'value' => array(
							esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
							esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
							esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
							esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
						),
						"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Mode", "impeka-wpb-extension" ),
						"param_name" => "image_mode",
						'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
							esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
							esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
							esc_html__( 'Landscape Medium Crop', 'impeka-wpb-extension' ) => 'landscape-medium',
							esc_html__( 'Landscape Large Wide Crop', 'impeka-wpb-extension' ) => 'landscape-large-wide',
							esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
							esc_html__( 'Resize ( Extra Extra Large )' , 'impeka-wpb-extension' ) => 'extra-extra-large',
							esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
							esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
							esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
						 ) ),
						"std" => 'extra-extra-large',
						"description" => esc_html__( "Select your slider image mode.", "impeka-wpb-extension" ),
					),
					array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Image Width", "impeka-wpb-extension" ),
						"param_name" => "image_width",
						'value' => array(
							esc_html__( 'Column Width', 'impeka-wpb-extension' ) => '',
							esc_html__( 'Auto', 'impeka-wpb-extension' ) => 'auto',
						),
						"dependency" => array( 'element' => "title_caption", 'value' => array( 'none' ) ),
						"description" => esc_html__( "Select if you want your image to fill the column space.", "impeka-wpb-extension" ),
					),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
				),
				//Navigation Tab
				array(
					array(
						"type" => 'impeka_param_label',
						"heading" => esc_html__( "Behavior", 'impeka-wpb-extension'),
						"param_name" => "label_behavior",
						'value' => '',
						"std" => '',
						"description" => esc_html__( "Configure the slider behavior", "impeka-wpb-extension" ),
						"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Loop", "impeka-wpb-extension" ),
						"param_name" => "loop",
						"value" => array(
							esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
							esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						),
						"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Autoplay", "impeka-wpb-extension" ),
						"param_name" => "auto_play",
						"value" => array(
							esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
							esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						),
						"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Slideshow Speed", "impeka-wpb-extension" ),
						"param_name" => "slideshow_speed",
						"value" => '3000',
						"description" => esc_html__( "Slideshow Speed in ms.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Pause on Hover", "impeka-wpb-extension" ),
						"param_name" => "pause_hover",
						"value" => array(
							esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
							esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						),
						"std" => "no",
						"description" => esc_html__( "If selected, carousel will be paused on hover", "impeka-wpb-extension" ),
						"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => 'checkbox',
						"heading" => esc_html__( "Auto Height", "impeka-wpb-extension" ),
						"param_name" => "auto_height",
						"value" => array( esc_html__( "Select if you want smooth auto height", "impeka-wpb-extension" ) => 'yes' ),
						"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Transition", "impeka-wpb-extension" ),
						"param_name" => "transition",
						"value" => array(
							esc_html__( "Slide", "impeka-wpb-extension" ) => 'slide',
							esc_html__( "Fade", "impeka-wpb-extension" ) => 'fade',
						),
						"description" => esc_html__( "Transition Effect.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => 'impeka_param_label',
						"heading" => esc_html__( "Navigation / Pagination", 'impeka-wpb-extension'),
						"param_name" => "label_navigation",
						'value' => '',
						"std" => '',
						"description" => esc_html__( "Configure the slider navigation", "impeka-wpb-extension" ),
						"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					),
					impeka_wpb_ext_add_navigation( 'yes' ),
					impeka_wpb_ext_add_navigation_icon( 'arrow-1' ),
					impeka_wpb_ext_add_navigation_icon_color( 'black' ),
					impeka_wpb_ext_add_navigation_shape(),
					impeka_wpb_ext_add_navigation_shape_type(),
					impeka_wpb_ext_add_navigation_shape_color(),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Pagination", "impeka-wpb-extension" ),
						"param_name" => "pagination",
						"value" => array(
							esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
							esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						),
						"std" => 'yes',
						"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Pagination Speed", "impeka-wpb-extension" ),
						"param_name" => "pagination_speed",
						"value" => '400',
						"description" => esc_html__( "Pagination Speed in ms.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "pagination", 'value' => array( 'yes' ) ),
						"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					),
				),
				//Titles & Hovers Tab
				array(
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Title & Caption Visibility", "impeka-wpb-extension" ),
						"param_name" => "title_caption",
						'value' => array(
							esc_html__( 'None' , 'impeka-wpb-extension' ) => 'none',
							esc_html__( 'Title and Caption' , 'impeka-wpb-extension' ) => 'title-caption',
							esc_html__( 'Title Only' , 'impeka-wpb-extension' ) => 'title-only',
							esc_html__( 'Caption Only' , 'impeka-wpb-extension' ) => 'caption-only',
						),
						"description" => esc_html__( "Define the visibility for your image title - caption.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
						"param_name" => "title_heading_tag",
						"value" => array(
							esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
							esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
							esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
							esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
							esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
							esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
							esc_html__( "div", "impeka-wpb-extension" ) => 'div',
						),
						"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
						"std" => 'h3',
						"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Title Size/Typography", "impeka-wpb-extension" ),
						"param_name" => "title_heading",
						"value" => array(
							esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
							esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
							esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
							esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
							esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
							esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
							esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
							esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
							esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
							esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
						),
						"description" => esc_html__( "Image Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
						"std" => 'h3',
						"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Title Custom Font Family", "impeka-wpb-extension" ),
						"param_name" => "title_custom_font_family",
						"value" => array(
							esc_html__( "Same as Typography", "impeka-wpb-extension" ) => '',
							esc_html__( "Custom Font Family 1", "impeka-wpb-extension" ) => 'custom-font-1',
							esc_html__( "Custom Font Family 2", "impeka-wpb-extension" ) => 'custom-font-2',
							esc_html__( "Custom Font Family 3", "impeka-wpb-extension" ) => 'custom-font-3',
							esc_html__( "Custom Font Family 4", "impeka-wpb-extension" ) => 'custom-font-4',

						),
						"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "impeka-wpb-extension" ),
						"std" => '',
						"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
						"param_name" => "title_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"std" => 'white',
						"description" => esc_html__( "Choose the title color.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Description/Text Color", "impeka-wpb-extension" ),
						"param_name" => "text_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"std" => 'white',
						"description" => esc_html__( "Choose the description /text color.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'caption-only', 'title-only'  ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Hover Styles", "impeka-wpb-extension" ),
						"param_name" => "hover_style",
						'value' => array(
							esc_html__( 'Split text on hover' , 'impeka-wpb-extension' ) => 'style-2',
							esc_html__( 'Text on media' , 'impeka-wpb-extension' ) => 'style-3',
							esc_html__( 'Mouse move effect' , 'impeka-wpb-extension' ) => 'style-6',
						),
						"description" => esc_html__( "Select the hover style for the slider.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'caption-only', 'title-only'  ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Overlay Color", "impeka-wpb-extension" ),
						"param_name" => "overlay_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"description" => esc_html__( "Choose the image color overlay.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'caption-only', 'title-only'  ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Overlay Opacity", "impeka-wpb-extension" ),
						"param_name" => "overlay_opacity",
						"value" => array( '0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100' ),
						"std" => '0',
						"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'caption-only', 'title-only'  ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Grayscale Effect", "impeka-wpb-extension" ),
						"param_name" => "image_effect",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Grayscale Image", "impeka-wpb-extension" ) => 'grayscale-image',
							esc_html__( "Colored on Hover", "impeka-wpb-extension" ) => 'grayscale-image-hover',
						),
						"description" => esc_html__( "Choose the grayscale effect.", "impeka-wpb-extension" ),
						"std" => 'none',
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
						"param_name" => "radius",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
							esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
							esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
							esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
							esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
							esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
							esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
							esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
						),
						"description" => '',
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension" ),
						"param_name" => "shadow",
						"value" => array(
							esc_html__( "No", "impeka-wpb-extension" ) => '',
							esc_html__( "Small", "impeka-wpb-extension" ) => 'small-shadow',
							esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium-shadow',
							esc_html__( "Large", "impeka-wpb-extension" ) => 'large-shadow',
						),
						"dependency" => array( 'element' => "type", 'value' => array( 'advanced' ) ),
						"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
					),
				),
				//Extras Tab
				array(
					array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Link Type", "impeka-wpb-extension" ),
						"param_name" => "link_type",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => 'none',
							esc_html__( "Image Popup", "impeka-wpb-extension" ) => 'popup',
							esc_html__( "Custom Link", "impeka-wpb-extension" ) => 'custom_link',
						),
						"description" => esc_html__( "Choose the image link type.", "impeka-wpb-extension" ),
						"std" => 'none',
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Popup Size", "impeka-wpb-extension" ),
						"param_name" => "image_popup_size",
						'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
							esc_html__( 'Large' , 'impeka-wpb-extension' ) => 'large',
							esc_html__( 'Extra Extra Large' , 'impeka-wpb-extension' ) => 'extra-extra-large',
							esc_html__( 'Full' , 'impeka-wpb-extension' ) => 'full',
						) ),
						"dependency" => array( 'element' => "link_type", 'value' => array( 'popup' ) ),
						"description" => esc_html__( "Select size for your popup image.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
						"std" => 'extra-extra-large',
					),
					array(
						'type' => 'exploded_textarea_safe',
						'heading' => esc_html__( 'Custom links', 'impeka-wpb-extension' ),
						'param_name' => 'custom_links',
						'description' => esc_html__( 'Enter links for each slide (Note: divide links with linebreaks (Enter)).', 'impeka-wpb-extension' ),
						'dependency' => array(
							'element' => 'link_type',
							'value' => array( 'custom_link' ),
						),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),
					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Custom link target', 'impeka-wpb-extension' ),
						'param_name' => 'custom_links_target',
						'description' => esc_html__( 'Select where to open custom links.', 'impeka-wpb-extension' ),
						'dependency' => array(
							'element' => 'link_type',
							'value' => array( 'custom_link' ),
						),
						"value" => array(
							esc_html__( "Same Window", "impeka-wpb-extension" ) => '_self',
							esc_html__( "New Window", "impeka-wpb-extension" ) => '_blank',
						),
						"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
					),
				)
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_slider', 'impeka_wpb_ext_slider_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
