<?php
/**
 * Image Text Shortcode
 */

function impeka_wpb_ext_image_text_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'image-text.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_image_text', 'impeka_wpb_ext_image_text_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_image_text_shortcode_params' ) ) {
	function impeka_wpb_ext_image_text_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Image Text", "impeka-wpb-extension" ),
			"description" => esc_html__( "Combine image or video with text and button", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-image-text",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				array(
					//General Tab
					array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Image Text Style", "impeka-wpb-extension" ),
						"param_name" => "image_text_style",
						"value" => array(
							esc_html__( "Style 1", "impeka-wpb-extension" ) => 'style-1',
							esc_html__( "Style 2", "impeka-wpb-extension" ) => 'style-2',
						),
						"description" => esc_html__( "Select your image text style.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Size", "impeka-wpb-extension" ),
						"param_name" => "image_mode",
						'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
							esc_html__( 'Full ( Custom )', 'impeka-wpb-extension' ) => '',
							esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
							esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
							esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
							esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
							esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						) ),
						"std" => '',
						"description" => esc_html__( "Select your Image Size.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "attach_image",
						"heading" => esc_html__( "Image", "impeka-wpb-extension" ),
						"param_name" => "image",
						"value" => '',
						"description" => esc_html__( "Select an image.", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "attach_image",
						"heading" => esc_html__( "Retina Image", "impeka-wpb-extension" ),
						"param_name" => "retina_image",
						"value" => '',
						"description" => esc_html__( "Select a 2x image.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_mode", 'value' => array( '' ) ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
						"param_name" => "image_load_mode",
						'value' => array(
							esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
							esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
							esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
							esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
						),
						"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
					),
					array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Image Position", "impeka-wpb-extension" ),
						"param_name" => "image_text_align",
						"description" => esc_html__( "Set the position of your image.", "impeka-wpb-extension" ),
						"value" => array(
							esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
							esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
						),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
						"param_name" => "radius",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => 'none',
							esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
							esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
							esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
							esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
							esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
							esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
							esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
							esc_html__( "Circle", "impeka-wpb-extension" ) => 'circle',
						),
						"std" => 'none',
					),
					array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Popup Mode", "impeka-wpb-extension" ),
						"param_name" => "popup_mode",
						"description" => esc_html__( "If selected, a popup will appear on click.", "impeka-wpb-extension" ),
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Video", "impeka-wpb-extension" ) => 'video',
							esc_html__( "Image", "impeka-wpb-extension" ) => 'image',
						),
						"dependency" => array( 'element' => "image_text_style", 'value' => array( 'style-1' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Popup Size", "impeka-wpb-extension" ),
						"param_name" => "image_popup_size",
						'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
							esc_html__( 'Large' , 'impeka-wpb-extension' ) => 'large',
							esc_html__( 'Extra Extra Large' , 'impeka-wpb-extension' ) => 'extra-extra-large',
							esc_html__( 'Full' , 'impeka-wpb-extension' ) => 'full',
						) ),
						"std" => 'extra-extra-large',
						"dependency" => array( 'element' => "popup_mode", 'value' => array( 'image' )),
						"description" => esc_html__( "Select size for your popup image.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
						"param_name" => "title",
						"value" => "Sample Title",
						"description" => esc_html__( "Enter your title.", "impeka-wpb-extension" ),
						"admin_label" => true,
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
						"param_name" => "title_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
						"description" => esc_html__( "Select the color of your title.", "impeka-wpb-extension" ),
					),
					impeka_wpb_ext_get_heading_tag( "h3" ),
					impeka_wpb_ext_get_heading( "h3" ),
					impeka_wpb_ext_get_custom_font_family(),
					array(
						"type" => "textarea",
						"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
						"param_name" => "content",
						"value" => "Sample Text",
						"description" => esc_html__( "Enter your text.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
						"param_name" => "text_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
						"description" => esc_html__( "Select the color of your text.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Text Style", "impeka-wpb-extension" ),
						"param_name" => "text_style",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Leader", "impeka-wpb-extension" ) => 'leader-text',
							esc_html__( "Subtitle", "impeka-wpb-extension" ) => 'subtitle-text',
							esc_html__( "Page Description", "impeka-wpb-extension" ) => 'page-description',
						),
						"description" => esc_html__( "Select your text style.", "impeka-wpb-extension" ),
					),
					array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Content Alignment", "impeka-wpb-extension" ),
						"param_name" => "content_align",
						"description" => esc_html__( "Set the alignment of your content", "impeka-wpb-extension" ),
						"value" => array(
							esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
							esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
						),
					),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
				),
				//Button Tab
				impeka_wpb_ext_get_button_params( 'image-text' ),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_image_text', 'impeka_wpb_ext_image_text_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
