<?php
/**
 * Language selector Shortcode
 */

function impeka_wpb_ext_language_selector_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'language-selector.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_language_selector', 'impeka_wpb_ext_language_selector_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_language_selector_shortcode_params' ) ) {
	function impeka_wpb_ext_language_selector_shortcode_params( $tag ) {

		return array(
			"name" => esc_html__( "Language Selector", "impeka-wpb-extension" ),
			"description" => esc_html__( "Place your language selector", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-languages",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Style", "impeka-wpb-extension" ),
					"param_name" => "style",
					'value' => array(
						esc_html__( "Dropdown", "impeka-wpb-extension" ) => 'dropdown',
						esc_html__( "List", "impeka-wpb-extension" ) => 'list',
					),
					"description" => esc_html__( "Select language selector style.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_align(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),

				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_language_selector', 'impeka_wpb_ext_language_selector_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
