<?php
/**
 * List Title Shortcode
 */

function impeka_wpb_ext_list_title_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'list-title.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_list_title', 'impeka_wpb_ext_list_title_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_list_title_shortcode_params' ) ) {
	function impeka_wpb_ext_list_title_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "List Title", "impeka-wpb-extension" ),
			"description" => esc_html__( "Display a post type as list with titles", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-list-title",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Type", "impeka-wpb-extension" ),
					"param_name" => "post_type",
					'value' => array(
						esc_html__( 'Post', 'impeka-wpb-extension' ) => 'post',
						esc_html__( 'Portfolio', 'impeka-wpb-extension' ) => 'portfolio',
						esc_html__( 'Product', 'impeka-wpb-extension' ) => 'product',
					),
					"description" => esc_html__( "Select the post type.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_order_by(),
				impeka_wpb_ext_add_order(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "impeka-wpb-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'gradient', 'standard'] ),
					"std" => 'black',
					"description" => esc_html__( "Choose the image color overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "impeka-wpb-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array(
						esc_html__( "0%", "impeka-wpb-extension" ) => '0',
						esc_html__( "10%", "impeka-wpb-extension" ) => '10',
						esc_html__( "20%", "impeka-wpb-extension" ) => '20',
						esc_html__( "30%", "impeka-wpb-extension" ) => '30',
						esc_html__( "40%", "impeka-wpb-extension" ) => '40',
						esc_html__( "50%", "impeka-wpb-extension" ) => '50',
						esc_html__( "60%", "impeka-wpb-extension" ) => '60',
						esc_html__( "70%", "impeka-wpb-extension" ) => '70',
						esc_html__( "80%", "impeka-wpb-extension" ) => '80',
						esc_html__( "90%", "impeka-wpb-extension" ) => '90',
						esc_html__( "100%", "impeka-wpb-extension" ) => '100'
					),
					"std" => '10',
					"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
					"param_name" => "heading_tag",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "div", "impeka-wpb-extension" ) => 'div',
					),
					"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
					"std" => 'h3',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"std" => 'h4',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the title color.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the text color.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Line Color", "impeka-wpb-extension" ),
					"param_name" => "line_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'standard'] ),
					"std" => 'primary-1',
					"description" => esc_html__( "Choose the text line color.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				//Pagination
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Items per page", "impeka-wpb-extension" ),
					"param_name" => "posts_per_page",
					"value" => '12',
					"description" => esc_html__( "Enter how many items per page you want to display.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Display Style", "impeka-wpb-extension" ),
					"param_name" => "display_style",
					"value" => array(
						esc_html__( "Show All", "impeka-wpb-extension" ) => '',
						esc_html__( "Pagination", "impeka-wpb-extension" ) => 'pagination',
					),
					"std" => 'pagination',
					"description" => esc_html__( "Select display style", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				//Filters
				impeka_wpb_ext_add_filter(),
				impeka_wpb_ext_add_filter_all_text(),
				impeka_wpb_ext_add_filter_order_by(),
				impeka_wpb_ext_add_filter_order(),
				impeka_wpb_ext_add_filter_style(),
				impeka_wpb_ext_add_filter_shape(),
				impeka_wpb_ext_add_filter_color(),
				impeka_wpb_ext_add_filter_align(),
				impeka_wpb_ext_add_filter_gototop(),
				//Categories
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Exclude Posts", "impeka-wpb-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__( "Categories", "impeka-wpb-extension" ),
					"param_name" => "categories",
					"value" => impeka_wpb_ext_get_post_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'post' ) ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Portfolio Categories", "impeka-wpb-extension" ),
					"param_name" => "portfolio_categories",
					"value" => impeka_wpb_ext_get_post_categories( 'portfolio_category' ),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'portfolio' ) ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Product Categories", "impeka-wpb-extension" ),
					"param_name" => "product_categories",
					"value" => impeka_wpb_ext_get_post_categories( 'product_cat' ),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'product' ) ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "impeka-wpb-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_list_title', 'impeka_wpb_ext_list_title_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
