<?php
/**
 * Media Box Shortcode
 */

function impeka_wpb_ext_media_box_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'media-box.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_media_box', 'impeka_wpb_ext_media_box_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_media_box_shortcode_params' ) ) {
	function impeka_wpb_ext_media_box_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Media Box", "impeka-wpb-extension" ),
			"description" => esc_html__( "Image, Video or Map combined with text", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-media-box",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Media type", "impeka-wpb-extension" ),
					"param_name" => "media_type",
					"value" => array(
						esc_html__( "Image", "impeka-wpb-extension" ) => 'image',
						esc_html__( "Image - Video Popup", "impeka-wpb-extension" ) => 'image-video-popup',
						esc_html__( "Video", "impeka-wpb-extension" ) => 'video',
						esc_html__( "Map", "impeka-wpb-extension" ) => 'map',
					),
					"description" => esc_html__( "Select your media type.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Style", "impeka-wpb-extension" ),
					"param_name" => "media_style",
					"value" => array(
						esc_html__( "Classic", "impeka-wpb-extension" ) => 'style-1',
						esc_html__( "Background Image", "impeka-wpb-extension" ) => 'style-2',
					),
					"description" => esc_html__( "Select your media box style.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'image', 'image-video-popup' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Size", "impeka-wpb-extension" ),
					"param_name" => "image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Full ( Custom )', 'impeka-wpb-extension' ) => '',
						esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
						esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
						esc_html__( 'Resize ( Extra Extra Large )', 'impeka-wpb-extension' ) => 'extra-extra-large',
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
						esc_html__( 'Thumbnail', 'impeka-wpb-extension' ) => 'thumbnail',
					) ),
					"std" => '',
					"description" => esc_html__( "Select your Image Size.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_style", 'value' => array( 'style-1' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Size", "impeka-wpb-extension" ),
					"param_name" => "bg_image_size",
					'value' => array(
						esc_html__( 'Full ( Custom )', 'impeka-wpb-extension' ) => '',
						esc_html__( 'Resize ( Extra Extra Large )', 'impeka-wpb-extension' ) => 'extra-extra-large',
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
					),
					"std" => '',
					"description" => esc_html__( "Select your Image Size.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_style", 'value' => array( 'style-2' ) ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Image", "impeka-wpb-extension" ),
					"param_name" => "image",
					"value" => '',
					"description" => esc_html__( "Select an image.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'image', 'image-video-popup' ) ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Retina Image", "impeka-wpb-extension" ),
					"param_name" => "retina_image",
					"value" => '',
					"description" => esc_html__( "Select a 2x image.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "image_mode", 'value' => array( '' ) ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
					"param_name" => "image_load_mode",
					'value' => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
						esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
						esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
						esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
					),
					"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'image', 'image-video-popup' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Colors", "impeka-wpb-extension" ),
					"param_name" => "text_colors",
					'value' => array(
						esc_html__( 'Auto', 'impeka-wpb-extension' ) => '',
						esc_html__( 'Inherit', 'impeka-wpb-extension' ) => 'inherit',
					),
					"std" => '',
					"description" => esc_html__( "Select your text colors.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_style", 'value' => array( 'style-2' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "impeka-wpb-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'black',
					"description" => esc_html__( "Choose the image color overlay.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'image', 'image-video-popup' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "impeka-wpb-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array( '0', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55', '60', '65', '70', '75', '80', '85', '90', '95', '100' ),
					"std" => '10',
					"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'image', 'image-video-popup' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small-shadow',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium-shadow',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large-shadow',
					),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Media shape", "impeka-wpb-extension" ),
					"param_name" => "image_shape",
					"value" => array(
						esc_html__( "Square", "impeka-wpb-extension" ) => 'square',
						esc_html__( "Radius 3px", "impeka-wpb-extension" ) => 'radius-3',
						esc_html__( "Radius 5px", "impeka-wpb-extension" ) => 'radius-5',
						esc_html__( "Radius 10px", "impeka-wpb-extension" ) => 'radius-10',
						esc_html__( "Radius 15px", "impeka-wpb-extension" ) => 'radius-15',
						esc_html__( "Radius 20px", "impeka-wpb-extension" ) => 'radius-20',
						esc_html__( "Radius 25px", "impeka-wpb-extension" ) => 'radius-25',
						esc_html__( "Radius 30px", "impeka-wpb-extension" ) => 'radius-30',
						esc_html__( "Radius 35px", "impeka-wpb-extension" ) => 'radius-35',
					),
					"description" => '',
					"dependency" => array( 'element' => "media_type", 'value' => array( 'image', 'image-video-popup' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Video Link", "impeka-wpb-extension" ),
					"param_name" => "video_link",
					"value" => "",
					"description" => esc_html__( "Type video URL e.g Vimeo/YouTube.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'image-video-popup', 'video' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Video Icon Color", "impeka-wpb-extension" ),
					"param_name" => "video_icon_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'primary-1',
					"dependency" => array( 'element' => "media_type", 'value' => array( 'image-video-popup', 'video' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Map Latitude", "impeka-wpb-extension" ),
					"param_name" => "map_lat",
					"value" => "51.516221",
					"description" => esc_html__( "Type map Latitude.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'map' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Map Longtitude", "impeka-wpb-extension" ),
					"param_name" => "map_lng",
					"value" => "-0.136986",
					"description" => esc_html__( "Type map Longtitude.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'map' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Map Zoom", "impeka-wpb-extension" ),
					"param_name" => "map_zoom",
					"value" => array( '1', '2', '3' ,'4', '5', '6', '7', '8' ,'9' ,'10' ,'11' ,'12', '13', '14', '15', '16', '17', '18', '19' ),
					"std" => '14',
					"description" => esc_html__( "Zoom of the map.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'map' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Map Height", "impeka-wpb-extension" ),
					"param_name" => "map_height",
					"value" => "280",
					"description" => esc_html__( "Type map height.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'map' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Disable Custom Style", "impeka-wpb-extension" ),
					"param_name" => "map_disable_style",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"description" => esc_html__( "Select if you want to disable custom map style.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'map' ) ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Custom marker", "impeka-wpb-extension" ),
					"param_name" => "map_marker",
					"value" => '',
					"description" => esc_html__( "Select an icon for custom marker.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_type", 'value' => array( 'map' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
					"param_name" => "title",
					"value" => "Sample Title",
					"description" => esc_html__( "Enter your title.", "impeka-wpb-extension" ),
					"save_always" => true,
					"admin_label" => true,
				),
				impeka_wpb_ext_get_heading_tag( "h3" ),
				impeka_wpb_ext_get_heading( "h3" ),
				impeka_wpb_ext_get_custom_font_family(),
				array(
					"type" => "textarea",
					"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
					"param_name" => "content",
					"value" => "Sample Text",
					"description" => esc_html__( "Enter your text.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Style", "impeka-wpb-extension" ),
					"param_name" => "text_style",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => '',
						esc_html__( "Leader", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle", "impeka-wpb-extension" ) => 'subtitle',
						esc_html__( "Page Description", "impeka-wpb-extension" ) => 'page-description',
					),
					"description" => esc_html__( "Select your text style.", 'impeka-wpb-extension' ),
				),
				array(
					"type" => "vc_link",
					"heading" => esc_html__( "Title Link", "impeka-wpb-extension" ),
					"param_name" => "title_link",
					"value" => "",
					"description" => esc_html__( "Enter title link.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Read More Title", "impeka-wpb-extension" ),
					"param_name" => "read_more_title",
					"value" => "",
					"description" => esc_html__( "Enter your title for your link.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Link Class", "impeka-wpb-extension" ),
					"param_name" => "link_class",
					"value" => "",
					"description" => esc_html__( "Enter extra class name for your link.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Min Height", "impeka-wpb-extension" ),
					"param_name" => "min_height",
					"value" => "400",
					"description" => esc_html__( "Enter min height for your media box (Note: CSS measurement units allowed).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "media_style", 'value' => array( 'style-2' ) ),
				),
				impeka_wpb_ext_add_align(),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_media_box', 'impeka_wpb_ext_media_box_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
