<?php
/**
 * Modal Shortcode
 */

function impeka_wpb_ext_menu_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'menu.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_menu', 'impeka_wpb_ext_menu_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_menu_shortcode_params' ) ) {
	function impeka_wpb_ext_menu_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Menu", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add a custom menu", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon" => "icon-wpb-grve-menu",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Menu", "impeka-wpb-extension" ),
					"param_name" => "nav_menu",
					"admin_label" => true,
					'save_always' => true,
					"value" => impeka_wpb_ext_get_menus(),
					"description" => esc_html__( "Select menu to display.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Menu Orientation", "impeka-wpb-extension" ),
					"param_name" => "orientation",
					"value" => array(
						esc_html__( "Horizontal", "impeka-wpb-extension" ) => 'horizontal',
						esc_html__( "Vertical", "impeka-wpb-extension" ) => 'vertical',
					),
					"description" => esc_html__( "Set the orientation of your menu.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Menu Responsive Orientation", "impeka-wpb-extension" ),
					"param_name" => "responsive_orientation",
					"value" => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
						esc_html__( "Vertical on Tablet Landscape and below", "impeka-wpb-extension" ) => 'vertical-tablet',
						esc_html__( "Vertical on Tablet Portrait and below", "impeka-wpb-extension" ) => 'vertical-tablet-sm',
						esc_html__( "Vertical on Mobile Ladscape and below", "impeka-wpb-extension" ) => 'vertical-mobile',
					),
					"description" => esc_html__( "Set the responsive orientation of your menu.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "orientation", 'value' => array( 'horizontal' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Menu Type", "impeka-wpb-extension" ),
					"param_name" => "menu_type",
					"admin_label" => true,
					'save_always' => true,
					"value" => array(
						esc_html__( "Toggle", "impeka-wpb-extension" ) => 'toggle',
						esc_html__( "Accordion", "impeka-wpb-extension" ) => 'accordion',
						esc_html__( "Slide", "impeka-wpb-extension" ) => 'slide',
					),
					"description" => esc_html__( "Select your menu type.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "orientation", 'value' => array( 'vertical' ) ),
				),
				impeka_wpb_ext_add_inherit_align(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Menu Font Size", "impeka-wpb-extension" ),
					"param_name" => "heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Body Text", "impeka-wpb-extension" ) => 'body-text',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
						esc_html__( "Main Menu Fonts", "impeka-wpb-extension" ) => 'menu-text',
						esc_html__( "Responsive Menu Fonts", "impeka-wpb-extension" ) => 'responsive-menu-text',
						esc_html__( "Offcanvas Menu Fonts", "impeka-wpb-extension" ) => 'offcanvas-menu-text',
						esc_html__( "Page Title Fonts", "impeka-wpb-extension" ) => 'page-title',
						esc_html__( "Feature Title Fonts", "impeka-wpb-extension" ) => 'feature-title',
					),
					"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"std" => 'menu-text',
				),
				impeka_wpb_ext_get_custom_font_family(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Item Spacing", "impeka-wpb-extension" ),
					"param_name" => "item_space",
					"value" => array( '0', '1', '5', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55', '60' ),
					"std" => '30',
					"description" => esc_html__( "Set the space between that will display on each side of your menu items in px.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_menu', 'impeka_wpb_ext_menu_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
