<?php
/**
 * Message Box Shortcode
 */

function impeka_wpb_ext_message_box_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'message-box.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_message_box', 'impeka_wpb_ext_message_box_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_message_box_shortcode_params' ) ) {
	function impeka_wpb_ext_message_box_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Message Box", "impeka-wpb-extension" ),
			"description" => esc_html__( "Info text with icons", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-message-box",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Add icon?", "impeka-wpb-extension" ),
					"param_name" => "add_icon",
					"value" => array( esc_html__( "Select if you want to show an icon", "impeka-wpb-extension" ) => 'yes' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon library', 'impeka-wpb-extension' ),
					'value' => array(
						esc_html__( 'Font Awesome', 'impeka-wpb-extension' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'impeka-wpb-extension' ) => 'openiconic',
						esc_html__( 'Typicons', 'impeka-wpb-extension' ) => 'typicons',
						esc_html__( 'Entypo', 'impeka-wpb-extension' ) => 'entypo',
						esc_html__( 'Linecons', 'impeka-wpb-extension' ) => 'linecons',
						esc_html__( 'Simple Line Icons', 'impeka-wpb-extension' ) => 'simplelineicons',
						esc_html__( 'Elegant Line Icons', 'impeka-wpb-extension' ) => 'etlineicons',
					),
					'param_name' => 'icon_library',
					'description' => esc_html__( 'Select icon library.', 'impeka-wpb-extension' ),
					"dependency" => array( 'element' => "add_icon", 'value' => array( 'yes' ) ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_fontawesome',
					'value' => 'fas fa-info-circle',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'fontawesome',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'openiconic',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'openiconic',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'typicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'typicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'entypo',
						'iconsPerPage' => 300, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'entypo',
					),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'linecons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'linecons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_simplelineicons',
					'value' => 'smp-icon-user',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'simplelineicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'simplelineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'impeka-wpb-extension' ),
					'param_name' => 'icon_etlineicons',
					'value' => 'et-icon-mobile',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'etlineicons',
						'iconsPerPage' => 100,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'etlineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'impeka-wpb-extension' ),
				),
				array(
					"type" => "textarea",
					"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
					"param_name" => "content",
					"value" => "Sample Text",
					"description" => esc_html__( "Enter your content.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Background Color", "impeka-wpb-extension" ),
					"param_name" => "bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
					"std" => 'green',
					"description" => esc_html__( "Background color of the box.", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Remove Close Button", "impeka-wpb-extension" ),
					"param_name" => "remove_close",
					"value" => array( esc_html__( "If selected, close button will be removed", "impeka-wpb-extension" ) => 'yes' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small-shadow',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium-shadow',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large-shadow',
					),
				),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				impeka_wpb_ext_add_animation_clipping(),
				impeka_wpb_ext_add_clipping(),
				impeka_wpb_ext_add_appear(),
				impeka_wpb_ext_add_clipping_colors(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_message_box', 'impeka_wpb_ext_message_box_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
