<?php
/**
 * Pie Chart Shortcode
 */

function impeka_wpb_ext_pie_chart_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'pie-chart.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_pie_chart', 'impeka_wpb_ext_pie_chart_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_pie_chart_shortcode_params' ) ) {
	function impeka_wpb_ext_pie_chart_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Pie Chart", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add a counter with icon and title", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-pie-chart",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Pie Chart Value", "impeka-wpb-extension" ),
					"param_name" => "pie_chart_val",
					"value" => "50",
					"description" => esc_html__( "Enter the pie chart value number.", "impeka-wpb-extension" ),
					"admin_label" => true,
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Value Prefix", "impeka-wpb-extension" ),
					"param_name" => "pie_chart_prefix",
					"value" => "",
					"description" => esc_html__( "Enter value prefix.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Value Suffix", "impeka-wpb-extension" ),
					"param_name" => "pie_chart_suffix",
					"value" => "",
					"description" => esc_html__( "Enter value suffix.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Pie Chart Size", "impeka-wpb-extension" ),
					"param_name" => "pie_chart_size",
					"value" => array(
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
					),
					"description" => esc_html__( "Select pie chart size.", "impeka-wpb-extension" ),
					"std" => 'medium',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Pie Chart Line Size", "impeka-wpb-extension" ),
					"param_name" => "pie_chart_line_size",
					"value" => "6",
					"description" => esc_html__( "Enter pie chart line size.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Pie Chart Style", "impeka-wpb-extension" ),
					"param_name" => "pie_line_style",
					"value" => array(
						esc_html__( "Square", "impeka-wpb-extension" ) => 'square',
						esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
					),
					"description" => esc_html__( "Set the pie chart shape style.", "impeka-wpb-extension" ),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( "Pie Chart Value Color", "impeka-wpb-extension" ),
					'param_name' => 'pie_chart_val_color',
					'description' => esc_html__( "Select the value color for your pie.", "impeka-wpb-extension" ),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( "Pie Chart Active Color", "impeka-wpb-extension" ),
					'param_name' => 'pie_active_color',
					'description' => esc_html__( "Select the active color for your pie.", "impeka-wpb-extension" ),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( "Pie Chart Base Color", "impeka-wpb-extension" ),
					'param_name' => 'pie_chart_color',
					'description' => esc_html__( "Select the base color for your pie.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
					"param_name" => "title",
					"value" => "",
					"description" => esc_html__( "Enter pie chart title", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
					"description" => esc_html__( "Select the color of your title.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_get_heading_tag( "h3" ),
				impeka_wpb_ext_get_heading( "h3" ),
				impeka_wpb_ext_get_custom_font_family(),
				array(
					"type" => "textarea",
					"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
					"param_name" => "pie_chart_text",
					"value" => "",
					"description" => esc_html__( "Type your text", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
					"description" => esc_html__( "Select the color of your text.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_pie_chart', 'impeka_wpb_ext_pie_chart_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
