<?php
/**
 * Portfolio Broken Shortcode
 */

function impeka_wpb_ext_portfolio_broken_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'portfolio-broken.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_portfolio_broken', 'impeka_wpb_ext_portfolio_broken_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_portfolio_broken_shortcode_params' ) ) {
	function impeka_wpb_ext_portfolio_broken_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Broken Portfolio", "impeka-wpb-extension" ),
			"description" => esc_html__( "Display Portfolio element in multiple styles", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-portfolio",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Portfolio Layout", "impeka-wpb-extension" ),
					"param_name" => "layout",
					"admin_label" => true,
					'value' => array(
						esc_html__( 'Layout 1' , 'impeka-wpb-extension' ) => 'layout-1',
						esc_html__( 'Layout 2' , 'impeka-wpb-extension' ) => 'layout-2',
						esc_html__( 'Layout 3' , 'impeka-wpb-extension' ) => 'layout-3',
						esc_html__( 'Layout 4' , 'impeka-wpb-extension' ) => 'layout-4',
					),
					"description" => esc_html__( "Select your portfolio layout", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
					"param_name" => "image_load_mode",
					'value' => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
						esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
						esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
						esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
					),
					"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_order_by(),
				impeka_wpb_ext_add_order(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "CSS Animation", "impeka-wpb-extension"),
					"param_name" => "animation",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Fade In", "impeka-wpb-extension" ) => "fade-in",
						esc_html__( "Fade In Up", "impeka-wpb-extension" ) => "fade-in-up",
						esc_html__( "Fade In Down", "impeka-wpb-extension" ) => "fade-in-down",
						esc_html__( "Fade In Left", "impeka-wpb-extension" ) => "fade-in-left",
						esc_html__( "Fade In Right", "impeka-wpb-extension" ) => "fade-in-right",
						esc_html__( "Zoom In", "impeka-wpb-extension" ) => "zoom-in",
					),
					"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
					"std" => "",
				),
				impeka_wpb_ext_add_margin_bottom(),
				array(
					"type" => "el_id",
					"heading" => esc_html__( "Element ID", "impeka-wpb-extension" ),
					'description' => esc_html__( "Enter element ID (Note: make sure it is unique)", "impeka-wpb-extension" ),
					"param_name" => "el_id",
					'settings' => array(
						'auto_generate' => true,
					),
				),
				impeka_wpb_ext_add_el_class(),
				//Styles & Titles
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Portfolio Style - Hovers", "impeka-wpb-extension" ),
					"param_name" => "style",
					'value' => array(
						esc_html__( 'Text below image' , 'impeka-wpb-extension' ) => 'style-1',
						esc_html__( 'Split text on hover' , 'impeka-wpb-extension' ) => 'style-2',
						esc_html__( 'Text on media' , 'impeka-wpb-extension' ) => 'style-3',
						esc_html__( 'Tilt media on hover' , 'impeka-wpb-extension' ) => 'style-4',
						esc_html__( 'Cursor effect' , 'impeka-wpb-extension' ) => 'style-5',
						esc_html__( 'Mouse move effect' , 'impeka-wpb-extension' ) => 'style-6',
						esc_html__( 'Gradient Overlay' , 'impeka-wpb-extension' ) => 'style-7',
					),
					"std" => 'style-1',
					"description" => esc_html__( "Select the hover style for the portfolio overview.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Indicator", "impeka-wpb-extension" ),
					"param_name" => "indicator",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Arrow", "impeka-wpb-extension" ) => 'arrow',
						esc_html__( "Plus", "impeka-wpb-extension" ) => 'plus',
						esc_html__( "Text", "impeka-wpb-extension" ) => 'text',
					),
					"std" => 'none',
					"description" => esc_html__( "Choose the indicator.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value_not_equal_to' => array( 'style-5' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Indicator Text", "impeka-wpb-extension" ),
					"param_name" => "indicator_text",
					"value" => 'More',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "indicator", 'value' => array( 'text' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Indicator Color", "impeka-wpb-extension" ),
					"param_name" => "indicator_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"std" => 'primary-1',
					"description" => esc_html__( "Choose the indicator color.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "indicator", 'value_not_equal_to' => array( 'none' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Effect", "impeka-wpb-extension" ),
					"param_name" => "image_effect",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => '',
						esc_html__( "Grayscale Image", "impeka-wpb-extension" ) => 'grayscale-image',
						esc_html__( "Colored on Hover", "impeka-wpb-extension" ) => 'grayscale-image-hover',
					),
					"description" => esc_html__( "Choose the grayscale effect.", "impeka-wpb-extension" ),
					"std" => '',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "impeka-wpb-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'gradient', 'standard', 'dominant'] ),
					"std" => 'black',
					"description" => esc_html__( "Choose the image color overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "style", 'value_not_equal_to' => array( 'style-7' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "impeka-wpb-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array(
						esc_html__( "0%", "impeka-wpb-extension" ) => '0',
						esc_html__( "10%", "impeka-wpb-extension" ) => '10',
						esc_html__( "20%", "impeka-wpb-extension" ) => '20',
						esc_html__( "30%", "impeka-wpb-extension" ) => '30',
						esc_html__( "40%", "impeka-wpb-extension" ) => '40',
						esc_html__( "50%", "impeka-wpb-extension" ) => '50',
						esc_html__( "60%", "impeka-wpb-extension" ) => '60',
						esc_html__( "70%", "impeka-wpb-extension" ) => '70',
						esc_html__( "80%", "impeka-wpb-extension" ) => '80',
						esc_html__( "90%", "impeka-wpb-extension" ) => '90',
						esc_html__( "100%", "impeka-wpb-extension" ) => '100'
					),
					"std" => '10',
					"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
					),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
					"param_name" => "radius",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
						esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
						esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
						esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
						esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
						esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
						esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
						esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
					),
					"description" => '',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Title & Description Visibility", "impeka-wpb-extension" ),
					"param_name" => "title_caption",
					'value' => array(
						esc_html__( 'None' , 'impeka-wpb-extension' ) => 'none',
						esc_html__( 'Title and Description' , 'impeka-wpb-extension' ) => 'title-caption',
						esc_html__( 'Title Only' , 'impeka-wpb-extension' ) => 'title-only',
						esc_html__( 'Description Only' , 'impeka-wpb-extension' ) => 'caption-only',
					),
					"std" => 'title-caption',
					"description" => esc_html__( "Define the visibility for your title - description.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
					"param_name" => "title_heading_tag",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "div", "impeka-wpb-extension" ) => 'div',
					),
					"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
					"std" => 'h3',
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Portfolio Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "title_heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Portfolio Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"std" => 'h4',
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the title color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Background Color", "impeka-wpb-extension" ),
					"param_name" => "title_bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
					"std" => 'transparent',
					"description" => esc_html__( "Choose the title background color ( available only for Cursor effect style ).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Description/Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the description/text color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'caption-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Description/Text Background Color", "impeka-wpb-extension" ),
					"param_name" => "text_bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
					"std" => 'transparent',
					"description" => esc_html__( "Choose the description/text background color ( available only for Cursor effect style ).", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'caption-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Link Type", "impeka-wpb-extension" ),
					"param_name" => "link_type",
					'value' => array(
						esc_html__( 'Classic Portfolio' , 'impeka-wpb-extension' ) => 'item',
						esc_html__( 'Quick View' , 'impeka-wpb-extension' ) => 'quick-view',
						esc_html__( 'Gallery Usage' , 'impeka-wpb-extension' ) => 'popup',
						esc_html__( 'Custom Link' , 'impeka-wpb-extension' ) => 'custom-link',
					),
					"description" => esc_html__( "Select the link type of your portfolio items.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Popup Size", "impeka-wpb-extension" ),
					"param_name" => "image_popup_size",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Large' , 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Extra Extra Large' , 'impeka-wpb-extension' ) => 'extra-extra-large',
						esc_html__( 'Full' , 'impeka-wpb-extension' ) => 'full',
					)),
					"std" => 'extra-extra-large',
					"dependency" => array( 'element' => "link_type", 'value' => array( 'popup' ) ),
					"description" => esc_html__( "Select size for your popup image.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overview Type", "impeka-wpb-extension" ),
					"param_name" => "overview_type",
					'value' => array(
						esc_html__( 'Default' , 'impeka-wpb-extension' ) => '',
						esc_html__( 'Custom Overview' , 'impeka-wpb-extension' ) => 'custom-overview',
					),
					"description" => esc_html__( "Select the overview type of your portfolio items.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Items per page", "impeka-wpb-extension" ),
					"param_name" => "items_per_page",
					"value" => '12',
					"description" => esc_html__( "Enter how many items per page you want to display.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Display Style", "impeka-wpb-extension" ),
					"param_name" => "display_style",
					"value" => array(
						esc_html__( "Show All", "impeka-wpb-extension" ) => '',
						esc_html__( "Pagination", "impeka-wpb-extension" ) => 'pagination',
					),
					"std" => 'pagination',
					"description" => esc_html__( "Select display style", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				//Categories
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Exclude Posts", "impeka-wpb-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Portfolio Categories", "impeka-wpb-extension" ),
					"param_name" => "categories",
					"value" => impeka_wpb_ext_get_post_categories( 'portfolio_category' ),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "impeka-wpb-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_portfolio_broken', 'impeka_wpb_ext_portfolio_broken_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
