<?php
/**
 * Portfolio Carousel Shortcode
 */

function impeka_wpb_ext_portfolio_carousel_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'portfolio-carousel.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_portfolio_carousel', 'impeka_wpb_ext_portfolio_carousel_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_portfolio_carousel_shortcode_params' ) ) {
	function impeka_wpb_ext_portfolio_carousel_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Portfolio Carousel", "impeka-wpb-extension" ),
			"description" => esc_html__( "Display Portfolio Carousel", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-portfolio-carousel",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Type", "impeka-wpb-extension" ),
					"param_name" => "type",
					"admin_label" => true,
					"value" => array(
						esc_html__( 'Classic', 'impeka-wpb-extension' ) => 'classic',
						esc_html__( 'Advanced', 'impeka-wpb-extension' ) => 'advanced',
					),
					"description" => esc_html__( "Select your Carousel Type.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
					"param_name" => "image_load_mode",
					'value' => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
						esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
						esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
						esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
					),
					"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Image Size", "impeka-wpb-extension" ),
					"param_name" => "image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
						esc_html__( 'Landscape Medium Crop', 'impeka-wpb-extension' ) => 'landscape-medium',
						esc_html__( 'Landscape Large Wide Crop', 'impeka-wpb-extension' ) => 'landscape-large-wide',
						esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
						esc_html__( 'Resize ( Extra Extra Large )' , 'impeka-wpb-extension' ) => 'extra-extra-large',
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
					) ),
					"std" => 'landscape',
					"description" => esc_html__( "Select your Carousel Image Size.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items per page", "impeka-wpb-extension" ),
					"param_name" => "items_per_page",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"description" => esc_html__( "Number of items per page", "impeka-wpb-extension" ),
					"std" => '4',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Tablet Landscape", "impeka-wpb-extension" ),
					"param_name" => "items_tablet_landscape",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"std" => '3',
					"description" => esc_html__( "Select number of items on tablet devices, landscape orientation.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Tablet Portrait", "impeka-wpb-extension" ),
					"param_name" => "items_tablet_portrait",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"std" => '3',
					"description" => esc_html__( "Select number of items on tablet devices, portrait orientation.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Mobile", "impeka-wpb-extension" ),
					"param_name" => "items_mobile",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"std" => '1',
					"description" => esc_html__( "Select number of items on mobile devices.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Items to show", "impeka-wpb-extension" ),
					"param_name" => "items_to_show",
					"value" => '12',
					"description" => esc_html__( "Maximum Portfolio Items to Show", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between items", "impeka-wpb-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"description" => esc_html__( "Add gutter among items.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "type", 'value' => array( 'classic' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "impeka-wpb-extension" ),
					"param_name" => "gutter_size",
					"value" => '30',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				impeka_wpb_ext_add_order_by(),
				impeka_wpb_ext_add_order(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				//Styles & Titles
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Portfolio Style - Hovers", "impeka-wpb-extension" ),
					"param_name" => "style",
					'value' => array(
						esc_html__( 'Text below image' , 'impeka-wpb-extension' ) => 'style-1',
						esc_html__( 'Split text on hover' , 'impeka-wpb-extension' ) => 'style-2',
						esc_html__( 'Text on media' , 'impeka-wpb-extension' ) => 'style-3',
						esc_html__( 'Mouse move effect' , 'impeka-wpb-extension' ) => 'style-6',
						esc_html__( 'Gradient Overlay' , 'impeka-wpb-extension' ) => 'style-7',
					),
					"std" => 'style-1',
					"description" => esc_html__( "Select the hover style for the portfolio overview.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Effect", "impeka-wpb-extension" ),
					"param_name" => "image_effect",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => '',
						esc_html__( "Grayscale Image", "impeka-wpb-extension" ) => 'grayscale-image',
						esc_html__( "Colored on Hover", "impeka-wpb-extension" ) => 'grayscale-image-hover',
					),
					"description" => esc_html__( "Choose the grayscale effect.", "impeka-wpb-extension" ),
					"std" => '',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "impeka-wpb-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'gradient', 'standard', 'dominant'] ),
					"std" => 'black',
					"description" => esc_html__( "Choose the image color overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "style", 'value_not_equal_to' => array( 'style-7' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "impeka-wpb-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array(
						esc_html__( "0%", "impeka-wpb-extension" ) => '0',
						esc_html__( "10%", "impeka-wpb-extension" ) => '10',
						esc_html__( "20%", "impeka-wpb-extension" ) => '20',
						esc_html__( "30%", "impeka-wpb-extension" ) => '30',
						esc_html__( "40%", "impeka-wpb-extension" ) => '40',
						esc_html__( "50%", "impeka-wpb-extension" ) => '50',
						esc_html__( "60%", "impeka-wpb-extension" ) => '60',
						esc_html__( "70%", "impeka-wpb-extension" ) => '70',
						esc_html__( "80%", "impeka-wpb-extension" ) => '80',
						esc_html__( "90%", "impeka-wpb-extension" ) => '90',
						esc_html__( "100%", "impeka-wpb-extension" ) => '100'
					),
					"std" => '20',
					"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
					),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
					"param_name" => "radius",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
						esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
						esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
						esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
						esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
						esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
						esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
						esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
					),
					"description" => '',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Title & Description Visibility", "impeka-wpb-extension" ),
					"param_name" => "title_caption",
					'value' => array(
						esc_html__( 'None' , 'impeka-wpb-extension' ) => 'none',
						esc_html__( 'Title and Description' , 'impeka-wpb-extension' ) => 'title-caption',
						esc_html__( 'Title Only' , 'impeka-wpb-extension' ) => 'title-only',
						esc_html__( 'Description Only' , 'impeka-wpb-extension' ) => 'caption-only',
					),
					"std" => 'title-caption',
					"description" => esc_html__( "Define the visibility for your title - description.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
					"param_name" => "title_heading_tag",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "div", "impeka-wpb-extension" ) => 'div',
					),
					"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
					"std" => 'h3',
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Portfolio Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "title_heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Portfolio Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"std" => 'h4',
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the title color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'title-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Description/Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the description /text color.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "title_caption", 'value' => array( 'title-caption', 'caption-only' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				//Navigation
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Behavior", 'impeka-wpb-extension'),
					"param_name" => "label_behavior",
					'value' => '',
					"std" => '',
					"description" => esc_html__( "Configure the carousel behavior", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Loop", "impeka-wpb-extension" ),
					"param_name" => "loop",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Autoplay", "impeka-wpb-extension" ),
					"param_name" => "auto_play",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Slideshow Speed", "impeka-wpb-extension" ),
					"param_name" => "slideshow_speed",
					"value" => '3000',
					"description" => esc_html__( "Slideshow Speed in ms.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "type", 'value' => array( 'classic' ) ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Pause on Hover", "impeka-wpb-extension" ),
					"param_name" => "pause_hover",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"std" => "no",
					"description" => esc_html__( "If selected, carousel will be paused on hover", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "type", 'value' => array( 'classic' ) ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Navigation", 'impeka-wpb-extension'),
					"param_name" => "label_pagination",
					'value' => '',
					"std" => '',
					"description" => esc_html__( "Configure the carousel navigation", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_navigation( 'yes' ),
				impeka_wpb_ext_add_navigation_icon( 'arrow-1' ),
				impeka_wpb_ext_add_navigation_icon_color( 'black' ),
				impeka_wpb_ext_add_navigation_shape(),
				impeka_wpb_ext_add_navigation_shape_type(),
				impeka_wpb_ext_add_navigation_shape_color(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Pagination", "impeka-wpb-extension" ),
					"param_name" => "pagination",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"std" => "no",
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Pagination Speed", "impeka-wpb-extension" ),
					"param_name" => "pagination_speed",
					"value" => '400',
					"description" => esc_html__( "Pagination Speed in ms.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "type", 'value' => array( 'classic' ) ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				//Extras
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Link Type", "impeka-wpb-extension" ),
					"param_name" => "link_type",
					'value' => array(
						esc_html__( 'Classic Portfolio' , 'impeka-wpb-extension' ) => 'item',
						esc_html__( 'Quick View' , 'impeka-wpb-extension' ) => 'quick-view',
						esc_html__( 'Gallery Usage' , 'impeka-wpb-extension' ) => 'popup',
						esc_html__( 'Custom Link' , 'impeka-wpb-extension' ) => 'custom-link',
					),
					"description" => esc_html__( "Select the link type of your portfolio items.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Popup Size", "impeka-wpb-extension" ),
					"param_name" => "image_popup_size",
					'value' => array(
						esc_html__( 'Large' , 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Extra Extra Large' , 'impeka-wpb-extension' ) => 'extra-extra-large',
						esc_html__( 'Full' , 'impeka-wpb-extension' ) => 'full',
					),
					"std" => 'extra-extra-large',
					"dependency" => array( 'element' => "link_type", 'value' => array( 'popup' ) ),
					"description" => esc_html__( "Select size for your popup image.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overview Type", "impeka-wpb-extension" ),
					"param_name" => "overview_type",
					'value' => array(
						esc_html__( 'Default' , 'impeka-wpb-extension' ) => '',
						esc_html__( 'Custom Overview' , 'impeka-wpb-extension' ) => 'custom-overview',
					),
					"description" => esc_html__( "Select the overview type of your portfolio items.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Exclude Posts", "impeka-wpb-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Portfolio Categories", "impeka-wpb-extension" ),
					"param_name" => "categories",
					"value" => impeka_wpb_ext_get_post_categories( 'portfolio_category' ),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "impeka-wpb-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_portfolio_carousel', 'impeka_wpb_ext_portfolio_carousel_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
