<?php
/**
 * Pricing Table Shortcode
 */

function impeka_wpb_ext_pricing_table_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'pricing-table.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_pricing_table', 'impeka_wpb_ext_pricing_table_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_pricing_table_shortcode_params' ) ) {
	function impeka_wpb_ext_pricing_table_shortcode_params( $tag ) {

		return array(
			"name" => esc_html__( "Pricing Table", "impeka-wpb-extension" ),
			"description" => esc_html__( "Stylish pricing tables", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-pricing-table",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Pricing Table Layout", "impeka-wpb-extension" ),
						"param_name" => "layout",
						"value" => array(
							esc_html__( "Layout 1", "impeka-wpb-extension" ) => 'layout-1',
							esc_html__( "Layout 2", "impeka-wpb-extension" ) => 'layout-2',
						),
						"description" => esc_html__( "Select your pricing table layout", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Price", "impeka-wpb-extension" ),
						"param_name" => "price",
						"value" => "$0",
						"save_always" => true,
						"description" => esc_html__( "Enter your price here. eg $80 or 80€.", "impeka-wpb-extension" ),
						"admin_label" => true,
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Price Tag", "impeka-wpb-extension" ),
						"param_name" => "heading_tag",
						"value" => array(
							esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
							esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
							esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
							esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
							esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
							esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
							esc_html__( "div", "impeka-wpb-extension" ) => 'div',
						),
						"description" => esc_html__( "Price Tag for SEO", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
						"std" => 'h3',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Price Size/Typography", "impeka-wpb-extension" ),
						"param_name" => "heading",
						"value" => array(
							esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
							esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
							esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
							esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
							esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
							esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
							esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
							esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
							esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
							esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
						),
						"description" => esc_html__( "Price size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
						"std" => 'h3',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Increase Price Heading Size", "impeka-wpb-extension" ),
						"param_name" => "increase_heading",
						"value" => array(
							esc_html__( "100%", "impeka-wpb-extension" ) => '100',
							esc_html__( "120%", "impeka-wpb-extension" ) => '120',
							esc_html__( "140%", "impeka-wpb-extension" ) => '140',
							esc_html__( "160%", "impeka-wpb-extension" ) => '160',
							esc_html__( "180%", "impeka-wpb-extension" ) => '180',
							esc_html__( "200%", "impeka-wpb-extension" ) => '200',
							esc_html__( "250%", "impeka-wpb-extension" ) => '250',
							esc_html__( "300%", "impeka-wpb-extension" ) => '300',
						),
						"description" => esc_html__( "Set the percentage you want to increase your Headings size.", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					impeka_wpb_ext_get_heading_increase_reset(),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Price Custom Font Family", "impeka-wpb-extension" ),
						"param_name" => "custom_font_family",
						"value" => array(
							esc_html__( "Same as Typography", "impeka-wpb-extension" ) => '',
							esc_html__( "Custom Font Family 1", "impeka-wpb-extension" ) => 'custom-font-1',
							esc_html__( "Custom Font Family 2", "impeka-wpb-extension" ) => 'custom-font-2',
							esc_html__( "Custom Font Family 3", "impeka-wpb-extension" ) => 'custom-font-3',
							esc_html__( "Custom Font Family 4", "impeka-wpb-extension" ) => 'custom-font-4',

						),
						"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "impeka-wpb-extension" ),
						"std" => '',
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Interval", "impeka-wpb-extension" ),
						"param_name" => "interval",
						"value" => "/month",
						"save_always" => true,
						"description" => esc_html__( "Enter interval period here. e.g: /month, per month, per year.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
						"param_name" => "title",
						"value" => "Title",
						"save_always" => true,
						"description" => esc_html__( "Enter your title here.", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Size/Typography", "impeka-wpb-extension" ),
						"param_name" => "title_heading",
						"value" => array(
							esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
							esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
							esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
							esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
							esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
							esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
							esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
							esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
							esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
							esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
						),
						"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
						"std" => 'h6',
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Description", "impeka-wpb-extension" ),
						"param_name" => "description",
						"value" => "",
						"save_always" => true,
						"description" => esc_html__( "Enter your description here.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "exploded_textarea",
						"heading" => esc_html__("Attributes", "impeka-wpb-extension"),
						"param_name" => "values",
						"description" => esc_html__( "Input attribute values. Divide values with linebreaks (Enter). Example: 100|Users.", "impeka-wpb-extension" ),
						"value" => "100|Users,8 Gig|Disc Space,Unlimited|Data Transfer",
						"save_always" => true,
						"dependency" => array( 'element' => "layout", 'value' => array( 'layout-1' ) ),
					),
					impeka_wpb_ext_add_align(),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
					//Styles
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
						"param_name" => "color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"std" => 'black',
						"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Price Color", "impeka-wpb-extension" ),
						"param_name" => "price_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"std" => 'black',
						"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					),
					array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Content Background", "impeka-wpb-extension" ),
						"param_name" => "content_bg",
						"param_holder_class" => "grve-colored-dropdown",
						"description" => esc_html__( "Select background color for your pricing table.", "impeka-wpb-extension" ),
						"value" => impeka_wpb_ext_get_color_array( ['none', 'primary', 'gradient', 'standard'] ),
						"std" => 'white',
						"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Border", "impeka-wpb-extension" ),
						"param_name" => "border",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Top Border", "impeka-wpb-extension" ) => 'top-border',
							esc_html__( "Bottom Border", "impeka-wpb-extension" ) => 'bottom-border',
						),
						"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "layout", 'value' => array( 'layout-2' ) ),
					),
					array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Border Color", "impeka-wpb-extension" ),
						"param_name" => "border_color",
						"param_holder_class" => "grve-colored-dropdown",
						"description" => esc_html__( "Selected border color for your pricing table.", "impeka-wpb-extension" ),
						"value" => impeka_wpb_ext_get_color_array( ['none', 'primary', 'gradient', 'standard'] ),
						"std" => 'primary-1',
						"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "border", 'value_not_equal_to' => array( '' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension" ),
						"param_name" => "shadow",
						"value" => array(
							esc_html__( "No", "impeka-wpb-extension" ) => '',
							esc_html__( "Small", "impeka-wpb-extension" ) => 'small-shadow',
							esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium-shadow',
							esc_html__( "Large", "impeka-wpb-extension" ) => 'large-shadow',
						),
						"dependency" => array( 'element' => "content_bg", 'value_not_equal_to' => array( 'none' ) ),
						"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
						"param_name" => "radius",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => 'none',
							esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
							esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
							esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
							esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
							esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
							esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
							esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
							esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
						),
						"group" => esc_html__( "Styles", "impeka-wpb-extension" ),
					),
				),
				//Button Tab
				impeka_wpb_ext_get_button_params(),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			)
		);

	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_pricing_table', 'impeka_wpb_ext_pricing_table_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
