<?php
/**
 * Product Shortcode
 */

function impeka_wpb_ext_products_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'products.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_products', 'impeka_wpb_ext_products_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_products_shortcode_params' ) ) {
	function impeka_wpb_ext_products_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Products", "impeka-wpb-extension" ),
			"description" => esc_html__( "Display product element in multiple styles", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-product",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Products Mode", "impeka-wpb-extension" ),
					"param_name" => "mode",
					"admin_label" => true,
					'value' => array(
						esc_html__( 'Grid' , 'impeka-wpb-extension' ) => 'grid',
						esc_html__( 'Masonry' , 'impeka-wpb-extension' ) => 'masonry',
					),
					"description" => esc_html__( "Select your products mode", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Grid Image Size", "impeka-wpb-extension" ),
					"param_name" => "grid_image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
						esc_html__( 'Landscape Medium Crop', 'impeka-wpb-extension' ) => 'landscape-medium',
						esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
						esc_html__( 'Portrait Medium Crop', 'impeka-wpb-extension' ) => 'portrait-medium',
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
					) ),
					"std" => 'landscape',
					"description" => esc_html__( "Select your Grid Image Size.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'grid' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Masonry Image Size", "impeka-wpb-extension" ),
					"param_name" => "masonry_image_mode",
					'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
						esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
					) ),
					"std" => 'large',
					"description" => esc_html__( "Select your Masonry Image Size.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "mode", 'value' => array( 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Large Screen Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_large_screen",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
					),
					"std" => '3',
					"description" => esc_html__( "Select your Products Columns.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Columns", "impeka-wpb-extension" ),
					"param_name" => "columns",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
					),
					"std" => '3',
					"description" => esc_html__( "Select your Products Columns.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Landscape Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_tablet_landscape",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, landscape orientation.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Portrait Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_tablet_portrait",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, portrait orientation.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Mobile Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_mobile",
					"value" => array(
						'1' => '1',
						'2' => '2',
					),
					"std" => '1',
					"description" => esc_html__( "Select responsive column on mobile devices.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between images", "impeka-wpb-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"description" => esc_html__( "Add gutter among images.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "impeka-wpb-extension" ),
					"param_name" => "gutter_size",
					"value" => '30',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				impeka_wpb_ext_add_order_by(),
				impeka_wpb_ext_add_order(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "CSS Animation", "impeka-wpb-extension"),
					"param_name" => "animation",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Fade In", "impeka-wpb-extension" ) => "fade-in",
						esc_html__( "Fade In Up", "impeka-wpb-extension" ) => "fade-in-up",
						esc_html__( "Fade In Down", "impeka-wpb-extension" ) => "fade-in-down",
						esc_html__( "Fade In Left", "impeka-wpb-extension" ) => "fade-in-left",
						esc_html__( "Fade In Right", "impeka-wpb-extension" ) => "fade-in-right",
						esc_html__( "Zoom In", "impeka-wpb-extension" ) => "zoom-in",
					),
					"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
					"std" => "zoom-in",
				),
				impeka_wpb_ext_add_margin_bottom(),
				array(
					"type" => "el_id",
					"heading" => esc_html__( "Element ID", "impeka-wpb-extension" ),
					'description' => esc_html__( "Enter element ID (Note: make sure it is unique)", "impeka-wpb-extension" ),
					"param_name" => "el_id",
					'settings' => array(
						'auto_generate' => true,
					),
				),
				impeka_wpb_ext_add_el_class(),
				//Titles & Hovers
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
					"param_name" => "title_heading_tag",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "div", "impeka-wpb-extension" ) => 'div',
					),
					"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
					"std" => 'h3',
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "title_heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"std" => 'h6',
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Product Style - Hovers", "impeka-wpb-extension" ),
					"param_name" => "hover_style",
					'value' => array(
						esc_html__( 'Content Below Image' , 'impeka-wpb-extension' ) => 'hover-style-1',
						esc_html__( 'Top Down Animated Content' , 'impeka-wpb-extension' ) => 'hover-style-2',
					),
					"description" => esc_html__( "Select the hover style for the product overview.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Second Image Effect", "impeka-wpb-extension" ),
					"param_name" => "second_image_effect",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"description" => esc_html__( "Choose if you want second image effect.", "impeka-wpb-extension" ),
					"std" => 'yes',
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['default', 'primary', 'standard'] ),
					"std" => 'default',
					"description" => esc_html__( "Choose the text color", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "impeka-wpb-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'black-white'] ),
					"std" => 'white',
					"description" => esc_html__( "Choose the image color overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "impeka-wpb-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array( '0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100' ),
					"std" => '90',
					"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Titles & Hovers", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Pagination", 'impeka-wpb-extension'),
					"description" => esc_html__( "Define the items to show per page or the total items number according to the selected display style.", "impeka-wpb-extension" ),
					"param_name" => "label_pagination",
					'value' => '',
					"std" => '',
					"group" => esc_html__( "Pagination", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Items per page", "impeka-wpb-extension" ),
					"param_name" => "items_per_page",
					"value" => '12',
					"description" => esc_html__( "Enter how many items per page you want to display.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Display Style", "impeka-wpb-extension" ),
					"param_name" => "display_style",
					"value" => array(
						esc_html__( "Show All", "impeka-wpb-extension" ) => '',
						esc_html__( "Pagination", "impeka-wpb-extension" ) => 'pagination',
						esc_html__( "Load More", "impeka-wpb-extension" ) => 'load-more',
						esc_html__( "Infinite Scroll", "impeka-wpb-extension" ) => 'infinite-scroll',
					),
					"std" => 'pagination',
					"description" => esc_html__( "Select Show All or define your pagination style.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Load More Title", "impeka-wpb-extension" ),
					"param_name" => "load_more_title",
					"value" => 'Load More',
					"description" => esc_html__( "Title for load more.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "display_style", 'value' => array( 'load-more' ) ),
					"group" => esc_html__( "Pagination", "impeka-wpb-extension" ),
				),
				//Extras
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Link Type", "impeka-wpb-extension" ),
					"param_name" => "link_type",
					'value' => array(
						esc_html__( 'Classic Product' , 'impeka-wpb-extension' ) => 'item',
						esc_html__( 'Quick View' , 'impeka-wpb-extension' ) => 'quick-view',
					),
					"description" => esc_html__( "Select the link type of your product items.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Quick View Title", "impeka-wpb-extension" ),
					"param_name" => "quick_view_title",
					"value" => 'Quick View',
					"description" => esc_html__( "Title for quick view.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "link_type", 'value' => array( 'quick-view' ) ),
					"group" => esc_html__( "Extras", "impeka-wpb-extension" ),
				),
				//Filters
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Filter", "impeka-wpb-extension" ),
					"param_name" => "filter",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"description" => esc_html__( "If selected, an isotope filter will be displayed.", "impeka-wpb-extension" ) . " " . esc_html__( "Enable product Filter ( Only for All or Multiple Categories )", "impeka-wpb-extension" ),
					"group" => esc_html__( "Filters", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_filter(),
				impeka_wpb_ext_add_filter_all_text(),
				impeka_wpb_ext_add_filter_order_by(),
				impeka_wpb_ext_add_filter_order(),
				impeka_wpb_ext_add_filter_style(),
				impeka_wpb_ext_add_filter_shape(),
				impeka_wpb_ext_add_filter_color(),
				impeka_wpb_ext_add_filter_align(),
				impeka_wpb_ext_add_filter_gototop(),
				//Categories
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Exclude Posts", "impeka-wpb-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Product Categories", "impeka-wpb-extension" ),
					"param_name" => "categories",
					"value" => impeka_wpb_ext_get_post_categories( 'product_cat' ),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "impeka-wpb-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_products', 'impeka_wpb_ext_products_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
