<?php
/**
 * Progress Bar Shortcode
 */

function impeka_wpb_ext_progress_bar_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'progress-bar.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_progress_bar', 'impeka_wpb_ext_progress_bar_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_progress_bar_shortcode_params' ) ) {
	function impeka_wpb_ext_progress_bar_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Progress Bar", "impeka-wpb-extension" ),
			"description" => esc_html__( "Create horizontal progress bar", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-progress-bar",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Progress Bar Style", "impeka-wpb-extension" ),
					"param_name" => "bar_style",
					"value" => array(
						esc_html__( "Style 1", "impeka-wpb-extension" ) => 'style-1',
						esc_html__( "Style 2", "impeka-wpb-extension" ) => 'style-2',
					),
					"description" => esc_html__( "Style of the bar line.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "exploded_textarea",
					"heading" => esc_html__("Bar values", "impeka-wpb-extension"),
					"param_name" => "values",
					"description" => esc_html__( "Input bar values here. Divide values with linebreaks (Enter). Example: 90|Development|black.", "impeka-wpb-extension" ) . '<br/>' .
									esc_html__( "Available colors: primary-1, green, orange, red, blue, aqua, purple, black, white.", "impeka-wpb-extension" ),
					"value" => "90|Development,80|Design,70|Marketing",
					"save_always" => true,
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Bars Color", "impeka-wpb-extension" ),
					"param_name" => "color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
					'std' => 'primary-1',
					"description" => esc_html__( "Use single color for all bars ( If not specified in Bar values )", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Base Color", "impeka-wpb-extension" ),
					"param_name" => "base_color",
					"value" => impeka_wpb_ext_get_color_array( ['none', 'black-white' ] ),
					"description" => esc_html__( "Select the base color for your bars.", "impeka-wpb-extension" ),
					"std" => 'black',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
					"description" => esc_html__( "Select the color of your text.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "bar_style", 'value' => array( 'style-2' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Progress Bar Height", "impeka-wpb-extension" ),
					"param_name" => "bar_height",
					"value" => "6",
					"description" => esc_html__( "Enter progress bar height.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "bar_style", 'value' => array( 'style-2' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Bars Line Style", "impeka-wpb-extension" ),
					"param_name" => "bar_line_style",
					"value" => array(
						esc_html__( "Square", "impeka-wpb-extension" ) => '',
						esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
						esc_html__( "Extra Round", "impeka-wpb-extension" ) => 'extra-round',
					),
					"description" => esc_html__( "Style of the bar line.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_get_heading( "small-text" ),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_progress_bar', 'impeka_wpb_ext_progress_bar_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
