<?php
/**
 * Promo Shortcode
 */

function impeka_wpb_ext_promo_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'promo.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_promo', 'impeka_wpb_ext_promo_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_promo_shortcode_params' ) ) {
	function impeka_wpb_ext_promo_shortcode_params( $tag ) {

		return array(
			"name" => esc_html__( "Advanced Promo", "impeka-wpb-extension" ),
			"description" => esc_html__( "Advanced, impressive promotion for whatever you like", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-promo",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Size", "impeka-wpb-extension" ),
						"param_name" => "image_mode",
						'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
							esc_html__( 'Full ( Custom )', 'impeka-wpb-extension' ) => '',
							esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
							esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
							esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
							esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
							esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
							esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
							esc_html__( 'Thumbnail', 'impeka-wpb-extension' ) => 'thumbnail',
						) ),
						"std" => 'thumbnail',
						"description" => esc_html__( "Select your Image Size.", "impeka-wpb-extension" ),
					),				
					array(
						"type" => "attach_image",
						"heading" => esc_html__( "Image", "impeka-wpb-extension" ),
						"param_name" => "image",
						"value" => '',
						"description" => esc_html__( "Select an image.", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "attach_image",
						"heading" => esc_html__( "Retina Image", "impeka-wpb-extension" ),
						"param_name" => "retina_image",
						"value" => '',
						"description" => esc_html__( "Select a 2x image.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_mode", 'value' => array( '' ) ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
						"param_name" => "image_load_mode",
						'value' => array(
							esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
							esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
							esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
							esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
						),
						"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textarea_html",
						"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
						"param_name" => "content",
						"value" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec in est neque. Aliquam egestas dolor id lorem aliquam, nec feugiat purus mollis. Vestibulum vel efficitur diam, sed facilisis orci. Aliquam condimentum eu ipsum a tempor.",
						"description" => esc_html__( "Enter your text.", "impeka-wpb-extension" ),
					),
					impeka_wpb_ext_add_align( 'center' ),
					impeka_wpb_ext_add_el_class(),
				),
				//Button Tab
				impeka_wpb_ext_get_button_params()
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_promo', 'impeka_wpb_ext_promo_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
