<?php
/**
 * Quote Shortcode
 */

function impeka_wpb_ext_quote_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'quote.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_quote', 'impeka_wpb_ext_quote_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_quote_shortcode_params' ) ) {
	function impeka_wpb_ext_quote_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Quote", "impeka-wpb-extension" ),
			"description" => esc_html__( "Easily create your Quote Text", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-quote",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => "textarea",
						"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
						"param_name" => "content",
						"value" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut dapibus nunc at ullamcorper porttitor.",
						"description" => esc_html__( "Type your quote.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
						"param_name" => "text_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
						"description" => esc_html__( "Select the color of your text.", "impeka-wpb-extension" ),
					),
					impeka_wpb_ext_add_inherit_align(),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
				),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_quote', 'impeka_wpb_ext_quote_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
