<?php
/**
 * Slogan Shortcode
 */

function impeka_wpb_ext_slogan_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'slogan.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_slogan', 'impeka_wpb_ext_slogan_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_slogan_shortcode_params' ) ) {
	function impeka_wpb_ext_slogan_shortcode_params( $tag ) {

		return array(
			"name" => esc_html__( "Slogan", "impeka-wpb-extension" ),
			"description" => esc_html__( "Create easily appealing slogans", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-slogan",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
						"param_name" => "title",
						"value" => "Sample Title",
						"description" => esc_html__( "Enter your title here.", "impeka-wpb-extension" ),
						"save_always" => true,
						"admin_label" => true,
					),
					impeka_wpb_ext_get_heading_tag( "h2" ),
					impeka_wpb_ext_get_heading( "h2" ),
					impeka_wpb_ext_get_heading_increase(),
					impeka_wpb_ext_get_heading_increase_reset(),
					impeka_wpb_ext_get_custom_font_family(),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
						"param_name" => "title_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'gradient', 'standard', 'custom'] ),
						"description" => esc_html__( "Select the color of your title.", "impeka-wpb-extension" ),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__( "Custom Title Color", "impeka-wpb-extension" ),
						'param_name' => 'title_color_custom',
						'description' => esc_html__( "Select a custom color for your title", "impeka-wpb-extension" ),
						"std" => '#e1e1e1',
						"dependency" => array( 'element' => "title_color", 'value' => array( 'custom' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Line type", "impeka-wpb-extension" ),
						"param_name" => "line_type",
						"value" => array(
							esc_html__( "No Line", "impeka-wpb-extension" ) => 'no-line',
							esc_html__( "With Line", "impeka-wpb-extension" ) => 'line',
						),
						"description" => esc_html__( "Line Type of the title.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Line Width", "impeka-wpb-extension" ),
						"param_name" => "line_width",
						"value" => "50",
						"description" => esc_html__( "Enter the width for your line (Note: CSS measurement units allowed).", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "line_type", 'value' => array( 'line' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Line Height", "impeka-wpb-extension" ),
						"param_name" => "line_height",
						"value" => array( '1', '2', '3', '4' , '5', '6', '7', '8', '9' , '10' ),
						"std" => '2',
						"description" => esc_html__( "Enter the hight for your line in px.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "line_type", 'value' => array( 'line' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Line Color", "impeka-wpb-extension" ),
						"param_name" => "line_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"description" => esc_html__( "Color for the line.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "line_type", 'value' => array( 'line' ) ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Sub Title", "impeka-wpb-extension" ),
						"param_name" => "subtitle",
						"value" => "",
						"description" => esc_html__( "Enter your sub title here.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Sub Title Color", "impeka-wpb-extension" ),
						"param_name" => "subtitle_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
						"description" => esc_html__( "Select the color of your sub title.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textarea",
						"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
						"param_name" => "content",
						"value" => "",
						"description" => esc_html__( "Type your text.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
						"param_name" => "text_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
						"description" => esc_html__( "Select the color of your text.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Text Style", "impeka-wpb-extension" ),
						"param_name" => "text_style",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Leader", "impeka-wpb-extension" ) => 'leader-text',
							esc_html__( "Subtitle", "impeka-wpb-extension" ) => 'subtitle-text',
							esc_html__( "Page Description", "impeka-wpb-extension" ) => 'page-description',
						),
						"description" => esc_html__( "Select your text style.", 'impeka-wpb-extension' ),
					),
					impeka_wpb_ext_add_inherit_align(),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
				),
				//Button 1 Tab
				impeka_wpb_ext_get_button_params('first'),
				//Button 2 Tab
				impeka_wpb_ext_get_button_params('second', '2'),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_slogan', 'impeka_wpb_ext_slogan_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
