<?php
/**
 * Social Links Shortcode
 */

function impeka_wpb_ext_social_links_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'social-links.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_social_links', 'impeka_wpb_ext_social_links_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_social_links_shortcode_params' ) ) {
	function impeka_wpb_ext_social_links_shortcode_params( $tag ) {

		return array(
			"name" => esc_html__( "Social Links", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add social networking links.", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-social",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Icon Type", "impeka-wpb-extension" ),
						"param_name" => "social_type",
						"value" => array(
							esc_html__( "Icon", "impeka-wpb-extension" ) => 'icon',
							esc_html__( "List", "impeka-wpb-extension" ) => 'list',
						),
						"description" => '',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "List Type", "impeka-wpb-extension" ),
						"param_name" => "list_type",
						"value" => array(
							esc_html__( "Vertical", "impeka-wpb-extension" ) => 'vertical',
							esc_html__( "Horizontal", "impeka-wpb-extension" ) => 'horizontal',
						),
						"description" => '',
						"dependency" => array( 'element' => "social_type", 'value' => array( 'list' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Font Size", "impeka-wpb-extension" ),
						"param_name" => "font_size",
						"value" => array(
							esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
							esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
							esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
							esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
							esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
							esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
							esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
							esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
							esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
							esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
						),
						"description" => '',
						"std" => 'link-text',
						"dependency" => array( 'element' => "social_type", 'value' => array( 'list' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Icon size", "impeka-wpb-extension" ),
						"param_name" => "icon_size",
						"value" => array(
							esc_html__( "Extra Large", "impeka-wpb-extension" ) => 'extra-large',
							esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
							esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
							esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
							esc_html__( "Extra Small", "impeka-wpb-extension" ) => 'extra-small',
						),
						"std" => 'medium',
						"dependency" => array( 'element' => "social_type", 'value' => array( 'icon' ) ),
						"description" => '',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Item Spacing", "impeka-wpb-extension" ),
						"param_name" => "item_space",
						"value" => array( '0', '1', '5', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55', '60' ),
						"std" => '15',
						"description" => esc_html__( "Set the space that will display on each side of your social items in px.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Icon Color", "impeka-wpb-extension" ),
						"param_name" => "icon_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"std" => 'primary-1',
						"description" => esc_html__( "Color of the social icon.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "social_type", 'value' => array( 'icon' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Icon shape", "impeka-wpb-extension" ),
						"param_name" => "icon_shape",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => 'no-shape',
							esc_html__( "Square", "impeka-wpb-extension" ) => 'square',
							esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
							esc_html__( "Circle", "impeka-wpb-extension" ) => 'circle',
						),
						"description" => '',
						"dependency" => array( 'element' => "social_type", 'value' => array( 'icon' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Shape Color", "impeka-wpb-extension" ),
						"param_name" => "shape_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"std" => 'primary-1',
						"description" => esc_html__( "Color of the shape.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Shape type", "impeka-wpb-extension" ),
						"param_name" => "shape_type",
						"value" => array(
							esc_html__( "Simple", "impeka-wpb-extension" ) => 'simple',
							esc_html__( "Outline", "impeka-wpb-extension" ) => 'outline',
						),
						"description" => esc_html__( "Select shape type.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
					),
					impeka_wpb_ext_add_inherit_align(),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
					array(
						"type" => "el_id",
						"heading" => esc_html__( "Element ID", "impeka-wpb-extension" ),
						'description' => esc_html__( "Enter element ID (Note: make sure it is unique)", "impeka-wpb-extension" ),
						"param_name" => "el_id",
						'settings' => array(
							'auto_generate' => true,
						),
					),
				),
				//Social Tab
				impeka_wpb_ext_get_social_links_params(),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_social_links', 'impeka_wpb_ext_social_links_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
